/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VrgIpInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;

public class ResourceMappingCommon {
    private static final Log log = LogFactory.getInstance(ResourceMappingCommon.class);
    private ISiteBaseService siteService;
    private ResourceMappingVerify rmVerify;
    private ResourceMappingDao rmDao;

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public ResourceMappingVerify getRmVerify() {
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.rmVerify = rmVerify;
    }

    public ResourceMappingDao getRmDao() {
        return this.rmDao;
    }

    public void setRmDao(ResourceMappingDao rmDao) {
        this.rmDao = rmDao;
    }

    public void checkObjExist(Object obj) {
        if (null == obj || obj instanceof String && VerifyUtil.isEmpty((Object)obj)) {
            log.error((Object)"obj not exist.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    public <T extends GalaxObject> List<T> parseRemoteResource(String jsonStr, Class<T> type) {
        ArrayList<GalaxObject> galaxObjectList = new ArrayList<GalaxObject>();
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                GalaxObject galaxObject = null;
                try {
                    JSONObject object = JSONObject.fromObject((Object)json);
                    String uuid = object.getString("uuid");
                    String name = object.getString("name");
                    galaxObject = (GalaxObject)type.newInstance();
                    galaxObject.setUuid(uuid);
                    galaxObject.setName(name);
                }
                catch (LegoCheckedException e) {
                    log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
                }
                catch (InstantiationException e) {
                    log.error((Object)"create GalaxObject error. ", (Throwable)e, 90160758787071L);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"create GalaxObject error. ", (Throwable)e, 90160758787071L);
                }
                if (galaxObject == null) {
                    log.error((Object)"Parse remote resource error", 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                galaxObjectList.add(galaxObject);
            }
        }
        catch (LegoCheckedException e) {
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return galaxObjectList;
    }

    public Site checkParameterAndGetSite(String siteId) {
        this.rmVerify.checkParam(siteId);
        return this.siteService.getSiteById(siteId);
    }

    public <T extends GalaxObject> List<T> getUnusedResourceList(List<T> resourceList) {
        ArrayList<GalaxObject> unUsedResList = new ArrayList<GalaxObject>();
        for (GalaxObject res : resourceList) {
            unUsedResList.add(res);
        }
        return unUsedResList;
    }

    public ComputeCluster getComputeClusterFromJson(String json) {
        ComputeCluster computeCluster;
        try {
            JSONObject object = JSONObject.fromObject((Object)json);
            String uuid = object.getString("uuid");
            String name = object.getString("name");
            String arch = object.getString("arch", null);
            computeCluster = new ComputeCluster();
            computeCluster.setUuid(uuid);
            computeCluster.setName(name);
            computeCluster.setArch(arch);
        }
        catch (LegoCheckedException e) {
            computeCluster = null;
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return computeCluster;
    }

    public PortGroup getPortGroupFromJson(String json) {
        PortGroup portGroup;
        try {
            JSONObject object = JSONObject.fromObject((Object)json);
            String uuid = object.getString("uuid");
            String name = object.getString("name");
            portGroup = new PortGroup();
            portGroup.setUuid(uuid);
            portGroup.setName(name);
        }
        catch (LegoCheckedException e) {
            portGroup = null;
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return portGroup;
    }

    public ComputeNode getComputeNodeFromJson(String json) {
        ComputeNode computeNode;
        try {
            JSONObject object = JSONObject.fromObject((Object)json);
            String uuid = object.getString("uuid");
            String name = object.getString("name");
            String arch = object.getString("arch", null);
            computeNode = new ComputeNode();
            computeNode.setUuid(uuid);
            computeNode.setName(name);
            computeNode.setArch(arch);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
            computeNode = null;
        }
        return computeNode;
    }

    public boolean isResourceMappingInSynQueue(List<ResourceMapping> synRSList2, ResourceMapping resMapping) {
        for (ResourceMapping rs : synRSList2) {
            int resType = rs.getResourceType();
            if (!(ResTypeEnum.VRG.getResType() == resType ? rs.getProductResourceId().equals(resMapping.getProductResourceId()) || rs.getProductResourceId().equals(resMapping.getRecoveryResourceId()) || rs.getRecoveryResourceId().equals(resMapping.getProductResourceId()) || rs.getRecoveryResourceId().equals(resMapping.getRecoveryResourceId()) : rs.getProductResourceId().equals(resMapping.getProductResourceId()) && rs.getRecoveryResourceId().equals(resMapping.getRecoveryResourceId()) || rs.getRecoveryResourceId().equals(resMapping.getProductResourceId()) && rs.getProductResourceId().equals(resMapping.getRecoveryResourceId()))) continue;
            return true;
        }
        return false;
    }

    public <T extends ManagedObject> T getGalaxObjectFromJson(String json, Class<T> type) {
        ManagedObject galaxObject = null;
        try {
            JSONObject object = JSONObject.fromObject((Object)json);
            String uuid = object.getString("uuid");
            String name = object.getString("name");
            galaxObject = (ManagedObject)type.newInstance();
            galaxObject.setUuid(uuid);
            galaxObject.setName(name);
            if (galaxObject instanceof DataStore && object.containsKey((Object)"storageUnits")) {
                String storageUnits = object.getString("storageUnits");
                DataStore dataStore = (DataStore)galaxObject;
                dataStore.setStorageUnits(storageUnits);
            }
            if (type == VRG.class) {
                String ipAddress = object.getString("ipAddress");
                ((VRG)galaxObject).setIpAddress(ipAddress);
                String businessIp = object.getString("businessIp");
                int port = object.getInt("businessPort");
                VrgIpInfo vrgIpInfo = new VrgIpInfo();
                vrgIpInfo.setAddress(businessIp);
                vrgIpInfo.setPort(port);
                galaxObject.addChildMo((ManagedObject)vrgIpInfo);
            }
        }
        catch (LegoCheckedException e) {
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        catch (InstantiationException e) {
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return (T)galaxObject;
    }
}

