/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingServiceUtils;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VRGResourceMapping;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class ResourceMappingDao {
    private static final String RES_PROVIDER_KEY = "ResourceProviderId";
    private static final String RESOURCE_KEY = "ResourceId";
    private Log log = LogFactory.getInstance(ResourceMappingDao.class);
    private IBaseDao<Object, Serializable> dao;
    private IMoDao moDao;
    private ResourceMappingVerify rmVerify;
    private ISiteBaseService siteService;
    private String trace = "trace";

    public IBaseDao<Object, Serializable> getDao() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.dao;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.dao = dao;
    }

    public IMoDao getMoDao() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.moDao = moDao;
    }

    public ResourceMappingVerify getRmVerify() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmVerify = rmVerify;
    }

    public ISiteBaseService getSiteService() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.siteService = siteService;
    }

    public List<ResourceMapping> getAllResourceMapping() {
        this.log.trace((Object)(this.trace + "getAllResourceMapping"));
        return this.getResourcemappingByVpcId(null, null);
    }

    public List<ResourceMapping> getResourcemappingByVpcId(String vpcId, String siteId) {
        List vpcRmList;
        this.log.trace((Object)(this.trace + "getResourcemappingByVpcId"));
        try {
            vpcRmList = !VerifyUtil.isEmpty((String)vpcId) && !VerifyUtil.isEmpty((String)siteId) ? this.dao.getHibernateTemplate().find("from ResourceMapping as rm where (rm.productVpcId = ? and rm.recoverySiteId = ?) or (rm.recoveryVpcId = ? and rm.productSiteId = ?)", new Object[]{vpcId, siteId, vpcId, siteId}) : this.dao.getHibernateTemplate().find("from ResourceMapping", new Object[0]);
        }
        catch (DataAccessException e) {
            this.log.error((Object)"failed to get rmList:", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return vpcRmList;
    }

    public ResourceMapping getResMappingWithPersistentValueOnly(String resMappingId) {
        this.log.trace((Object)(this.trace + "getResMappingWithPersistentValueOnly"));
        this.rmVerify.checkParam(resMappingId);
        try {
            ResourceMapping resourceMapping = (ResourceMapping)this.dao.getHibernateTemplate().get(ResourceMapping.class, (Serializable)((Object)resMappingId));
            return resourceMapping;
        }
        catch (DataAccessException e) {
            this.log.error((Object)("get resourceMapping by id failed, resMappingId=" + resMappingId), (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void saveResouceMapping(ResourceMapping resourceMapping) {
        this.log.trace((Object)(this.trace + "saveResouceMapping"));
        try {
            this.dao.getHibernateTemplate().save((Object)resourceMapping);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"add resourceMapping error", (long)-1L, null, (Log)this.log);
        }
    }

    public void updateResourceMappingInDB(ResourceMapping resMapping) {
        this.log.trace((Object)(this.trace + "updateResourceMappingInDB"));
        try {
            this.dao.update((Object)resMapping);
        }
        catch (DataAccessException e) {
            this.log.error((Object)"update resourceMapping failed", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void deleteResourceMappingInDB(ResourceMapping resourceMapping) {
        this.log.trace((Object)(this.trace + "deleteResourceMappingInDB"));
        try {
            this.dao.getHibernateTemplate().delete((Object)resourceMapping);
        }
        catch (DataAccessException e) {
            this.log.error((Object)("delete resourceMapping by id failed, resMappingId=" + resourceMapping.getMappingId()), (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public DrResource getCloudPlatformBySN(String deviceSn) {
        this.log.trace((Object)(this.trace + "getCloudPlatformBySN"));
        List drList = this.dao.getHibernateTemplate().find("from DrResource as dr where deviceSn = ? ", new Object[]{deviceSn});
        if (null == drList || drList.size() <= 0) {
            return null;
        }
        return (DrResource)drList.get(0);
    }

    public String getLocalResourceName(int resourceType, String resourceId) {
        this.log.trace((Object)(this.trace + "getLocalResourceName"));
        Class cls = ResTypeEnum.getResClass((int)resourceType);
        if (null == cls) {
            this.log.error((Object)"param: cls is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String resourceName = this.getResourceName(this.moDao, resourceId, cls);
        return resourceName;
    }

    public String getResourceName(IMoDao paraMoDao, String resourceId, Class<? extends ManagedObject> clazz) {
        this.log.trace((Object)(this.trace + "getResourceName"));
        ManagedObject resourceObj = paraMoDao.getMo(clazz, "uuid", (Object)resourceId);
        if (resourceObj == null) {
            this.log.error((Object)("parameter error " + clazz.getName() + " not exist,resourceId:" + resourceId), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        String resourceName = resourceObj.getName();
        return resourceName;
    }

    public Page pageQueryConditionResourceMapping(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props) {
        Page remotePage = this.pageQueryConditionResourceMappingRemote(pageNo, pageSize, orderBy, isAsc, props);
        if (null != remotePage) {
            return remotePage;
        }
        this.log.info((Object)("pageQueryResourceMapping,pageNo=" + pageNo + "pageSize=" + pageSize + "orderBy=" + orderBy + "isAsc=" + isAsc), 90160758786816L);
        ArrayList<Object> returnRmList = new ArrayList<Object>();
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        List<Criterion> criterionList = this.getRmCondition(props);
        Page ret = this.dao.pagedQuery(ResourceMapping.class, pageNo, pageSize, criterionList, orderBy, isAsc);
        List rmList1 = ret.getResult();
        for (ResourceMapping rm : rmList1) {
            String productSiteId = rm.getProductSiteId();
            String recoverySiteId = rm.getRecoverySiteId();
            Site productSite = this.siteService.getSiteById(productSiteId);
            Site recoverySite = this.siteService.getSiteById(recoverySiteId);
            if (productSite == null || recoverySite == null) continue;
            if (!rm.getProductSiteName().equals(productSite.getName()) || !rm.getRecoverySiteName().equals(recoverySite.getName())) {
                rm.setProductSiteName(productSite.getName());
                rm.setRecoverySiteName(recoverySite.getName());
                this.dao.save((Object)rm);
            }
            if (rm.getResourceType() == ResTypeEnum.VRG.getResType()) {
                VRG vrg = this.getlocalVRG(rm);
                VRGResourceMapping vrgMap = new VRGResourceMapping(rm);
                if (!VerifyUtil.isEmpty((Object)vrg)) {
                    vrgMap.setStatus(vrg.getMapStatus());
                } else {
                    this.log.error((Object)("can not find the VRG, and the mapstatus is default, rm=" + rm), 90160758787071L);
                }
                returnRmList.add(vrgMap);
                continue;
            }
            returnRmList.add(rm);
        }
        ret.setResult(returnRmList);
        return ret;
    }

    private List<Criterion> getRmCondition(List<QueryCondition> props) {
        this.log.trace((Object)(this.trace + " getRmCondition"));
        ArrayList<QueryCondition> newProps = new ArrayList<QueryCondition>();
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        ArrayList<QueryCondition> tmpProps = new ArrayList<QueryCondition>();
        for (QueryCondition prop : props) {
            QueryCondition qcRecovery;
            QueryCondition qcProduct;
            if (prop.getPropName().equalsIgnoreCase(RESOURCE_KEY)) {
                qcProduct = new QueryCondition("productResourceId", prop.getPropValue());
                tmpProps.add(qcProduct);
                qcRecovery = new QueryCondition("recoveryResourceId", prop.getPropValue());
                tmpProps.add(qcRecovery);
                continue;
            }
            if (prop.getPropName().equalsIgnoreCase(RES_PROVIDER_KEY)) {
                qcProduct = new QueryCondition("productResourceProviderId", prop.getPropValue());
                tmpProps.add(qcProduct);
                qcRecovery = new QueryCondition("recoveryResourceProviderId", prop.getPropValue());
                tmpProps.add(qcRecovery);
                continue;
            }
            newProps.add(prop);
        }
        if (!tmpProps.isEmpty()) {
            List crsTemps = this.dao.translatePropsToCriterions(tmpProps);
            if (crsTemps.size() != 2) {
                this.log.error((Object)"param: crsTemps's size is not equal Two.");
                throw new LegoCheckedException(1073947393L);
            }
            criterions.add((Criterion)Restrictions.or((Criterion)((Criterion)crsTemps.get(0)), (Criterion)((Criterion)crsTemps.get(1))));
        }
        criterions.addAll(this.dao.translatePropsToCriterions(newProps));
        return criterions;
    }

    private VRG getlocalVRG(ResourceMapping rm) {
        this.log.trace((Object)(this.trace + "getlocalVRG"));
        VRG vrg = rm.getRole() == 0 ? (VRG)CommonDAOLocator.getMoDao().getMo(VRG.class, "sn", (Object)rm.getRecoveryResourceId()) : (VRG)CommonDAOLocator.getMoDao().getMo(VRG.class, "sn", (Object)rm.getProductResourceId());
        return vrg;
    }

    private Page pageQueryConditionResourceMappingRemote(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props) {
        if (VerifyUtil.isEmpty(props)) {
            return null;
        }
        QueryCondition filterCondition = null;
        String resourceProviderId = null;
        String resourceType = null;
        for (QueryCondition prop : props) {
            if (RES_PROVIDER_KEY.equalsIgnoreCase(prop.getPropName())) {
                filterCondition = prop;
                resourceProviderId = String.valueOf(prop.getPropValue());
                continue;
            }
            if (!"resourceType".equalsIgnoreCase(prop.getPropName())) continue;
            resourceType = String.valueOf(prop.getPropValue());
        }
        if (null == resourceProviderId || null == resourceType || null == filterCondition) {
            return null;
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(resourceProviderId, "ism.drm.deviceType.fusionsphere.mainType");
        if (null == drResource) {
            return null;
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(drResource.getSiteId());
        if (null == site || 0 == site.getSiteType()) {
            return null;
        }
        IManagementServerBaseService service = (IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class);
        ManagementServer server = service.getServer(site.getServerUuid());
        if (null == server || !Integer.valueOf(0).equals(server.getStatus())) {
            this.log.debug((Object)"server:%s not online", new Object[]{site.getServerUuid()});
            return null;
        }
        return this.getRemoteResourceMapping(pageNo, pageSize, orderBy, isAsc, filterCondition, resourceType, site);
    }

    private Page getRemoteResourceMapping(int pageNo, int pageSize, String orderBy, boolean isAsc, QueryCondition filterCondition, String resourceType, Site site) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("resourceType", resourceType);
        uriVariables.put("startPage", pageNo);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("orderBy", orderBy);
        uriVariables.put("orderType", isAsc ? "asc" : "desc");
        uriVariables.put("filterName", filterCondition.getPropName());
        uriVariables.put("filterValue", filterCondition.getPropValue());
        String url = "/ws/resourcemapping?resourceType={resourceType}&filterName={filterName}&filterValue={filterValue}&startPage={startPage}&pageSize={pageSize}&orderBy={orderBy}&orderType={orderType}";
        this.log.debug((Object)"start getRemoteRecords, url: %s, recoverySite: %s, uriVariables: %s", new Object[]{url, site.getName(), uriVariables});
        RestClient client = SiteUtil.initClient((Site)site);
        String response = client.get(url, uriVariables);
        this.log.debug((Object)"end getRemoteRecords, url: %s, reponse: %s", new Object[]{url, response});
        if (VerifyUtil.isEmpty((String)response)) {
            return null;
        }
        JSONObject returnObject = JSONObject.fromObject((Object)response);
        if (returnObject.containsKey((Object)"totalCount") && returnObject.containsKey((Object)"records")) {
            List rmList = JSONArray.toCollection((JSONArray)returnObject.getJSONArray("records"), ResourceMapping.class);
            Page ret = new Page((long)pageNo, (long)returnObject.getInt("totalCount"), pageSize, rmList);
            return ret;
        }
        return null;
    }

    public Page pageQueryResourceMapping(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props) {
        Page pageA;
        this.log.info((Object)("pageQueryResourceMapping,pageNo=" + pageNo + "pageSize=" + pageSize + "orderBy=" + orderBy + "isAsc=" + isAsc), 90160758786816L);
        Page newPage = pageA = this.pageQueryResourceMappingAction(pageNo, pageSize, orderBy, isAsc, props);
        if (!VerifyUtil.isEmpty(props)) {
            for (QueryCondition condition : props) {
                String name = ResourceMappingServiceUtils.replaceRmParamName(condition.getPropName());
                condition.setPropName(name);
            }
            Page pageB = this.pageQueryResourceMappingAction(pageNo, pageSize, orderBy, isAsc, props);
            List rmList1 = pageA.getResult();
            List rmList2 = pageB.getResult();
            for (ResourceMapping rm : rmList2) {
                rm.swap();
            }
            rmList1.addAll(rmList2);
            newPage = new Page(0L, (long)rmList1.size(), pageSize, rmList1);
        }
        return newPage;
    }

    private Page pageQueryResourceMappingAction(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props) {
        this.log.trace((Object)(this.trace + "pageQueryResourceMappingAction"));
        ArrayList<ResourceMapping> rmList2 = new ArrayList<ResourceMapping>();
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        List criterionList = this.dao.translatePropsToCriterions(props);
        Page ret = this.dao.pagedQuery(ResourceMapping.class, pageNo, pageSize, criterionList, orderBy, isAsc);
        List rmList1 = ret.getResult();
        for (ResourceMapping rm : rmList1) {
            String productSiteId = rm.getProductSiteId();
            String recoverySiteId = rm.getRecoverySiteId();
            Site productSite = this.siteService.getSiteById(productSiteId);
            Site recoverySite = this.siteService.getSiteById(recoverySiteId);
            if (productSite == null || recoverySite == null) continue;
            if (!rm.getProductSiteName().equals(productSite.getName()) || !rm.getRecoverySiteName().equals(recoverySite.getName())) {
                rm.setProductSiteName(productSite.getName());
                rm.setRecoverySiteName(recoverySite.getName());
                this.dao.save((Object)rm);
            }
            rmList2.add(rm);
        }
        ret.setResult(rmList2);
        return ret;
    }

    public boolean hasRelativeResourceMapping(String siteId, String resourceProviderId) {
        this.log.trace((Object)(this.trace + " trace message"));
        boolean isExist = false;
        this.log.info((Object)("hasRelativeResourceMapping,siteId = " + siteId + "resourceProviderId =" + resourceProviderId), 90160758787071L);
        try {
            List rmList1 = this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.productSiteId = ? and rm.productResourceProviderId = ?", new Object[]{siteId, resourceProviderId});
            List rmList2 = this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.recoverySiteId = ? and rm.recoveryResourceProviderId = ?", new Object[]{siteId, resourceProviderId});
            if (!VerifyUtil.isEmpty((Collection)rmList1) || !VerifyUtil.isEmpty((Collection)rmList2)) {
                isExist = true;
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)"failed to get rmList:", (Throwable)e, 90160758786876L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return isExist;
    }

    public boolean hasRelativeResourceMappingByResource(String siteId, String resourceId) {
        this.log.trace((Object)(this.trace + " trace message"));
        boolean isExist = false;
        this.log.info((Object)("hasRelativeResourceMapping,siteId = " + siteId + "resourceId =" + resourceId), 90160758787071L);
        try {
            List rmList1 = this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.productSiteId = ? and rm.productResourceId = ?", new Object[]{siteId, resourceId});
            List rmList2 = this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.recoverySiteId = ? and rm.recoveryResourceId = ?", new Object[]{siteId, resourceId});
            if (!VerifyUtil.isEmpty((Collection)rmList1) || !VerifyUtil.isEmpty((Collection)rmList2)) {
                isExist = true;
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)"failed to get rmList:", (Throwable)e, 90160758786876L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return isExist;
    }

    public List<ResourceMapping> getResourceMappingBySite(String siteId, ResTypeEnum resourceType, String poProviderSn) {
        if (VerifyUtil.isEmpty((String)siteId) || VerifyUtil.isEmpty((Object)resourceType) || VerifyUtil.isEmpty((String)poProviderSn)) {
            this.log.error((Object)"Error params.");
            throw new LegoCheckedException(1073947393L);
        }
        String hql = "from ResourceMapping as rm where (rm.recoverySiteId = ? or rm.productSiteId = ?) AND rm.resourceType=?  AND  (rm.productResourceProviderId=? or rm.recoveryResourceProviderId=?)";
        return this.dao.getHibernateTemplate().find(hql, new Object[]{siteId, siteId, resourceType.getResType(), poProviderSn, poProviderSn});
    }
}

