/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.drm.galax.constant.cloudenum.ObserverManagerEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.resource.mapping.DrsMappingOperator;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingRemoteOperation;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.DVSwitch;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.VDC;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class ResourceMappingObserver
implements Observer {
    private static final Log log = LogFactory.getInstance(ResourceMappingObserver.class);
    private ResourceMappingRemoteOperation rmRemoteOp;
    private ResourceMappingDao rmDao;
    private DrsMappingOperator drsOperator;

    public ResourceMappingObserver() {
        ObserverManager.getInstance((String)ObserverManagerEnum.FC_DISCOVER_MANAGER.name()).addObserver((Observer)this);
        ObserverManager.getInstance((String)ObserverManagerEnum.FM_DISCOVER_MANAGER.name()).addObserver((Observer)this);
        ObserverManager.getInstance((String)ObserverManagerEnum.VRG_DISCOVER_MANAGER.name()).addObserver((Observer)this);
    }

    public DrsMappingOperator getDrsOperator() {
        return this.drsOperator;
    }

    public void setDrsOperator(DrsMappingOperator drsOperator) {
        this.drsOperator = drsOperator;
    }

    public ResourceMappingRemoteOperation getRmRemoteOp() {
        return this.rmRemoteOp;
    }

    public void setRmRemoteOp(ResourceMappingRemoteOperation rmRemoteOp) {
        this.rmRemoteOp = rmRemoteOp;
    }

    public ResourceMappingDao getRmDao() {
        return this.rmDao;
    }

    public void setRmDao(ResourceMappingDao rmDao) {
        this.rmDao = rmDao;
    }

    @Override
    public void update(Observable o, Object arg) {
        AbstractContext context = (AbstractContext)arg;
        String cloudKeyFlag = (String)context.getAttribute("GALAX_KEY_FLAG");
        if ("DRMFM".equals(cloudKeyFlag)) {
            this.updateFmResourceMapping(arg);
        } else if ("DRMVRM".equals(cloudKeyFlag)) {
            this.updateFcResourceMapping(arg);
        } else if ("DRMVRG".equals(cloudKeyFlag)) {
            this.updateVRGResourceMapping(arg);
        } else {
            log.error((Object)("failed to get cloud key flag:" + cloudKeyFlag), 90160758787071L);
        }
    }

    private void updateFmResourceMapping(Object arg) {
        AbstractContext context = (AbstractContext)arg;
        FusionManager fm = (FusionManager)context.getAttribute("DRMFM");
        log.info((Object)("update resourcemapping after refresh FM " + fm.getName()), 90160758786816L);
        List<ResourceMapping> rmInDB = this.rmDao.getAllResourceMapping();
        if (VerifyUtil.isEmpty((Collection)fm.getChildMos())) {
            this.updateAllResourceMappingProviderInfo(rmInDB, (ManagedObject)fm);
        } else {
            ArrayList<ManagedObject> fmResList = new ArrayList<ManagedObject>();
            fmResList.add((ManagedObject)fm);
            for (ManagedObject mo : fm.getChildMos()) {
                if (!(mo instanceof VPC)) continue;
                fmResList.add(mo);
                fmResList.addAll(mo.getChildMos());
            }
            this.updateFmResourceMappingMoInfo(rmInDB, fmResList);
        }
    }

    private void updateFmResourceMappingMoInfo(List<ResourceMapping> rmInDB, List<ManagedObject> fmResList) {
        for (ResourceMapping rm : rmInDB) {
            if (!rm.isFmResourceMapping()) continue;
            boolean updateFlag = false;
            for (ManagedObject mo : fmResList) {
                if (!this.updateResourceMappingDetailInfo(rm, mo)) continue;
                updateFlag = true;
            }
            if (!updateFlag || !this.rmRemoteOp.updateResourceMappingInRemote(rm)) continue;
            this.rmDao.updateResourceMappingInDB(rm);
        }
    }

    private void updateFcResourceMappingDetailInfo(VRM vrm, ResourceMapping rm) {
        Iterator<ManagedObject> it = vrm.getChildMos().iterator();
        if (rm.getResourceType() == ResTypeEnum.PORT_GROUP.getResType()) {
            while (it.hasNext()) {
                ManagedObject mo = (ManagedObject)it.next();
                if (!(mo instanceof DVSwitch)) continue;
                Iterator<ManagedObject> portGroups = mo.getChildMos().iterator();
                this.updateResourceMappingAfterRefreshVRM(rm, portGroups, vrm);
            }
        } else {
            this.updateResourceMappingAfterRefreshVRM(rm, it, vrm);
            this.updateDrsMappingAfterRefreshRM(vrm, rm);
        }
    }

    private void updateDrsMappingAfterRefreshRM(VRM vrm, ResourceMapping rm) {
        if (rm.getResourceType() == ResTypeEnum.CLUSTER_RESOURCE.getResType()) {
            for (ManagedObject mo : vrm.getChildMos()) {
                if (!(mo instanceof ComputeCluster)) continue;
                Set drsGroups = mo.getChildMos();
                this.drsOperator.updateDrsMappingAfterRefreshResourceMapping(rm, drsGroups, vrm.getUuid());
            }
        }
    }

    private void updateFcResourceMapping(Object arg) {
        AbstractContext context = (AbstractContext)arg;
        VRM vrm = (VRM)context.getAttribute("DRMVRM");
        log.info((Object)("update resourcemapping after refresh VRM " + vrm.getName()), 90160758786816L);
        List rmInDB = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ResourceMapping", new Object[0]);
        if (VerifyUtil.isEmpty((Collection)vrm.getChildMos())) {
            this.updateAllResourceMappingProviderInfo(rmInDB, (ManagedObject)vrm);
        } else {
            for (ResourceMapping rm : rmInDB) {
                if (!vrm.getUuid().equals(rm.getProductResourceProviderId()) && !vrm.getUuid().equals(rm.getRecoveryResourceProviderId())) continue;
                this.updateFcResourceMappingDetailInfo(vrm, rm);
            }
        }
        this.updateAllDrsMappingAndRestoreAlarm();
    }

    private void updateAllDrsMappingAndRestoreAlarm() {
        this.checkAllDrsMapping();
        this.drsOperator.restoreAllDrsMappingAlarm();
    }

    private void checkAllDrsMapping() {
        log.info((Object)"Begin check all DrsMapping...");
        List allDrsMapping = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrsMapping", new Object[0]);
        for (DrsMapping drsMapping : allDrsMapping) {
            log.info((Object)"begin check DrsMapping %s", new Object[]{drsMapping.getMappingId()});
            boolean checkFlag = this.drsOperator.checkDrsMappingAndSendAlarm(drsMapping, true);
            if (!checkFlag) continue;
            log.info((Object)"DrsMapping %s valid,continue check next", new Object[]{drsMapping.getMappingId()});
        }
        log.info((Object)"Check all DrsMapping end...");
    }

    private void updateAllResourceMappingProviderInfo(List<ResourceMapping> rmInDB, ManagedObject mo) {
        for (ResourceMapping rm : rmInDB) {
            this.updateResourceMappingProviderInfo(rm, mo);
        }
    }

    private void updateResourceMappingProviderInfo(ResourceMapping rm, ManagedObject mo) {
        boolean isChanged = false;
        if (mo.getUuid().equals(rm.getProductResourceProviderId())) {
            if (!mo.getName().equals(rm.getProductResourceProviderName())) {
                rm.setProductResourceProviderName(mo.getName());
                isChanged = true;
            }
        } else if (mo.getUuid().equals(rm.getRecoveryResourceProviderId()) && !mo.getName().equals(rm.getRecoveryResourceProviderName())) {
            rm.setRecoveryResourceProviderName(mo.getName());
            isChanged = true;
        }
        if (isChanged && this.rmRemoteOp.updateResourceMappingInRemote(rm)) {
            this.rmDao.updateResourceMappingInDB(rm);
        }
    }

    private void updateResourceMappingAfterRefreshVRM(ResourceMapping rm, Iterator<ManagedObject> it, VRM vrm) {
        boolean isChanged = false;
        if (vrm.getUuid().equals(rm.getProductResourceProviderId())) {
            isChanged = this.updateVrmProductResource(rm, it, vrm);
        } else if (vrm.getUuid().equals(rm.getRecoveryResourceProviderId())) {
            isChanged = this.updateVrmRecoveryResource(rm, it, vrm);
        }
        if (isChanged && this.rmRemoteOp.updateResourceMappingInRemote(rm)) {
            this.rmDao.updateResourceMappingInDB(rm);
        }
    }

    private boolean updateVrmRecoveryResource(ResourceMapping rm, Iterator<ManagedObject> it, VRM vrm) {
        boolean isChanged = false;
        if (!vrm.getName().equals(rm.getRecoveryResourceProviderName())) {
            rm.setRecoveryResourceProviderName(vrm.getName());
            isChanged = true;
        }
        while (it.hasNext()) {
            ManagedObject mo = it.next();
            if (!mo.getUuid().equals(rm.getRecoveryResourceId()) || mo.getName().equals(rm.getRecoveryResourceName())) continue;
            rm.setRecoveryResourceName(mo.getName());
            isChanged = true;
            break;
        }
        return isChanged;
    }

    private boolean updateVrmProductResource(ResourceMapping rm, Iterator<ManagedObject> it, VRM vrm) {
        boolean isChanged = false;
        if (!vrm.getName().equals(rm.getProductResourceProviderName())) {
            rm.setProductResourceProviderName(vrm.getName());
            isChanged = true;
        }
        while (it.hasNext()) {
            ManagedObject mo = it.next();
            if (!mo.getUuid().equals(rm.getProductResourceId()) || mo.getName().equals(rm.getProductResourceName())) continue;
            rm.setProductResourceName(mo.getName());
            isChanged = true;
            break;
        }
        return isChanged;
    }

    private boolean updateResourceMappingDetailInfo(ResourceMapping rm, ManagedObject mo) {
        if (mo instanceof FusionManager) {
            return rm.updateResourceMappingFmInfo(mo);
        }
        if (mo instanceof VPC) {
            return rm.updateResourceMappingVpcInfo(mo);
        }
        if (mo instanceof VDC || mo instanceof FmNetwork || mo instanceof SecurityGroup) {
            return rm.updateResourceMappingResourceInfo(mo);
        }
        return false;
    }

    private void updateVRGResourceMapping(Object arg) {
        AbstractContext context = (AbstractContext)arg;
        VRG vrg = (VRG)context.getAttribute("DRMVRG");
        log.info((Object)("update resourcemapping after refresh VRG " + vrg.getName()), 90160758786816L);
        List<ResourceMapping> rmInDB = this.rmDao.getAllResourceMapping();
        for (ResourceMapping rm : rmInDB) {
            if (rm.getResourceType() != ResTypeEnum.VRG.getResType()) continue;
            boolean updateFlag = false;
            if (vrg.getSn().equals(rm.getProductResourceId()) && !vrg.getName().equals(rm.getProductResourceName())) {
                rm.setProductResourceName(vrg.getName());
                updateFlag = true;
            }
            if (vrg.getSn().equals(rm.getRecoveryResourceId()) && !vrg.getName().equals(rm.getRecoveryResourceName())) {
                rm.setRecoveryResourceName(vrg.getName());
                updateFlag = true;
            }
            if (!updateFlag || !this.rmRemoteOp.updateResourceMappingInRemote(rm)) continue;
            this.rmDao.updateResourceMappingInDB(rm);
        }
    }
}

