/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingCommon;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingRemoteOperation;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.resource.mapping.service.ResourceMappingDeleteCheckService;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class ResourceMappingOperator {
    private static final List<ResourceMapping> SYN_RS_QUEUE = new ArrayList<ResourceMapping>();
    private Log log = LogFactory.getInstance(ResourceMappingOperator.class);
    private String trace = "trace";
    private ISiteBaseService siteService;
    private ResourceMappingDao rmDao;
    private ResourceMappingVerify rmVerify;
    private ResourceMappingRemoteOperation rmRemoteOp;
    private ResourceMappingCommon rmCommon;
    private ResourceMappingDeleteCheckService rmDeleteCheckService;

    public ISiteBaseService getSiteService() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.siteService = siteService;
    }

    public ResourceMappingDao getRmDao() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.rmDao;
    }

    public void setRmDao(ResourceMappingDao rmDao) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmDao = rmDao;
    }

    public ResourceMappingVerify getRmVerify() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmVerify = rmVerify;
    }

    public ResourceMappingRemoteOperation getRmRemoteOp() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.rmRemoteOp;
    }

    public void setRmRemoteOp(ResourceMappingRemoteOperation rmRemoteOp) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmRemoteOp = rmRemoteOp;
    }

    public ResourceMappingCommon getRmCommon() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.rmCommon;
    }

    public void setRmCommon(ResourceMappingCommon rmCommon) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmCommon = rmCommon;
    }

    public void setRmDeleteCheckService(ResourceMappingDeleteCheckService rmDeleteCheckService) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmDeleteCheckService = rmDeleteCheckService;
    }

    public ResourceMappingDeleteCheckService getRmDeleteCheckService() {
        this.log.trace((Object)(this.trace + " trace message"));
        return this.rmDeleteCheckService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createResourceMapping(ResourceMapping resMapping) {
        this.log.trace((Object)(this.trace + " trace message"));
        try {
            List<ResourceMapping> list = SYN_RS_QUEUE;
            synchronized (list) {
                if (this.rmCommon.isResourceMappingInSynQueue(SYN_RS_QUEUE, resMapping) || this.rmVerify.isResourceAlreadyUsed(resMapping, false)) {
                    this.log.error((Object)"Failed to create ResourceMapping by local. Resource is already used.", 90160758787071L);
                    throw new LegoCheckedException(1073947680L);
                }
                this.log.info((Object)("Add ResourceMapping" + resMapping + " to syn list by local."), 90160758786816L);
                SYN_RS_QUEUE.add(resMapping);
            }
            this.addResourceMappingByLocal(resMapping);
        }
        finally {
            if (SYN_RS_QUEUE.contains(resMapping)) {
                this.log.info((Object)("Remove ResourceMapping" + resMapping + " from syn list by local."), 90160758786816L);
                SYN_RS_QUEUE.remove(resMapping);
            }
        }
    }

    private void addResourceMappingByLocal(ResourceMapping resMapping) {
        this.log.trace((Object)(this.trace + " trace message"));
        if (this.rmVerify.isResourceAlreadyUsed(resMapping, false)) {
            this.log.error((Object)"Failed to create ResourceMapping. Resource is already in used.", 90160758787071L);
            throw new LegoCheckedException(1073947680L);
        }
        this.log.info((Object)("createResourceMapping,productSiteId=" + resMapping.getProductSiteId() + "recoverySiteId=" + resMapping.getRecoverySiteId()), 90160758786816L);
        this.rmVerify.isParameterValid(resMapping);
        this.rmVerify.checkResourceType(resMapping.getResourceType());
        resMapping.setRole(1);
        resMapping.setMappingId(UUIDGenerator.getUUID());
        String recoverySiteId = resMapping.getRecoverySiteId();
        this.rmVerify.judgeRmIsValid(resMapping);
        Site recoverySite = this.siteService.getSiteById(recoverySiteId);
        if (recoverySite == null) {
            this.log.error((Object)("recovery site not exist,SiteId" + recoverySiteId), 90160758787071L);
            throw new LegoCheckedException(1073947681L);
        }
        if ("--".equals(resMapping.getRecoveryResourceName())) {
            this.log.error((Object)("param error by recoveryResourceId \uff1a" + resMapping.getRecoveryResourceId()), 90160758787071L);
            throw new LegoCheckedException(65540L);
        }
        if (recoverySite.getSiteType() != 0) {
            this.rmRemoteOp.postRemoteRes(resMapping, recoverySite);
        }
        this.rmDao.saveResouceMapping(resMapping);
    }

    private String getRecoveryResourceName(Site recoverySite, int resourceType, String recoveryResourceId, String recoveryResourceProviderId) {
        this.log.trace((Object)(this.trace + " trace message"));
        if (null == recoverySite) {
            this.log.error((Object)"recoverySite is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (recoverySite.getSiteType() != 0) {
            return this.rmRemoteOp.getRemoteResourceName(resourceType, recoveryResourceId, recoverySite, recoveryResourceProviderId);
        }
        return this.rmDao.getLocalResourceName(resourceType, recoveryResourceId);
    }

    public DrResource getRemoteCloudPaltformDrResource(String siteId, String sn) {
        this.log.trace((Object)(this.trace + " trace message"));
        Site recoverySite = this.siteService.getSiteById(siteId);
        if (recoverySite == null) {
            this.log.error((Object)("recovery site not exist,SiteId" + siteId), 90160758787071L);
            throw new LegoCheckedException(1073947681L);
        }
        DrResource drRemote = this.rmRemoteOp.getRemoteCloudPaltformDrResource(sn, recoverySite);
        this.rmVerify.checkParam(drRemote);
        return drRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synAddResourceMapping(ResourceMapping resourceMapping) {
        this.log.trace((Object)(this.trace + " trace message"));
        try {
            List<ResourceMapping> list = SYN_RS_QUEUE;
            synchronized (list) {
                if (this.rmCommon.isResourceMappingInSynQueue(SYN_RS_QUEUE, resourceMapping) || this.rmVerify.isResourceAlreadyUsed(resourceMapping, false)) {
                    this.log.error((Object)"Failed to syn add ResourceMapping by remote. Resource is already in used.", 90160758787071L);
                    throw new LegoCheckedException(-1L);
                }
                this.log.info((Object)("Add ResourceMapping " + resourceMapping + " to syn list by local."), 90160758786816L);
                SYN_RS_QUEUE.add(resourceMapping);
            }
            this.addResourceMappingByRemote(resourceMapping);
        }
        finally {
            if (SYN_RS_QUEUE.contains(resourceMapping)) {
                this.log.info((Object)("Remove ResourceMapping  " + resourceMapping + " from syn list by local."), 90160758786816L);
                SYN_RS_QUEUE.remove(resourceMapping);
            }
        }
    }

    private void addResourceMappingByRemote(ResourceMapping resourceMapping) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmVerify.checkParam(resourceMapping);
        if (this.rmVerify.isResourceAlreadyUsed(resourceMapping, false)) {
            this.log.error((Object)"Failed to synAddResourceMapping,sync add resourceMapping failed", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        resourceMapping.setRole(0);
        try {
            this.rmDao.saveResouceMapping(resourceMapping);
            this.log.info((Object)"Succeed to synAddResourceMapping", 90160758786816L);
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Failed to synAddResourceMapping,DataAccessException", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public synchronized void deleteResourceMapping(String resMappingId) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.log.info((Object)("To deleteResourceMapping, resMappingId:" + resMappingId), 90160758786816L);
        this.rmVerify.checkParam(resMappingId);
        ResourceMapping resourceMapping = this.rmDao.getResMappingWithPersistentValueOnly(resMappingId);
        this.rmCommon.checkObjExist(resourceMapping);
        this.log.info((Object)("deleteResourceMappingInDB ,resMappingId:" + resourceMapping.getMappingId()), 90160758786816L);
        Site remoteSite = this.siteService.getSiteById(resourceMapping.getRecoverySiteId());
        if (remoteSite == null) {
            throw new LegoCheckedException(1073947681L);
        }
        if (remoteSite.getSiteType() != 0) {
            this.rmRemoteOp.deleteRemoteResourceMapping(resourceMapping, remoteSite);
        }
        try {
            this.rmDao.deleteResourceMappingInDB(resourceMapping);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("delete resourceMapping error, resMappingId=" + resMappingId), (long)-1L, null, (Log)this.log);
        }
    }

    public synchronized void updateResourceMapping(ResourceMapping resMapping) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.log.info((Object)resMapping.toString(), 90160758786816L);
        String resMappingId = resMapping.getMappingId();
        this.rmVerify.checkParam(resMappingId);
        ResourceMapping rm = this.rmDao.getResMappingWithPersistentValueOnly(resMappingId);
        this.rmCommon.checkObjExist(rm);
        String oldRecoverySiteId = rm.getRecoverySiteId();
        String recoverySiteId = resMapping.getRecoverySiteId();
        String recoveryResourceProviderId = resMapping.getRecoveryResourceProviderId();
        int resourceType = resMapping.getResourceType();
        String recoveryVpcId = resMapping.getRecoveryVpcId();
        String recoveryVpcName = resMapping.getRecoveryVpcName();
        String recoveryResourceId = resMapping.getRecoveryResourceId();
        String recoveryResourceName = resMapping.getRecoveryResourceName();
        this.rmVerify.checkProductInfo(rm, resMapping);
        this.rmVerify.isParameterValid(resMapping);
        if (this.rmVerify.isResourceAlreadyUsed(resMapping, true)) {
            throw new LegoCheckedException(1073947680L);
        }
        Site recoverySite = this.getSiteAndCheck(recoverySiteId);
        Site oldRecoverySite = this.getSiteAndCheck(oldRecoverySiteId);
        String recoverySiteName = recoverySite.getName();
        DrResource drRemote = this.rmRemoteOp.getRemoteCloudPaltformDrResource(recoveryResourceProviderId, recoverySite);
        this.rmVerify.checkParam(drRemote);
        String recoveryResourceProviderName = drRemote.getName();
        this.rmVerify.checkResourceType(resourceType);
        String parentId = recoveryResourceProviderId;
        if (this.rmVerify.isRelationVPC(resMapping)) {
            if (!rm.getRecoveryVpcName().equals(recoveryVpcName)) {
                recoveryVpcName = this.rmRemoteOp.getRemoteVpcResouceName(recoveryVpcId, recoverySite, recoveryResourceProviderId);
            }
            parentId = recoveryVpcId;
        }
        if (!rm.getRecoveryResourceName().equals(recoveryResourceName)) {
            recoveryResourceName = this.getNewrecoveryResourceName(resourceType, recoveryResourceId, recoverySite, parentId);
            this.rmCommon.checkObjExist(recoveryResourceName);
        }
        if (recoverySite.getSiteType() == 0 && oldRecoverySite.getSiteType() != 0) {
            this.rmRemoteOp.deleteRemoteResourceMapping(rm, oldRecoverySite);
        }
        rm.setRecoveryResourceId(recoveryResourceId);
        rm.setRecoveryResourceName(recoveryResourceName);
        rm.setRecoveryResourceProviderId(recoveryResourceProviderId);
        rm.setRecoveryResourceProviderName(recoveryResourceProviderName);
        rm.setRecoverySiteId(recoverySiteId);
        rm.setRecoverySiteName(recoverySiteName);
        rm.setResourceType(resourceType);
        rm.setRecoveryVpcId(recoveryVpcId);
        rm.setRecoveryVpcName(recoveryVpcName);
        this.rmRemoteOp.updateRemoteRes(rm, recoverySite, oldRecoverySite);
        this.rmDao.updateResourceMappingInDB(rm);
    }

    private Site getSiteAndCheck(String siteId) {
        this.log.trace((Object)(this.trace + " trace message"));
        Site site = this.siteService.getSiteById(siteId);
        if (site == null) {
            this.log.error((Object)("site not exist,site id " + siteId), 90160758787071L);
            throw new LegoCheckedException(1073947681L);
        }
        return site;
    }

    private String getNewrecoveryResourceName(int resourceType, String recoveryResourceId, Site recoverySite, String recoveryResourceProviderId) {
        this.log.trace((Object)(this.trace + " trace message"));
        if (recoverySite.getSiteType() != 0) {
            return this.rmRemoteOp.getRemoteResourceName(resourceType, recoveryResourceId, recoverySite, recoveryResourceProviderId);
        }
        return this.rmDao.getLocalResourceName(resourceType, recoveryResourceId);
    }

    public BatchOperationResult createResourceMapping(List<ResourceMapping> resMappingList) {
        this.log.trace((Object)(this.trace + " trace message"));
        BatchOperationResult ret = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int succCount = 0;
        if (resMappingList == null) {
            return ret;
        }
        for (ResourceMapping rm : resMappingList) {
            BatchOperation batchOperation = new BatchOperation();
            try {
                this.resetRmResourceName(rm);
                this.createResourceMapping(rm);
                batchOperation.setErrorCode(0L);
                ++succCount;
            }
            catch (LegoCheckedException e) {
                this.log.error((Object)"catch legoexception with", (Throwable)e, 90160758787071L);
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (Exception e) {
                this.log.error((Object)("catch exception with" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                batchOperation.setErrorCode(-1L);
            }
            batchOperation.setTargetName(rm.getResourceType() + "," + rm.getProductResourceName() + "," + rm.getRecoveryResourceName());
            if (this.rmVerify.isRelationVPC(rm)) {
                batchOperation.setDetailParam(new String[]{rm.getProductResourceName(), rm.getRecoveryResourceName(), rm.getProductSiteName(), rm.getProductResourceProviderName(), rm.getProductVpcName(), rm.getRecoverySiteName(), rm.getRecoveryResourceProviderName(), rm.getRecoveryVpcName()});
            } else {
                batchOperation.setDetailParam(new String[]{rm.getProductResourceName(), rm.getRecoveryResourceName(), rm.getProductSiteName(), rm.getProductResourceProviderName(), rm.getRecoverySiteName(), rm.getRecoveryResourceProviderName()});
            }
            resultList.add(batchOperation);
        }
        ret.setResult(resultList);
        ret.setFailCount(resMappingList.size() - succCount);
        ret.setTotalCount(resMappingList.size());
        ret.setSucceedCount(succCount);
        return ret;
    }

    public void synDeleteResourceMapping(String resMappingId) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmVerify.checkParam(resMappingId);
        ResourceMapping resourceMapping = this.rmDao.getResMappingWithPersistentValueOnly(resMappingId);
        this.rmDeleteCheckService.checkResourceMappingCanDelete(resourceMapping);
        this.rmCommon.checkObjExist(resourceMapping);
        this.rmDao.deleteResourceMappingInDB(resourceMapping);
    }

    public void synUpdateResourceMapping(ResourceMapping resMapping) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.log.info((Object)("Before exchange,resMapping's role is " + resMapping.getRole()), 90160758786816L);
        resMapping.setRole(resMapping.getRole() ^ 1);
        this.log.info((Object)("After exchange,resMapping's role is " + resMapping.getRole()), 90160758786816L);
        this.rmDao.updateResourceMappingInDB(resMapping);
    }

    public void checkResourceMappingCanDelete(String resMappingId) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.log.info((Object)("To check resourcemapping can delete, resMappingId:" + resMappingId), 90160758786816L);
        this.rmVerify.checkParam(resMappingId);
        ResourceMapping resourceMapping = this.rmDao.getResMappingWithPersistentValueOnly(resMappingId);
        this.rmCommon.checkObjExist(resourceMapping);
        this.rmDeleteCheckService.checkResourceMappingCanDelete(resourceMapping);
    }

    private void resetRmResourceName(ResourceMapping resMapping) {
        DrResource drRemote;
        DrResource dr;
        this.log.trace((Object)(this.trace + " trace message"));
        String productSiteId = resMapping.getProductSiteId();
        String recoverySiteId = resMapping.getRecoverySiteId();
        String productResourceProviderId = resMapping.getProductResourceProviderId();
        String recoveryResourceProviderId = resMapping.getRecoveryResourceProviderId();
        int resourceType = resMapping.getResourceType();
        String productResourceId = resMapping.getProductResourceId();
        String recoveryResourceId = resMapping.getRecoveryResourceId();
        String productVpcId = resMapping.getProductVpcId();
        String recoveryVpcId = resMapping.getRecoveryVpcId();
        String productVpcName = "--";
        String recoveryVpcName = "--";
        String productSiteName = "--";
        String productResourceName = "--";
        String productResourceProviderName = "--";
        String recoverySiteName = "--";
        String recoveryResourceName = "--";
        String recoveryResourceProviderName = "--";
        Site productSite = this.siteService.getSiteById(productSiteId);
        Site recoverySite = this.siteService.getSiteById(recoverySiteId);
        if (productSite != null) {
            productSiteName = productSite.getName();
        }
        if (recoverySite != null) {
            recoverySiteName = recoverySite.getName();
        }
        if ((dr = this.rmDao.getCloudPlatformBySN(productResourceProviderId)) != null) {
            productResourceProviderName = dr.getName();
        }
        if (null != (drRemote = this.getRemoteCloudPaltformDrResource(recoverySiteId, recoveryResourceProviderId))) {
            recoveryResourceProviderName = drRemote.getName();
        }
        try {
            productResourceName = this.rmDao.getLocalResourceName(resourceType, productResourceId);
            if (this.rmVerify.isRelationVPC(resMapping)) {
                recoveryResourceName = this.getRecoveryResourceName(recoverySite, resourceType, recoveryResourceId, recoveryVpcId);
                productVpcName = this.rmDao.getLocalResourceName(ResTypeEnum.VPC.getResType(), productVpcId);
                recoveryVpcName = this.rmRemoteOp.getRemoteVpcResouceName(recoveryVpcId, recoverySite, recoveryResourceProviderId);
            } else {
                recoveryResourceName = this.getRecoveryResourceName(recoverySite, resourceType, recoveryResourceId, recoveryResourceProviderId);
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"Failed to createResourceMapping, Resource name is empty. ", (Throwable)e, 90160758787071L);
            if (1073947394L == e.getErrorCode()) {
                resMapping.setProductResourceName(VerifyUtil.isEmpty((String)productResourceName) ? "--" : productResourceName);
                resMapping.setRecoveryResourceName(VerifyUtil.isEmpty((String)recoveryResourceName) ? "--" : recoveryResourceName);
                throw e;
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to createResourceMapping, Resource name is empty. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        resMapping.setProductSiteName(productSiteName);
        resMapping.setRecoverySiteName(recoverySiteName);
        resMapping.setProductResourceProviderName(productResourceProviderName);
        resMapping.setRecoveryResourceProviderName(recoveryResourceProviderName);
        resMapping.setProductResourceName(VerifyUtil.isEmpty((String)productResourceName) ? "--" : productResourceName);
        resMapping.setRecoveryResourceName(VerifyUtil.isEmpty((String)recoveryResourceName) ? "--" : recoveryResourceName);
        resMapping.setProductVpcName(productVpcName);
        resMapping.setRecoveryVpcName(recoveryVpcName);
    }
}

