/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingCommon;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.VDC;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceMappingRemoteOperation {
    private Log log = LogFactory.getInstance(ResourceMappingRemoteOperation.class);
    private String trace = "trace";
    private ISiteBaseService siteService;
    private ResourceMappingCommon rmCommon;
    private ResourceMappingDao rmDao;
    private ResourceMappingVerify rmVerify;
    private Map<String, String> remoteRestUrl = new HashMap<String, String>();

    public ResourceMappingRemoteOperation() {
        this.remoteRestUrl.put(SecurityGroup.class.getName(), "/ws/resmapping/getAvailableSecurityGroup?siteId=%s&sn=%s");
        this.remoteRestUrl.put(FmNetwork.class.getName(), "/ws/resmapping/getAvailableNetwork?siteId=%s&sn=%s");
        this.remoteRestUrl.put(VDC.class.getName(), "/ws/resmapping/getAvailableVDC?siteId=%s&sn=%s");
        this.remoteRestUrl.put(DataStore.class.getName(), "/ws/resmapping/getAvailableDataStore?siteId=%s&sn=%s");
        this.remoteRestUrl.put(VRG.class.getName(), "/ws/resmapping/getAvailableVRG?siteId=%s&sn=%s");
    }

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public ResourceMappingCommon getRmCommon() {
        return this.rmCommon;
    }

    public void setRmCommon(ResourceMappingCommon rmCommon) {
        this.rmCommon = rmCommon;
    }

    public ResourceMappingDao getRmDao() {
        return this.rmDao;
    }

    public void setRmDao(ResourceMappingDao rmDao) {
        this.rmDao = rmDao;
    }

    public ResourceMappingVerify getRmVerify() {
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.rmVerify = rmVerify;
    }

    public void postRemoteRes(ResourceMapping resourceMapping, Site recoverySite) {
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)recoverySite);
        if (!this.rmVerify.isValidated(resourceMapping)) {
            this.log.error((Object)"resourceMapping is not validated");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            client.postSerializableObj((Object)resourceMapping, "/ws/resmapping/synAddResourceMapping");
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"syn add ResourceMapping to remote site exception.", (long)1073947440L, null, (Log)this.log);
        }
    }

    public void updateRemoteRes(ResourceMapping rm, Site recoverySite, Site oldRecoverySite) {
        this.log.trace((Object)(this.trace + " trace message"));
        if (recoverySite.getSiteType() != 0 && oldRecoverySite.getSiteType() != 0 && recoverySite.getSiteId().equals(oldRecoverySite.getSiteId())) {
            this.updateRemoteRes1(recoverySite, rm);
        } else if (recoverySite.getSiteType() != 0 && oldRecoverySite.getSiteType() != 0 && !recoverySite.getSiteId().equals(oldRecoverySite.getSiteId())) {
            this.updateRemoteRes2(oldRecoverySite, recoverySite, rm);
        } else if (recoverySite.getSiteType() != 0 && oldRecoverySite.getSiteType() == 0) {
            this.updateRemoteRes3(recoverySite, rm);
        }
    }

    public boolean updateResourceMappingInRemote(ResourceMapping rm) {
        this.log.trace((Object)(this.trace + " trace message"));
        Site productSite = this.siteService.getSiteById(rm.getProductSiteId());
        Site recoverySite = this.siteService.getSiteById(rm.getRecoverySiteId());
        if (productSite.getSiteType() == 1) {
            try {
                this.updateRemoteRes1(productSite, rm);
            }
            catch (LegoCheckedException ex) {
                this.log.error((Object)("An error occurs while updating ResourceMapping on remote site " + productSite.getName()), (Throwable)ex, 90160758787071L);
                return false;
            }
        }
        if (recoverySite.getSiteType() == 1) {
            try {
                this.updateRemoteRes1(recoverySite, rm);
            }
            catch (LegoCheckedException ex) {
                this.log.error((Object)("An error occurs while updating ResourceMapping on remote site " + recoverySite.getName()), (Throwable)ex, 90160758787071L);
                return false;
            }
        }
        return true;
    }

    public void updateRemoteRes1(Site recoverySite, ResourceMapping rm) {
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)recoverySite);
        if (!this.rmVerify.isValidated(rm)) {
            this.log.error((Object)"rm is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            client.postSerializableObj((Object)rm, "/ws/resmapping/synUpdateResourceMapping");
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"syn update ResourceMapping to remote site exception.", (long)1073947440L, null, (Log)this.log);
        }
    }

    public void updateRemoteRes2(Site oldRecoverySite, Site recoverySite, ResourceMapping rm) {
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient clientOld = SiteUtil.initClient((Site)oldRecoverySite);
        if (VerifyUtil.isEmpty((String)rm.getMappingId()) || "-1".equals(rm.getMappingId())) {
            this.log.error((Object)"MappingId is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            clientOld.get("/ws/resmapping/synDeleteResourceMapping?resMappingId=" + rm.getMappingId());
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"delete resource mapping catch LegoCheckedException:", (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"delete ResourceMapping to remote site exception.", (long)1073947440L, null, (Log)this.log);
        }
        RestClient clientNew = SiteUtil.initClient((Site)recoverySite);
        if (!this.rmVerify.isValidated(rm)) {
            this.log.error((Object)"rm is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            clientNew.postSerializableObj((Object)rm, "/ws/resmapping/synAddResourceMapping");
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"add remote resource mapping catch exception:", (long)1073947440L, null, (Log)this.log);
        }
    }

    public void updateRemoteRes3(Site recoverySite, ResourceMapping rm) {
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)recoverySite);
        if (!this.rmVerify.isValidated(rm)) {
            this.log.error((Object)"rm is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            client.postSerializableObj((Object)rm, "/ws/resmapping/synAddResourceMapping");
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"add remote resource mapping catch exception:", (long)1073947440L, null, (Log)this.log);
        }
    }

    public void deleteRemoteResourceMapping(ResourceMapping resourceMapping, Site remoteSite) {
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)remoteSite);
        if (!resourceMapping.isResourceMappingIDValid()) {
            this.log.error((Object)"ResourceMappingID is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            client.get("/ws/resmapping/synDeleteResourceMapping?resMappingId=" + resourceMapping.getMappingId());
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)("delete remote resourceMapping rest request error, resMappingId=" + resourceMapping.getMappingId()), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"delete remote resourceMapping rest request catch exception", (long)1073947440L, null, (Log)this.log);
        }
    }

    public String getRemoteResourceName(int resourceType, String recoveryResourceId, Site remoteSite, String vrmId) {
        String resourceName;
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)remoteSite);
        if (resourceType == ResTypeEnum.CLUSTER_RESOURCE.getResType()) {
            resourceName = this.getRemoteComputeClusterResouceName(remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.COMPUTE_NODE.getResType()) {
            resourceName = this.getRemoteComputeNodeResouceName(remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.PORT_GROUP.getResType()) {
            resourceName = this.getRemotePortGroupResouceName(remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.DATASTORE.getResType()) {
            resourceName = this.getRemoteDataStoreResouceName(remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.NETWORK.getResType()) {
            resourceName = this.getRemoteCloudPlatformResouceName(ResTypeEnum.NETWORK.getResType(), remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.SECURITY_GROUP.getResType()) {
            resourceName = this.getRemoteCloudPlatformResouceName(ResTypeEnum.SECURITY_GROUP.getResType(), remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.VDC.getResType()) {
            resourceName = this.getRemoteCloudPlatformResouceName(ResTypeEnum.VDC.getResType(), remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else if (resourceType == ResTypeEnum.VRG.getResType()) {
            resourceName = this.getRemoteCloudPlatformResouceName(ResTypeEnum.VRG.getResType(), remoteSite.getSiteId(), vrmId, recoveryResourceId, client);
        } else {
            this.log.error((Object)("Error resource type : " + resourceType), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        return resourceName;
    }

    public String getRemoteComputeClusterResouceName(String siteId, String vrmId, String recoveryResourceId, RestClient client) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<ComputeCluster> computeClusterList = new ArrayList<ComputeCluster>();
        String resourceName = null;
        String url = "/ws/resmapping/getAvailableCluster?siteId=" + siteId + "&vrmId=" + vrmId;
        String jsonStr = client.getReourceCollect(url);
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                ComputeCluster computeCluster = this.rmCommon.getComputeClusterFromJson(json);
                if (computeCluster == null) {
                    this.log.error((Object)("parameter error computeCluster not exist,recoveryResourceId:" + recoveryResourceId), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                computeClusterList.add(computeCluster);
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        for (ComputeCluster cc : computeClusterList) {
            if (!cc.getUuid().equals(recoveryResourceId)) continue;
            resourceName = cc.getName();
        }
        return resourceName;
    }

    public String getRemoteComputeNodeResouceName(String siteId, String vrmId, String recoveryResourceId, RestClient client) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<ComputeNode> computeNodeList = new ArrayList<ComputeNode>();
        String resourceName = null;
        String url = "/ws/resmapping/getAvailableComputeNode?siteId=" + siteId + "&vrmId=" + vrmId;
        String jsonStr = client.getReourceCollect(url);
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                ComputeNode computeNode = this.rmCommon.getComputeNodeFromJson(json);
                if (computeNode == null) {
                    this.log.error((Object)("parameter error computeNode not exist,recoveryResourceId:" + recoveryResourceId), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                computeNodeList.add(computeNode);
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        for (ComputeNode cn : computeNodeList) {
            if (!cn.getUuid().equals(recoveryResourceId)) continue;
            resourceName = cn.getName();
        }
        return resourceName;
    }

    public String getRemotePortGroupResouceName(String siteId, String vrmId, String recoveryResourceId, RestClient client) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<PortGroup> portGroupList = new ArrayList<PortGroup>();
        String resourceName = null;
        String url = "/ws/resmapping/getAvailablePortGroup?siteId=" + siteId + "&vrmId=" + vrmId;
        String jsonStr = client.getReourceCollect(url);
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                PortGroup portGroup = this.rmCommon.getPortGroupFromJson(json);
                if (portGroup == null) {
                    this.log.error((Object)("parameter error portGroup not exist,recoveryResourceId:" + recoveryResourceId), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                portGroupList.add(portGroup);
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        for (PortGroup cn : portGroupList) {
            if (!cn.getUuid().equals(recoveryResourceId)) continue;
            resourceName = cn.getName();
        }
        return resourceName;
    }

    public String getRemoteCloudPlatformResouceName(int resourceType, String siteId, String sn, String recoveryResourceId, RestClient client) {
        String url;
        this.log.trace((Object)(this.trace + " trace message"));
        String resourceName = null;
        if (ResTypeEnum.NETWORK.getResType() == resourceType) {
            url = "/ws/resmapping/getAvailableNetwork?siteId=" + siteId + "&sn=" + sn;
        } else if (ResTypeEnum.SECURITY_GROUP.getResType() == resourceType) {
            url = "/ws/resmapping/getAvailableSecurityGroup?siteId=" + siteId + "&sn=" + sn;
        } else if (ResTypeEnum.VPC.getResType() == resourceType) {
            url = "/ws/resmapping/getAllVPC?siteId=" + siteId + "&sn=" + sn;
        } else if (ResTypeEnum.VDC.getResType() == resourceType) {
            url = "/ws/resmapping/getAvailableVDC?siteId=" + siteId + "&sn=" + sn;
        } else if (ResTypeEnum.VRG.getResType() == resourceType) {
            url = "/ws/resmapping/getAvailableVRG?siteId=" + siteId + "&sn=" + sn;
        } else {
            this.log.error((Object)"ResTypeEnum do not has the resourceType ");
            throw new LegoCheckedException(1073947393L);
        }
        String jsonStr = client.get(url, null);
        List<GalaxObject> galaxObjectList = this.rmCommon.parseRemoteResource(jsonStr, GalaxObject.class);
        for (GalaxObject go : galaxObjectList) {
            if (!go.getUuid().equals(recoveryResourceId)) continue;
            resourceName = go.getName();
            break;
        }
        return resourceName;
    }

    public String getRemoteVpcResouceName(String recoveryResourceId, Site remoteSite, String sn) {
        String resourceName;
        this.log.trace((Object)(this.trace + " trace message"));
        if (remoteSite.getSiteType() == 0) {
            resourceName = this.rmDao.getLocalResourceName(ResTypeEnum.VPC.getResType(), recoveryResourceId);
        } else {
            RestClient client = SiteUtil.initClient((Site)remoteSite);
            resourceName = this.getRemoteCloudPlatformResouceName(ResTypeEnum.VPC.getResType(), remoteSite.getSiteId(), sn, recoveryResourceId, client);
        }
        return resourceName;
    }

    public DrResource getRemoteCloudPaltformDrResource(String recoveryResourceProviderId, Site recoverySite) {
        this.log.trace((Object)(this.trace + " trace message"));
        DrResource drCloud = null;
        if (recoverySite.getSiteType() != 0) {
            RestClient client = SiteUtil.initClient((Site)recoverySite);
            String url = "/ws/resmapping/getRemoteCloudPaltformDrResource?siteId=" + recoverySite.getSiteId() + "&sn=" + recoveryResourceProviderId;
            if (VerifyUtil.isEmpty((String)recoveryResourceProviderId) || recoveryResourceProviderId.equals("-1")) {
                this.log.error((Object)"recoveryResourceProviderId is empty or -1.");
                throw new LegoCheckedException(1073947393L);
            }
            try {
                String json = client.get(url, null);
                JSONObject object = JSONObject.fromObject((Object)json);
                String uuid = object.getString("uuid");
                String name = object.getString("name");
                if (VerifyUtil.isEmpty((String)uuid) || VerifyUtil.isEmpty((String)name)) {
                    this.log.error((Object)("get remote object faild, object is not exist, recoveryResourceProviderId=" + recoveryResourceProviderId), 90160758787071L);
                    throw new LegoCheckedException(1073947394L);
                }
                drCloud = new DrResource();
                drCloud.setDeviceSn(uuid);
                drCloud.setName(name);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("get remote object faild, recoveryResourceProviderId=" + recoveryResourceProviderId), (long)1073947399L, null, (Log)this.log);
            }
        } else {
            drCloud = this.rmDao.getCloudPlatformBySN(recoveryResourceProviderId);
        }
        return drCloud;
    }

    public <T extends ManagedObject> List<T> getRemoteAvailableResources(Site site, String siteId, String sn, Class<T> resClass) {
        String jsonStr;
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<T> availableList = new ArrayList<T>();
        RestClient client = SiteUtil.initClient((Site)site);
        String url = String.format(this.remoteRestUrl.get(resClass.getName()), siteId, sn);
        try {
            jsonStr = client.getReourceCollect(url);
        }
        catch (LegoCheckedException e) {
            return availableList;
        }
        catch (Exception e) {
            this.log.error((Object)("getRemoteAvailableResources failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return availableList;
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                T galaxObject = this.rmCommon.getGalaxObjectFromJson(json, resClass);
                if (null == galaxObject) continue;
                availableList.add(galaxObject);
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return availableList;
    }

    public String getRemoteDataStoreResouceName(String siteId, String vrmId, String recoveryResourceId, RestClient client) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<DataStore> dataStoreList = new ArrayList<DataStore>();
        String resourceName = null;
        String url = "/ws/resmapping/getAvailableDataStore?siteId=" + siteId + "&sn=" + vrmId;
        String jsonStr = client.getReourceCollect(url);
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                DataStore dataStore = this.rmCommon.getGalaxObjectFromJson(json, DataStore.class);
                if (dataStore == null) {
                    this.log.error((Object)("parameter error portGroup not exist,recoveryResourceId:" + recoveryResourceId), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                dataStoreList.add(dataStore);
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        for (DataStore cn : dataStoreList) {
            if (!cn.getUuid().equals(recoveryResourceId)) continue;
            resourceName = cn.getName();
        }
        return resourceName;
    }
}

