/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class ResourceMappingVerify {
    private static final Log log = LogFactory.getInstance(ResourceMappingVerify.class);
    private static final boolean IS_ULTRAVR = BusinessUtil.isUltraVR();
    private IBaseDao<Object, Serializable> dao;

    public IBaseDao<Object, Serializable> getDao() {
        return this.dao;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.dao = dao;
    }

    public boolean isResourceAlreadyUsed(ResourceMapping rm, boolean isUpdate) {
        boolean isExist = false;
        try {
            List rmList = rm.getResourceType() == ResTypeEnum.VRG.getResType() ? this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.productResourceId = ? or rm.recoveryResourceId = ? or rm.productResourceId = ? or rm.recoveryResourceId = ?", new Object[]{rm.getProductResourceId(), rm.getProductResourceId(), rm.getRecoveryResourceId(), rm.getRecoveryResourceId()}) : (rm.getResourceType() == ResTypeEnum.CLUSTER_RESOURCE.getResType() || rm.getResourceType() == ResTypeEnum.PORT_GROUP.getResType() ? (isUpdate ? this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.recoveryResourceId = ? or rm.productResourceId = ?", new Object[]{rm.getProductResourceId(), rm.getRecoveryResourceId()}) : this.getResourceMappingsByIsUltraVR(rm, IS_ULTRAVR)) : this.dao.getHibernateTemplate().find("from ResourceMapping as rm where (rm.productResourceId = ? and rm.recoveryResourceId = ?) or (rm.productResourceId = ? and rm.recoveryResourceId = ?)", new Object[]{rm.getProductResourceId(), rm.getRecoveryResourceId(), rm.getRecoveryResourceId(), rm.getProductResourceId()}));
            log.info((Object)"Parameter rm of method isResourceAlreadyUsed is %s.", new Object[]{rm.toString()});
            if (!VerifyUtil.isEmpty((Collection)rmList)) {
                isExist = true;
            }
            if (!isExist) {
                isExist = this.isExistInTwoSite(rm);
            }
        }
        catch (DataAccessException ex) {
            log.error((Object)"Failed to get rmList,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return isExist;
    }

    private List<ResourceMapping> getResourceMappingsByIsUltraVR(ResourceMapping rm, boolean isUltraVR) {
        List rmList = isUltraVR ? this.dao.getHibernateTemplate().find("from ResourceMapping as rm where rm.productResourceId = ? or rm.recoveryResourceId = ? or rm.productResourceId = ? or rm.recoveryResourceId = ?", new Object[]{rm.getProductResourceId(), rm.getProductResourceId(), rm.getRecoveryResourceId(), rm.getRecoveryResourceId()}) : this.dao.getHibernateTemplate().find("from ResourceMapping as rm where (rm.productResourceId = ? and rm.recoveryResourceId = ?) or (rm.productResourceId = ? and rm.recoveryResourceId = ?)", new Object[]{rm.getProductResourceId(), rm.getRecoveryResourceId(), rm.getRecoveryResourceId(), rm.getProductResourceId()});
        return rmList;
    }

    private boolean isExistInTwoSite(ResourceMapping rm) {
        List rmList;
        boolean isExist = false;
        if (ResTypeEnum.VRG.getResType() != rm.getResourceType() && !VerifyUtil.isEmpty((Collection)(rmList = this.dao.getHibernateTemplate().find("from ResourceMapping as rm where (rm.productSiteId = ? and rm.recoverySiteId = ?) or (rm.recoverySiteId = ? and rm.productSiteId = ?)", new Object[]{rm.getProductSiteId(), rm.getRecoverySiteId(), rm.getRecoverySiteId(), rm.getProductSiteId()})))) {
            for (ResourceMapping mapping : rmList) {
                if (null != mapping.getMappingId() && mapping.getMappingId().equals(rm.getMappingId()) || mapping.getResourceType() != rm.getResourceType() || !mapping.getProductResourceId().equals(rm.getProductResourceId()) && !mapping.getRecoveryResourceId().equals(rm.getProductResourceId()) && !mapping.getProductResourceId().equals(rm.getRecoveryResourceId()) && !mapping.getRecoveryResourceId().equals(rm.getRecoveryResourceId())) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    public void checkParam(Object param) {
        if (null == param) {
            log.error((Object)"Error params.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public boolean isResourceUnUsed(String resourceId) {
        List resourceMappingList = this.dao.getHibernateTemplate().loadAll(ResourceMapping.class);
        boolean tag = true;
        for (ResourceMapping resourceMapping : resourceMappingList) {
            if (resourceMapping.getProductResourceId().equals(resourceId) || resourceMapping.getRecoveryResourceId().equals(resourceId)) {
                tag = false;
                break;
            }
            tag = true;
        }
        return tag;
    }

    public void checkProductInfo(ResourceMapping oldRes, ResourceMapping newRes) {
        String oldProductSiteId = oldRes.getProductSiteId();
        String oldProductResourceProviderId = oldRes.getProductResourceProviderId();
        String oldProductResourceId = oldRes.getProductResourceId();
        String newproductSiteId = newRes.getProductSiteId();
        String newproductResourceProviderId = newRes.getProductResourceProviderId();
        String newproductResourceId = newRes.getProductResourceId();
        int oldResourceType = oldRes.getResourceType();
        int newresourceType = newRes.getResourceType();
        if (!(oldProductSiteId.equals(newproductSiteId) && oldProductResourceProviderId.equals(newproductResourceProviderId) && oldProductResourceId.equals(newproductResourceId))) {
            throw new LegoCheckedException(65540L);
        }
        if (oldResourceType != newresourceType) {
            throw new LegoCheckedException(65540L);
        }
    }

    public void judgeRmIsValid(ResourceMapping resourceMapping) {
        if (!this.isValidated(resourceMapping)) {
            log.error((Object)"resourceMapping is invalide ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void isParameterValid(ResourceMapping resMapping) {
        String productSiteId = resMapping.getProductSiteId();
        String recoverySiteId = resMapping.getRecoverySiteId();
        String productResourceProviderId = resMapping.getProductResourceProviderId();
        String recoveryResourceProviderId = resMapping.getRecoveryResourceProviderId();
        String productResourceId = resMapping.getProductResourceId();
        String recoveryResourceId = resMapping.getRecoveryResourceId();
        String productVpcId = resMapping.getProductVpcId();
        String recoveryVpcId = resMapping.getRecoveryVpcId();
        if (productSiteId == null || recoverySiteId == null || productSiteId.equals(recoverySiteId)) {
            log.error((Object)("parameter error productSiteId:" + productSiteId + "recoverySiteId:" + recoverySiteId), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (productResourceProviderId == null || recoveryResourceProviderId == null || productResourceId == null || recoveryResourceId == null) {
            log.error((Object)("invalid parameter productResourceProviderId:" + productResourceProviderId + "recoveryResourceProviderId:" + recoveryResourceProviderId + "productResourceId" + productResourceId + "recoveryResourceId" + recoveryResourceId), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!(resMapping.getResourceType() != ResTypeEnum.NETWORK.getResType() && resMapping.getResourceType() != ResTypeEnum.SECURITY_GROUP.getResType() || productVpcId != null && recoveryVpcId != null)) {
            log.error((Object)("invalid parameter productVpcId:" + productResourceProviderId + "recoveryVpcId:"), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void checkResourceType(int resourceType) {
        ResTypeEnum resType = ResTypeEnum.getResType((int)resourceType);
        if (null == resType) {
            log.error((Object)("resourceType error,resourceType" + resourceType), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public boolean isValidated(ResourceMapping rm) {
        boolean isValidate;
        boolean isValidateVpc;
        if (null == rm) {
            return false;
        }
        boolean isValidateProName = !VerifyUtil.isEmpty((String)rm.getProductSiteName()) && !VerifyUtil.isEmpty((String)rm.getRecoverySiteName()) && !VerifyUtil.isEmpty((String)rm.getProductResourceProviderName());
        boolean isValidateRecName = !VerifyUtil.isEmpty((String)rm.getRecoveryResourceProviderName()) && !VerifyUtil.isEmpty((String)rm.getProductResourceName()) && !VerifyUtil.isEmpty((String)rm.getRecoveryResourceName());
        boolean bl = isValidateVpc = !VerifyUtil.isEmpty((String)rm.getProductVpcName()) && !VerifyUtil.isEmpty((String)rm.getRecoveryVpcName());
        if (rm.getResourceType() == ResTypeEnum.NETWORK.getResType() || rm.getResourceType() == ResTypeEnum.SECURITY_GROUP.getResType()) {
            isValidate = isValidateProName && isValidateRecName && isValidateVpc;
        } else {
            boolean bl2 = isValidate = isValidateProName && isValidateRecName;
        }
        if (!isValidate) {
            log.error((Object)rm.toString(), 90160758787071L);
        }
        return isValidate;
    }

    public boolean isRelationVPC(ResourceMapping rm) {
        return rm.getResourceType() == ResTypeEnum.NETWORK.getResType() || rm.getResourceType() == ResTypeEnum.SECURITY_GROUP.getResType();
    }
}

