/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingCommon;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingRemoteOperation;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsGroupInfo;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class RmFcResourceService {
    private static final Log LOG = LogFactory.getInstance(RmFcResourceService.class);
    private IMoDao moDao;
    private ResourceMappingCommon rmCommon;
    private ResourceMappingVerify rmVerify;
    private ResourceMappingRemoteOperation rmRemoteOp;
    private IVrmService vrmService;

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public ResourceMappingCommon getRmCommon() {
        return this.rmCommon;
    }

    public void setRmCommon(ResourceMappingCommon rmCommon) {
        this.rmCommon = rmCommon;
    }

    public ResourceMappingVerify getRmVerify() {
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.rmVerify = rmVerify;
    }

    public ResourceMappingRemoteOperation getRmRemoteOp() {
        return this.rmRemoteOp;
    }

    public void setRmRemoteOp(ResourceMappingRemoteOperation rmRemoteOp) {
        this.rmRemoteOp = rmRemoteOp;
    }

    public IVrmService getVrmService() {
        return this.vrmService;
    }

    public void setVrmService(IVrmService vrmService) {
        this.vrmService = vrmService;
    }

    public List<ComputeCluster> getAvailableCluster(String siteId, String vrmId) {
        LOG.info((Object)("getAvailableCluster,siteId" + siteId + "vrmId" + vrmId), 90160758786816L);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        List<ComputeCluster> computeClusterListForReturn = new ArrayList<ComputeCluster>();
        LOG.info((Object)("getAvailableCluster,siteId=" + siteId + "vrmId" + vrmId), 90160758786816L);
        if (null == site) {
            return computeClusterListForReturn;
        }
        if (site.getSiteType() == 0) {
            VRM vrm = (VRM)this.moDao.getMo(VRM.class, "sn", (Object)vrmId);
            this.rmCommon.checkObjExist(vrm);
            HashMap<String, VRM> props = new HashMap<String, VRM>();
            props.put("parentMo", vrm);
            List computeClusterList = this.moDao.findMoBy(ComputeCluster.class, "name", true, props);
            if (!VerifyUtil.isEmpty((Collection)computeClusterList)) {
                computeClusterListForReturn = this.getComputeCluster(computeClusterList, computeClusterListForReturn);
                LOG.info((Object)("getAvailableCluster:computeClusterListForReturn" + computeClusterListForReturn), 90160758787071L);
                return computeClusterListForReturn;
            }
        } else if (site.getSiteType() == 1) {
            computeClusterListForReturn = this.getRemoteComCluster(site, siteId, vrmId, computeClusterListForReturn);
        }
        return computeClusterListForReturn;
    }

    private List<ComputeCluster> getComputeCluster(List<ComputeCluster> computeClusterList, List<ComputeCluster> computeClusterListForReturn) {
        return this.getUnusedResourceList(computeClusterList, computeClusterListForReturn, ComputeCluster.class);
    }

    public List<ComputeCluster> getRemoteComCluster(Site site, String siteId, String vrmId, List<ComputeCluster> computeClusterListForReturn) {
        String jsonStr;
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/resmapping/getAvailableCluster?siteId=" + siteId + "&vrmId=" + vrmId;
        try {
            jsonStr = client.getReourceCollect(url);
        }
        catch (LegoCheckedException e) {
            return computeClusterListForReturn;
        }
        catch (Exception e) {
            LOG.error((Object)("getRemoteComCluster failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return computeClusterListForReturn;
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                ComputeCluster computeCluster = this.rmCommon.getComputeClusterFromJson(json);
                if (null == computeCluster) continue;
                computeClusterListForReturn.add(computeCluster);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return computeClusterListForReturn;
    }

    public List<ComputeNode> getAvailableComputeNode(String siteId, String vrmId) {
        LOG.info((Object)("getAvailableComputeNode,siteId" + siteId + "vrmId" + vrmId), 90160758786816L);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        List<ComputeNode> computeNodeListForReturn = new ArrayList<ComputeNode>();
        if (null == site) {
            return computeNodeListForReturn;
        }
        if (site.getSiteType() == 0) {
            VRM vrm = (VRM)this.moDao.getMo(VRM.class, "sn", (Object)vrmId);
            this.rmCommon.checkObjExist(vrm);
            List<ComputeNode> computeNodeList = this.getComputeNodeList(vrm.getUuid());
            if (!VerifyUtil.isEmpty(computeNodeList)) {
                computeNodeListForReturn = this.getComputeNode(computeNodeList, computeNodeListForReturn);
            }
            return computeNodeListForReturn;
        }
        if (site.getSiteType() == 1) {
            computeNodeListForReturn = this.getRemoteComNode(site, siteId, vrmId, computeNodeListForReturn);
        }
        return computeNodeListForReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<ComputeNode> getComputeNodeList(String uuid) {
        List<Object> computeNodeList = new ArrayList<ComputeNode>();
        Session session = null;
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            String queryHQL = "from ComputeNode cn where cn.parentMo.uuid=:poUuid and cn.computeClusterUrn=null order by cn.name asc";
            Query query = session.createQuery(queryHQL);
            query.setString("poUuid", uuid);
            computeNodeList = query.list();
            this.closeSession(session);
        }
        catch (HibernateException e) {
            LOG.error((Object)("Getting hiernateSession or create hibernate query failed:" + uuid), (Throwable)e, 90160758784001L);
            this.closeSession(session);
        }
        catch (Exception e2) {
            LOG.error((Object)("Getting recovery logs failed. Id:" + uuid + ExceptionUtil.getErrorMessage((Throwable)e2)), 90160758784001L);
            this.closeSession(session);
            {
                catch (Throwable throwable) {
                    this.closeSession(session);
                    throw throwable;
                }
            }
        }
        return computeNodeList;
    }

    private void closeSession(Session session) {
        DBOperationUtil.closeSession((Session)session);
    }

    private List<ComputeNode> getComputeNode(List<ComputeNode> computeNodeList, List<ComputeNode> computeNodeListForReturn) {
        return this.getUnusedResourceList(computeNodeList, computeNodeListForReturn, ComputeNode.class);
    }

    private List<PortGroup> getportGroup(List<PortGroup> portGroupList, List<PortGroup> portGroupListForReturn) {
        return this.getUnusedResourceList(portGroupList, portGroupListForReturn, PortGroup.class);
    }

    private <T> List<T> getUnusedResourceList(List<T> resourceList, List<T> resourceListForReturn, Class<T> clazz) {
        for (T computeCluster : resourceList) {
            resourceListForReturn.add(clazz.cast(computeCluster));
        }
        return resourceListForReturn;
    }

    public List<ComputeNode> getRemoteComNode(Site site, String siteId, String vrmId, List<ComputeNode> computeNodeListForReturn) {
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/resmapping/getAvailableComputeNode?siteId=" + siteId + "&vrmId=" + vrmId;
        try {
            String jsonStr = client.getReourceCollect(url);
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                ComputeNode computeNode = this.rmCommon.getComputeNodeFromJson(json);
                if (null == computeNode) continue;
                computeNodeListForReturn.add(computeNode);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        catch (Exception e) {
            LOG.error((Object)("create json object error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return computeNodeListForReturn;
    }

    public List<PortGroup> getAvailablePortGroup(String siteId, String vrmId) {
        LOG.info((Object)("getAvailablePortGroup,siteId" + siteId + "vrmId" + vrmId), 90160758786816L);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        List<PortGroup> portGroupListForReturn = new ArrayList<PortGroup>();
        if (null == site) {
            return portGroupListForReturn;
        }
        if (site.getSiteType() == 0) {
            VRM vrm = (VRM)this.moDao.getMo(VRM.class, "sn", (Object)vrmId);
            this.rmVerify.checkParam(vrm);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("topMoUuid", vrmId);
            List portGroupList = this.moDao.findMoBy(PortGroup.class, "name", true, props);
            if (!VerifyUtil.isEmpty((Collection)portGroupList)) {
                portGroupListForReturn = this.getportGroup(portGroupList, portGroupListForReturn);
                return portGroupListForReturn;
            }
        } else if (site.getSiteType() == 1) {
            portGroupListForReturn = this.getRemotePortGroup(site, siteId, vrmId, portGroupListForReturn);
        }
        return portGroupListForReturn;
    }

    public List<PortGroup> getRemotePortGroup(Site site, String siteId, String vrmId, List<PortGroup> portGroupListForReturn) {
        String jsonStr;
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/resmapping/getAvailablePortGroup?siteId=" + siteId + "&vrmId=" + vrmId;
        try {
            jsonStr = client.getReourceCollect(url);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"get remote port group catch LegoCheckedException:", (Throwable)e, 90160758787071L);
            return portGroupListForReturn;
        }
        catch (Exception e) {
            LOG.error((Object)("get remote port group catch Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return portGroupListForReturn;
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)jsonStr);
            for (int i = 0; i < array.size(); ++i) {
                String json = array.getJSONObject(i).toString();
                PortGroup portGroup = this.rmCommon.getPortGroupFromJson(json);
                if (null == portGroup) continue;
                portGroupListForReturn.add(portGroup);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return portGroupListForReturn;
    }

    public List<DataStore> getAvailableDataStore(String siteId, String vrmId) {
        LOG.info((Object)("getAvailableDataStore,siteId" + siteId + "vrmId" + vrmId), 90160758786816L);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        List<DataStore> availableDataStoreList = new ArrayList<DataStore>();
        LOG.info((Object)("getAvailableDataStore,siteId=" + siteId + "vrmId" + vrmId), 90160758786816L);
        if (null == site) {
            return availableDataStoreList;
        }
        if (site.getSiteType() == 0) {
            List dataStoreList = this.vrmService.getDataStoreListByVrmSn(vrmId);
            if (!VerifyUtil.isEmpty((Collection)dataStoreList)) {
                availableDataStoreList = this.getDataStore(dataStoreList, availableDataStoreList);
                LOG.info((Object)("getAvailableDataStore:dataStoreListForReturn" + availableDataStoreList), 90160758787071L);
                return availableDataStoreList;
            }
        } else if (site.getSiteType() == 1) {
            availableDataStoreList = this.rmRemoteOp.getRemoteAvailableResources(site, siteId, vrmId, DataStore.class);
        }
        return availableDataStoreList;
    }

    private List<DataStore> getDataStore(List<DataStore> dataStoreList, List<DataStore> dataStoreListForReturn) {
        return this.getUnusedResourceList(dataStoreList, dataStoreListForReturn, DataStore.class);
    }

    public List<DrsGroup> getTotalRemoteAvailableGroup(DrsGroupInfo drsGroupInfo, Site site) {
        long totalNum;
        int currentNum;
        int currentPage;
        if (VerifyUtil.isEmpty((Object)drsGroupInfo) || VerifyUtil.isEmpty((Object)site)) {
            LOG.error((Object)"Error params.");
            return Collections.emptyList();
        }
        int pageSize = drsGroupInfo.getPageSize();
        ArrayList<DrsGroup> list = new ArrayList<DrsGroup>();
        do {
            currentPage = drsGroupInfo.getStartPage();
            Page page = this.getRemoteDrsGroup(site, drsGroupInfo);
            totalNum = page.getTotalCount();
            List current = page.getResult();
            currentNum = current.size();
            list.addAll(current);
            int nextPage = currentPage + 1;
            drsGroupInfo.setStartPage(nextPage);
        } while ((long)currentPage * (long)pageSize + (long)currentNum < totalNum);
        return list;
    }

    public Page getAvailableGroup(DrsGroupInfo drsGroupInfo) {
        LOG.info((Object)"Method getAvailableGroup,drsGroupInfo is %s .", new Object[]{JSONObject.fromObject((Object)drsGroupInfo)});
        try {
            Site site = this.rmCommon.checkParameterAndGetSite(drsGroupInfo.getSiteId());
            if (site == null) {
                return new Page();
            }
            if (site.getSiteType() != 0) {
                return this.getRemoteDrsGroup(site, drsGroupInfo);
            }
            ComputeCluster cluster = (ComputeCluster)this.moDao.getMo(ComputeCluster.class, "urn", (Object)drsGroupInfo.getClusterId());
            this.rmCommon.checkObjExist(cluster);
            ArrayList<Object> criterionList = new ArrayList<Object>();
            criterionList.add(Restrictions.eq((String)"parentMo", (Object)cluster));
            if (drsGroupInfo.getGroupType() != null) {
                criterionList.add(Restrictions.eq((String)"groupType", (Object)drsGroupInfo.getGroupType()));
            }
            if (drsGroupInfo.getRuleType() != null) {
                criterionList.add(Restrictions.eq((String)"ruleType", (Object)drsGroupInfo.getRuleType()));
            }
            if (drsGroupInfo.getHostRuleType() != null) {
                criterionList.add(Restrictions.eq((String)"vm2HostRuleType", (Object)drsGroupInfo.getHostRuleType()));
            }
            if (!VerifyUtil.isEmpty((String)drsGroupInfo.getGroupName())) {
                criterionList.add(Restrictions.ilike((String)"name", (Object)("%" + drsGroupInfo.getGroupName() + "%")));
            }
            return this.moDao.pagedQuery(DrsGroup.class, drsGroupInfo.getStartPage(), drsGroupInfo.getPageSize(), criterionList, "name", true);
        }
        catch (Exception ex) {
            LOG.error((Object)"Method getAvailableGroup error,msg is %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L);
        }
    }

    private Page getRemoteDrsGroup(Site site, DrsGroupInfo drsGroupInfo) {
        String jsonStr;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"groupType", (Object)drsGroupInfo.getGroupType());
        jsonObject.put((Object)"siteId", (Object)drsGroupInfo.getSiteId());
        jsonObject.put((Object)"clusterId", (Object)drsGroupInfo.getClusterId());
        jsonObject.put((Object)"resourceProviderId", (Object)drsGroupInfo.getResourceProviderId());
        jsonObject.put((Object)"groupName", (Object)drsGroupInfo.getGroupName());
        jsonObject.put((Object)"ruleType", (Object)drsGroupInfo.getRuleType());
        jsonObject.put((Object)"hostRuleType", (Object)drsGroupInfo.getHostRuleType());
        jsonObject.put((Object)"pageSize", (Object)drsGroupInfo.getPageSize());
        jsonObject.put((Object)"startPage", (Object)drsGroupInfo.getStartPage());
        String url = "/ws/drsmapping/action/getResource";
        RestClient client = SiteUtil.initClient((Site)site);
        try {
            jsonStr = client.post(url, jsonObject.toString(), new HashMap());
        }
        catch (Exception ex) {
            LOG.error((Object)String.format(Locale.ROOT, "Method getRemoteComCluster failed,msg is %s. ", ExceptionUtil.getErrorMessage((Throwable)ex)));
            return new Page();
        }
        try {
            JSONObject jb = JSONUtils.fromString((String)jsonStr);
            int start = drsGroupInfo.getPageSize() * drsGroupInfo.getStartPage();
            int totalCount = jb.getInt("totalCount", 0);
            List list = JSONUtils.toCollection((JSONArray)jb.getJSONArray("records"), DrsGroup.class);
            return new Page((long)start, (long)totalCount, drsGroupInfo.getPageSize(), list);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Create json object error,msg is %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return new Page();
        }
    }
}

