/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingCommon;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingRemoteOperation;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class RmFmResourceService {
    private Log log = LogFactory.getInstance(RmFmResourceService.class);
    private String trace = "trace";
    private ResourceMappingVerify rmVerify;
    private IMoDao moDao;
    private ResourceMappingDao rmDao;
    private ISiteBaseService siteService;
    private ResourceMappingCommon rmCommon;
    private ResourceMappingRemoteOperation rmRemoteOp;

    public ResourceMappingVerify getRmVerify() {
        this.log.trace((Object)(" enter getRmVerify" + this.trace));
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.log.trace((Object)(" enter setRmVerify" + this.trace));
        this.rmVerify = rmVerify;
    }

    public IMoDao getMoDao() {
        this.log.trace((Object)(" enter getMoDao" + this.trace));
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.log.trace((Object)(" enter setMoDao" + this.trace));
        this.moDao = moDao;
    }

    public ResourceMappingDao getRmDao() {
        this.log.trace((Object)(" enter getRmDao" + this.trace));
        return this.rmDao;
    }

    public void setRmDao(ResourceMappingDao rmDao) {
        this.log.trace((Object)(" enter setRmDao" + this.trace));
        this.rmDao = rmDao;
    }

    public ISiteBaseService getSiteService() {
        this.log.trace((Object)(" enter getSiteService" + this.trace));
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.log.trace((Object)(" enter setSiteService" + this.trace));
        this.siteService = siteService;
    }

    public ResourceMappingCommon getRmCommon() {
        this.log.trace((Object)(" enter getRmCommon" + this.trace));
        return this.rmCommon;
    }

    public void setRmCommon(ResourceMappingCommon rmCommon) {
        this.log.trace((Object)(" enter setRmCommon" + this.trace));
        this.rmCommon = rmCommon;
    }

    public ResourceMappingRemoteOperation getRmRemoteOp() {
        this.log.trace((Object)(" enter getRmRemoteOp" + this.trace));
        return this.rmRemoteOp;
    }

    public void setRmRemoteOp(ResourceMappingRemoteOperation rmRemoteOp) {
        this.log.trace((Object)(" enter setRmRemoteOp" + this.trace));
        this.rmRemoteOp = rmRemoteOp;
    }

    public List<VPC> getAllVPC(String siteId, String sn) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.log.info((Object)("getAllVPC,siteId" + siteId + "sn" + sn), 90160758786816L);
        this.rmVerify.checkParam(sn);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        List<Object> vpcList = new ArrayList<VPC>();
        if (null == site) {
            return vpcList;
        }
        if (site.getSiteType() == 0) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("topMoUuid", sn);
            vpcList = this.moDao.findMoBy(VPC.class, "name", true, props);
            return vpcList;
        }
        if (site.getSiteType() == 1) {
            vpcList = this.getRemoteAllVPC(site, siteId, sn);
        }
        return vpcList;
    }

    private List<VPC> getRemoteAllVPC(Site site, String siteId, String sn) {
        String jsonStr;
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/resmapping/getAllVPC?siteId=" + siteId + "&sn=" + sn;
        try {
            jsonStr = client.getReourceCollect(url);
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"legoCheckedException:", (Throwable)e, 90160758787071L);
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
        List<VPC> vpcList = this.rmCommon.parseRemoteResource(jsonStr, VPC.class);
        return vpcList;
    }

    public List<VPC> getMappingVpcByVpc(String siteId, String fmSn, String vpcSn) {
        List<VPC> vpcList;
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmVerify.checkParam(fmSn);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        if (site.getSiteType() == 0) {
            List<ResourceMapping> rmList = this.rmDao.getResourcemappingByVpcId(vpcSn, siteId);
            if (!this.isSameVPCResourceProvider(rmList, fmSn)) {
                return new ArrayList<VPC>();
            }
            vpcList = this.getMappingVpc(rmList, siteId, fmSn, vpcSn);
        } else {
            vpcList = this.getRemoteMappingVpcByVpc(site, siteId, fmSn, vpcSn);
        }
        return vpcList;
    }

    private List<VPC> getMappingVpc(List<ResourceMapping> rmList, String siteId, String fmSn, String vpcSn) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<VPC> vpcList = new ArrayList<VPC>();
        if (!VerifyUtil.isEmpty(rmList)) {
            List<String> rmVpcList = this.getMappingVpcId(rmList, vpcSn);
            for (String vpcId : rmVpcList) {
                VPC vpc = (VPC)this.moDao.getMo(VPC.class, "uuid", (Object)vpcId);
                if (null == vpc) continue;
                vpcList.add(vpc);
            }
        } else {
            vpcList.addAll(this.findUnusedVpc(siteId, fmSn, vpcSn));
        }
        return vpcList;
    }

    private List<String> getMappingVpcId(List<ResourceMapping> rmList, String vpcSn) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<String> rmVpcList = new ArrayList<String>();
        for (ResourceMapping rm : rmList) {
            if (vpcSn.equals(rm.getProductVpcId())) {
                if (rmVpcList.contains(rm.getRecoveryVpcId())) continue;
                rmVpcList.add(rm.getRecoveryVpcId());
                continue;
            }
            if (!vpcSn.equals(rm.getRecoveryVpcId()) || rmVpcList.contains(rm.getProductVpcId())) continue;
            rmVpcList.add(rm.getProductVpcId());
        }
        return rmVpcList;
    }

    private List<VPC> findUnusedVpc(String siteId, String fmSn, String vpcSn) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<VPC> vpcList = new ArrayList<VPC>();
        List<VPC> vpcTmpList = this.getAllVPC(siteId, fmSn);
        List<ResourceMapping> rmList = this.rmDao.getAllResourceMapping();
        for (VPC vpcRet : vpcTmpList) {
            boolean flag = false;
            String vpcId = vpcRet.getUuid();
            for (ResourceMapping rm : rmList) {
                if ((!vpcId.equals(rm.getProductVpcId()) || !vpcSn.equals(rm.getRecoveryVpcId())) && (!vpcId.equals(rm.getRecoveryVpcId()) || !vpcSn.equals(rm.getProductVpcId()))) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            vpcList.add(vpcRet);
        }
        return vpcList;
    }

    public boolean isSameVPCResourceProvider(List<ResourceMapping> rmList, String fmSn) {
        this.log.trace((Object)(this.trace + " trace message"));
        for (ResourceMapping rm : rmList) {
            if (rm.getProductResourceProviderId().equals(fmSn) || rm.getRecoveryResourceProviderId().equals(fmSn)) continue;
            return false;
        }
        return true;
    }

    public List<VPC> getRemoteMappingVpcByVpc(Site site, String siteId, String fmSn, String vpcSn) {
        String jsonStr;
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/resmapping/getMappingVpcByVpc?siteId=" + siteId + "&fmSn=" + fmSn + "&vpcSn=" + vpcSn;
        try {
            jsonStr = client.getReourceCollect(url);
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"legoCheckedException:", (Throwable)e, 90160758787071L);
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("other Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
        List<VPC> vpcList = this.rmCommon.parseRemoteResource(jsonStr, VPC.class);
        return vpcList;
    }

    public List<VPC> getAvailableVpcByVpc(String siteId, String fmSn, String vpcSn) {
        List<VPC> vpcList;
        this.log.trace((Object)(this.trace + " trace message"));
        this.rmVerify.checkParam(fmSn);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        if (site.getSiteType() == 0) {
            List<ResourceMapping> rmList = this.rmDao.getResourcemappingByVpcId(vpcSn, siteId);
            this.filterNonFmResourceMapping(rmList);
            if (rmList.size() > 1) {
                vpcList = this.isSameVPCResourceProvider(rmList, fmSn) ? this.getMappingVpc(rmList, siteId, fmSn, vpcSn) : new ArrayList<VPC>();
            } else if (rmList.size() == 1) {
                vpcList = this.findUnusedVpc(siteId, fmSn, vpcSn);
                if (!this.isSameVPCResourceProvider(rmList, fmSn)) {
                    return vpcList;
                }
                List<String> mapVpcIdList = this.getMappingVpcId(rmList, vpcSn);
                VPC vpc = null;
                if (!VerifyUtil.isEmpty(mapVpcIdList)) {
                    vpc = (VPC)this.moDao.getMo(VPC.class, "uuid", (Object)mapVpcIdList.get(0));
                }
                if (null != vpc) {
                    vpcList.add(vpc);
                }
            } else {
                vpcList = this.findUnusedVpc(siteId, fmSn, vpcSn);
            }
        } else {
            vpcList = this.getRemoteAvailableVpcByVpc(site, siteId, fmSn, vpcSn);
        }
        return vpcList;
    }

    public List<VPC> getRemoteAvailableVpcByVpc(Site site, String siteId, String fmSn, String vpcSn) {
        String jsonStr;
        this.log.trace((Object)(this.trace + " trace message"));
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/resmapping/getAvailableVpcByVpc?siteId=" + siteId + "&fmSn=" + fmSn + "&vpcSn=" + vpcSn;
        try {
            jsonStr = client.getReourceCollect(url);
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)"get remote vpc failed, LegoCheckedException is:", (Throwable)e, 90160758787071L);
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("get remote vpc failed, exception is:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
        List<VPC> vpcList = this.rmCommon.parseRemoteResource(jsonStr, VPC.class);
        return vpcList;
    }

    public void filterNonFmResourceMapping(List<ResourceMapping> rmList) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<ResourceMapping> rmListNew = new ArrayList<ResourceMapping>(rmList);
        for (ResourceMapping rm : rmListNew) {
            if (rm.isFmResourceMapping()) continue;
            rmList.remove(rm);
        }
    }

    public List<GalaxObject> getAllAvailableFmResources(String siteId, String fmId) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<GalaxObject> availableList = new ArrayList<GalaxObject>();
        List<SecurityGroup> sgs = this.getAvailableFmResources(siteId, fmId, VPC.class, SecurityGroup.class);
        availableList.addAll(sgs);
        List<FmNetwork> nets = this.getAvailableFmResources(siteId, fmId, VPC.class, FmNetwork.class);
        availableList.addAll(nets);
        return availableList;
    }

    public <T extends GalaxObject, PT extends ManagedObject> List<T> getAvailableFmResources(String siteId, String sn, Class<PT> parentClass, Class<T> resClass) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.log.info((Object)("getAvailableFmResources Enter.siteId=" + siteId + ",sn" + sn + ",resClass=" + resClass.getName()), 90160758786816L);
        if (sn == null) {
            this.log.error((Object)"invalid parameter", 90160758787071L);
            throw new LegoCheckedException(65540L);
        }
        Site site = this.siteService.getSiteById(siteId);
        List<Object> availableList = new ArrayList();
        if (null == site) {
            return availableList;
        }
        if (site.getSiteType() == 0) {
            ManagedObject parent = this.moDao.getMo(parentClass, "uuid", (Object)sn);
            if (parent == null) {
                this.log.error((Object)("FusionManager not exist,fmId" + sn), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            HashMap<String, ManagedObject> props = new HashMap<String, ManagedObject>();
            props.put("parentMo", parent);
            List resList = this.moDao.findMoBy(resClass, "name", true, props);
            if (!VerifyUtil.isEmpty((Collection)resList)) {
                availableList = this.rmCommon.getUnusedResourceList(resList);
                this.log.info((Object)("getAvailableFmResources:availableList" + availableList.toString()), 90160758787071L);
                return availableList;
            }
        } else {
            availableList = this.rmRemoteOp.getRemoteAvailableResources(site, siteId, sn, resClass);
        }
        return availableList;
    }
}

