/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingCommon;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingRemoteOperation;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.sdk.model.DrVRG;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class RmVrgResourceService {
    private static final Log log = LogFactory.getInstance(RmVrgResourceService.class);
    private IMoDao moDao;
    private ResourceMappingCommon rmCommon;
    private ResourceMappingVerify rmVerify;
    private ResourceMappingRemoteOperation rmRemoteOp;

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public ResourceMappingCommon getRmCommon() {
        return this.rmCommon;
    }

    public void setRmCommon(ResourceMappingCommon rmCommon) {
        this.rmCommon = rmCommon;
    }

    public ResourceMappingVerify getRmVerify() {
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.rmVerify = rmVerify;
    }

    public ResourceMappingRemoteOperation getRmRemoteOp() {
        return this.rmRemoteOp;
    }

    public void setRmRemoteOp(ResourceMappingRemoteOperation rmRemoteOp) {
        this.rmRemoteOp = rmRemoteOp;
    }

    public List<VRG> getAvailableVRG(String siteId, String sn) {
        log.info((Object)("getAvailableVRG,siteId" + siteId + "vrmId" + sn), 90160758786816L);
        Site site = this.rmCommon.checkParameterAndGetSite(siteId);
        List<VRG> vrgList = new ArrayList<VRG>();
        if (null == site) {
            return vrgList;
        }
        if (site.getSiteType() == 0) {
            vrgList = this.calculateVRGsOfFc(siteId, sn);
        } else if (site.getSiteType() == 1 && !VerifyUtil.isEmpty(vrgList = this.rmRemoteOp.getRemoteAvailableResources(site, siteId, sn, VRG.class))) {
            this.filterVrg(vrgList, siteId);
        }
        return vrgList;
    }

    private void filterVrg(List<VRG> vrgList, String siteId) {
        List drVrgList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(" from DrVRG where siteId = ? ", new Object[]{siteId});
        if (VerifyUtil.isEmpty((Collection)drVrgList)) {
            vrgList.clear();
            return;
        }
        HashSet<VRG> removeVrgs = new HashSet<VRG>();
        for (VRG vrg : vrgList) {
            if (this.existInSite(vrg, drVrgList)) continue;
            removeVrgs.add(vrg);
        }
        vrgList.removeAll(removeVrgs);
    }

    private boolean existInSite(VRG vrg, List<DrVRG> drVrgList) {
        for (DrVRG drVrg : drVrgList) {
            if (!drVrg.getDeviceSn().equals(vrg.getUuid())) continue;
            return true;
        }
        return false;
    }

    private List<VRG> calculateVRGsOfFc(String siteId, String sn) {
        ArrayList<VRG> availVrgList = new ArrayList<VRG>();
        List<VRG> registedVrgList = this.getSiteRegistedVRG(siteId);
        if (VerifyUtil.isEmpty(registedVrgList)) {
            log.info((Object)(" No VRG of UltraVR : " + sn), 90160758786816L);
            return availVrgList;
        }
        IVirtualResourceManager vrmVirtualResService = VrmManager.getInstance().getVrmVirtualResService();
        VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)sn);
        for (VRG vrg : registedVrgList) {
            String vrgIp = vrg.getLinkIp();
            List vmList = vrmVirtualResService.queryVMByIp(vrmInfo, vrgIp);
            if (VerifyUtil.isEmpty((Collection)vmList)) continue;
            availVrgList.add(vrg);
        }
        return this.getUnusedResourceList(availVrgList, VRG.class);
    }

    private List<VRG> getSiteRegistedVRG(String siteId) {
        ArrayList<VRG> vrgList = new ArrayList<VRG>();
        List drVrgList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(" from DrVRG where siteId = ? ", new Object[]{siteId});
        for (DrVRG drVrg : drVrgList) {
            VRG vrg = (VRG)this.moDao.getMo(VRG.class, "sn", (Object)drVrg.getDeviceSn());
            if (vrg == null) continue;
            vrgList.add(vrg);
        }
        return vrgList;
    }

    private <T> List<T> getUnusedResourceList(List<T> resourceList, Class<T> clazz) {
        ArrayList<T> unusedList = new ArrayList<T>();
        for (T resource : resourceList) {
            if (!this.rmVerify.isResourceUnUsed(((ManagedObject)ManagedObject.class.cast(resource)).getUuid())) continue;
            unusedList.add(clazz.cast(resource));
        }
        return unusedList;
    }
}

