/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.provider.protectgroup;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmStatusEnum;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectGroupProviderAdapter;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.resource.provider.constant.GalaxVmPgConstants;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.FusionSphereVmProvider;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectProvider;
import com.huawei.ism.drm.galax.sdk.pg.service.IProtectObjectStorageInfoService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.cloud.JudgeHandler;
import com.huawei.ism.drm.galax.util.cloud.VrmJudgeDefine;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.provider.sdk.model.VMConfigs;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.HypermetroVolumeInfo;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.virtualization.alarm.AlarmGenerator;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class FusionComputeVmProvider
extends FusionSphereVmProvider {
    private static final Log LOGGER = LogFactory.getInstance(FusionComputeVmProvider.class);
    private static final int TASK_TIMEOUT = 21600;
    private static final String TASK_TIMEOUT_KEY = "back.task.timeout";
    private INeMgrProtocolExtendService neMgr;
    private GalaxProtectGroupProviderAdapter poProviderAdapter;

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    @Override
    public GalaxProtectGroupProviderAdapter getPoProviderAdapter() {
        return this.poProviderAdapter;
    }

    public void setPoProviderAdapter(GalaxProtectGroupProviderAdapter poProviderAdapter) {
        this.poProviderAdapter = poProviderAdapter;
    }

    public String getCloudType() {
        return DrVrm.class.getSimpleName();
    }

    private boolean isSupportedPolicyTemplateType(int templateType) {
        return GalaxVmPgConstants.EVOL_SUPPORT_TEMPLATES.contains(templateType) || GalaxVmPgConstants.FUSIONSTORAGE_SUPPORT_TEMPLATES.contains(templateType);
    }

    public void refreshProtectGroup(ProtectGroup pg) {
        if (!this.isSupportedPolicyTemplateType(pg.getTemplate().getType())) {
            LOGGER.warn((Object)"UnSupported policyTemplateType(%s) for Pg(%s).", new Object[]{pg.getTemplate().getType(), pg.getUuid()});
            return;
        }
        LOGGER.debug((Object)"Begin refresh pg:%s.", new Object[]{pg.getUuid()});
        this.refreshProps(pg);
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (ProtectObject po : pg.getPolist()) {
            vmUuidSet.add(po.getMoUuid());
        }
        List<GalaxVM> vms = this.getGalaxVMsByUuid(vmUuidSet);
        HashSet<String> listVmUrns = new HashSet<String>();
        HashSet<String> poToBeUnsupport = new HashSet<String>();
        HashSet<String> poToBeResupport = new HashSet<String>();
        this.filterGalaxVM(vms, listVmUrns, poToBeUnsupport, poToBeResupport, pg);
        HashSet<String> poToBeValid = new HashSet<String>();
        HashSet<String> poToBeInvalid = new HashSet<String>();
        this.checkVmStatus(vms, poToBeValid, poToBeInvalid);
        HashSet<ProtectObject> poToBeDeleted = new HashSet<ProtectObject>();
        Set<String> poNotHasValidPair = this.checkPGRelation(pg);
        HashSet<String> poNotBeConsistent = new HashSet<String>();
        HashSet<String> poDisklBeClean = new HashSet<String>();
        HashSet<String> poDisklBeExpand = new HashSet<String>();
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        List diskInfoListOld = pgService.queryDiskInfo(pg.getUuid());
        List diskInfoList = pgService.queryDiskInfo(pg);
        HashMap<String, List<ProtectObject>> resourceIdtoPoMapOld = new HashMap<String, List<ProtectObject>>();
        for (DiskInfo diskInfo : diskInfoListOld) {
            resourceIdtoPoMapOld.put(diskInfo.getResourceId(), diskInfo.getProtectObjects());
        }
        boolean result = this.dealDiskInfoAlarm(pg, poNotBeConsistent, poDisklBeClean, poDisklBeExpand, diskInfoList, resourceIdtoPoMapOld);
        this.reinforceDealBeCleanDisk(pg, poDisklBeClean, diskInfoList, resourceIdtoPoMapOld);
        for (ProtectObject po : pg.getPolist()) {
            this.setProjectPoStatus(poToBeResupport, poToBeValid, po);
            result = this.checkProtectPoStatus(result, poToBeUnsupport, poNotHasValidPair, poNotBeConsistent, po);
            result = this.checkDiskInvalid(result, poDisklBeClean, poDisklBeExpand, po, pg);
            result = this.checkVmDeleteFromFc(result, listVmUrns, poToBeDeleted, po);
            result = this.checkVmRunStatus(result, poToBeInvalid, po);
            if (poDisklBeExpand.contains(po.getMoUuid())) continue;
            AlarmReporter.restoreAlarm((String)"0x3230057", (String[])new String[]{po.getUuid()});
        }
        this.checkHyperMetroProtectStatus(pg, poNotHasValidPair);
        this.checkPoHyperMetro(pg, vms, diskInfoList);
        this.handleAlarm(pg, result, pg.getUuid(), poToBeUnsupport, poToBeDeleted, poNotHasValidPair);
    }

    private void reinforceDealBeCleanDisk(ProtectGroup pg, Set<String> poDisklBeClean, List<DiskInfo> diskInfoList, Map<String, List<ProtectObject>> resourceIdToPoMapOld) {
        HashMap<String, Set<String>> storageReplicaMap = new HashMap<String, Set<String>>();
        HashMap<String, String> poIdMoUuidMap = new HashMap<String, String>();
        for (ProtectObject protectObject : pg.getPolist()) {
            poIdMoUuidMap.put(protectObject.getUuid(), protectObject.getMoUuid());
        }
        for (ProtectGroupReplica protectGroupReplica : pg.getReplicaList()) {
            for (ProtectObjectReplica protectObjectReplica : protectGroupReplica.getReplicas()) {
                this.findProtectObjectByDisk(protectObjectReplica, storageReplicaMap, poIdMoUuidMap, resourceIdToPoMapOld);
            }
        }
        for (DiskInfo diskInfo : diskInfoList) {
            String key;
            if (!DiskProtectStatusEnum.REMOVED.getStatus().equals(diskInfo.getStatus()) || !storageReplicaMap.containsKey(key = diskInfo.getResourceId())) continue;
            poDisklBeClean.addAll((Collection)storageReplicaMap.get(key));
        }
    }

    private void findProtectObjectByDisk(ProtectObjectReplica protectObjectReplica, Map<String, Set<String>> storageReplicaMap, Map<String, String> poIdMoUuidMap, Map<String, List<ProtectObject>> resourceIdToPoMapOld) {
        block0: for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
            String poId = protectObjectReplica.getPoId();
            String storageId = storageInfo.getSrcStorageId();
            if (poIdMoUuidMap.containsKey(poId)) {
                Set poIds = storageReplicaMap.getOrDefault(storageId, new HashSet());
                poIds.add(poIdMoUuidMap.get(poId));
                storageReplicaMap.put(storageId, poIds);
                continue;
            }
            for (RelicaStorageInfo storageInfoSecond : protectObjectReplica.getStorageInfos()) {
                String curStorageId = storageInfoSecond.getSrcStorageId();
                if (curStorageId.equals(storageId) || !resourceIdToPoMapOld.containsKey(curStorageId) || resourceIdToPoMapOld.get(curStorageId).size() != 1) continue;
                Set poIds = storageReplicaMap.getOrDefault(storageId, new HashSet());
                poIds.add(resourceIdToPoMapOld.get(curStorageId).get(0).getMoUuid());
                storageReplicaMap.put(storageId, poIds);
                continue block0;
            }
        }
    }

    private void checkPoHyperMetro(ProtectGroup pg, List<GalaxVM> gvms, List<DiskInfo> diskInfoList) {
        Boolean unCheck = LegoBaseConfig.getInstance().getBoolean("pg_need_check", Boolean.valueOf(true));
        if (!ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg) || unCheck.booleanValue()) {
            return;
        }
        if (VerifyUtil.isEmpty(gvms)) {
            return;
        }
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(pg.getPoProviderSN());
        IVirtualResourceManager manager = FusionSphereServiceManager.getInstance().getVirResourceService();
        gvms.forEach(galaxVM -> manager.checkVmsHypermetro(vrmInfo, pg, galaxVM, diskInfoList));
    }

    private boolean checkHyperMetroDisk(boolean result, Set<String> poDisklBeClean, Set<String> poDisklBeExpand, ProtectObject po) {
        boolean flag = result;
        if (poDisklBeClean.contains(po.getMoUuid()) || poDisklBeExpand.contains(po.getMoUuid())) {
            po.setPoStatus(ProtectObjectStatusEnum.UNSUPPORTED.getValue());
            flag = false;
        }
        return flag;
    }

    private void checkHyperMetroProtectStatus(ProtectGroup pg, Set<String> poNotHasPair) {
        if (!ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg) || pg.getStatus() == DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus()) {
            return;
        }
        if (!pg.getPolist().stream().findFirst().isPresent()) {
            return;
        }
        if (pg.getPolist().stream().anyMatch(po -> po.getPoStatus() != ProtectObjectStatusEnum.INVALID.getValue()) && VerifyUtil.isEmpty(poNotHasPair)) {
            pg.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
        } else {
            pg.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
        }
    }

    private boolean checkDiskInvalid(boolean result, Set<String> poDisklBeClean, Set<String> poDisklBeExpand, ProtectObject po, ProtectGroup pg) {
        if (ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg)) {
            return this.checkHyperMetroDisk(result, poDisklBeClean, poDisklBeExpand, po);
        }
        if (poDisklBeClean.contains(po.getMoUuid()) || poDisklBeExpand.contains(po.getMoUuid())) {
            po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
            return false;
        }
        return result;
    }

    private boolean checkVmDeleteFromFc(boolean result, Set<String> listVmUrns, Set<ProtectObject> poToBeDeleted, ProtectObject po) {
        if (!listVmUrns.contains(po.getMoUuid())) {
            poToBeDeleted.add(po);
            po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
            return false;
        }
        return result;
    }

    private boolean checkVmRunStatus(boolean result, Set<String> poToBeInvalid, ProtectObject po) {
        if (poToBeInvalid.contains(po.getMoUuid())) {
            po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
            return false;
        }
        return result;
    }

    private boolean checkProtectPoStatus(boolean result, Set<String> poToBeUnsupport, Set<String> poNotHasPair, Set<String> poNotBeConsistent, ProtectObject po) {
        if (poToBeUnsupport.contains(po.getMoUuid()) || poNotHasPair.contains(po.getMoUuid()) || poNotBeConsistent.contains(po.getMoUuid())) {
            po.setPoStatus(ProtectObjectStatusEnum.UNSUPPORTED.getValue());
            return false;
        }
        return result;
    }

    private void setProjectPoStatus(Set<String> poToBeResupport, Set<String> poToBeValid, ProtectObject po) {
        if (poToBeResupport.contains(po.getMoUuid()) && poToBeValid.contains(po.getMoUuid())) {
            po.setPoStatus(ProtectObjectStatusEnum.VALID.getValue());
        }
    }

    private void handleAlarm(ProtectGroup pg, boolean result, String protectGroupId, Set<String> poToBeUnsupport, Set<ProtectObject> poToBeDeleted, Set<String> poNotHasPair) {
        if (!result) {
            AlarmGenerator.sendProtectObjectUnsupportedAlarm((String)pg.getUuid(), poToBeUnsupport);
            AlarmGenerator.sendProtectObjectConsistentAlarm((int)ProtectionTypeEnum.STORAGE_REPLICATION.getValue(), (String)pg.getUuid(), poNotHasPair);
            AlarmGenerator.sendProtectObjectRemoveAlarm((String)pg.getUuid(), (String)pg.getName(), poToBeDeleted);
        }
        ProtectObject protectObject = (ProtectObject)pg.getPolist().iterator().next();
        HashMap<String, Object> extendCondition = new HashMap<String, Object>();
        extendCondition.put("isPoAllow", true);
        List<GalaxVM> fcVmList = FsRecoveryUtil.getFilterVms(protectObject.getProviderSN(), extendCondition);
        List unProtectShareVms = VrmUtil.findVmShareNotAllInGroup((Set)pg.getPolist(), fcVmList);
        if (!unProtectShareVms.isEmpty()) {
            List unProtectVms = unProtectShareVms.stream().map(ManagedObject::getName).collect(Collectors.toList());
            AlarmReporter.sendAlarm((String)"0x3230056", (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{pg.getUuid(), pg.getName(), unProtectVms.toString()});
            result = false;
        } else {
            AlarmReporter.restoreAlarm((String)"0x3230056", (String[])new String[]{pg.getUuid()});
        }
        LOGGER.info((Object)"End Refresh ProtectGroup. Pg:%s, IsValid: %s", new Object[]{protectGroupId, result});
        if (result) {
            AlarmGenerator.restoreProtectObjectAlarm((String)pg.getUuid());
        }
    }

    private void refreshProps(ProtectGroup pg) {
        ((IProtectObjectStorageInfoService)ServiceLocator.getInstance().getService(IProtectObjectStorageInfoService.class)).setDataStoreInfoForProtectGroup(pg);
        String protectType = (String)pg.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        IGalaxProtectObjectProvider galaxProtectObjectProvider = GalaxProtectGroupProviderAdapter.getInstance().getGalaxPoProvider(protectType);
        galaxProtectObjectProvider.updateProtectObjectProperties(pg);
        ((IProtectObjectStorageInfoService)ServiceLocator.getInstance().getService(IProtectObjectStorageInfoService.class)).loadProtectObjectStorageInfo(new ArrayList(pg.getPolist()));
        this.updatePgInfoWhenStorageHA(pg);
    }

    private void updatePgInfoWhenStorageHA(ProtectGroup pg) {
        if (!ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg)) {
            LOGGER.debug((Object)"The protect group(%s) type is not hyper metro of small lun.", new Object[]{pg.getName()});
            return;
        }
        if (this.checkStorageHA(pg)) {
            LOGGER.info((Object)"The protection group(%s) has been HA, start to update information.", new Object[]{pg.getName()});
            this.invertPoolMapping(pg);
            this.invertReplica(pg);
            this.swapCg(pg);
        }
    }

    private void swapCg(ProtectGroup pg) {
        LOGGER.info((Object)"Swap consistent group, pg: %s.", new Object[]{pg.getName()});
        RelicaStorageInfo replicaStorage = this.getReplicaStoragesFromPg(pg).get(0);
        if (!(replicaStorage instanceof RemoteStorageReplica)) {
            LOGGER.info((Object)"The replica is not of RemoteStorageReplica type.");
            return;
        }
        RemoteStorageReplica storageReplica = (RemoteStorageReplica)replicaStorage;
        String devSn = storageReplica.getStorageProviderSN();
        IStorageHyperMetroBaseManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        manager.swap(devSn, storageReplica.getConsistentGroupId(), Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()), true);
    }

    private void invertReplica(ProtectGroup pg) {
        String tmp;
        LOGGER.info((Object)"Invert replica, pg: %s.", new Object[]{pg.getName()});
        for (ProtectGroupReplica pgReplica : pg.getReplicaList()) {
            tmp = pgReplica.getProductArray();
            pgReplica.setProductArray(pgReplica.getRecoveryArray());
            pgReplica.setRecoveryArray(tmp);
        }
        for (RelicaStorageInfo relicaStorage : this.getReplicaStoragesFromPg(pg)) {
            tmp = relicaStorage.getStorageProviderSN();
            relicaStorage.setStorageProviderSN(relicaStorage.getSrcStorageProviderSN());
            relicaStorage.setSrcStorageProviderSN(tmp);
            tmp = relicaStorage.getSrcStorageId();
            relicaStorage.setSrcStorageId(relicaStorage.getStorageId());
            relicaStorage.setStorageId(tmp);
        }
    }

    private void invertPoolMapping(ProtectGroup pg) {
        LOGGER.info((Object)"Invert pool mapping, pg: %s.", new Object[]{pg.getName()});
        List storagePairs = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)pg.getProperty("storagePoolMapping")), StoragePair.class);
        for (StoragePair storagePair : storagePairs) {
            String tmp = storagePair.getSrcDevSN();
            storagePair.setSrcDevSN(storagePair.getTgtDevSN());
            storagePair.setTgtDevSN(tmp);
            storagePair.setStoragePools(MapUtils.invertMap((Map)storagePair.getStoragePools()));
        }
        pg.setProperty("storagePoolMapping", (Object)JSONArray.fromObject((Object)storagePairs).toString());
    }

    private List<RelicaStorageInfo> getReplicaStoragesFromPg(ProtectGroup pg) {
        Set pgReplicaList = pg.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicaList)) {
            return Collections.emptyList();
        }
        List poReplicaList = pgReplicaList.stream().map(ProtectGroupReplica::getReplicas).flatMap(Collection::stream).collect(Collectors.toList());
        return poReplicaList.stream().map(ProtectObjectReplica::getStorageInfos).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean checkStorageHA(ProtectGroup pg) {
        List poStorageList = pg.distinctStorageInfo();
        List<RelicaStorageInfo> replicaStorageList = this.getReplicaStoragesFromPg(pg);
        if (VerifyUtil.isEmpty((Collection)poStorageList) || VerifyUtil.isEmpty(replicaStorageList)) {
            LOGGER.debug((Object)"There is no storage in the protection group(%s).", new Object[]{pg.getName()});
            return false;
        }
        Map relicaStorageMap = replicaStorageList.stream().collect(Collectors.toMap(RelicaStorageInfo::getProtectObjectStorageWwn, Function.identity()));
        for (ProtectObjectStorageInfo poStorage : poStorageList) {
            String lunWwn = poStorage.getLunWWN();
            RelicaStorageInfo replicaStorage = (RelicaStorageInfo)relicaStorageMap.get(lunWwn);
            if (replicaStorage == null) {
                LOGGER.debug((Object)"The volume(%s) in vm is not protected.", new Object[]{lunWwn});
                continue;
            }
            String poStorageSrcSN = poStorage.getResourceProviderSN();
            if (VerifyUtil.isEmpty((String)poStorageSrcSN) || !poStorageSrcSN.equals(replicaStorage.getStorageProviderSN())) continue;
            LOGGER.info((Object)"The storage of the protection group(%s) is switched over.", new Object[]{pg.getName()});
            return true;
        }
        return false;
    }

    private void filterGalaxVM(List<GalaxVM> galaxVms, Set<String> listVmUrns, Set<String> poToBeUnsupport, Set<String> poToBeResupport, ProtectGroup pg) {
        ArrayList<JudgeHandler.JudgeUnit> judgeList = new ArrayList<JudgeHandler.JudgeUnit>();
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NIC, (boolean)true));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_DISK, (boolean)true));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_NON_PERSISTENT_DISK, (boolean)false));
        if (ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg)) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_SMALL_LUN_DISK_TYPE, (boolean)true));
        } else {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_FS_DISK_TYPE, (boolean)true));
        }
        if (pg.getTemplate().getType() != 38) {
            judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_GPU_GROUP, (boolean)false));
        }
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PASS_THROUGH_GPU, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_PCIS, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_DR_SUPPORT, (boolean)true));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_HAS_USB, (boolean)false));
        judgeList.add(JudgeHandler.JudgeUnit.unit((Function)VrmJudgeDefine.IS_VM_LINK_CLONE, (boolean)false));
        for (GalaxVM galaxVm : galaxVms) {
            galaxVm.setVmConfigType((VmConfigType)CommonUtil.jsonToBean((String)galaxVm.getVmConfig(), VmConfigType.class));
            listVmUrns.add(galaxVm.getUuid());
            if (!JudgeHandler.build((Object)galaxVm).judge(judgeList)) {
                poToBeUnsupport.add(galaxVm.getUuid());
                continue;
            }
            poToBeResupport.add(galaxVm.getUuid());
        }
    }

    private void checkVmStatus(List<GalaxVM> galaxVms, Set<String> poToBeValid, Set<String> poToBeInvalid) {
        for (GalaxVM gvm : galaxVms) {
            if (gvm.getStatus().intValue() == VmStatusEnum.RUNNING.getKey() || gvm.getStatus().intValue() == VmStatusEnum.STOPPED.getKey()) {
                poToBeValid.add(gvm.getUuid());
                continue;
            }
            poToBeInvalid.add(gvm.getUuid());
        }
    }

    private boolean dealDiskInfoAlarm(ProtectGroup pg, Set<String> poNotBeConsistent, Set<String> poDisklBeClean, Set<String> poDisklBeExpand, List<DiskInfo> diskInfoList, Map<String, List<ProtectObject>> resourceIdtoPoMapOld) {
        boolean result = true;
        for (DiskInfo diskInfo : diskInfoList) {
            List poList;
            if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskInfo.getStatus())) {
                poList = diskInfo.getProtectObjects();
                for (ProtectObject po : poList) {
                    poNotBeConsistent.add(po.getMoUuid());
                    AlarmGenerator.sendProtectObjectConsistentAlarm((int)ProtectionTypeEnum.STORAGE_REPLICATION.getValue(), (String)pg.getUuid(), poNotBeConsistent);
                }
                result = false;
                continue;
            }
            if (DiskProtectStatusEnum.REMOVED.getStatus().equals(diskInfo.getStatus())) {
                poList = resourceIdtoPoMapOld.get(diskInfo.getResourceId());
                for (ProtectObject po : poList) {
                    poDisklBeClean.add(po.getMoUuid());
                    AlarmReporter.sendAlarm((String)"0x3230027", (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{po.getUuid(), pg.getName(), po.getName()});
                }
                result = false;
                continue;
            }
            if (!DiskProtectStatusEnum.EXPANDED.getStatus().equals(diskInfo.getStatus())) continue;
            poList = diskInfo.getProtectObjects();
            for (ProtectObject po : poList) {
                poDisklBeExpand.add(po.getMoUuid());
                AlarmReporter.sendAlarm((String)"0x3230057", (String)(pg.getUuid() + po.getUuid()), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{po.getUuid(), pg.getName(), po.getName()});
            }
            result = false;
        }
        return result;
    }

    private Set<String> checkPGRelation(ProtectGroup pg) {
        HashSet<String> poNotHasPair = new HashSet<String>();
        Set replicaList = pg.getReplicaList();
        HashMap<String, String> uuidToMouuid = new HashMap<String, String>();
        pg.getPolist().forEach(po -> uuidToMouuid.put(po.getUuid(), po.getMoUuid()));
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            this.checkPGRelation(pg, poNotHasPair, uuidToMouuid, protectGroupReplica);
            this.checkPGPairAndDealAlarm(pg, poNotHasPair, uuidToMouuid, protectGroupReplica);
        }
        return poNotHasPair;
    }

    private void checkPGPairAndDealAlarm(ProtectGroup pg, Set<String> poNotHasPair, Map<String, String> uuidToMouuid, ProtectGroupReplica protectGroupReplica) {
        HashMap<String, String> lunPoMap = new HashMap<String, String>();
        String srcDevsn = this.getSrcDevSNAndUpdateLunIds(protectGroupReplica, uuidToMouuid, lunPoMap);
        Set<String> lunIds = lunPoMap.keySet();
        ArrayList<HypermetroPair> moList = new ArrayList<HypermetroPair>();
        if (ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg)) {
            List<HypermetroPair> hypermetroPairList = this.queryHyperMetroPairs(srcDevsn, lunIds);
            if (VerifyUtil.isEmpty(hypermetroPairList)) {
                LOGGER.error((Object)"HypermetroPairList size error! pgName:%s", new Object[]{pg.getName()});
                return;
            }
            moList.addAll(hypermetroPairList);
        } else {
            IStorageBaseService storageService = (IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class);
            List replicationPairList = storageService.getReplicationPairsByResourceIds(srcDevsn, new ArrayList<String>(lunIds));
            if (VerifyUtil.isEmpty((Collection)replicationPairList) || replicationPairList.size() != lunIds.size()) {
                LOGGER.error((Object)"ReplicationPairList size error! pgName:%s", new Object[]{pg.getName()});
                return;
            }
            moList.addAll(replicationPairList);
        }
        boolean needCleanAlarm = true;
        for (ManagedObject managedObject : moList) {
            if (this.isPairHealthStatusAvailable(managedObject)) continue;
            if (managedObject instanceof HypermetroPair) {
                String lunId = ((HypermetroPair)managedObject).getLocalobjid();
                poNotHasPair.add((String)lunPoMap.get(lunId));
            }
            needCleanAlarm = false;
            LOGGER.debug((Object)"Pair status unhealthy, need send alarm, pairId: %s.", new Object[]{managedObject.getUuid()});
            AlarmReporter.sendAlarm((String)"0x3230062", (String)protectGroupReplica.getPg().getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{protectGroupReplica.getPg().getUuid(), protectGroupReplica.getPg().getName()});
        }
        if (needCleanAlarm) {
            AlarmReporter.restoreAlarm((String)"0x3230062", (String[])new String[]{pg.getUuid()});
        }
    }

    private void checkPGRelation(ProtectGroup pg, Set<String> poNotHasPair, Map<String, String> uuidToMouuid, ProtectGroupReplica protectGroupReplica) {
        Set protectObjectReplicaList = protectGroupReplica.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaList) {
            Set relicaStorageInfoList = protectObjectReplica.getStorageInfos();
            if (ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg)) {
                if (!this.isHypermetroRelationEmpty(relicaStorageInfoList)) continue;
                LOGGER.warn((Object)"Relation is empty, replicaId is %s.", new Object[]{protectObjectReplica.getId()});
                poNotHasPair.add(uuidToMouuid.get(protectObjectReplica.getPoId()));
                continue;
            }
            ReplicationRelation replicationRelation = this.getReplicationRelation(relicaStorageInfoList);
            if (replicationRelation != null) continue;
            LOGGER.warn((Object)"Relation is null, replicaId is %s.", new Object[]{protectObjectReplica.getId()});
            poNotHasPair.add(uuidToMouuid.get(protectObjectReplica.getPoId()));
        }
    }

    private String getSrcDevSNAndUpdateLunIds(ProtectGroupReplica pgReplica, Map<String, String> uuidToMouuid, Map<String, String> lunPoMap) {
        LOGGER.debug((Object)"Begin getSrcDevSNAndUpdateLunIds");
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                lunPoMap.put(storage.getSrcStorageId(), uuidToMouuid.get(poReplica.getPoId()));
                srcDevSn = storage.getSrcStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    private boolean isPairHealthStatusAvailable(ManagedObject pair) {
        if (pair instanceof ReplicationPair) {
            return this.isReplicationPairHealthStatusAvailable((ReplicationPair)pair);
        }
        if (pair instanceof HypermetroPair) {
            return this.isHypermetroPairStatusAvailable((HypermetroPair)pair);
        }
        return false;
    }

    private boolean isReplicationPairHealthStatusAvailable(ReplicationPair pair) {
        try {
            ArrayList<Integer> normalRunningStateList = new ArrayList<Integer>();
            normalRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue());
            normalRunningStateList.add(ReplicationConstantDefine.PairStatus.NORMAL.getValue());
            normalRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZED.getValue());
            normalRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue());
            normalRunningStateList.add(ReplicationConstantDefine.PairStatus.SYNCHRONIZING.getValue());
            Integer runningState = Integer.valueOf(pair.getRunningState());
            if (!normalRunningStateList.contains(runningState)) {
                return false;
            }
            Integer healthState = Integer.valueOf(pair.getHealthState());
            if (!healthState.equals(1) || !healthState.equals(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue())) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.error((Object)"The lun's healthState is error. healthState:%s, runningState:%s, error is %s.", new Object[]{pair.getHealthState(), pair.getRunningState(), ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return true;
    }

    private boolean isHypermetroPairStatusAvailable(HypermetroPair pair) {
        if (VerifyUtil.isEmpty((Object)pair)) {
            LOGGER.error((Object)"Param pair is empty.");
            return false;
        }
        if (VerifyUtil.isEmpty((String)pair.getSrcDevSN())) {
            LOGGER.error((Object)"Param srcDevSN is empty, pairId is %s.", new Object[]{pair.getId()});
            return false;
        }
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        return hyperProxy.getMgrByDevId(pair.getSrcDevSN()).isHypermetroPairStatusAvailable(pair);
    }

    private ReplicationRelation getReplicationRelation(Set<RelicaStorageInfo> relicaStorageInfoList) {
        for (RelicaStorageInfo relicaStorageInfo : relicaStorageInfoList) {
            RemoteStorageReplica remoteStorage = (RemoteStorageReplica)relicaStorageInfo;
            boolean isCgEmpty = !remoteStorage.getConsistentGroupId().isEmpty();
            IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
            if (isCgEmpty) {
                return recoveryService.queryReplication(remoteStorage.getSrcStorageProviderSN(), remoteStorage.getConsistentGroupId(), isCgEmpty);
            }
            if (remoteStorage.getReplicationPairId().isEmpty()) continue;
            return recoveryService.queryReplication(remoteStorage.getSrcStorageProviderSN(), remoteStorage.getReplicationPairId(), isCgEmpty);
        }
        return null;
    }

    private boolean isHypermetroRelationEmpty(Set<RelicaStorageInfo> relicaStorageInfoList) {
        HashSet<String> lunIds = new HashSet<String>();
        String srcDevSn = null;
        for (RelicaStorageInfo storage : relicaStorageInfoList) {
            lunIds.add(storage.getSrcStorageId());
            srcDevSn = storage.getSrcStorageProviderSN();
        }
        List<HypermetroPair> hypermetroPairList = this.queryHyperMetroPairs(srcDevSn, lunIds);
        return VerifyUtil.isEmpty(hypermetroPairList);
    }

    private List<HypermetroPair> queryHyperMetroPairs(String srcDevSn, Set<String> lunIds) {
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        return hyperProxy.getMgrByDevId(srcDevSn).getLocalHyperMetroPairs(srcDevSn, lunIds);
    }

    private List<GalaxVM> getGalaxVMsByUuid(Set<String> vmUuidSet) {
        LOGGER.debug((Object)"Enter getGalaxVMsByUuid enter.");
        QueryCondition qc = new QueryCondition("uuid", (Object)vmUuidSet.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vmList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            LOGGER.error((Object)"There is no vm in those uuids, vmUuidSet=%s.", new Object[]{vmUuidSet});
            return new ArrayList<GalaxVM>();
        }
        return vmList;
    }

    public String getProviderType() {
        return "FusionCompute";
    }

    public void refreshCloud(String cloudSn, String username, boolean cascade) {
        LOGGER.debug((Object)"RefreshVrm enter");
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            LOGGER.error((Object)"vrmSn is empty, and refreshing vrm failed.");
            throw new LegoCheckedException(1073947393L);
        }
        final VRM mo = (VRM)CommonDAOLocator.getMoDao().getMo(VRM.class, "sn", (Object)cloudSn);
        if (mo == null || mo.getMoId() == null) {
            LOGGER.error((Object)"VRM(%s) doesn't exist.Failed to refresh.", new Object[]{SecurityUtil.desensitizeId((String)cloudSn)});
            throw new LegoCheckedException(1073947394L);
        }
        if (mo.getName() == null) {
            mo.setName(mo.getLinkIp());
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)mo.getName(), (String)"ism.drm.vrm.log.refresh", (String)username, (String)"", null);
        AbstractBackTask task = new AbstractBackTask(mo.getUuid(), bt, true){

            protected void doWork() {
                long moId = mo.getMoId();
                NeMgrProtocolExtend extend = FusionComputeVmProvider.this.neMgr.findByMoId(Long.valueOf(moId));
                if (extend == null) {
                    LOGGER.error((Object)"VRM(%s)'NeMgrProtocolExtend dosen't exist.Failed to refresh.", new Object[]{mo.getName()});
                    throw new LegoCheckedException(1073947393L);
                }
                RefreshContext context = new RefreshContext((ManagedObject)mo);
                context.setAttribute("refreshTask", (Object)this);
                context.setAttribute("DiscoveryType", (Object)"refresh");
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Vrm");
                if (refreshTemplate == null) {
                    throw new LegoCheckedException(127402L);
                }
                refreshTemplate.process((AbstractContext)context);
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    throw new LegoCheckedException(errorCode.longValue());
                }
            }
        };
        int taskTimeout = Integer.parseInt(LegoBaseConfig.getInstance().getKeyValue(TASK_TIMEOUT_KEY, String.valueOf(21600)));
        task.setTimeout(taskTimeout);
        BackTaskHandler.getInstance().submitTask(task);
    }

    @Override
    public void multiSetVmBlockIoHangTimeout(String cloudSn, List<VMConfigs> vmConfigsList) {
        LOGGER.info((Object)"Start sending request for multiSetVmBlockIoHangTimeout.");
        if (VerifyUtil.isEmpty(vmConfigsList)) {
            LOGGER.error((Object)"The param vmConfigsList is empty.");
            return;
        }
        Set<String> uuidSet = vmConfigsList.stream().map(VMConfigs::getMoUuid).collect(Collectors.toSet());
        List<GalaxVM> vmList = this.getGalaxVMsByUuid(uuidSet);
        HashMap<String, String> uuidVmIdMap = new HashMap<String, String>();
        for (GalaxVM galaxVm : vmList) {
            String vmId = galaxVm.getUri().split("vms")[1].replace("/", "");
            if (VerifyUtil.isEmpty((String)vmId)) {
                LOGGER.debug((Object)"GalaxVM's vmId is null,uri is %s.", new Object[]{galaxVm.getUri()});
                continue;
            }
            uuidVmIdMap.put(galaxVm.getUuid(), vmId);
        }
        if (uuidVmIdMap.isEmpty()) {
            LOGGER.warn((Object)"The uuidVmIdMap is empty,uuidSet is %s.", new Object[]{uuidSet});
            return;
        }
        List vmConfigs = vmConfigsList.stream().filter(item -> uuidVmIdMap.containsKey(item.getMoUuid()) && !VerifyUtil.isEmpty((Object)item.getBlockIoHangTimeout())).map(item -> {
            JSONObject object = new JSONObject();
            object.put((Object)"vmId", uuidVmIdMap.get(item.getMoUuid()));
            object.put((Object)"blockIoHangTimeout", (Object)item.getBlockIoHangTimeout());
            return object;
        }).collect(Collectors.toList());
        JSONObject message = new JSONObject();
        message.put((Object)"vmConfigs", vmConfigs);
        IVirtualResourceManager vrmVirtualResService = VrmManager.getInstance().getVrmVirtualResService();
        VrmObject vrmObject = VrmUtil.getRecoveryVrmObject((String)cloudSn);
        vrmVirtualResService.multiSetVmBlockIoHangTimeout(vrmObject, message);
        LOGGER.info((Object)"The request for multiSetVmBlockIoHangTimeout is send.");
    }

    public void enablePoHyperMetro(String cloudSn, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(cloudSn);
        FusionSphereServiceManager.getInstance().getVirResourceService().enableVmsHypermetro(vrmInfo, hypermetroVolumeInfos);
    }

    public void stopPoHyperMetro(String cloudSn, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(cloudSn);
        FusionSphereServiceManager.getInstance().getVirResourceService().stopVmsHypermetro(vrmInfo, hypermetroVolumeInfos);
    }
}

