/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.provider.protectgroup;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectGroupProviderAdapter;
import com.huawei.ism.drm.galax.resource.discovery.manager.FmServiceManager;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.FusionComputeVmProvider;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.FusionSphereVmProvider;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class FusionManagerVmProvider
extends FusionSphereVmProvider {
    private static final Log LOGGER = LogFactory.getInstance(FusionManagerVmProvider.class);
    private INeMgrProtocolExtendService neMgr;
    private FusionComputeVmProvider fusionComputeVmProvider;
    private GalaxProtectGroupProviderAdapter poProviderAdapter;

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public FusionComputeVmProvider getFusionComputeVmProvider() {
        return this.fusionComputeVmProvider;
    }

    public void setFusionComputeVmProvider(FusionComputeVmProvider fusionComputeVmProvider) {
        this.fusionComputeVmProvider = fusionComputeVmProvider;
    }

    @Override
    public GalaxProtectGroupProviderAdapter getPoProviderAdapter() {
        return this.poProviderAdapter;
    }

    public void setPoProviderAdapter(GalaxProtectGroupProviderAdapter poProviderAdapter) {
        this.poProviderAdapter = poProviderAdapter;
    }

    public String getCloudType() {
        return DrFm.class.getSimpleName();
    }

    public void refreshProtectGroup(ProtectGroup pg) {
    }

    public String getProviderType() {
        return "FusionManager";
    }

    public void refreshCloud(String cloudSn, String userName, boolean cascade) {
        this.refreshFm(cloudSn, userName);
        if (!cascade) {
            return;
        }
        List regVrms = FmServiceManager.getInstance().getFmService().getRegistedFcOfSpecfiedFm(cloudSn);
        if (!VerifyUtil.isEmpty((Collection)regVrms)) {
            for (VRM vrm : regVrms) {
                try {
                    this.fusionComputeVmProvider.refreshCloud(vrm.getSn(), userName, cascade);
                }
                catch (LegoCheckedException e) {
                    LOGGER.error((Object)("Failed to refresh vrm : " + vrm.getSn()), 90160758787071L);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Failed to refresh vrm : " + vrm.getSn() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                }
            }
        }
    }

    private void refreshFm(String fmSn, String username) {
        LOGGER.debug((Object)"refreshFm enter", 90160758786816L);
        if (VerifyUtil.isEmpty((String)fmSn)) {
            LOGGER.error((Object)"fmSn is empty, and refreshing fm failed", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        final ManagedObject mo = CommonDAOLocator.getMoDao().getMo(FusionManager.class, "sn", (Object)fmSn);
        if (null == mo || null == mo.getMoId()) {
            LOGGER.error((Object)("FM(" + fmSn + ") dosen't exist.Failed to refresh."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        FusionManager fm = (FusionManager)mo;
        if (null == fm.getName()) {
            mo.setName(fm.getLinkIp());
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)mo.getName(), (String)"ism.drm.fm.log.refresh", (String)username, (String)"", null);
        AbstractBackTask task = new AbstractBackTask(mo.getUuid(), bt, true){

            protected void doWork() {
                long moId = mo.getMoId();
                NeMgrProtocolExtend extend = FusionManagerVmProvider.this.neMgr.findByMoId(Long.valueOf(moId));
                if (null == extend) {
                    LOGGER.error((Object)("FM(" + mo.getName() + ") dosen't exist.Failed to refresh."), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                RefreshContext context = new RefreshContext(mo);
                context.setAttribute("refreshTask", (Object)this);
                context.setAttribute("DiscoveryType", (Object)"refresh");
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Fm");
                if (null == refreshTemplate) {
                    throw new LegoCheckedException(127402L);
                }
                refreshTemplate.process((AbstractContext)context);
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    throw new LegoCheckedException(errorCode.longValue());
                }
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }
}

