/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.provider.protectgroup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectGroupProviderAdapter;
import com.huawei.ism.drm.galax.recovery.service.GalaxRecoveryPlanNetworkService;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.AbstractVmProvider;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.GalaxVirtualMachineProvider;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.TestNetworkSetting;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectProvider;
import com.huawei.ism.drm.galax.sdk.pg.service.IProtectObjectStorageInfoService;
import com.huawei.ism.drm.galax.sdk.service.IHostRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class FusionSphereVmProvider
extends AbstractVmProvider {
    private static final Log logger = LogFactory.getInstance(FusionSphereVmProvider.class);
    private static final String RECOVERY_PLAN_HOST = "host";
    private static final int POLICY_TEMPLATE_TYPE_HOST_REPLICATION = 11;
    private static final String PRODUCT_NET_URN = "proNetworkUrn";
    private static final String TEST_NET_URN = "testNetworkUrn";
    private static final String RECOVERY_PLAN_STORAGE = "storage";
    private static final List<Integer> STORAGE_REPLICATION_SUPPORT_TEMPLATES = ImmutableList.of((Object)0, (Object)1, (Object)18, (Object)26, (Object)27, (Object)20, (Object)33, (Object)39, (Object)51, (Object)52, (Object)23, (Object)24, (Object[])new Integer[]{3, 4, 5, 6});
    private static final Map<Integer, String> REPLICATION_TYPE_TO_PROTECT_TYPE_MAP = ImmutableMap.of((Object)ProtectionTypeEnum.HOST_REPLICATION.getValue(), (Object)ProtectTypeEnum.HOST_REPLICATION.getType(), (Object)ProtectionTypeEnum.VIS_HIGHAVAILABILITY.getValue(), (Object)ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType(), (Object)ProtectionTypeEnum.VIS_STORAGEMIRROR.getValue(), (Object)ProtectTypeEnum.VIS_DOUBLE_ACTIVE.getType(), (Object)ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue(), (Object)ProtectTypeEnum.SAN_HYPER_ACTIVE.getType(), (Object)ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue(), (Object)ProtectTypeEnum.STORAGE_SNAP_ACTIVE.getType());
    private static final Map<Integer, String> TEMPLATE_MAPPING_REPLICATION_TYPE_MAP = ImmutableMap.builder().put((Object)11, (Object)ProtectTypeEnum.HOST_REPLICATION.getType()).put((Object)1, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)0, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)18, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)20, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)23, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)26, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)27, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)24, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)3, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)4, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)5, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)6, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)33, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)39, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)51, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)52, (Object)ProtectTypeEnum.STORAGE_ARRAY.getType()).put((Object)19, (Object)ProtectTypeEnum.SAN_HYPER_ACTIVE.getType()).put((Object)2, (Object)ProtectTypeEnum.STORAGE_SNAP_ACTIVE.getType()).build();
    private static final List<Integer> SAN_HIGHAVAILABILITY_SUPPORT_TEMPLATES = ImmutableList.of((Object)15, (Object)19);
    private static final List<Integer> FC_HIGH_AVAILABILITY_SUPPORT_TEMPLATES = ImmutableList.of((Object)38, (Object)53);
    private static final List<Integer> FC_STORAGE_SNAPSHOT_SUPPORT_TEMPLATES = ImmutableList.of((Object)2);
    private static final Map<Integer, List<Integer>> SUPPORT_TEMPLATE_MAP = ImmutableMap.builder().put((Object)ProtectionTypeEnum.STORAGE_REPLICATION.getValue(), STORAGE_REPLICATION_SUPPORT_TEMPLATES).put((Object)ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue(), SAN_HIGHAVAILABILITY_SUPPORT_TEMPLATES).put((Object)ProtectionTypeEnum.FC_HIGH_AVAILABILITY.getValue(), FC_HIGH_AVAILABILITY_SUPPORT_TEMPLATES).put((Object)ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue(), FC_STORAGE_SNAPSHOT_SUPPORT_TEMPLATES).build();
    private IPolicyTemplateManager policyTemplateManager;

    public IPolicyTemplateManager getPolicyTemplateManager() {
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public abstract GalaxProtectGroupProviderAdapter getPoProviderAdapter();

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        if (null == this.policyTemplateManager) {
            return new ArrayList<PolicyTemplate>();
        }
        List list = this.policyTemplateManager.getAllTemplate(0L);
        ArrayList<PolicyTemplate> supportList = new ArrayList<PolicyTemplate>();
        for (int i = 0; i < list.size(); ++i) {
            PolicyTemplate policy = (PolicyTemplate)list.get(i);
            if (policy.getType() == 0 || policy.getType() == 1 || policy.getType() == 11 || policy.getType() == 33 || policy.getType() == 39) {
                supportList.add(policy);
            }
            if (!this.checkArrayHyperTemplate(policy)) continue;
            supportList.add(policy);
        }
        return supportList;
    }

    private boolean checkArrayHyperTemplate(PolicyTemplate policy) {
        List<Integer> supported = Arrays.asList(18, 20, 23, 24, 26, 27);
        return this.checkHyperMetroTemplate(policy) || supported.contains(policy.getType());
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int replicationType) {
        List<PolicyTemplate> supportList = this.getSupportTemplateByRepType(replicationType);
        HashSet<String> vmUUIDs = new HashSet<String>();
        for (ProtectObject po : protectObjectList) {
            vmUUIDs.add(po.getMoUuid());
            HashMap<String, String> props = new HashMap<String, String>();
            String protectType = REPLICATION_TYPE_TO_PROTECT_TYPE_MAP.getOrDefault(replicationType, ProtectTypeEnum.STORAGE_ARRAY.getType());
            props.put(PgExParamsEnum.PG_PROTECT_TYPE.getValue(), protectType);
            po.setProps(props);
        }
        this.updatePoProvider(vmUUIDs, protectObjectList);
        return supportList;
    }

    private List<PolicyTemplate> getSupportTemplateByRepType(int replicationType) {
        if (null == this.policyTemplateManager) {
            return new ArrayList<PolicyTemplate>();
        }
        List list = this.policyTemplateManager.getAllTemplate(0L);
        ArrayList<PolicyTemplate> supportList = new ArrayList<PolicyTemplate>();
        for (int i = 0; i < list.size(); ++i) {
            PolicyTemplate policy = (PolicyTemplate)list.get(i);
            if (!this.checkSupportTemplate(policy, replicationType)) continue;
            supportList.add(policy);
        }
        return supportList;
    }

    private boolean checkSupportTemplate(PolicyTemplate policy, int replicationType) {
        return Optional.ofNullable(SUPPORT_TEMPLATE_MAP.get(replicationType)).map(templates -> templates.contains(policy.getType()) && GalaxVirtualMachineProvider.checkUltraVRSupport(policy)).orElse(false);
    }

    private boolean checkHyperMetroTemplate(PolicyTemplate policy) {
        return policy.getType() == 15 || policy.getType() == 19;
    }

    private void updatePoProvider(Set<String> vmUUIDs, List<ProtectObject> poList) {
        QueryCondition qc = new QueryCondition("uuid", (Object)vmUUIDs.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vmList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            return;
        }
        block0: for (ProtectObject po : poList) {
            for (GalaxVM gVm : vmList) {
                if (!gVm.getUuid().equals(po.getMoUuid())) continue;
                po.setProviderSN(gVm.getTopMoUuid());
                continue block0;
            }
        }
    }

    public Map<String, Object> checkRecoveryContext(DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, String reySite) {
        String shareIp;
        ProtectGroup pg = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
        PolicyTemplate template = pg.getTemplate();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
        settings.put("PRODUCT_SITE_ID", productSiteId);
        settings.put("SELECT_DISASTER_SITE_KEY", reySite);
        String disterSiteId = this.getDisterSiteId(reySite, (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups()));
        settings.put("DISASTER_SITE_ID", disterSiteId);
        boolean useNas = false;
        if (null != recoveryPlan.getProtectGroups()) {
            useNas = RecoveryProcessBaseUtil.isProtectGroupUseNasFileSystem((ProtectGroup)((ProtectGroup)recoveryPlan.getProtectGroups().iterator().next()));
        }
        if (!VerifyUtil.isEmpty((String)(shareIp = recoveryContext.get("nasSharePortIp"))) && useNas) {
            this.checkNasShareIp(shareIp);
            settings.put("nasSharePortIp", recoveryContext.get("nasSharePortIp"));
        }
        String replicationType = null;
        if (!VerifyUtil.isEmpty((Object)template)) {
            replicationType = TEMPLATE_MAPPING_REPLICATION_TYPE_MAP.get(template.getType());
        }
        Map<String, Object> result = new HashMap<String, Object>();
        if (!VerifyUtil.isEmpty(replicationType)) {
            result = this.updateSettings(recoveryPlan, procType, replicationType, recoveryContext, settings);
        }
        return result;
    }

    private void checkNasShareIp(String shareIp) {
        if (!CommUtil.checkDrmIpParam((String)shareIp)) {
            logger.error((Object)"shareIp is not validated.");
            throw new LegoCheckedException(1073947393L, "shareIp is error.");
        }
    }

    private Map<String, Object> updateSettings(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String replicationType, Map<String, String> recoveryContext, Map<String, Object> settings) {
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING)) {
            if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
                this.updateLocalSetting(plan, recoveryContext, settings);
            } else {
                List<TestNetworkSetting> testNetworkSettings = this.getTestNetSettings(recoveryContext);
                this.updateNetwork(replicationType, plan.getPlanId(), recoveryContext.get("DISASTER_SITE_ID"), testNetworkSettings);
                JSONArray netArrays = JSONUtils.getJSONArrayFromCollection(testNetworkSettings);
                settings.put("TestNetwork", netArrays.toString());
            }
            return settings;
        }
        if (procType.equals((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY) && replicationType.equals(ProtectTypeEnum.HOST_REPLICATION.getType())) {
            int recoveryTypeInt;
            String recoveryType = recoveryContext.get("RecoveryType");
            if (null == recoveryType) {
                recoveryType = "1";
            }
            try {
                recoveryTypeInt = Integer.parseInt(recoveryType);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("recoveryType is invalid:" + recoveryType), (Throwable)e, 90160758787071L);
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
            if (recoveryTypeInt < 1 || recoveryTypeInt > 2) {
                logger.error((Object)"execute recoveryplan error, recoveryTypeInt is invalid. ", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            settings.put("RecoveryType", recoveryType);
            return settings;
        }
        return settings;
    }

    private List<TestNetworkSetting> getTestNetSettings(Map<String, String> recoveryContext) {
        String settingKey = recoveryContext.get("TestNetwork");
        if (VerifyUtil.isEmpty((String)settingKey)) {
            logger.error((Object)"testNetwork is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<TestNetworkSetting> testNetworkSettings = new ArrayList<TestNetworkSetting>();
        try {
            JSONArray netSettings = JSONArray.fromObject((Object)settingKey);
            int len = netSettings.size();
            for (int i = 0; i < len; ++i) {
                TestNetworkSetting tmpSettings = new TestNetworkSetting();
                tmpSettings.setProNetworkUrn(netSettings.getJSONObject(i).getString(PRODUCT_NET_URN));
                tmpSettings.setTestNetworkUrn(netSettings.getJSONObject(i).getString(TEST_NET_URN));
                testNetworkSettings.add(tmpSettings);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getTestNetSettings error.", (Throwable)e);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return testNetworkSettings;
    }

    private void updateNetwork(String replicationType, String planId, String recoverySiteId, List<TestNetworkSetting> testNetworkSettings) {
        if (replicationType.equals(ProtectTypeEnum.STORAGE_ARRAY.getType())) {
            IStorageRecoveryPlanService storageService = (IStorageRecoveryPlanService)GalaxRecoveryPlanNetworkService.getInstance().getNetworkServiceCallBack(RECOVERY_PLAN_STORAGE);
            if (null == storageService) {
                logger.error((Object)"failed to get storageservcie.", 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            storageService.updateTestNetworkSetting(planId, recoverySiteId, testNetworkSettings, 1L);
        } else if (replicationType.equals(ProtectTypeEnum.HOST_REPLICATION.getType())) {
            IHostRecoveryPlanService hostService = (IHostRecoveryPlanService)GalaxRecoveryPlanNetworkService.getInstance().getNetworkServiceCallBack(RECOVERY_PLAN_HOST);
            if (null == hostService) {
                logger.error((Object)"failed to get hostService.", 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            hostService.updateTestNetworkSetting(planId, recoverySiteId, testNetworkSettings, 1L);
        }
    }

    private void updateLocalSetting(RecoveryPlan plan, Map<String, String> recoveryContext, Map<String, Object> settings) {
        String testClouds = recoveryContext.get("testHostCluster");
        JSONArray cloudInfos = this.getJsonArrayByString(testClouds);
        this.checkClusterHostMapping(plan, cloudInfos, recoveryContext);
        settings.put("testHostCluster", cloudInfos.toString());
        String testSecGroups = recoveryContext.get("testSecurityGroup");
        String testNetworks = recoveryContext.get("testNetwork");
        String testPortGroups = recoveryContext.get("testPortGroup");
        JSONArray secGroups = this.getJsonArrayByString(testSecGroups);
        JSONArray networks = this.getJsonArrayByString(testNetworks);
        JSONArray portGroups = this.getJsonArrayByString(testPortGroups);
        this.checkNetworkMappingSet(secGroups, networks, portGroups);
        settings.put("testSecurityGroup", null == secGroups ? new JSONArray().toString() : secGroups.toString());
        settings.put("testNetwork", null == networks ? new JSONArray().toString() : networks.toString());
        settings.put("testPortGroup", null == testPortGroups ? new JSONArray().toString() : portGroups.toString());
    }

    private void checkNetworkMappingSet(JSONArray secGroups, JSONArray networks, JSONArray portGroups) {
        boolean isnPortGroupInvalid;
        boolean isSecGInvalid = null == secGroups || secGroups.isEmpty();
        boolean isnNetworkInvalid = null == networks || networks.isEmpty();
        boolean bl = isnPortGroupInvalid = null == portGroups || portGroups.isEmpty();
        if (isSecGInvalid && isnPortGroupInvalid && isnNetworkInvalid) {
            logger.error((Object)"params: isSecGInvalid, isnPortGroupInvalid and isnNetworkInvalid are true.");
            throw new LegoCheckedException(1073947393L);
        }
        if (isnPortGroupInvalid && isnNetworkInvalid) {
            logger.error((Object)"params: isnPortGroupInvalid and isnNetworkInvalid are true.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!isnNetworkInvalid) {
            this.checkNetworkMapping(networks);
        }
        if (!isnPortGroupInvalid) {
            this.checkPortGroupMapping(portGroups);
        }
        if (!isSecGInvalid) {
            this.checkSecGroupMapping(secGroups);
        }
    }

    private void checkPortGroupMapping(JSONArray portGroups) {
        for (int idx = 0; idx < portGroups.size(); ++idx) {
            JSONObject portGroupMapping = portGroups.getJSONObject(idx);
            String srcPortGroupUuid = portGroupMapping.getString("srcPortGroupId");
            String remotePortGroupUuid = portGroupMapping.getString("remotePortGroupId");
            this.checkResourceExist(GalaxObject.class, "uuid", srcPortGroupUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", remotePortGroupUuid);
        }
    }

    private void checkSecGroupMapping(JSONArray secGroups) {
        for (int idx = 0; idx < secGroups.size(); ++idx) {
            JSONObject secGroupMapping = secGroups.getJSONObject(idx);
            String srcSecGroupUuid = secGroupMapping.getString("srcSecurityGroupId");
            String remoteSecGroupUuid = secGroupMapping.getString("remoteSecurityGroupId");
            String srcVpcUuid = secGroupMapping.getString("srcVPCId");
            String remoteVpcUuid = secGroupMapping.getString("remoteVPCId");
            this.checkResourceExist(GalaxObject.class, "uuid", srcSecGroupUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", remoteSecGroupUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", srcVpcUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", remoteVpcUuid);
        }
    }

    private void checkNetworkMapping(JSONArray networks) {
        for (int idx = 0; idx < networks.size(); ++idx) {
            JSONObject networkMapping = networks.getJSONObject(idx);
            String srcNetworkUuid = networkMapping.getString("srcNetworkId");
            String remoteNetworkUuid = networkMapping.getString("remoteNetworkId");
            String srcVpcUuid = networkMapping.getString("srcVPCId");
            String remoteVpcUuid = networkMapping.getString("remoteVPCId");
            this.checkResourceExist(GalaxObject.class, "uuid", srcNetworkUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", remoteNetworkUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", srcVpcUuid);
            this.checkResourceExist(GalaxObject.class, "uuid", remoteVpcUuid);
        }
    }

    private <T extends ManagedObject> void checkResourceExist(Class<T> cl, String type, Object value) {
        ManagedObject mo = VrmManager.getInstance().getDaoAdapter().getMo(cl, type, value);
        if (null == mo) {
            logger.error((Object)"failed to get hostService.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void checkClusterHostMapping(RecoveryPlan plan, JSONArray clusterHostInfos, Map<String, String> recoveryContext) {
        if (null == clusterHostInfos || clusterHostInfos.isEmpty()) {
            logger.error((Object)"clusterHostInfos is null or empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject cloudMapping = clusterHostInfos.getJSONObject(0);
        String srcCloudSn = cloudMapping.getString("srcCloudId");
        String remoteCloudSn = cloudMapping.getString("remoteCloudId");
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        if (!srcCloudSn.equals(pg.getPoProviderSN()) || !remoteCloudSn.equals(recoveryContext.get("PG_DISASTER_HOST"))) {
            logger.error((Object)"params: srcCloudSn or remoteCloudSn error.");
            throw new LegoCheckedException(1073947393L);
        }
        if (srcCloudSn.equals(remoteCloudSn)) {
            logger.error((Object)"srcCloudSn is equal remoteCloudSn.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkResourceExist(NetworkEntity.class, "sn", srcCloudSn);
        this.checkResourceExist(NetworkEntity.class, "sn", remoteCloudSn);
        String srcClusterHostUuid = cloudMapping.getString("srcHostClusterId");
        String remoteClusterHostUuid = cloudMapping.getString("remoteHostClusterId");
        this.checkResourceExist(GalaxObject.class, "uuid", srcClusterHostUuid);
        this.checkResourceExist(GalaxObject.class, "uuid", remoteClusterHostUuid);
    }

    private JSONArray getJsonArrayByString(String jString) {
        if (VerifyUtil.isEmpty((String)jString)) {
            return null;
        }
        try {
            return JSONArray.fromObject((Object)jString);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getJsonArrayByString error.", (Throwable)e);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    private String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        IRecoveryProcessBaseService processBaseService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        ProtectGroupReplica rep = processBaseService.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (null != rep) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList, Object vmlist) {
        HashSet<String> vmUUIDs = new HashSet<String>();
        for (ProtectObject po : protectObjectList) {
            vmUUIDs.add(po.getMoUuid());
        }
        this.updatePoProvider(vmUUIDs, protectObjectList);
        ((IProtectObjectStorageInfoService)ServiceLocator.getInstance().getService(IProtectObjectStorageInfoService.class)).loadProtectObjectStorageInfo(protectObjectList);
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        logger.info((Object)("enter buildProtectObjects( " + protectGroup.getName() + ") of " + this.getClass().getSimpleName()), 90160758786816L);
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        this.getGalaxProtectObjectProvider(protectType).buildProtectObjects(protectGroup);
        logger.info((Object)"leave buildProtectObjects", 90160758786816L);
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition, Map<String, Object> extendResults) {
        String protectType = (String)extendCondition.get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        return this.getGalaxProtectObjectProvider(protectType).getAvailableProtectObject(poProviderSn, extendCondition, extendResults);
    }

    public Map<String, List<String>> checkAvailableVm(List<GalaxVM> vmLit, String protectType, int templateType) {
        return this.getGalaxProtectObjectProvider(protectType).checkAvailableGalaxVm(vmLit, templateType);
    }

    public void refreshProtectObjectProperties(ProtectGroup protectGroup) {
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        this.getGalaxProtectObjectProvider(protectType).updateProtectGroup(protectGroup.getUuid());
    }

    private IGalaxProtectObjectProvider getGalaxProtectObjectProvider(String protectType) {
        IGalaxProtectObjectProvider poProvider = this.getPoProviderAdapter().getGalaxPoProvider(protectType);
        if (poProvider == null) {
            logger.error((Object)("can not find the GalaxProtectObjectProvider, protectType=" + protectType), 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        return poProvider;
    }

    public void fillProtectObjects(ProtectGroup protectGroup) {
    }
}

