/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.provider.protectgroup;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectGroupProviderAdapter;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectObjectCloudProviderAdapter;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.resource.checker.ProtectObjectCountChecker;
import com.huawei.ism.drm.galax.resource.provider.constant.GalaxVmPgConstants;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectProvider;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigPropertiesType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.model.QueryPOPage;
import com.huawei.ism.drm.protection.provider.sdk.model.VMConfigs;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.storage.manager.sdk.model.HypermetroVolumeInfo;
import com.huawei.ism.drm.util.Base64;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.MemeryContext;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GalaxVirtualMachineProvider
extends AbstractProtectObjectProvider {
    private static final String CODE_UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getInstance(GalaxVirtualMachineProvider.class);
    private static final List<Integer> ULTRAVR_EXCLUDE_POLICYTEMPLATETYPES = ImmutableList.of((Object)19, (Object)23, (Object)24, (Object)3, (Object)4, (Object)5, (Object)6);
    private String trace = "trace";
    private IPolicyTemplateManager policyTemplateManager;

    public IPolicyTemplateManager getPolicyTemplateManager() {
        logger.trace((Object)(" enter  getPolicyTemplateManager" + this.trace));
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        logger.trace((Object)(" enter  setPolicyTemplateManager" + this.trace));
        this.policyTemplateManager = policyTemplateManager;
    }

    public List<ProtectObject> getSupportProtectObjectTypes() {
        logger.trace((Object)(this.trace + " trace message"));
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        ProtectObject po = new ProtectObject();
        po.setPoType(12);
        po.setName("Huawei Virtual Machine");
        poList.add(po);
        return poList;
    }

    public int getProviderByType() {
        logger.trace((Object)(this.trace + " trace message"));
        return 12;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        logger.trace((Object)(this.trace + " trace message"));
        String cloudSn = protectGroup.getPoProviderSN();
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(cloudSn);
        if (null == poProvider) {
            return;
        }
        Map pgProps = protectGroup.getProps();
        pgProps.put("PROVIDER_TYPE", poProvider.getProviderType());
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            return;
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            po.setProtectGroup(protectGroup);
            Map props = po.getProps();
            props.put(PgExParamsEnum.PG_PROTECT_TYPE.getValue(), protectType);
        }
        poProvider.buildProtectObjects(protectGroup);
    }

    private void checkMaxPoCount(ProtectGroup protectGroup) {
        logger.trace((Object)(this.trace + " trace message"));
        ProtectObjectCountChecker.checkPoCountInPg(protectGroup.getPoCount());
        ProtectObjectCountChecker.checkPoCountInSystem(protectGroup.getPoCount(), protectGroup.getUuid());
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition) {
        logger.trace((Object)(this.trace + " trace message"));
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(poProviderSn);
        if (null == poProvider) {
            return null;
        }
        List result = poProvider.getAvailableProtectObject(poProviderSn, extendCondition, new HashMap());
        this.pageQueryPO(extendCondition, result);
        return result;
    }

    private int pageQueryPO(Map<String, Object> extendCondition, List<ProtectObject> poList) {
        logger.trace((Object)(this.trace + " trace message"));
        int totalCount = 0;
        if (!VerifyUtil.isEmpty(poList)) {
            String orderBy = (String)extendCondition.get("orderBy");
            Integer pageSize = (Integer)extendCondition.get("pageSize");
            Integer startPage = (Integer)extendCondition.get("pageIndex");
            String orderType = (String)extendCondition.get("orderType");
            String nameValue = (String)extendCondition.get("name");
            String osTypeValue = (String)extendCondition.get("osType");
            String filterName = null;
            String filterValue = null;
            if (!VerifyUtil.isEmpty((String)osTypeValue)) {
                filterName = "osTypeValue";
                filterValue = osTypeValue;
            }
            if (!VerifyUtil.isEmpty((String)nameValue)) {
                filterName = "name";
                filterValue = nameValue;
            }
            this.filterPO(filterName, filterValue, poList);
            totalCount = poList.size();
            if (!VerifyUtil.isEmpty((String)orderType) && !VerifyUtil.isEmpty((String)orderBy)) {
                boolean orderByAscend = orderType.equals("asc");
                Collections.sort(poList, new CommonComparator(orderBy, orderByAscend, false));
            }
            if (!(VerifyUtil.isEmpty((String)orderBy) || VerifyUtil.isEmpty((String)orderType) || VerifyUtil.isEmpty((Object)startPage) || VerifyUtil.isEmpty((Object)pageSize))) {
                this.pageQuery(null, poList, orderBy, orderType, startPage, pageSize);
            }
        }
        return totalCount;
    }

    private void filterPO(String filterName, String filterValue, List<ProtectObject> poList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)filterName) || VerifyUtil.isEmpty((String)filterValue) || VerifyUtil.isEmpty(poList)) {
            return;
        }
        Iterator<ProtectObject> iterator = poList.iterator();
        while (iterator.hasNext()) {
            ProtectObject po = iterator.next();
            if (!filterName.equals("name") || po.getName().toUpperCase(Locale.getDefault()).contains(filterValue.toUpperCase(Locale.getDefault()))) continue;
            iterator.remove();
        }
    }

    private <T> void pageQuery(String defaultSortField, List<T> viewList, String orderBy, String orderType, int startPage, int pageSize) {
        logger.trace((Object)(" enter  pageQuery" + this.trace));
        if (null == viewList) {
            return;
        }
        if (viewList.isEmpty()) {
            viewList.addAll(Collections.EMPTY_LIST);
            return;
        }
        boolean orderByAscend = false;
        String sortType = orderType;
        if (VerifyUtil.isEmpty((String)sortType) || sortType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        String sortField = orderBy;
        String sortName = !VerifyUtil.isEmpty((String)defaultSortField) ? defaultSortField : sortField;
        Collections.sort(viewList, new CommonComparator(sortName, orderByAscend, false));
        int pageNo = startPage;
        Page page = Page.createPage((int)pageNo, (int)pageSize, viewList);
        if (null != page) {
            viewList.clear();
            viewList.addAll(page.getResult());
        } else {
            viewList.addAll(Collections.EMPTY_LIST);
        }
    }

    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject po) {
        logger.trace((Object)(this.trace + " trace message"));
        return null;
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return Collections.emptyList();
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (poProvider == null) {
            return Collections.emptyList();
        }
        return poProvider.getSupportPolicyTemplate(protectObjectList);
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        logger.trace((Object)(this.trace + " trace message"));
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(poProviderSn);
        if (null == poProvider) {
            return null;
        }
        List result = poProvider.getAvailableProtectObject(poProviderSn, extParamInQueryParam, new HashMap());
        this.pageQueryPO(extParamInQueryParam, result);
        return result;
    }

    public void refreshProtectObjectProperties(List<ProtectObject> protectObjectList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        ProtectObject po = protectObjectList.get(0);
        ProtectGroup pg = po.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)pg)) {
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (VerifyUtil.isEmpty((Object)poProvider)) {
            return;
        }
        poProvider.refreshProtectObjectProperties(pg);
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        logger.trace((Object)(" enter  checkProtectObjectsInProtectGroup " + this.trace));
        this.checkMaxPoCount(protectGroup);
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        this.getProviderByPoList(protectObjectList).ifPresent(poProvider -> poProvider.loadProtectObjectStorageInfo(protectObjectList, new Object()));
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int replicationType) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            logger.warn((Object)"Protect object List is empty");
            return Collections.emptyList();
        }
        List<String> storageTypeList = this.getStorageTypes(protectObjectList);
        this.checkPoStorageType(storageTypeList);
        List<PolicyTemplate> templateList = this.getProviderByPoList(protectObjectList).map(poProvider -> poProvider.getSupportPolicyTemplate(protectObjectList, replicationType)).orElse(Collections.emptyList());
        return this.filterTemplatesByStorageType(templateList, storageTypeList);
    }

    private Optional<IGalaxProtectObjectCloudProvider> getProviderByPoList(List<ProtectObject> protectObjectList) {
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (poProvider == null) {
            logger.warn((Object)"Protect object provider is null");
            return Optional.empty();
        }
        return Optional.of(poProvider);
    }

    private List<PolicyTemplate> filterTemplatesByStorageType(List<PolicyTemplate> templateList, List<String> storageTypeList) {
        if (VerifyUtil.isEmpty(templateList)) {
            return Collections.emptyList();
        }
        boolean isEVolType = storageTypeList.contains("advanceSan");
        Predicate<PolicyTemplate> removeCondition = template -> isEVolType != GalaxVmPgConstants.EVOL_SUPPORT_TEMPLATES.contains(template.getType());
        templateList.removeIf(removeCondition);
        return templateList;
    }

    private void checkPoStorageType(List<String> storageTypeList) {
        if (VerifyUtil.isEmpty(storageTypeList)) {
            logger.warn((Object)"The storage type list of protect Object is empty.");
            return;
        }
        if (storageTypeList.size() == 1 || Arrays.asList("LUNPOME", "LUN").containsAll(storageTypeList)) {
            return;
        }
        logger.error((Object)"The storage type list of protect Object conflicts, storageTypes: %s", new Object[]{storageTypeList});
        throw new LegoCheckedException(1073948184L);
    }

    private List<String> getStorageTypes(List<ProtectObject> protectObjectList) {
        List<String> uuidList = protectObjectList.stream().map(ProtectObject::getMoUuid).collect(Collectors.toList());
        ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>();
        conditionList.add(new QueryCondition("uuid", (Object)uuidList.toArray(new String[0])));
        List vmConfigList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, conditionList).stream().map(GalaxVM::getVmConfig).filter(vmConfig -> !VerifyUtil.isEmpty((String)vmConfig)).map(vmConfig -> (VmConfigType)CommonUtil.jsonToBean((String)vmConfig, VmConfigType.class)).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(vmConfigList)) {
            logger.error((Object)"The vmConfig is empty, vm's uuid list: %s.", new Object[]{uuidList});
            throw new LegoCheckedException(1073947394L);
        }
        return vmConfigList.stream().map(VmConfigType::getDisks).flatMap(Collection::stream).map(VmConfigDiskType::getStorageType).filter(type -> !VerifyUtil.isEmpty((String)type)).distinct().collect(Collectors.toList());
    }

    public static boolean checkUltraVRSupport(PolicyTemplate policy) {
        return !BusinessUtil.isUltraVR() || !ULTRAVR_EXCLUDE_POLICYTEMPLATETYPES.contains(policy.getType());
    }

    public Map<String, Object> pretreatmentParams(Map<String, Object> params) {
        logger.info((Object)"%s trace message", new Object[]{this.trace});
        if (VerifyUtil.isEmpty(params)) {
            return params;
        }
        String deviceSn = (String)params.get("deviceSn");
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return params;
        }
        try {
            String newDeviceSn = new String(Base64.base64ToByteArray((String)deviceSn), CODE_UTF_8);
            params.put("deviceSn", newDeviceSn);
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)("uft-8 not support:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            throw new LegoCheckedException(102410L, (Throwable)e);
        }
        return params;
    }

    private IGalaxProtectObjectCloudProvider getProtectObjectProvider(ProtectObject po) {
        logger.trace((Object)(" enter  getProtectObjectProvider " + this.trace));
        String poProviderSn = po.getProviderSN();
        if (VerifyUtil.isEmpty((String)poProviderSn)) {
            ManagedObject mo = CommonDAOLocator.getMoDao().getMoByUuid(po.getMoUuid(), Boolean.valueOf(true));
            poProviderSn = null == mo ? GalaxVirtualMachineProvider.getOpenstackUuidFromStr(po.getMoUuid()) : mo.getTopMoUuid();
        }
        return this.getProtectObjectProvider(poProviderSn);
    }

    private static String getOpenstackUuidFromStr(String uuid) {
        String ret = "";
        if (VerifyUtil.isEmpty((String)uuid)) {
            return "";
        }
        if (uuid.contains(":")) {
            ret = uuid.split(":")[0];
        }
        return ret;
    }

    private IGalaxProtectObjectCloudProvider getProtectObjectProvider(String poProviderSn) {
        logger.trace((Object)(" enter  getProtectObjectProvider " + this.trace));
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{poProviderSn});
        if (VerifyUtil.isEmpty((Collection)resources)) {
            logger.error((Object)("resources get from DrResource where deviceSn= " + poProviderSn + "is null"), 90160758787071L);
            return null;
        }
        Object s1 = resources.get(0);
        String providerType = s1.getClass().getSimpleName();
        IGalaxProtectObjectCloudProvider poProvider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByCloud(providerType);
        return poProvider;
    }

    public void encryptProperties(ProtectGroup protectGroup) {
        IGalaxProtectObjectProvider iGalaxProtectObjectProvider;
        logger.trace((Object)(" enter  encryptProperties " + this.trace));
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        if (null != protectType && null != (iGalaxProtectObjectProvider = GalaxProtectGroupProviderAdapter.getInstance().getGalaxPoProvider(protectType))) {
            iGalaxProtectObjectProvider.encryptProperties(protectGroup);
        }
    }

    public void decryptPropreties(ProtectGroup protectGroup) {
        logger.trace((Object)(" enter  decryptPropreties " + this.trace));
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        IGalaxProtectObjectProvider galaxProtectObjectProvider = GalaxProtectGroupProviderAdapter.getInstance().getGalaxPoProvider(protectType);
        if (null != galaxProtectObjectProvider) {
            galaxProtectObjectProvider.decryptPropreties(protectGroup);
        }
    }

    public void refreshProtectGroup(ProtectGroup protectGroup) {
        String cloudSn = protectGroup.getPoProviderSN();
        if (VerifyUtil.isEmpty((String)protectGroup.getPoProviderSN())) {
            logger.error((Object)("cloudSn is empty,pgName=" + protectGroup.getName()));
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(cloudSn);
        if (null == poProvider) {
            logger.error((Object)("can't get poprovider,cloudsn=" + cloudSn));
            return;
        }
        MemeryContext.with((Object)protectGroup.getUuid(), (Object)protectGroup, () -> poProvider.refreshProtectGroup(protectGroup));
    }

    public BatchOperationResult multiSetVmBlockIoHangTimeout(String cloudSn, List<VMConfigs> vmConfigsList) {
        if (VerifyUtil.isEmpty(vmConfigsList)) {
            throw new LegoCheckedException("Parameter of vmConfigsList is empty.");
        }
        IGalaxProtectObjectCloudProvider provider = this.getProtectObjectProvider(cloudSn);
        if (VerifyUtil.isEmpty((Object)provider)) {
            throw new LegoCheckedException("Provider is empty");
        }
        provider.multiSetVmBlockIoHangTimeout(cloudSn, vmConfigsList);
        return this.checkVmBlockIoHangTimeout(cloudSn, vmConfigsList);
    }

    private BatchOperationResult checkVmBlockIoHangTimeout(String cloudSn, List<VMConfigs> vmConfigsList) {
        BatchOperationResult operationResult = new BatchOperationResult();
        List operationList = operationResult.getResult();
        IVirtualResourceManager resourceManager = (IVirtualResourceManager)ServiceLocator.getInstance().getService(IVirtualResourceManager.class);
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(cloudSn);
        Map<String, Integer> timeoutMap = vmConfigsList.stream().collect(Collectors.toMap(VMConfigs::getMoUuid, VMConfigs::getBlockIoHangTimeout));
        List vmList = resourceManager.queryVmsByUuuids(timeoutMap.keySet(), vrmInfo);
        for (GalaxVM galaxVM : vmList) {
            VmConfigPropertiesType vmProperties;
            String uuid = galaxVM.getUuid();
            VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)galaxVM.getVmConfig(), VmConfigType.class);
            if (VerifyUtil.isEmpty((Object)vmConfig) || VerifyUtil.isEmpty((Object)(vmProperties = vmConfig.getProperties()))) continue;
            Integer timeout = vmProperties.getBlockIoHangTimeout();
            if (!timeoutMap.get(uuid).equals(timeout)) continue;
            timeoutMap.remove(uuid);
            BatchOperation operation = new BatchOperation();
            operation.setTargetName(uuid);
            operationList.add(operation);
            CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)galaxVM);
        }
        int total = vmConfigsList.size();
        int fail = timeoutMap.size();
        logger.info((Object)"Set of multiSetVmBlockIoHangTimeout. total: %s, fail: %s", new Object[]{String.valueOf(total), String.valueOf(fail)});
        operationResult.setTotalCount(total);
        operationResult.setFailCount(fail);
        operationResult.setSucceedCount(total - fail);
        for (String uuid : timeoutMap.keySet()) {
            BatchOperation operation = new BatchOperation();
            operation.setTargetName(uuid);
            operation.setErrorCode(310L);
            operationList.add(operation);
            logger.warn((Object)"Set multiSetVmBlockIoHangTimeout fail, moUuid is %s.", new Object[]{uuid});
        }
        return operationResult;
    }

    public void enablePoHyperMetro(String cloudSn, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            logger.error((Object)"cloudSn(%s)is empty", new Object[]{cloudSn});
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(cloudSn);
        poProvider.enablePoHyperMetro(cloudSn, hypermetroVolumeInfos);
    }

    public void stopPoHyperMetro(String cloudSn, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            logger.error((Object)"cloudSn(%s)is empty", new Object[]{cloudSn});
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(cloudSn);
        poProvider.stopPoHyperMetro(cloudSn, hypermetroVolumeInfos);
    }

    public QueryPOPage getAvailableProtectObjectPage(String poProviderSn, Map<String, Object> extendCondition) {
        logger.trace((Object)(this.trace + " trace message"));
        QueryPOPage page = new QueryPOPage();
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(poProviderSn);
        if (poProvider == null) {
            return page;
        }
        HashMap extendResults = new HashMap();
        List poList = poProvider.getAvailableProtectObject(poProviderSn, extendCondition, extendResults);
        int totalCount = extendResults.containsKey("totalCount") ? ((Integer)extendResults.get("totalCount")).intValue() : this.pageQueryPO(extendCondition, poList);
        page.setTotalCount(Integer.valueOf(totalCount));
        page.setPoList(poList);
        return page;
    }
}

