/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.resource.mapping.RmFcResourceService;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.pg.model.DsMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.pg.model.PgMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.topo.sdk.element.CloudElement;
import com.huawei.ism.drm.galax.topo.sdk.element.DatastoreElement;
import com.huawei.ism.drm.galax.topo.sdk.element.GalaxVirtualElement;
import com.huawei.ism.drm.galax.topology.GalaXTopoResourceHelper;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.topo.builder.AbstractTopoCommonBuilder;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.skin.LinkFromAtLeftSkin;
import com.huawei.ism.drm.topo.skin.LinkWithArrowSkin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.twaver.ElementBox;
import com.huawei.twaver.IData;
import com.huawei.twaver.IElement;
import com.huawei.twaver.Link;
import com.huawei.twaver.Node;
import com.huawei.twaver.SubNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:ProtectGroup-12")
public class GalaxVirtualMachineTopoBuilder
extends AbstractTopoCommonBuilder {
    private static final List<Integer> OPENSTACK_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(22, 21, 25, 29, 22, 34, 37));
    private static final Log LOGGER = LogFactory.getInstance(GalaxVirtualMachineTopoBuilder.class);
    private static final List<Integer> SAN_ACTIVE_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(15, 18, 23, 26, 28, 19));
    private static final List<Integer> HYPER_METRO_REPLICATION_RING = Arrays.asList(26);
    private static final List<Integer> REPLICATION_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(0, 1, 20, 18, 24, 23, 26, 27, 33, 39, 51, 52, 2));
    private static final Set<Integer> THREE_DC_TEMPLATE_TYPE_SET = new HashSet<Integer>(Arrays.asList(3, 4, 5, 6));
    private static final int MAX_PG_PROP_VALUE_LENGTH = 262144;
    private static final int SUB_NETWORK_FILL_CORLOR = 0xF1F1FF;
    private static final int SUB_NETWORK_LABEL_CORLOR = 35020;
    private RmFcResourceService rmFcService;

    public void setRmFcService(RmFcResourceService rmFcService) {
        this.rmFcService = rmFcService;
    }

    public static List<Integer> getOpenstackTemplateTypeList() {
        return OPENSTACK_TEMPLATE_TYPE_LIST;
    }

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup pg;
        if (context.getRootNode() == null) {
            this.initialize(context);
        }
        if (VerifyUtil.isEmpty((Object)(pg = context.getProtectGroup())) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            LOGGER.warn((Object)"protect group or polist is null.", 90160758786816L);
            return;
        }
        int templateType = pg.getTemplate().getType();
        if (OPENSTACK_TEMPLATE_TYPE_LIST.contains(templateType)) {
            return;
        }
        Node proSiteStyleNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(pg.getProductSiteId() + ":proSiteParent"));
        context.addChild((IData)context.getRootNode(), (IData)proSiteStyleNode);
        String productSiteId = pg.getProductSiteId();
        Node productSiteNode = this.createGalaxSiteNode(context, proSiteStyleNode, productSiteId, templateType);
        Node proCloudStyleNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(productSiteNode.getID() + ":proCloudParent"));
        context.addChild((IData)productSiteNode, (IData)proCloudStyleNode);
        String proCloudSn = pg.getPoProviderSN();
        Node proCloudNode = this.createCloudNode(context, proCloudSn, proCloudStyleNode);
        if (this.checkRepTemplateType(templateType) || this.check3DcTemplateType(templateType) || SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(templateType) || ProtectGroupUtil.isHyperMetroOfSmallLun((ProtectGroup)pg)) {
            this.buildNodes(context, pg, templateType, proCloudNode);
        }
    }

    private void buildNodes(TopoBaseContext context, ProtectGroup pg, int templateType, Node proCloudNode) {
        Node vmStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)"", (String)(proCloudNode.getID() + ":galaxvm"));
        this.addVmNode(context, pg, proCloudNode, vmStyleNode);
        Node dsStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)"", (String)(proCloudNode.getID() + ":datastore" + context.getType()));
        this.addStorageNode(context, proCloudNode, dsStyleNode);
        this.setVmDsLink(context, vmStyleNode, dsStyleNode);
        if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(templateType)) {
            ProtectObject po = (ProtectObject)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)context.getProtectGroup().getPolist());
            ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)po.getUsedStorageResourceSet());
            List siteIdList = this.getHyperMetroSiteIds(context, poStorageInfo);
            if (templateType == 18 || templateType == 23) {
                this.createSanHyperRepDsNodes(context, dsStyleNode, siteIdList);
                return;
            }
            Map<String, String> dataMap = new HashMap<String, String>();
            if (DrmEnumDefine.ResourceTypeE.NAS.getValue() == this.getStorageResourceType(pg) && 15 == pg.getTemplate().getType()) {
                dataMap = this.getHyperMetroPairMap(context, pg);
            }
            this.createSanActiveDsNodes(context, dsStyleNode, siteIdList, dataMap);
            return;
        }
        if (ProtectGroupUtil.isReplicaOfSmallLun((ProtectGroup)pg)) {
            List<DsMgrInfoBase> dsInfos = this.getDatastores(context.getProtectGroup());
            if (dsInfos.isEmpty()) {
                return;
            }
            for (DsMgrInfoBase ds : dsInfos) {
                this.createFDSNodes(context, pg, dsStyleNode, ds);
            }
            return;
        }
        if (templateType == 2) {
            this.createArraySnapshotTopo(context, dsStyleNode);
            return;
        }
        this.addDsNodes(context, pg, dsStyleNode);
    }

    private void createArraySnapshotTopo(TopoBaseContext context, Node dsStyleNode) {
        List<DsMgrInfoBase> dataStores = this.getDatastores(context.getProtectGroup());
        dataStores.forEach(dataStore -> {
            String dsUrn = dataStore.getDsUrn();
            IElement element = context.getElementBox().getElementByID((Object)dsUrn);
            if (element instanceof Node) {
                LOGGER.info((Object)"Element of dsUrn:%s is not empty,continue iterate dataStores", new Object[]{dsUrn});
            } else if (element != null) {
                LOGGER.info((Object)"Type of DsNode is wrong:%s", new Object[]{element});
            } else {
                DatastoreElement dsNode = new DatastoreElement(dataStore);
                context.addChild((IData)dsStyleNode, (IData)dsNode);
                context.linkTo((Node)dsNode, (Object)(context.getProtectGroup().getProductSiteId() + dataStore.getPrimaryLunWwn()), new Skin[0]);
            }
        });
    }

    private void addDsNodes(TopoBaseContext context, ProtectGroup pg, Node dsStyleNode) {
        Set replicas = pg.getReplicaList();
        ArrayList<ProtectGroupReplica> replicaList = new ArrayList<ProtectGroupReplica>(replicas);
        replicaList.sort(Comparator.comparingInt(ProtectGroupReplica::getProtectLocation));
        for (ProtectGroupReplica replica : replicaList) {
            this.createDsNodes(context, dsStyleNode, replica);
        }
    }

    private void setVmDsLink(TopoBaseContext context, Node vmStyleNode, Node dsStyleNode) {
        Link link = new Link((Object)"vmToDs", vmStyleNode, dsStyleNode);
        link.setLayerID((Object)"layer0");
        new LinkFromAtLeftSkin().apply((IElement)link);
        link.setStyle("link.to.position", (Object)"left");
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)link);
    }

    private void addStorageNode(TopoBaseContext context, Node proCloudNode, Node dsStyleNode) {
        dsStyleNode.setClient("leftGap", 11.0);
        dsStyleNode.setClient("topGap", 11.0);
        dsStyleNode.setClient("sonsGap", 7.0);
        context.addChild((IData)proCloudNode, (IData)dsStyleNode);
    }

    private void addVmNode(TopoBaseContext context, ProtectGroup pg, Node proCloudNode, Node vmStyleNode) {
        context.addChild((IData)proCloudNode, (IData)vmStyleNode);
        vmStyleNode.setClient("leftGap", 11.0);
        vmStyleNode.setClient("topGap", 11.0);
        vmStyleNode.setClient("sonsGap", 7.0);
        vmStyleNode.setClient("layout", (Object)"leftright");
        context.addChild((IData)proCloudNode, (IData)vmStyleNode);
        this.createVmNodes(context, vmStyleNode, pg);
    }

    private void createFDSNodes(TopoBaseContext context, ProtectGroup pg, Node dsStyleNode, DsMgrInfoBase ds) {
        String dsUrn = ds.getDsUrn();
        Node dsNode = (Node)context.getElementBox().getElementByID((Object)dsUrn);
        if (!VerifyUtil.isEmpty((Object)dsNode)) {
            return;
        }
        dsNode = new DatastoreElement(ds);
        context.addChild((IData)dsStyleNode, (IData)dsNode);
        Set polists = pg.getPolist();
        for (ProtectObject polist : polists) {
            VmConfigType vmConfigType = this.getvmConfig(polist);
            if (VerifyUtil.isEmpty((Object)vmConfigType)) {
                return;
            }
            List diskList = vmConfigType.getDisks();
            HashSet<String> volumNameSet = new HashSet<String>();
            for (VmConfigDiskType disk : diskList) {
                if (!disk.getDatastoreUrn().equals(ds.getDsUrn())) continue;
                String volumeName = disk.getVolumeUrl().startsWith("scsi-3") ? disk.getVolumeUrl().substring(6) : disk.getVolNameOnDev();
                volumNameSet.add(volumeName);
            }
            if (!volumNameSet.isEmpty()) {
                this.linkFsAndSrcLun(context, polist, dsNode, volumNameSet);
            }
            diskList.clear();
        }
    }

    private VmConfigType getvmConfig(ProtectObject protectObject) {
        VmConfigType vmConfigType = null;
        Map prop = protectObject.getProps();
        if (!prop.isEmpty() && prop.containsKey(PoExParamsEnum.VM_MGR_INFO.getValue())) {
            FixLengthProps poRecoveryProps = new FixLengthProps(prop, 8192);
            String vmMgrJson = poRecoveryProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
            Map vmMgrInfoMap = (Map)JSONObject.toBean((String)vmMgrJson, Map.class);
            vmConfigType = (VmConfigType)CommonUtil.jsonToBean((String)vmMgrInfoMap.get("vmConfig").toString(), VmConfigType.class);
        }
        return vmConfigType;
    }

    private boolean checkRepTemplateType(int templateType) {
        return REPLICATION_TEMPLATE_TYPE_LIST.contains(templateType);
    }

    private boolean check3DcTemplateType(int templateType) {
        return THREE_DC_TEMPLATE_TYPE_SET.contains(templateType);
    }

    private void createVISDsNodes(TopoBaseContext context, Node dsStyleNode) {
        ProtectGroup protectGroup = context.getProtectGroup();
        Set poSet = protectGroup.getPolist();
        for (ProtectObject po : poSet) {
            Set storageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                String dataStoreNodeId = storageInfo.getResourceProviderSN();
                Node dataStoreNode = (Node)context.getElementBox().getElementByID((Object)dataStoreNodeId);
                if (dataStoreNode == null) {
                    String dsName = storageInfo.getDeviceName();
                    dataStoreNode = new DatastoreElement(dataStoreNodeId, dsName);
                    context.addChild((IData)dsStyleNode, (IData)dataStoreNode);
                }
                String lunWWN = storageInfo.getLunWWN();
                context.linkTo(dataStoreNode, (Object)lunWWN.toUpperCase(Locale.getDefault()), new Skin[0]);
                context.linkTo(dataStoreNode, (Object)lunWWN, new Skin[0]);
            }
        }
    }

    private void createSanActiveDsNodes(TopoBaseContext context, Node dsStyleNode, List<String> siteIdList, Map<String, String> dataMap) {
        Set poSet;
        ProtectGroup protectGroup = context.getProtectGroup();
        Map<String, DataStore> wwnDsMap = this.getWwnMap(protectGroup, poSet = protectGroup.getPolist());
        if (VerifyUtil.isEmpty(wwnDsMap)) {
            return;
        }
        int policyTemplateType = protectGroup.getTemplate().getType();
        for (ProtectObject po : poSet) {
            Set storageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                String lunWWN = storageInfo.getLunWWN();
                String pairId = dataMap.get(this.getUuidKey(storageInfo));
                DataStore ds = wwnDsMap.get(lunWWN);
                if (ds == null) continue;
                Node dataStoreNode = (Node)context.getElementBox().getElementByID((Object)ds.getUuid());
                if (dataStoreNode == null) {
                    dataStoreNode = new DatastoreElement(ds.getUuid(), ds.getName());
                    context.addChild((IData)dsStyleNode, (IData)dataStoreNode);
                }
                String string = lunWWN = DrmEnumDefine.ResourceTypeE.NAS.getValue() == this.getStorageResourceType(protectGroup) ? pairId : lunWWN;
                if (VerifyUtil.isEmpty((String)lunWWN)) continue;
                for (String siteId : siteIdList) {
                    if (!HYPER_METRO_REPLICATION_RING.contains(policyTemplateType)) {
                        context.linkTo(dataStoreNode, (Object)(siteId + lunWWN.toUpperCase(Locale.getDefault())), new Skin[0]);
                        context.linkTo(dataStoreNode, (Object)(siteId + lunWWN), new Skin[0]);
                        continue;
                    }
                    HashMap<String[], Node> endings = (HashMap<String[], Node>)context.find((Object)"endings");
                    if (endings == null) {
                        endings = new HashMap<String[], Node>();
                        context.bind((Object)"endings", endings);
                    }
                    endings.put(new String[]{lunWWN, siteId}, dataStoreNode);
                }
            }
        }
    }

    private Map<String, DataStore> getWwnMap(ProtectGroup protectGroup, Set<ProtectObject> poSet) {
        JSONObject jsonObject;
        ArrayList<String> wwnList = new ArrayList<String>();
        for (ProtectObject po : poSet) {
            Set storageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                wwnList.add(storageInfo.getLunWWN());
            }
        }
        List<Object> pgVrmDataStoreList = Collections.emptyList();
        if (this.rmFcService != null && protectGroup.getPoProviderSN() != null && protectGroup.getPoType() == DrmEnumDefine.AppType.GALAX_VM.getValue() && (jsonObject = (JSONObject)protectGroup.getProperty("pgMgrInfo", JSONObject.class)) != null && jsonObject.containsKey((Object)PgExParamsEnum.PG_FCSN.getValue())) {
            pgVrmDataStoreList = this.rmFcService.getAvailableDataStore(protectGroup.getProductSiteId(), jsonObject.getString(PgExParamsEnum.PG_FCSN.getValue()));
        }
        return DsgUtil.getDataStoreByWwns(wwnList, pgVrmDataStoreList);
    }

    private void createSanHyperRepDsNodes(TopoBaseContext context, Node dsStyleNode, List<String> siteIdList) {
        List<DsMgrInfoBase> dsInfos = this.getDatastores(context.getProtectGroup());
        for (DsMgrInfoBase ds : dsInfos) {
            String dsUrn = ds.getDsUrn();
            Node dsNode = (Node)context.getElementBox().getElementByID((Object)dsUrn);
            if (!VerifyUtil.isEmpty((Object)dsNode)) {
                return;
            }
            dsNode = new DatastoreElement(ds);
            context.addChild((IData)dsStyleNode, (IData)dsNode);
            for (String siteId : siteIdList) {
                List wwns = ds.getWwns();
                if (VerifyUtil.isEmpty((Collection)wwns)) continue;
                for (String lunWWN : wwns) {
                    context.linkTo(dsNode, (Object)(siteId + lunWWN.toUpperCase(Locale.getDefault())), new Skin[0]);
                    context.linkTo(dsNode, (Object)(siteId + lunWWN), new Skin[0]);
                }
            }
        }
    }

    protected Node createGalaxSiteNode(TopoBaseContext context, Node parentNode, String siteId, int templateType) {
        Node siteNode = (Node)context.getElementBox().getElementByID((Object)siteId);
        if (siteNode == null) {
            Site site = context.getSiteService().getSiteById(siteId);
            if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(templateType)) {
                site.setSiteId(site.getSiteId() + ":hypermetro");
                siteNode = new SiteElement(site);
                siteNode.setStyle("vector.fill", false);
                siteNode.setName(null);
                siteNode.setToolTip(null);
                siteNode.setStyle("vector.outline.alpha", 0.0);
            } else {
                siteNode = new SiteElement(site);
            }
            context.addChild((IData)parentNode, (IData)siteNode);
        }
        return siteNode;
    }

    protected Node createCloudNode(TopoBaseContext context, String cloudSn, Node parentNode) {
        GalaXTopoResourceHelper topoHelper = new GalaXTopoResourceHelper(context.getProtectGroup());
        Node cloudNode = (Node)context.getElementBox().getElementByID((Object)cloudSn);
        if (cloudNode == null) {
            DrResource drResource = this.getDrResource(cloudSn);
            topoHelper.checkDrResource(drResource);
            String providerSn = context.getProtectGroup().getPoProviderSN();
            cloudNode = providerSn.startsWith("Dr_Vrm") ? new CloudElement(drResource) : new CloudElement(drResource, "ism.drm.topo.app.fm.name");
            context.addChild((IData)parentNode, (IData)cloudNode);
        }
        return cloudNode;
    }

    protected void createDsNodes(TopoBaseContext context, Node poStyleNode, ProtectGroupReplica replica) {
        List<DsMgrInfoBase> dsInfos = this.getDatastores(context.getProtectGroup());
        for (DsMgrInfoBase ds : dsInfos) {
            String dsUrn = ds.getDsUrn();
            Node dsNode = (Node)context.getElementBox().getElementByID((Object)dsUrn);
            if (!VerifyUtil.isEmpty((Object)dsNode)) {
                return;
            }
            dsNode = new DatastoreElement(ds);
            dsNode.setClient("dsPool", (Object)ds.getWwns());
            context.addChild((IData)poStyleNode, (IData)dsNode);
            this.linkDsAndSrcLun(context, replica, ds, dsNode);
        }
    }

    private void linkFsAndSrcLun(TopoBaseContext context, ProtectObject polist, Node dsNode, Set<String> volumNameSet) {
        Set useStorageInfos = polist.getUsedStorageResourceSet();
        HashSet<String> wwnSet = new HashSet<String>();
        for (ProtectObjectStorageInfo useStorageInfo : useStorageInfos) {
            if (!volumNameSet.contains(useStorageInfo.getResourceName()) && !volumNameSet.contains(useStorageInfo.getLunWWN())) continue;
            String srcWwn = useStorageInfo.getLunWWN();
            wwnSet.add(srcWwn);
            if (context.getProtectGroup().isPrimary()) {
                List luns = DsgUtil.getLunByWwn((String)srcWwn);
                if (luns == null) {
                    LOGGER.error((Object)("lun is null, wwn=" + srcWwn), 90160758787071L);
                    throw new LegoCheckedException(1073947394L);
                }
                for (Lun lun : luns) {
                    context.linkTo(dsNode, (Object)(lun.getDevSn() + lun.getLunId()), (Object)("ds2lun" + lun.getDevSn() + lun.getLunId()), new Skin[]{new LinkWithArrowSkin()});
                }
                continue;
            }
            this.linkFsAndSrcLunInRec(context, wwnSet, dsNode);
        }
    }

    private void linkFsAndSrcLunInRec(TopoBaseContext context, Set<String> wwnSet, Node dsNode) {
        ProtectGroup pg = context.getProtectGroup();
        Set replicas = pg.getReplicaList();
        for (String wwn : wwnSet) {
            for (ProtectGroupReplica replica : replicas) {
                Set<RelicaStorageInfo> storageInfos = this.getRelicaStorageInfos(replica);
                for (RelicaStorageInfo storageInfo : storageInfos) {
                    if (!wwn.equals(storageInfo.getProtectObjectStorageWwn())) continue;
                    String srcLunId = storageInfo.getSrcStorageId();
                    context.linkTo(dsNode, (Object)(replica.getProductArray() + srcLunId), (Object)("ds2lun" + replica.getProductArray() + srcLunId), new Skin[]{new LinkWithArrowSkin()});
                }
            }
        }
    }

    private void linkDsAndSrcLun(TopoBaseContext context, ProtectGroupReplica replica, DsMgrInfoBase ds, Node dsNode) {
        if (context.getProtectGroup().isPrimary()) {
            for (String wwn : ds.getWwns()) {
                List luns = DsgUtil.getLunByWwn((String)wwn);
                if (luns == null) {
                    LOGGER.error((Object)("lun is null, wwn=" + wwn), 90160758787071L);
                    throw new LegoCheckedException(1073947394L);
                }
                for (Lun lun : luns) {
                    context.linkTo(dsNode, (Object)(lun.getDevSn() + lun.getLunId()), (Object)("ds2lun" + lun.getDevSn() + lun.getLunId()), new Skin[]{new LinkWithArrowSkin()});
                }
            }
        } else {
            this.linkDsAndSrcLunInRec(context, replica, ds, dsNode);
        }
    }

    private void linkDsAndSrcLunInRec(TopoBaseContext context, ProtectGroupReplica replica, DsMgrInfoBase ds, Node dsNode) {
        Set<RelicaStorageInfo> storageInfos = this.getRelicaStorageInfos(replica);
        List wwns = ds.getWwns();
        for (String wwn : wwns) {
            for (RelicaStorageInfo storageInfo : storageInfos) {
                if (!wwn.equals(storageInfo.getProtectObjectStorageWwn())) continue;
                String srcLunId = storageInfo.getSrcStorageId();
                context.linkTo(dsNode, (Object)(replica.getProductArray() + srcLunId), (Object)("ds2lun" + replica.getProductArray() + srcLunId), new Skin[]{new LinkWithArrowSkin()});
            }
        }
    }

    private Set<RelicaStorageInfo> getRelicaStorageInfos(ProtectGroupReplica replica) {
        HashSet<RelicaStorageInfo> retInfos = new HashSet<RelicaStorageInfo>();
        Set replicas = replica.getReplicas();
        for (ProtectObjectReplica poReplica : replicas) {
            retInfos.addAll(poReplica.getStorageInfos());
        }
        return retInfos;
    }

    private List<DsMgrInfoBase> getDatastores(ProtectGroup pg) {
        List<Object> dsMrgInfoList = new ArrayList<DsMgrInfoBase>();
        FixLengthProps pgRecoveryProps = new FixLengthProps(pg.getProps(), 262144);
        String mgrInfoJson = pgRecoveryProps.getValue("pgMgrInfo");
        if (VerifyUtil.isEmpty((String)mgrInfoJson)) {
            LOGGER.error((Object)"getDatastores failed: mgrInfoJson is null.", 90160758786816L);
            return dsMrgInfoList;
        }
        PgMgrInfoBase pgMgr = (PgMgrInfoBase)CommonUtil.jsonToBean((String)mgrInfoJson, PgMgrInfoBase.class);
        if (VerifyUtil.isEmpty((Object)pgMgr)) {
            LOGGER.error((Object)"getDatastores failed: pgMgr is null.", 90160758786816L);
            return dsMrgInfoList;
        }
        dsMrgInfoList = pgMgr.getDsInfos();
        return dsMrgInfoList;
    }

    protected List<Node> createVmNodes(TopoBaseContext context, Node parentNode, ProtectGroup pg) {
        ArrayList<Node> vmNodes = new ArrayList<Node>();
        String vmStyleNodeId = parentNode.getID().toString() + "_" + pg.getUuid();
        String netWorkId = "subNetwork:more:" + vmStyleNodeId;
        SubNetwork subNetwork = new SubNetwork((Object)netWorkId);
        this.initSubNetwork(subNetwork);
        Set poList = pg.getPolist();
        for (ProtectObject po : poList) {
            if (parentNode.getChildren().size() == 2) {
                context.addChild((IData)parentNode, (IData)subNetwork);
                context.setSubNetWork(true);
            }
            String vmId = po.getUuid();
            Node vmNode = (Node)context.getElementBox().getElementByID((Object)vmId);
            if (!VerifyUtil.isEmpty((Object)vmNode)) continue;
            vmNode = new GalaxVirtualElement(pg.getTemplate().getType(), po);
            if (parentNode.getChildren().size() < 2) {
                context.addChild((IData)parentNode, (IData)vmNode);
                GalaxVirtualElement node = new GalaxVirtualElement(pg.getTemplate().getType(), "vminnetwork:" + po.getUuid(), po);
                subNetwork.addChild((IData)node);
            } else {
                subNetwork.addChild((IData)vmNode);
            }
            vmNode.setLayerID((Object)"layer0");
            TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)vmNode);
            vmNodes.add(vmNode);
        }
        return vmNodes;
    }

    private void initSubNetwork(SubNetwork subNetwork) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        subNetwork.setName(resourceManager.getText("ism.drm.topo.subnetwork.seemore"));
        subNetwork.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        subNetwork.setStyle("label.color", 35020);
        subNetwork.setStyle("label.bold", false);
        subNetwork.setClient("layout", (Object)"leftright");
        subNetwork.setClient("leftGap", 11.0);
        subNetwork.setClient("topGap", 11.0);
        subNetwork.setClient("sonsGap", 1.0);
        subNetwork.setStyle("content.type", (Object)"vector");
        subNetwork.setStyle("label.position", (Object)"bottom.top");
        subNetwork.setClient("TopoModel", (Object)"StyleGroup");
        subNetwork.setStyle("vector.shape", (Object)"roundrect");
        subNetwork.setStyle("vector.fill.color", 0xFCFCFC);
        subNetwork.setStyle("background.type", (Object)"vector");
        subNetwork.setStyle("background.vector.fill.color", 0xF1F1FF);
        subNetwork.setStyle("select.style", (Object)"none");
        subNetwork.setLayerID((Object)"layer0");
        subNetwork.setToolTip(resourceManager.getText("ism.drm.topo.subnetwork.doubleclick.seemore"));
    }
}

