/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.support.dao;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.support.dao.BaseDaoAdapter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DaoAdapter
extends BaseDaoAdapter
implements IDaoAdapter {
    private static final Log LOGGER = LogFactory.getInstance(DaoAdapter.class);

    public ResourceMapping getResourceMappingByProductResourceId(String sn) {
        return this.getResourceMappingByProductRes("productResourceId", sn);
    }

    public ResourceMapping getResourceMappingByProductRes(String key, String value) {
        List<ResourceMapping> rmList = this.getResourceMappingList(key, value);
        return rmList.get(0);
    }

    public List<ResourceMapping> getResourceMappingList(String key, String value) {
        this.checkRMParamKey(key);
        String queryString = "from ResourceMapping as rm where rm." + key + " = ? ";
        List rmList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryString, new Object[]{value});
        queryString = key.startsWith("product") ? queryString.replace(".product", ".recovery") : queryString.replace(".recovery", ".product");
        List rmList2 = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryString, new Object[]{value});
        if (!VerifyUtil.isEmpty((Collection)rmList2)) {
            ArrayList<ResourceMapping> copyList = new ArrayList<ResourceMapping>();
            for (ResourceMapping rm : rmList2) {
                copyList.add(rm.getSwapResourceMapping());
            }
            if (null != rmList && !rmList.isEmpty()) {
                copyList.addAll(rmList);
            }
            return copyList;
        }
        if (!VerifyUtil.isEmpty((Collection)rmList)) {
            return rmList;
        }
        LOGGER.error((Object)"rmList is empty.");
        throw new LegoCheckedException(1073947394L);
    }

    public List<ResourceMapping> getResourceMappingByType(Integer resType) {
        if (null == resType) {
            LOGGER.error((Object)"resType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String queryString = "from ResourceMapping as rm where rm.resourceType = ? ";
        return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryString, new Object[]{resType});
    }

    private void checkRMParamKey(String key) {
        Field[] fields;
        boolean isExist = false;
        for (Field field : fields = ResourceMapping.class.getDeclaredFields()) {
            if (null == field || !field.getName().equals(key)) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            LOGGER.error((Object)("key:" + key + "is not exist in ResourceMapping."), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public List<DataStore> getDataStoresByVmUuids(Set<String> vmUuids) {
        List vmList = this.queryGalaxVMByVmUuids(vmUuids);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            LOGGER.error((Object)("query vm failed, vmUuids=" + vmUuids), 90160758787071L);
            return null;
        }
        HashSet<String> dsUrns = new HashSet<String>();
        for (GalaxVM vm : vmList) {
            if (VerifyUtil.isEmpty((String)vm.getDataStoreUrns())) continue;
            dsUrns.addAll(Arrays.asList(vm.getDataStoreUrns().split(",")));
        }
        QueryCondition dsQc = new QueryCondition("urn", (Object)dsUrns.toArray(), 8);
        ArrayList<QueryCondition> dsQcList = new ArrayList<QueryCondition>();
        dsQcList.add(dsQc);
        return CommonDAOLocator.getMoDao().findMoBy(DataStore.class, "name", true, dsQcList);
    }
}

