/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.topology;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.galax.resource.discovery.manager.FmServiceManager;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.vrg.model.AssignedVm;
import com.huawei.ism.drm.galax.topo.sdk.service.IGalaxTopoBuilder;
import com.huawei.ism.drm.galax.topology.GalaxTopoAdapter;
import com.huawei.ism.drm.galax.topology.GalaxTopoServiceManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GalaXTopoResourceHelper {
    private Log logger = LogFactory.getInstance(GalaXTopoResourceHelper.class);
    private GalaxTopoAdapter galaxTopoAdapter = GalaxTopoServiceManager.getInstance().getGalaxTopoAdapter();
    private IFmService fmService = FmServiceManager.getInstance().getFmService();
    private ICloudService cloudService = VrmManager.getInstance().getCloudService();
    private Map<String, List<String>> productFmToFcMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> productFcToVrgMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> recoveryFmToFcMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> recoveryFcToVrgMap = new HashMap<String, List<String>>();
    private Map<String, String> vrgMap = new HashMap<String, String>();
    private Map<String, String> storageMap = new HashMap<String, String>();
    private String storageRecoveryFcSn;
    private String debug = "debug";

    public GalaXTopoResourceHelper() {
        this.logger.debug((Object)"GalaXTopoResourceHelper enter.", 90160758786816L);
    }

    public GalaXTopoResourceHelper(ProtectGroup protectGroup) {
        this.logger.debug((Object)"GalaXTopoResourceHelper enter.", 90160758786816L);
        this.init(protectGroup);
    }

    public GalaxTopoAdapter getGalaxTopoAdapter() {
        return this.galaxTopoAdapter;
    }

    public void setGalaxTopoAdapter(GalaxTopoAdapter galaxTopoAdapter) {
        this.galaxTopoAdapter = galaxTopoAdapter;
    }

    public IFmService getFmService() {
        return this.fmService;
    }

    public void setFmService(IFmService fmService) {
        this.fmService = fmService;
    }

    public ICloudService getCloudService() {
        return this.cloudService;
    }

    public void setCloudService(ICloudService cloudService) {
        this.cloudService = cloudService;
    }

    public String getStorageRecoveryFcSn() {
        return this.storageRecoveryFcSn;
    }

    public Map<String, String> getStorageMap() {
        return this.storageMap;
    }

    public Map<String, List<String>> getProductFmToFcMap() {
        return this.productFmToFcMap;
    }

    public Map<String, List<String>> getProductFcToVrgMap() {
        return this.productFcToVrgMap;
    }

    public Map<String, List<String>> getRecoveryFmToFcMap() {
        return this.recoveryFmToFcMap;
    }

    public Map<String, List<String>> getRecoveryFcToVrgMap() {
        return this.recoveryFcToVrgMap;
    }

    public Map<String, String> getVrgMap() {
        return this.vrgMap;
    }

    private void init(ProtectGroup protectGroup) {
        this.logger.debug((Object)(this.debug + "init enter."), 90160758786816L);
        this.initHostProtectGroupMap(protectGroup);
    }

    private Set<String> getProductVrgSns(ProtectGroup protectGroup) {
        this.logger.debug((Object)(this.debug + "getProductVrgSns enter."), 90160758786816L);
        String protectGroupType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        IGalaxTopoBuilder topoBuilder = this.galaxTopoAdapter.getGalaxPoProvider(protectGroupType);
        if (null != topoBuilder) {
            return topoBuilder.getProductVrgSns(protectGroup);
        }
        return null;
    }

    public List<AssignedVm> getVrgAssignedVms(String vrgSn) {
        this.logger.debug((Object)(this.debug + "getVrgAssignedVms enter."), 90160758786816L);
        String sql = "from AssignedVm as vrgvm where vrgvm.vrgSn = ?";
        List listVm = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(sql, new Object[]{vrgSn});
        return listVm;
    }

    private void initHostProtectGroupMap(ProtectGroup protectGroup) {
        this.logger.debug((Object)(this.debug + "initHostProtectGroupMap enter."), 90160758786816L);
        if (!this.isCorrectProtectGroupType(protectGroup, ProtectTypeEnum.HOST_REPLICATION.getType())) {
            return;
        }
        Set<String> productVrgSns = this.getProductVrgSns(protectGroup);
        if (VerifyUtil.isEmpty(productVrgSns)) {
            return;
        }
        for (String productVrgSn : productVrgSns) {
            String productFmSn;
            String productFcSn;
            ResourceMapping vrgResMapping;
            String recoveryVrgSn;
            if (productVrgSn.equals(recoveryVrgSn = (vrgResMapping = this.getResMapping(productVrgSn)).getRecoveryResourceId())) {
                recoveryVrgSn = vrgResMapping.getProductResourceId();
            }
            this.vrgMap.put(productVrgSn, recoveryVrgSn);
            String productCloudSn = protectGroup.getPoProviderSN();
            if (productCloudSn.startsWith("Dr_Vrm")) {
                productFcSn = productCloudSn;
                productFmSn = this.checkFmByFc(protectGroup.getProductSiteId(), productFcSn);
            } else {
                String fmSn = this.checkFmByFc(protectGroup.getProductSiteId(), vrgResMapping.getProductResourceProviderId());
                productFcSn = productCloudSn.equals(fmSn) ? vrgResMapping.getProductResourceProviderId() : vrgResMapping.getRecoveryResourceProviderId();
                productFmSn = productCloudSn;
            }
            String recoveryFcSn = vrgResMapping.getRecoveryResourceProviderId();
            if (productFcSn.equals(recoveryFcSn)) {
                recoveryFcSn = vrgResMapping.getProductResourceProviderId();
            }
            this.updateFcToVrgMap(productFcSn, productVrgSn, recoveryFcSn, recoveryVrgSn);
            this.updateFmToFcMap(productFmSn, productFcSn, this.productFmToFcMap);
        }
    }

    public boolean isCorrectProtectGroupType(ProtectGroup protectGroup, String pgProtectType) {
        this.logger.debug((Object)(this.debug + "isCorrectProtectGroupType enter."), 90160758786816L);
        if (null == protectGroup) {
            this.logger.error((Object)"protectGroup is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        return null != pgProtectType && pgProtectType.equals(protectType);
    }

    private void updateFmToFcMap(String cloudSn, String fcSn, Map<String, List<String>> fmToFcMap) {
        this.logger.debug((Object)(this.debug + "updateFmToFcMap enter."), 90160758786816L);
        if (null != cloudSn && !cloudSn.startsWith("Dr_Vrm")) {
            List<String> productFcs = fmToFcMap.get(cloudSn);
            if (VerifyUtil.isEmpty(productFcs)) {
                productFcs = new ArrayList<String>();
                productFcs.add(fcSn);
                fmToFcMap.put(cloudSn, productFcs);
            } else {
                productFcs.add(fcSn);
            }
        }
    }

    private void updateFcToVrgMap(String productFcSn, String productVrgSn, String recoveryFcSn, String recoveryVrgSn) {
        this.logger.debug((Object)(this.debug + "updateFcToVrgMap enter."), 90160758786816L);
        List<String> productVrgs = this.productFcToVrgMap.get(productFcSn);
        if (VerifyUtil.isEmpty(productVrgs)) {
            productVrgs = new ArrayList<String>();
            productVrgs.add(productVrgSn);
            this.productFcToVrgMap.put(productFcSn, productVrgs);
        } else {
            productVrgs.add(productVrgSn);
        }
        List<String> recoveryVrgs = this.recoveryFcToVrgMap.get(recoveryFcSn);
        if (VerifyUtil.isEmpty(recoveryVrgs)) {
            recoveryVrgs = new ArrayList<String>();
            recoveryVrgs.add(recoveryVrgSn);
            this.recoveryFcToVrgMap.put(recoveryFcSn, recoveryVrgs);
        } else {
            recoveryVrgs.add(recoveryVrgSn);
        }
    }

    private ResourceMapping getResMapping(String productResourceId) {
        this.logger.debug((Object)(this.debug + "getResMapping enter."), 90160758786816L);
        List resMappingList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ResourceMapping where productResourceId=? or recoveryResourceId=?", new Object[]{productResourceId, productResourceId});
        if (VerifyUtil.isEmpty((Collection)resMappingList)) {
            this.logger.error((Object)("resMappingList is empty for " + productResourceId), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return (ResourceMapping)resMappingList.get(0);
    }

    public List<String> getProductFcListByFmSn(String fmSn) {
        this.logger.debug((Object)(this.debug + "getProductFcListByFmSn enter."), 90160758786816L);
        return this.productFmToFcMap.get(fmSn);
    }

    public List<String> getProductVrgListByFcSn(String fcSn) {
        this.logger.debug((Object)(this.debug + "getProductVrgListByFcSn enter."), 90160758786816L);
        return this.productFcToVrgMap.get(fcSn);
    }

    public List<String> getRecoveryVrgListByFcSn(String fcSn) {
        return this.recoveryFcToVrgMap.get(fcSn);
    }

    public String getProductFmSnByFcSn(String productFcSn) {
        this.logger.debug((Object)(this.debug + "getProductFmSnByFcSn enter."), 90160758786816L);
        for (Map.Entry<String, List<String>> entry : this.productFmToFcMap.entrySet()) {
            if (!entry.getValue().contains(productFcSn)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getRecoveryFcSnByVrgSn(String recoveryVrgSn) {
        this.logger.debug((Object)(this.debug + "getRecoveryFcSnByVrgSn enter."), 90160758786816L);
        for (Map.Entry<String, List<String>> entry : this.recoveryFcToVrgMap.entrySet()) {
            if (!entry.getValue().contains(recoveryVrgSn)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getRecoveryVrg(String productVrgSn) {
        this.logger.debug((Object)(this.debug + "getRecoveryVrg enter."), 90160758786816L);
        return this.vrgMap.get(productVrgSn);
    }

    public String checkFmByFc(String siteId, String fcSn) {
        this.logger.debug((Object)(this.debug + "checkFmByFc enter."), 90160758786816L);
        Page page = this.cloudService.pageQueryRegistedCloudsBySiteId(siteId, "name", 0, 1000, true, Long.valueOf(1L));
        String fmSn = null;
        List resultList = page.getResult();
        for (CloudInfo cd : resultList) {
            if (!cd.getDeviceSn().equals(fcSn)) continue;
            fmSn = cd.getParentResource();
            break;
        }
        return fmSn;
    }

    public VRG getVRGBySn(String vrgSn) {
        this.logger.debug((Object)(this.debug + "getVRGBySn enter."), 90160758786816L);
        VRG vrg = (VRG)CommonDAOLocator.getMoDao().getMo(VRG.class, "sn", (Object)vrgSn);
        if (null == vrg) {
            this.logger.error((Object)("Failed to find vrg:" + vrgSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return vrg;
    }

    public String configVrgStatus(String drResourceStatue, int vrgStatus) {
        this.logger.debug((Object)(this.debug + "configVrgStatus enter."), 90160758786816L);
        String configStatus = "-1";
        if (configStatus.equals(drResourceStatue)) {
            return configStatus;
        }
        configStatus = String.valueOf(vrgStatus);
        return configStatus;
    }

    public String getVrgStatus(String vrgSn, Site site) {
        this.logger.debug((Object)(this.debug + "getVrgStatus enter."), 90160758786816L);
        RestClient client = SiteUtil.initClient((Site)site);
        StringBuilder request = new StringBuilder();
        request.append("/ws/vrg/getRemoteVRGStatus?sn=").append(vrgSn);
        try {
            String json = client.getReourceCollect(request.toString());
            JSONObject object = JSONObject.fromObject((Object)json);
            String status = object.getString("status");
            return status;
        }
        catch (Exception e) {
            this.logger.error((Object)("create json object error. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
    }

    public void checkDrResource(DrResource resource) {
        this.logger.debug((Object)(this.debug + "checkDrResource enter."), 90160758786816L);
        if (VerifyUtil.isEmpty((Object)resource)) {
            this.logger.error((Object)"getDrResource null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }
}

