/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.i18n;

import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;

public class I18nMgrImpl
implements I18nMgr,
InitializingBean {
    private static final long serialVersionUID = 4885017051868053189L;
    private static final Log LOGGER = LogFactory.getInstance(I18nMgrImpl.class);
    private Map<Locale, List<ResourceBundle>> resMap = new HashMap<Locale, List<ResourceBundle>>();

    public String getString(String key, Locale local) {
        if (key == null) {
            return "";
        }
        String value = key;
        if (this.resMap == null || this.resMap.isEmpty()) {
            return value;
        }
        List<ResourceBundle> list = this.resMap.get(local);
        if (this.checkListNull(list)) {
            return value;
        }
        for (ResourceBundle resourceBundle : list) {
            try {
                if (!resourceBundle.containsKey(key)) continue;
                value = resourceBundle.getString(key.trim());
                return value;
            }
            catch (Exception e) {
                LOGGER.error((Object)String.format(Locale.ENGLISH, "Not value: %s.", ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return value;
    }

    public String getString(String key) {
        return this.getString(key, Locale.ENGLISH);
    }

    public String getString(String key, Locale local, String[] agrs) {
        String oldValue = this.getString(key, local);
        return this.judgeString(key, agrs, oldValue);
    }

    public String getString(String key, String[] agrs) {
        String oldValue = this.getString(key);
        return this.judgeString(key, agrs, oldValue);
    }

    private boolean checkListNull(List<ResourceBundle> list) {
        return VerifyUtil.isEmpty(list);
    }

    private String judgeString(String key, String[] agrs, String oldValue) {
        if (!oldValue.equalsIgnoreCase(key)) {
            try {
                oldValue = MessageFormatUtil.format((String)oldValue, (Object[])agrs);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Not value, error :%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        return oldValue;
    }

    public void afterPropertiesSet() {
        this.loadReportConf();
        List urls = AdapterUtils.getAllClassPathEntries((String)"legoi18n/*.properties");
        for (URL url : urls) {
            Locale locale;
            String fileName = url.getFile();
            int c = fileName.lastIndexOf("_");
            if (c <= 0) continue;
            if (fileName.contains("_en")) {
                locale = Locale.ENGLISH;
                this.processRes(url, locale);
                continue;
            }
            if (!fileName.contains("_zh")) continue;
            locale = Locale.SIMPLIFIED_CHINESE;
            this.processRes(url, locale);
        }
        this.loadExtraProp(new Locale("zh", "CN"), "/zh/", "commonI18n/zh/*.properties");
        this.loadExtraProp(new Locale("en"), "/en/", "commonI18n/en/*.properties");
    }

    private void loadExtraProp(Locale localType, String filter, String urlPath) {
        List<URL> urlList = AdapterUtils.getAllClassPathEntries((String)urlPath).stream().filter(url -> url.getFile().contains(filter)).collect(Collectors.toList());
        urlList.forEach(url -> this.processRes((URL)url, localType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRes(URL url, Locale locale) {
        PropertyResourceBundle resourceBundle = null;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(url.openStream());
            resourceBundle = new PropertyResourceBundle(inputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
        this.addToBundleLst(locale, resourceBundle);
    }

    private void addToBundleLst(Locale locale, ResourceBundle resourceBundle) {
        List<ResourceBundle> bundleLst = this.resMap.get(locale);
        if (bundleLst == null) {
            bundleLst = new ArrayList<ResourceBundle>();
            bundleLst.add(resourceBundle);
            this.resMap.put(locale, bundleLst);
        } else {
            bundleLst.add(resourceBundle);
            this.resMap.put(locale, bundleLst);
        }
    }

    private boolean loadReportConf() {
        String location = "reporti18n.conf";
        boolean isReportConfEnabled = false;
        try {
            ClassLoader classLoader = I18nMgrImpl.class.getClassLoader();
            if (classLoader == null) {
                LOGGER.warn((Object)"Not found classLoader", 0L);
                return isReportConfEnabled;
            }
            Enumeration<URL> url = classLoader.getResources(location);
            if (url.hasMoreElements()) {
                URL path = url.nextElement();
                Properties prop = new Properties();
                prop.load(path.openStream());
                String i18n = prop.getProperty("i18n");
                if (i18n == null) {
                    LOGGER.warn((Object)"Not found i18n conf.", 0L);
                    return isReportConfEnabled;
                }
                isReportConfEnabled = true;
                String[] res = i18n.split(",");
                Locale localeZh = Locale.SIMPLIFIED_CHINESE;
                Locale localeEn = Locale.ENGLISH;
                this.dealLsts(res, localeZh, localeEn);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)"The i18n readConfig,error :%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return isReportConfEnabled;
    }

    private void dealLsts(String[] res, Locale localeZh, Locale localeEn) {
        for (String re : res) {
            try {
                this.dealLst(re, localeZh, localeEn);
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Res:%s files loaded.", re));
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error when load i18n file,value:%s, error :%s .", new Object[]{re, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private void dealLst(String re, Locale localeZh, Locale localeEn) {
        ResourceBundle resourceBundleCn = ResourceBundle.getBundle(re, localeZh);
        this.addToBundleLst(localeZh, resourceBundleCn);
        ResourceBundle resourceBundleEn = ResourceBundle.getBundle(re, localeEn);
        this.addToBundleLst(localeEn, resourceBundleEn);
    }

    public String[] getParseParamForContainErrorID(LegoAlarm legoAlarm, Locale local) {
        String[] afterParseParam = new String[legoAlarm.getAlarmParam().length];
        int idx = 0;
        for (String param : legoAlarm.getAlarmParam()) {
            afterParseParam[idx++] = param.startsWith("lego.err.") ? this.getString(param, local) : param;
        }
        return afterParseParam;
    }
}

