/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroEnumDefine;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class CreateHypermetroGroupTask
implements Callable<HypermetroGroup> {
    private static Log logger = LogFactory.getInstance(CreateHypermetroGroupTask.class);
    private List<HypermetroPair> pairList;
    private HypermetroPairConfiguration config;
    private StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
    private LegoCheckedException exception;

    public CreateHypermetroGroupTask(List<HypermetroPair> pair, HypermetroPairConfiguration config) {
        this.pairList = pair;
        this.config = config;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public HypermetroGroup call() {
        try {
            return this.excuteWork();
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Create hyperMetroGroup failed %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            this.setException(ex);
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)"Create hyperMetroGroup failed.", (long)1073948472L, (String[])new String[]{this.config.findStoragePair().getSrcDevSN(), this.config.findStoragePair().getTgtDevSN()}, (Log)logger);
            logger.error((Object)"Create hyperMetroGroup failed, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            this.setException(legoCheckedException);
        }
        return null;
    }

    HypermetroGroup excuteWork() {
        HypermetroGroup group;
        logger.debug((Object)"CreateHyperMetroGroupTask excuteWork enter.");
        Set hypermetrocgIdSet = this.pairList.stream().filter(pair -> pair != null && !VerifyUtil.isEmpty((String)pair.getCgId()) && !"--".equals(pair.getCgId())).map(pair -> pair.getControlClusterId() + pair.getCgId()).collect(Collectors.toSet());
        if (hypermetrocgIdSet.size() > 1) {
            logger.error((Object)"The cgId size not only one:%s", new Object[]{hypermetrocgIdSet});
            throw new LegoCheckedException(-1L);
        }
        HypermetroPair hyperMetroPairWithGroup = this.pairList.stream().filter(cg -> cg != null && !VerifyUtil.isEmpty((String)cg.getCgId()) && !cg.getCgId().equals("--")).findFirst().orElse(null);
        if (hyperMetroPairWithGroup != null) {
            String srcDevSN = hyperMetroPairWithGroup.getSrcDevSN();
            String cgGroupId = hyperMetroPairWithGroup.getCgId();
            String controlClusterId = hyperMetroPairWithGroup.getControlClusterId();
            group = this.hyperProxy.getMgrByDevId(srcDevSN).queryHypermetroCGroup(srcDevSN, controlClusterId, cgGroupId);
        } else {
            HypermetroPair hypermetroPair = this.pairList.stream().findFirst().orElse(null);
            if (hypermetroPair == null) {
                logger.error((Object)"HyperMetroPair is null.");
                throw new LegoCheckedException(-1L, "HyperMetroPair is null.");
            }
            group = new HypermetroGroup();
            group.setName("RD_HYPER_CG_" + System.currentTimeMillis());
            group.setSrcDevSN(hypermetroPair.getSrcDevSN());
            group.setControlClusterId(hypermetroPair.getControlClusterId());
            group.setDomainid(hypermetroPair.getDomainid());
            group.setPriorityStationType(HypermetroEnumDefine.PRIORITY_STATION_TYPE.LOCAL.getType());
            group.setRecoveryPolicy(HypermetroEnumDefine.RECOVERY_POLICY.EXC_AND_REC_MODE_AUTO.getType());
            group = this.hyperProxy.getMgrByDevId(hypermetroPair.getSrcDevSN()).createHypermetroCGroup(group);
        }
        if (group == null) {
            logger.error((Object)"Create hyperMetro group failed.");
            throw new LegoCheckedException(-1L);
        }
        logger.debug((Object)"CreateHyperMetroGroupTask excuteWork leave.");
        return group;
    }
}

