/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class DeleteHypermetroPairTask
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(DeleteHypermetroPairTask.class);
    private StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
    private HypermetroPair pair;
    private String storageDevSn;
    private HypermetroPairConfiguration config;
    private LegoCheckedException exception;

    public DeleteHypermetroPairTask(HypermetroPair pair, HypermetroPairConfiguration config, String storageDevSn) {
        this.pair = pair;
        this.config = config;
        this.storageDevSn = storageDevSn;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public Boolean call() {
        logger.debug((Object)"DeleteHypermetroPairTask call enter");
        String pairId = this.pair.getId();
        String controlClusterId = this.pair.getControlClusterId();
        String devSn = this.pair.getSrcDevSN();
        HypermetroPair pairInDevice = null;
        try {
            if (!VerifyUtil.isEmpty((String)pairId)) {
                pairInDevice = this.hyperProxy.getMgrByDevId(devSn).queryHypermetroPair(devSn, controlClusterId, pairId);
            } else {
                logger.debug((Object)"DeleteHypermetroPairTask call pairId is empty");
                pairInDevice = null;
            }
        }
        catch (LegoCheckedException e) {
            if (IStorageHyperMetroBaseManager.isPairNotExistException((LegoCheckedException)e)) {
                pairInDevice = null;
            }
            logger.error((Object)"GetHypermetroPair error: %s", new Object[]{e.getMessage()});
            this.setException(e);
            throw e;
        }
        catch (Exception ex) {
            logger.error((Object)"GetHypermetroPair call error: %s", new Object[]{ex.getMessage()});
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("Delete hypermetro pair failed. id:%s" + this.pair.getId()), (long)1073948475L, (String[])new String[]{this.pair.getSrcDevSN(), pairId}, (Log)logger);
            logger.error((Object)legoCheckedException.getMessage(), (Throwable)legoCheckedException);
            this.setException(legoCheckedException);
            throw ex;
        }
        this.deleteHypermetroPair(pairInDevice);
        logger.debug((Object)"DeleteHypermetroPairTask call leave");
        return true;
    }

    private void deleteHypermetroPair(HypermetroPair pairInDevice) {
        logger.debug((Object)"DeleteHypermetroPair enter");
        String pairId = this.pair.getId();
        String controlClusterId = this.pair.getControlClusterId();
        String devSn = this.pair.getSrcDevSN();
        String cgId = pairInDevice != null ? pairInDevice.getCgId() : "";
        String localobjid = this.pair.getLocalobjid();
        String remoteobjid = this.pair.getRemoteobjid();
        if (StringUtils.isEmpty((CharSequence)this.pair.getId()) && StringUtils.isNotEmpty((CharSequence)localobjid) && StringUtils.isNotEmpty((CharSequence)remoteobjid)) {
            logger.debug((Object)"DeleteHypermetroPair pair is empty");
            this.deleteLun(devSn, localobjid, remoteobjid);
        }
        if (null == pairInDevice) {
            logger.info((Object)"DeleteHypermetroPair pair is null");
            return;
        }
        try {
            IStorageHyperMetroBaseManager manager = this.hyperProxy.getMgrByDevId(devSn);
            if (!VerifyUtil.isEmpty((String)cgId) && !"--".equals(cgId)) {
                logger.debug((Object)"DeleteHypermetroPair removePairsFromCg");
                this.removePairsFromCg(pairInDevice, controlClusterId, devSn, cgId);
            } else if (!manager.isAccordantExpectForRunningStatus(pairInDevice.getRunningStatus(), "PAUSE")) {
                manager.pauseHypermetroPair(devSn, controlClusterId, pairId, Boolean.valueOf(!this.storageDevSn.equals(devSn)));
            }
            manager.deleteHypermetroPair(devSn, controlClusterId, pairId, Boolean.valueOf(false));
            this.deleteLun(devSn, localobjid, remoteobjid);
            logger.debug((Object)"DeleteHypermetroPair leave");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"GetHypermetroPair error:%s", new Object[]{e.getMessage()});
            this.setException(e);
            throw e;
        }
        catch (Exception ex) {
            logger.error((Object)"GetHypermetroPair error:%s", (Throwable)ex);
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("Delete hypermetro pair failed. id:" + this.pair.getId()), (long)1073948475L, (String[])new String[]{this.pair.getSrcDevSN(), pairId}, (Log)logger);
            logger.error((Object)legoCheckedException.getMessage(), (Throwable)legoCheckedException);
            this.setException(legoCheckedException);
            throw ex;
        }
    }

    private void deleteLun(String devSn, String localobjid, String remoteobjid) {
        logger.debug((Object)"DeleteHypermetroPair deleteLun enter");
        IStorageLunBaseManager manager = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(devSn);
        if (devSn.equals(this.storageDevSn)) {
            logger.debug((Object)"DeleteHypermetroPair devSn equals storageDevSn");
            String pointDevSn = this.config.findStoragePair().getTgtDevSN();
            manager.deleteLun(pointDevSn, remoteobjid, null);
        } else {
            String pointDevSn = this.config.findStoragePair().getSrcDevSN();
            logger.debug((Object)"DeleteHypermetroPair pointDevSn:%s", new Object[]{pointDevSn});
            manager.deleteLun(pointDevSn, localobjid, null);
        }
    }

    private void removePairsFromCg(HypermetroPair pairInDevice, String controlClusterId, String devSn, String cgId) {
        logger.debug((Object)"RemovePairsFromCg cgId:%s,devSn:%s", new Object[]{cgId, devSn});
        this.hyperProxy.getMgrByDevId(devSn).pausedHypermetroCGroup(devSn, controlClusterId, cgId, Boolean.valueOf(!this.storageDevSn.equals(devSn)));
        HypermetroGroup group = new HypermetroGroup();
        group.setSrcDevSN(devSn);
        group.setId(cgId);
        group.setControlClusterId(controlClusterId);
        ArrayList<HypermetroPair> pairs = new ArrayList<HypermetroPair>();
        pairs.add(pairInDevice);
        this.hyperProxy.getMgrByDevId(devSn).removeHypermetroPairs(group, pairs);
        this.hyperProxy.getMgrByDevId(devSn).startHypermetroCGroup(devSn, controlClusterId, cgId);
        logger.debug((Object)"RemovePairsFromCg leave");
    }
}

