/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.List;
import java.util.Map;

public class HypermetroPairConfiguration {
    private static final Log LOGGER = LogFactory.getInstance(HypermetroPairConfiguration.class);
    private List<StoragePair> storagePairs;

    public HypermetroPairConfiguration(String config) {
        JSONArray jsonArray = JSONArray.fromObject((Object)config);
        this.storagePairs = JSONArray.toCollection((JSONArray)jsonArray, StoragePair.class);
    }

    public StoragePair findStoragePair() {
        return this.storagePairs.stream().findFirst().orElse(null);
    }

    public StoragePair findStoragePairBySrcPool(String srcPoolId) {
        for (StoragePair pair : this.storagePairs) {
            Map storagePools = pair.getStoragePools();
            if (!storagePools.containsKey(srcPoolId)) continue;
            return pair;
        }
        LOGGER.error((Object)"Not found storage pair, srcPool: %s.", new Object[]{srcPoolId});
        throw new LegoCheckedException(1073947725L);
    }
}

