/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.storage.hypermetro.builder.DeleteHypermetroPairTask;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.CollectionUtils;

public class HypermetroPairRollbackItem
implements IRollbackItem {
    private static final Log logger = LogFactory.getInstance(HypermetroPairRollbackItem.class);
    private List<HypermetroPair> pairList;
    private Map<Integer, List<String>> resourceIds;
    private String hyperMetroCfg;
    private String storageDevSn;
    private List<Callable<Boolean>> taskList = new ArrayList<Callable<Boolean>>();

    public HypermetroPairRollbackItem(List<HypermetroPair> pairList, String hyperMetroCfg, String storageDevSn) {
        this.pairList = pairList;
        this.hyperMetroCfg = hyperMetroCfg;
        this.storageDevSn = storageDevSn;
        this.resourceIds = new HashMap<Integer, List<String>>();
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.pairList)) {
            return "{}";
        }
        this.setResourceIds(this.pairList);
        return this.generatedRollBackParams(this.pairList);
    }

    private String generatedRollBackParams(List<HypermetroPair> pairList) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pairList", JSONArray.fromObject(pairList).toString());
        paramMap.put("storageDevSn", this.storageDevSn);
        paramMap.put("hyperMetroCfg", this.hyperMetroCfg);
        JSONArray array = new JSONArray();
        for (HypermetroPair pair : pairList) {
            JSONObject jsonObject = this.getHyperMetroPairJson(pair);
            array.add((Object)jsonObject);
        }
        JSONObject result = new JSONObject();
        result.put((Object)this.getClass().getSimpleName(), (Object)JSONObject.fromObject(paramMap).toString());
        return result.toString();
    }

    private JSONObject getHyperMetroPairJson(HypermetroPair pair) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"srcDevSN", (Object)pair.getSrcDevSN());
        jsonObject.put((Object)"cgId", (Object)pair.getCgId());
        jsonObject.put((Object)"controlClusterId", (Object)pair.getControlClusterId());
        jsonObject.put((Object)"id", (Object)pair.getId());
        jsonObject.put((Object)"localobjid", (Object)pair.getLocalobjid());
        jsonObject.put((Object)"remoteobjid", (Object)pair.getRemoteobjid());
        return jsonObject;
    }

    private void setResourceIds(List<HypermetroPair> pairList) {
        for (HypermetroPair pair : pairList) {
            if (!this.resourceIds.containsKey(0)) {
                this.resourceIds.put(0, new ArrayList());
            }
            this.resourceIds.get(0).add(pair.getSrcDevSN());
            if (!this.resourceIds.containsKey(1)) {
                this.resourceIds.put(1, new ArrayList());
            }
            this.resourceIds.get(1).add(pair.getSrcLunId());
            if (!this.resourceIds.containsKey(2)) {
                this.resourceIds.put(2, new ArrayList());
            }
            this.resourceIds.get(2).add(pair.getId());
        }
    }

    public boolean execute() {
        logger.debug((Object)"HypermetroPairRollbackItem execute enter...");
        for (HypermetroPair pair : this.pairList) {
            HypermetroPairConfiguration config = new HypermetroPairConfiguration(this.hyperMetroCfg);
            DeleteHypermetroPairTask task = new DeleteHypermetroPairTask(pair, config, this.storageDevSn);
            this.taskList.add(task);
        }
        long count = LegoBaseConfig.getInstance().getNumber("fsb_delete_pair_count", 10L);
        long timeout = LegoBaseConfig.getInstance().getNumber("fsb_delete_pair_timeout", 2147483L);
        List result = ExecutionService.batchSubmit(this.taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)((int)timeout), (int)((int)count));
        return result.size() == this.pairList.size();
    }

    public Map<Integer, List<String>> getResourceId() {
        return this.resourceIds;
    }
}

