/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.AbstractEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.task.CachedProtectThreadPool;
import com.huawei.ism.drm.storage.hypermetro.builder.CreateHypermetroGroupTask;
import com.huawei.ism.drm.storage.hypermetro.builder.CreateHypermetroPairTask;
import com.huawei.ism.drm.storage.hypermetro.builder.DeleteHypermetroPairTask;
import com.huawei.ism.drm.storage.hypermetro.builder.EnableHypermetroTask;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroGroupBuilderManager;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroGroupRollbackItem;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairRollbackItem;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroRelationRollbackItem;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroRollbackTask;
import com.huawei.ism.drm.storage.hypermetro.builder.QueryLunTask;
import com.huawei.ism.drm.storage.hypermetro.builder.StopHypermetroTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IHypermetroGroupBuilder;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hibernate.Session;

public class StorageHypermetroGroupFactory {
    private static final long SLEEP_TIME_SECOND = 10000L;
    private static final Log LOGGER = LogFactory.getInstance(StorageHypermetroGroupFactory.class);
    private static final long E_CONNECT_FAILED = 0x1007001L;
    private boolean failed = false;
    private HypermetroRollbackTask rollback = new HypermetroRollbackTask();
    private ProtectGroup protectGroupInDb;
    private List<DiskInfo> diskInfoList;
    private ProtectGroup protectGroup;

    public static StorageHypermetroGroupFactory newFactory() {
        return new StorageHypermetroGroupFactory();
    }

    public boolean deleteHypermetroGroup(ProtectGroup protectGroup) {
        LOGGER.debug((Object)"Method deleteHypermetroGroup ,groupName=%s.", new Object[]{protectGroup.getName()});
        this.protectGroup = protectGroup;
        List newStorageInfoSet = protectGroup.distinctStorageInfo();
        String storageDevSn = this.getAndcheckFromSameStorage(newStorageInfoSet);
        IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        List<HypermetroPair> allDeletedPairStack = this.queryProtectGroupPairs(protectGroup);
        Map<String, List<HypermetroPair>> pairMap = this.getHypermetroPair(allDeletedPairStack);
        List<HypermetroPair> hyperMetroPairs = this.getDeleteHypermetroPairList(pairMap);
        if (VerifyUtil.isEmpty(hyperMetroPairs)) {
            return true;
        }
        String hyperMetroCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        HypermetroRollbackTask rollbackList = new HypermetroRollbackTask();
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hyperMetroCfg);
        HypermetroRelationRollbackItem hypermetroRelationRollbackItem = new HypermetroRelationRollbackItem(protectGroup, this.getDeleteDiskSet(this.diskInfoList), storageDevSn);
        hypermetroRelationRollbackItem.execute();
        HypermetroPairRollbackItem hypermetroPairRollbackItem = new HypermetroPairRollbackItem(hyperMetroPairs, hyperMetroCfg, storageDevSn);
        rollbackList.addItem(hypermetroPairRollbackItem);
        List<HypermetroGroup> hyperMetroGroups = this.getHypermetroGroupList(pairMap, config);
        for (HypermetroGroup hypermetroGroup : hyperMetroGroups) {
            HypermetroGroupRollbackItem hypermetroGroupRollbackItem = new HypermetroGroupRollbackItem(hypermetroGroup, storageDevSn);
            rollbackList.addItem(hypermetroGroupRollbackItem);
        }
        rollbackList.execute(protectGroup);
        LOGGER.debug((Object)"Method deleteHypermetroGroup leave.");
        return true;
    }

    private List<HypermetroPair> queryProtectGroupPairs(ProtectGroup protectGroup) {
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        String hypermetroCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        String srcDevSN = config.findStoragePair().getSrcDevSN();
        String controlClusterId = config.findStoragePair().getSrcControlClusterId();
        ArrayList<HypermetroPair> pairList = new ArrayList<HypermetroPair>();
        ProtectGroupReplica replica = (ProtectGroupReplica)new ArrayList(protectGroup.getReplicaList()).get(0);
        JSONArray poReplicaJsonArray = JSONArray.fromObject((Object)replica.getPoReplicaMateData());
        if (VerifyUtil.isEmpty((Collection)poReplicaJsonArray)) {
            LOGGER.error((Object)"Param poReplicaJsonArray is empty.");
            throw new LegoCheckedException("Param poReplicaJsonArray is empty.");
        }
        JSONObject json = JSONObject.fromObject((Object)poReplicaJsonArray.get(0));
        JSONArray storageInfosArray = JSONArray.fromObject((Object)json.get("storageInfos"));
        for (Object item : storageInfosArray) {
            JSONObject storageInfo = JSONObject.fromObject(item);
            JSONObject remoteStorageReplica = JSONObject.fromObject((Object)storageInfo.get("RemoteStorageReplica"));
            String replicationPairId = remoteStorageReplica.getString("replicationPairId");
            try {
                HypermetroPair hypermetroPair = hyperProxy.getMgrByDevId(srcDevSN).queryHypermetroPair(srcDevSN, controlClusterId, replicationPairId);
                pairList.add(hypermetroPair);
            }
            catch (LegoCheckedException exception) {
                if (IStorageHyperMetroBaseManager.isPairNotExistException((LegoCheckedException)exception)) {
                    LOGGER.info((Object)"The hyper metro pair not exist, pairId: %s.", new Object[]{replicationPairId});
                    continue;
                }
                LOGGER.error((Object)"Query hyper metro pair fail, pairId: %s, e:%s.", new Object[]{replicationPairId, ExceptionUtil.getErrorMessage((Throwable)exception)});
                throw exception;
            }
        }
        return pairList;
    }

    private Set<DiskInfo> getDeleteDiskSet(List<DiskInfo> diskInfoList) {
        return Optional.ofNullable(diskInfoList).orElseGet(ArrayList::new).stream().filter(this::filterDeleteDisk).collect(Collectors.toSet());
    }

    private boolean filterDeleteDisk(DiskInfo diskInfo) {
        return !DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskInfo.getStatus()) && !DiskProtectStatusEnum.REMOVED.getStatus().equals(diskInfo.getStatus());
    }

    private List<HypermetroGroup> getHypermetroGroupList(Map<String, List<HypermetroPair>> pairMap, HypermetroPairConfiguration config) {
        ArrayList<HypermetroGroup> hypermetroGroups = new ArrayList<HypermetroGroup>();
        for (Map.Entry<String, List<HypermetroPair>> entry : pairMap.entrySet()) {
            HypermetroGroup group = new HypermetroGroup();
            List<HypermetroPair> pairList = entry.getValue();
            HypermetroPair tmpPair = pairList.iterator().next();
            group.setSrcDevSN(tmpPair.getSrcDevSN());
            group.setId(entry.getKey());
            String controlClusterId = config.findStoragePair().getSrcControlClusterId();
            group.setControlClusterId(controlClusterId);
            hypermetroGroups.add(group);
        }
        return hypermetroGroups;
    }

    private List<HypermetroPair> getDeleteHypermetroPairList(Map<String, List<HypermetroPair>> pairMap) {
        ArrayList<HypermetroPair> hypermetroPairs = new ArrayList<HypermetroPair>();
        for (Map.Entry<String, List<HypermetroPair>> entry : pairMap.entrySet()) {
            hypermetroPairs.addAll((Collection<HypermetroPair>)entry.getValue());
        }
        return hypermetroPairs;
    }

    public List<HypermetroGroup> buildHypermetroGroup(ProtectGroup protectGroup) {
        block3: {
            if (VerifyUtil.isEmpty((Object)protectGroup)) {
                LOGGER.error((Object)"Param protectGroup is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            String protectGroupId = protectGroup.getUuid();
            this.protectGroup = protectGroup;
            try {
                IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
                this.protectGroupInDb = groupServcie.getProtectGroupByID(protectGroupId, false);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Method buildHypermetroGroup error,error: %s.", new Object[]{e.getMessage()});
                if (e.getErrorCode() != 1073947394L) break block3;
                LOGGER.info((Object)"Protect Group does't exists in db. begin to create Hypermetro for protect group.");
                return this.createHypermetroGroup(protectGroup);
            }
        }
        return this.updateHypermetroGroup(protectGroup);
    }

    private List<HypermetroGroup> createHypermetroGroup(ProtectGroup protectGroup) {
        IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        HypermetroGroupBuilderManager manager = HypermetroGroupBuilderManager.getInstance();
        IHypermetroGroupBuilder builder = manager.getBuilder(protectGroup.getPoType());
        List cmdGroupList = builder.buildHypermetroGroup(protectGroup);
        String hypermetroCfg = protectGroup.getProperty("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        try {
            return this.batchCreateHypermetroGroup(protectGroup, cmdGroupList, config);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"An exception occurred while creating a consistency group:%s.", new Object[]{ex.getMessage()});
            if (!this.failed) {
                this.rollback.execute(protectGroup);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HypermetroGroup> batchCreateHypermetroGroup(ProtectGroup protectGroup, List<HypermetroGroup> groupList, HypermetroPairConfiguration config) {
        ArrayList<HypermetroGroup> results = new ArrayList<HypermetroGroup>();
        try {
            this.batchCreateReplicationGroupImp(groupList, config, results);
        }
        finally {
            if (this.failed) {
                this.rollback(protectGroup);
            }
        }
        return results;
    }

    private void batchCreateReplicationGroupImp(List<HypermetroGroup> groupList, HypermetroPairConfiguration config, List<HypermetroGroup> results) {
        long count = LegoBaseConfig.getInstance().getNumber("fsb_create_pair_count", 10L);
        long timeout = LegoBaseConfig.getInstance().getNumber("fsb_create_pair_timeout", 2147483L);
        LOGGER.info((Object)"Create hyperMetroPair timeout: %s, count: %s.", new Object[]{timeout, count});
        for (HypermetroGroup group : groupList) {
            List<Callable<HypermetroPair>> taskList = this.getHyperMetroPairTaskList(config, group);
            List result = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)((int)timeout), (int)((int)count));
            List<HypermetroPair> pairList = result.stream().filter(Objects::nonNull).collect(Collectors.toList());
            LOGGER.info((Object)"BatchCreateReplicationGroupImp pairList.");
            List<HypermetroPair> rollbackPairList = this.getNeedRollbackPairs(pairList);
            LOGGER.info((Object)"BatchCreateReplicationGroupImp rollbackPairList.");
            List newStorageInfoSet = this.protectGroup.distinctStorageInfo();
            String storageDevSn = this.getAndcheckFromSameStorage(newStorageInfoSet);
            String hypermetroCfg = (String)this.protectGroup.getProps().get("storagePoolMapping");
            if (pairList.size() == taskList.size()) {
                this.rollback.addItem(new HypermetroPairRollbackItem(rollbackPairList, hypermetroCfg, storageDevSn));
                CreateHypermetroGroupTask task = new CreateHypermetroGroupTask(result, config);
                Future hypermetroGroupFuture = ExecutionService.submit((Callable)task);
                Optional objectOptional = this.getFromFuture(hypermetroGroupFuture);
                if (!objectOptional.isPresent()) {
                    LOGGER.error((Object)"HypermetroGroup is null.");
                    throw task.getException();
                }
                HypermetroGroup createdGroup = (HypermetroGroup)objectOptional.get();
                if (this.protectGroupInDb == null) {
                    this.rollback.addItem(new HypermetroGroupRollbackItem(createdGroup, storageDevSn));
                }
                try {
                    this.addPairToGroupAndSetRelation(group, result, pairList, storageDevSn, createdGroup);
                }
                catch (Exception ex) {
                    this.rollback.addItem(new HypermetroPairRollbackItem(rollbackPairList, hypermetroCfg, storageDevSn));
                    LOGGER.error((Object)"Error occurs in createConsistentGroup,error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    throw ex;
                }
                String cgId = createdGroup.getId();
                pairList.forEach(pair -> pair.setCgId(cgId));
                createdGroup.getHypermetroPairs().addAll(pairList);
                results.add(createdGroup);
                this.saveHyperMetroPairs(storageDevSn, cgId, group.getControlClusterId());
                continue;
            }
            this.failed = true;
            LOGGER.error((Object)"Create hypermetro pair failed.");
            this.rollback.addItem(new HypermetroPairRollbackItem(rollbackPairList, hypermetroCfg, storageDevSn));
            this.checkHyperException(taskList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHyperMetroPairs(String storageDevSn, String cgId, String controlClusterId) {
        StorageUnit storageUnit;
        IStorageHyperMetroBaseManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(storageDevSn);
        ArrayList hyperMetroPairs = new ArrayList();
        if (HvsUnit.class.getName().equals(manager.getStorageType())) {
            hyperMetroPairs.addAll(manager.queryHyperMetroPairsByCg(storageDevSn, cgId));
            storageUnit = (StorageUnit)CommonDAOLocator.getMoDao().getMo(HvsUnit.class, "devSn", (Object)storageDevSn);
        } else {
            hyperMetroPairs.addAll(manager.getHypermetroPairsByCgId(storageDevSn, controlClusterId, cgId));
            storageUnit = (StorageUnit)CommonDAOLocator.getMoDao().getMo(FusionStorageUnit.class, "devSn", (Object)storageDevSn);
            hyperMetroPairs.forEach(pair -> pair.setUuid(CommUtil.combineString((String[])new String[]{"pair", storageUnit.getUuid(), UUIDGenerator.getUUID()})));
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            for (AbstractEntity hyperMetroPair : hyperMetroPairs) {
                hyperMetroPair.setParentMo((ManagedObject)storageUnit);
                hyperMetroPair.setTopMoUuid(storageUnit.getTopMoUuid());
                session.saveOrUpdate((Object)hyperMetroPair);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                LOGGER.error((Object)"Save or update hyperMetroPairs failed, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void checkHyperException(List<Callable<HypermetroPair>> taskList) {
        for (Callable<HypermetroPair> task : taskList) {
            if (!(task instanceof CreateHypermetroPairTask)) {
                return;
            }
            CreateHypermetroPairTask res = (CreateHypermetroPairTask)task;
            if (res.getException() == null) continue;
            throw res.getException();
        }
    }

    private void addPairToGroupAndSetRelation(HypermetroGroup group, List<HypermetroPair> result, List<HypermetroPair> pairList, String storageDevSn, HypermetroGroup createdGroup) {
        createdGroup.setDevSn(group.getDevSn());
        this.addHypermetroPairToCG(createdGroup, result);
        this.waitAndCheckCgStatus(createdGroup);
        this.setHyperMetroRelation(pairList, storageDevSn);
    }

    private List<Callable<HypermetroPair>> getHyperMetroPairTaskList(HypermetroPairConfiguration config, HypermetroGroup group) {
        ArrayList<Callable<HypermetroPair>> taskList = new ArrayList<Callable<HypermetroPair>>();
        for (HypermetroPair pair : group.getHypermetroPairs()) {
            CreateHypermetroPairTask task = new CreateHypermetroPairTask(pair, config);
            taskList.add(task);
        }
        return taskList;
    }

    private void setHyperMetroRelation(List<HypermetroPair> pairList, String storageDevSn) {
        LOGGER.debug((Object)"SetHyperMetroRelation enter.");
        EnableHypermetroTask enableHypermetroTask = new EnableHypermetroTask(this.protectGroup, pairList);
        Future booleanFuture = CachedProtectThreadPool.submit((Callable)enableHypermetroTask);
        Optional enableHypermetroOptional = this.getFromFuture(booleanFuture);
        if (!enableHypermetroOptional.isPresent() || !((Boolean)enableHypermetroOptional.get()).booleanValue()) {
            LOGGER.error((Object)"EnableHypermetro error.");
            throw enableHypermetroTask.getException();
        }
        this.rollback.addItem(new HypermetroRelationRollbackItem(this.protectGroup, this.getDeleteDiskSet(this.diskInfoList), storageDevSn));
        LOGGER.debug((Object)"SetHyperMetroRelation leave.");
    }

    private List<HypermetroPair> getNeedRollbackPairs(List<HypermetroPair> pairs) {
        Map<String, String> diskStatusMap = this.getDiskStatusMap();
        return pairs.stream().filter(pair -> {
            String diskStatus = (String)diskStatusMap.get(pair.getLocalobjname());
            return DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskStatus);
        }).collect(Collectors.toList());
    }

    private Map<String, String> getDiskStatusMap() {
        HashMap<String, String> diskStatusMap = new HashMap<String, String>();
        if (!VerifyUtil.isEmpty(this.diskInfoList)) {
            this.diskInfoList.forEach(disk -> {
                SubDiskInfo subDiskInfo = disk.getSubDiskInfo().stream().findFirst().orElse(new SubDiskInfo());
                diskStatusMap.put(VerifyUtil.isEmpty((String)disk.getDeviceName()) ? subDiskInfo.getName() : disk.getDeviceName(), disk.getStatus());
            });
        }
        return diskStatusMap;
    }

    private <T> Optional<T> getFromFuture(Future<T> future) {
        try {
            T result = future.get(200L, TimeUnit.MINUTES);
            return Optional.ofNullable(result);
        }
        catch (ExecutionException e1) {
            LOGGER.error((Object)"Get ExecutionException , getFromFuture error:", (Throwable)e1);
            ExceptionUtil.rethrowException((Throwable)e1, (String)"", (long)-1L, null, (Log)LOGGER);
        }
        catch (InterruptedException e2) {
            LOGGER.error((Object)"Get InterruptedException, getFromFuture error:", (Throwable)e2);
            ExceptionUtil.rethrowException((Throwable)e2, (String)"", (long)-1L, null, (Log)LOGGER);
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Get TimeoutException, getFromFuture error:", (Throwable)e);
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)LOGGER);
        }
        return Optional.empty();
    }

    private void addHypermetroPairToCG(HypermetroGroup createdGroup, List<HypermetroPair> pairs) {
        LOGGER.debug((Object)"AddHypermetroPairToCG enter.");
        String srcDevSN = createdGroup.getSrcDevSN();
        String devSn = createdGroup.getDevSn();
        String cgGroupId = createdGroup.getId();
        String controlClusterId = createdGroup.getControlClusterId();
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        IStorageHyperMetroBaseManager storageHyperMetroManager = hyperProxy.getMgrByDevId(srcDevSN);
        HypermetroGroup hypermetroGroup = storageHyperMetroManager.queryHypermetroCGroup(srcDevSN, controlClusterId, cgGroupId);
        if (!storageHyperMetroManager.isAccordantExpectForRunningStatus(hypermetroGroup.getRunningStatus(), "PAUSE")) {
            hyperProxy.getMgrByDevId(srcDevSN).pausedHypermetroCGroup(srcDevSN, controlClusterId, cgGroupId, Boolean.valueOf(!devSn.equals(srcDevSN)));
        }
        String domainId = pairs.get(0).getDomainid();
        List hypermetroPairList = hyperProxy.getMgrByDevId(srcDevSN).queryHypermetroPairs(srcDevSN, controlClusterId, domainId, new HashMap());
        Map<String, HypermetroPair> hypermetroPairMap = hypermetroPairList.stream().collect(Collectors.toMap(HypermetroPair::getId, pair -> pair, (pair1, pair2) -> pair1));
        pairs.forEach(pair -> {
            HypermetroPair currentPair = (HypermetroPair)hypermetroPairMap.get(pair.getId());
            if (storageHyperMetroManager.isAccordantExpectForRunningStatus(currentPair.getRunningStatus(), "NORMAL")) {
                hyperProxy.getMgrByDevId(devSn).pauseHypermetroPair(devSn, controlClusterId, pair.getId(), Boolean.valueOf(!devSn.equals(srcDevSN)));
            }
        });
        if (devSn.equals(srcDevSN)) {
            this.addPairsToGroup(createdGroup, pairs);
        } else {
            this.addreversePairsToGroup(createdGroup, pairs);
        }
        LOGGER.debug((Object)"AddHypermetroPairToCG leave.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPairsToGroup(HypermetroGroup createdGroup, List<HypermetroPair> pairs) {
        LOGGER.debug((Object)"AddPairsToGroup enter.");
        String devSn = createdGroup.getDevSn();
        String cgGroupId = createdGroup.getId();
        String controlClusterId = createdGroup.getControlClusterId();
        String srcDevSN = createdGroup.getSrcDevSN();
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        try {
            hyperProxy.getMgrByDevId(srcDevSN).addHypermetroPairs(createdGroup, pairs);
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() == 37100021L) {
                LOGGER.error((Object)"AddPairsToGroup error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                HypermetroGroup cloneHypermetroGroup = (HypermetroGroup)createdGroup.clone();
                cloneHypermetroGroup.setSrcDevSN(devSn);
                srcDevSN = devSn;
                hyperProxy.getMgrByDevId(devSn).addHypermetroPairs(cloneHypermetroGroup, pairs);
            }
            if (ex.getErrorCode() == 37100022L) {
                LOGGER.error((Object)"AddPairsToGroup error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw ex;
            }
        }
        finally {
            hyperProxy.getMgrByDevId(srcDevSN).startHypermetroCGroup(srcDevSN, controlClusterId, cgGroupId);
        }
        LOGGER.debug((Object)"AddPairsToGroup leave.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addreversePairsToGroup(HypermetroGroup createdGroup, List<HypermetroPair> pairs) {
        String devSn = createdGroup.getDevSn();
        String cgGroupId = createdGroup.getId();
        String controlClusterId = createdGroup.getControlClusterId();
        String srcDevSN = createdGroup.getSrcDevSN();
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        try {
            HypermetroGroup cloneHypermetroGroup = (HypermetroGroup)createdGroup.clone();
            cloneHypermetroGroup.setSrcDevSN(devSn);
            hyperProxy.getMgrByDevId(devSn).addHypermetroPairs(cloneHypermetroGroup, pairs);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 37100021L) {
                devSn = srcDevSN;
                hyperProxy.getMgrByDevId(srcDevSN).addHypermetroPairs(createdGroup, pairs);
            }
        }
        finally {
            hyperProxy.getMgrByDevId(devSn).startHypermetroCGroup(devSn, controlClusterId, cgGroupId);
        }
    }

    private void waitAndCheckCgStatus(HypermetroGroup hypermetroGroup) {
        LOGGER.debug((Object)"WaitAndCheckCgStatus enter.");
        CommonUtil.sleep((long)5000L);
        String srcDevSN = hypermetroGroup.getSrcDevSN();
        String cgGroupId = hypermetroGroup.getId();
        String controlClusterId = hypermetroGroup.getControlClusterId();
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        IStorageHyperMetroBaseManager storageHyperMetroManager = hyperProxy.getMgrByDevId(srcDevSN);
        HypermetroGroup hymGroup = storageHyperMetroManager.queryHypermetroCGroup(srcDevSN, controlClusterId, cgGroupId);
        if (storageHyperMetroManager.isAccordantExpectForRunningStatus(hymGroup.getRunningStatus(), "NORMAL")) {
            LOGGER.debug((Object)"HymGroup state is normal.");
            return;
        }
        long waitTimes = LegoBaseConfig.getInstance().getNumber("fusionStorage.hypermetro.waittimes", 56L);
        int i = 0;
        while ((long)i < waitTimes) {
            long sleepTime = i < 60 ? 10000L : (i < 61 ? 30000L : (i <= 81 ? 3600000L : 0x6DDD00L));
            CommonUtil.sleep((long)sleepTime);
            hymGroup = hyperProxy.getMgrByDevId(srcDevSN).queryHypermetroCGroup(srcDevSN, controlClusterId, cgGroupId);
            if (storageHyperMetroManager.isAccordantExpectForRunningStatus(hymGroup.getRunningStatus(), "NORMAL")) {
                LOGGER.debug((Object)"CGroup state is normal.");
                return;
            }
            if (!storageHyperMetroManager.isAccordantExpectForRunningStatus(hymGroup.getRunningStatus(), "SYNCHRONIZING")) {
                LOGGER.error((Object)"CGroup(%s) state is %s, state is not expected.", new Object[]{hypermetroGroup.getId(), hymGroup.getRunningStatus()});
                throw new LegoCheckedException(1073948474L, new String[]{hypermetroGroup.getId()});
            }
            LOGGER.debug((Object)"CGroup state is synchronnizing.");
            ++i;
        }
    }

    private void rollback(ProtectGroup pg) {
        this.rollback.execute(pg);
    }

    String getAndcheckFromSameStorage(List<ProtectObjectStorageInfo> newStorageInfoSet) {
        HashSet devSnSet = new HashSet();
        newStorageInfoSet.forEach(storageInfo -> devSnSet.add(storageInfo.getResourceProviderSN()));
        if (devSnSet.size() > 1) {
            throw new LegoCheckedException(1073948192L);
        }
        return (String)devSnSet.iterator().next();
    }

    private List<HypermetroGroup> updateHypermetroGroup(ProtectGroup protectGroup) {
        List newStorageInfoSet = protectGroup.distinctStorageInfo();
        List<String> needReleaseStorage = this.getReleaseStorage(newStorageInfoSet);
        String storageDevSn = this.getAndcheckFromSameStorage(newStorageInfoSet);
        IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        HashSet addedStorageInfoSet = new HashSet();
        HashSet deletedStorageInfoSet = new HashSet();
        HashSet protectedStorageInfoSet = new HashSet();
        HashSet<DiskInfo> releaseDiskInfo = new HashSet<DiskInfo>();
        HashSet<ProtectObjectStorageInfo> releaseStorageInfoSet = new HashSet<ProtectObjectStorageInfo>();
        this.diskInfoList.forEach(diskInfo -> {
            boolean isContainsDeleteDiskDevice;
            ProtectObjectStorageInfo storageInfo = this.getProtectObjectStorageInfo(storageDevSn, (DiskInfo)diskInfo);
            this.groupStorageInfoByDiskStatus(addedStorageInfoSet, deletedStorageInfoSet, protectedStorageInfoSet, diskInfo.getStatus(), storageInfo);
            if (needReleaseStorage.contains(diskInfo.getDeviceName())) {
                this.checkStorageInfoSet(addedStorageInfoSet, deletedStorageInfoSet, (DiskInfo)diskInfo);
                releaseDiskInfo.add((DiskInfo)diskInfo);
                releaseStorageInfoSet.add(storageInfo);
            }
            if (isContainsDeleteDiskDevice = deletedStorageInfoSet.stream().anyMatch(delStorageInfo -> delStorageInfo.getResourceName().equals(diskInfo.getDeviceName()))) {
                this.checkStorageInfoSet(addedStorageInfoSet, (Set<ProtectObjectStorageInfo>)releaseStorageInfoSet, (DiskInfo)diskInfo);
                releaseDiskInfo.add((DiskInfo)diskInfo);
            }
        });
        if (protectedStorageInfoSet.size() == releaseStorageInfoSet.size()) {
            LOGGER.error((Object)"Not support release all volumes, keep at least one.");
            throw new LegoCheckedException(1073948477L);
        }
        if (!releaseDiskInfo.isEmpty()) {
            this.releaseHypermetroGroup(releaseStorageInfoSet, releaseDiskInfo, storageDevSn);
            newStorageInfoSet.forEach(info -> info.setNeedRelease(false));
            return this.getHypermetroGroup(newStorageInfoSet);
        }
        if (!addedStorageInfoSet.isEmpty()) {
            this.createHypermetroGroup(protectGroup);
        }
        if (!deletedStorageInfoSet.isEmpty()) {
            LOGGER.info((Object)"There has some deleted storaged: %s.", new Object[]{deletedStorageInfoSet});
        }
        return this.getHypermetroGroup(newStorageInfoSet);
    }

    private void groupStorageInfoByDiskStatus(Set<ProtectObjectStorageInfo> addedStorageInfoSet, Set<ProtectObjectStorageInfo> deletedStorageInfoSet, Set<ProtectObjectStorageInfo> protectedStorageInfoSet, String diskStatus, ProtectObjectStorageInfo storageInfo) {
        if (DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskStatus) || DiskProtectStatusEnum.EXPANDED.getStatus().equals(diskStatus)) {
            protectedStorageInfoSet.add(storageInfo);
        }
        if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskStatus)) {
            addedStorageInfoSet.add(storageInfo);
        }
        if (DiskProtectStatusEnum.REMOVED.getStatus().equals(diskStatus)) {
            deletedStorageInfoSet.add(storageInfo);
        }
    }

    private ProtectObjectStorageInfo getProtectObjectStorageInfo(String storageDevSn, DiskInfo diskInfo) {
        ProtectObjectStorageInfo storageInfo = new ProtectObjectStorageInfo();
        storageInfo.setResourceProviderSN(storageDevSn);
        SubDiskInfo subDiskInfo = diskInfo.getSubDiskInfo().stream().findFirst().orElse(new SubDiskInfo());
        String subDiskInfoName = VerifyUtil.isEmpty((String)subDiskInfo.getName()) ? "" : subDiskInfo.getName();
        storageInfo.setResourceName(VerifyUtil.isEmpty((String)diskInfo.getDeviceName()) ? subDiskInfoName : diskInfo.getDeviceName());
        return storageInfo;
    }

    private void checkStorageInfoSet(Set<ProtectObjectStorageInfo> addedStorageInfoSet, Set<ProtectObjectStorageInfo> deletedOrReleaseStorageInfoSet, DiskInfo diskInfo) {
        boolean isAddedStorageExist = addedStorageInfoSet.stream().anyMatch(addStorageInfo -> addStorageInfo.getResourceName().equals(diskInfo.getDeviceName()));
        boolean isDeleteOrReleaseStorageExist = deletedOrReleaseStorageInfoSet.stream().anyMatch(deleteStorageInfo -> deleteStorageInfo.getResourceName().equals(diskInfo.getDeviceName()));
        if (isAddedStorageExist || isDeleteOrReleaseStorageExist) {
            LOGGER.error((Object)"The volume(%s) is not Support release or delete, status is %s.", new Object[]{diskInfo.getDeviceName(), diskInfo.getStatus()});
            throw new LegoCheckedException(-1L);
        }
    }

    private List<String> getReleaseStorage(List<ProtectObjectStorageInfo> newStorageInfoSet) {
        return newStorageInfoSet.stream().filter(ProtectObjectStorageInfo::isNeedRelease).map(ProtectObjectStorageInfo::getResourceName).collect(Collectors.toList());
    }

    private void releaseHypermetroGroup(Set<ProtectObjectStorageInfo> storageInfoCollection, Set<DiskInfo> releaseDiskInfo, String storageDevSn) {
        Boolean isNeedCheck = LegoBaseConfig.getInstance().getBoolean("check.storage.state", Boolean.valueOf(true));
        if (isNeedCheck.booleanValue()) {
            this.checkStorageState();
        } else {
            LOGGER.warn((Object)"The param check.storage.state is false.");
        }
        StopHypermetroTask stopHypermetroTask = new StopHypermetroTask(this.protectGroup, releaseDiskInfo, storageDevSn);
        Future booleanFuture = ExecutionService.submit((Callable)stopHypermetroTask);
        Optional optional = this.getFromFuture(booleanFuture);
        if (!optional.isPresent() || !((Boolean)optional.get()).booleanValue()) {
            LOGGER.error((Object)"EnableHypermetro error.");
            throw stopHypermetroTask.getException();
        }
        this.deleteHypermetroPair(storageInfoCollection, storageDevSn);
    }

    private void checkStorageState() {
        String hypermetroCfg = (String)this.protectGroup.getProps().get("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        String srcDevSN = config.findStoragePair().getSrcDevSN();
        String tgtDevSn = config.findStoragePair().getTgtDevSN();
        IStorageHyperMetroBaseManager srcStorageManager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(srcDevSN);
        IStorageHyperMetroBaseManager tgtStorageManager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(tgtDevSn);
        List srcControlClusters = srcStorageManager.queryControlClusters(srcDevSN);
        List tgtControlClusters = tgtStorageManager.queryControlClusters(tgtDevSn);
        if (!VerifyUtil.isEmpty((Collection)srcControlClusters) && !VerifyUtil.isEmpty((Collection)tgtControlClusters)) {
            LOGGER.debug((Object)"SrcControlClusters and tgtControlClusters all not empty, End check storage state.");
            return;
        }
        List srcRemoteDevices = srcStorageManager.queryRemoteDevices(srcDevSN);
        List tgtRemoteDevices = srcStorageManager.queryRemoteDevices(tgtDevSn);
        if (!VerifyUtil.isEmpty((Collection)srcRemoteDevices) && !VerifyUtil.isEmpty((Collection)tgtRemoteDevices) && this.checkHvsRemoteDeviceStatus(srcRemoteDevices, tgtDevSn)) {
            LOGGER.debug((Object)"HvsRemoteDevices all not empty, status normal, End check storage state.");
            return;
        }
        LOGGER.error((Object)"CheckStorageState failed! please check the connection to the storage devices!");
        throw new LegoCheckedException(0x1007001L);
    }

    private boolean checkHvsRemoteDeviceStatus(List<RemoteDevice> srcRemoteDevices, String tgtDevSn) {
        Optional<RemoteDevice> remoteDeviceOptional = srcRemoteDevices.stream().filter(device -> device.getSn().equals(tgtDevSn)).findFirst();
        if (remoteDeviceOptional.isPresent()) {
            RemoteDevice remoteDevice = remoteDeviceOptional.get();
            String healthState = remoteDevice.getHealthState();
            String runningState = remoteDevice.getRunningState();
            LOGGER.debug((Object)"Remote device healthState:%s, Remote device runningState:%s.", new Object[]{healthState, runningState});
            return healthState.equals(String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue())) && runningState.equals(String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.LINK_UP.getValue()));
        }
        LOGGER.error((Object)"Cannot find matched remote device by srcRemoteDevices!");
        return false;
    }

    private List<HypermetroPair> getAllHypermetroPair(Set<ProtectObjectStorageInfo> storageInfoCollection) {
        List lunNameList;
        if (VerifyUtil.isEmpty(storageInfoCollection)) {
            return Collections.emptyList();
        }
        String hypermetroCfg = (String)this.protectGroup.getProps().get("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        String srcDevSN = config.findStoragePair().getSrcDevSN();
        ArrayList<QueryLunTask> taskList = new ArrayList<QueryLunTask>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (ProtectObjectStorageInfo storageInfo : storageInfoCollection) {
            String lunName = storageInfo.getResourceName();
            nameList.add(lunName);
            QueryLunTask queryLunTask = new QueryLunTask(srcDevSN, lunName);
            taskList.add(queryLunTask);
        }
        long count = LegoBaseConfig.getInstance().getNumber("fsb_query_lun_count", 10L);
        long timeout = LegoBaseConfig.getInstance().getNumber("fsb_query_lun_timeout", 2147483L);
        List results = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)((int)timeout), (int)((int)count));
        if (results != null && results.size() != storageInfoCollection.size()) {
            lunNameList = results.stream().map(ManagedObject::getName).collect(Collectors.toList());
            String errorMsg = "Find lun by Name {0} from storage device failed. result Lun Name {1}.";
            errorMsg = MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{((Object)nameList).toString(), lunNameList.toString()});
            LOGGER.error((Object)errorMsg);
        }
        if (results == null) {
            LOGGER.error((Object)"Results is null.");
            throw new LegoCheckedException(0x300001L);
        }
        lunNameList = results.stream().map(ManagedObject::getName).collect(Collectors.toList());
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        String controlClusterId = config.findStoragePair().getSrcControlClusterId();
        String domainId = config.findStoragePair().getSrcHyperMetroDomainId();
        List hypermetroPairs = hyperProxy.getMgrByDevId(srcDevSN).queryHypermetroPairs(srcDevSN, controlClusterId, domainId, new HashMap());
        List<HypermetroPair> allPairStack = hypermetroPairs.stream().filter(pair -> pair.getLocalobjname().equals(pair.getRemoteobjname()) && lunNameList.contains(pair.getLocalobjname())).collect(Collectors.toList());
        return allPairStack;
    }

    public Map<String, List<HypermetroPair>> getHypermetroPair(List<HypermetroPair> pairList) {
        HashMap<String, List<HypermetroPair>> result = new HashMap<String, List<HypermetroPair>>();
        pairList.forEach(pair -> {
            String cgId = pair.getCgId();
            if (VerifyUtil.isEmpty((String)cgId) || "--".equals(cgId)) {
                return;
            }
            if (!result.containsKey(cgId)) {
                ArrayList groupedPairList = new ArrayList();
                result.put(cgId, groupedPairList);
            }
            ((List)result.get(cgId)).add(pair);
        });
        return result;
    }

    private void deleteHypermetroPair(Set<ProtectObjectStorageInfo> storageInfoCollection, String storageDevSn) {
        List<HypermetroPair> allDeletedPairStack = this.getAllHypermetroPair(storageInfoCollection);
        if (allDeletedPairStack.isEmpty()) {
            LOGGER.info((Object)"DeletePair is null.");
            return;
        }
        Map<String, List<HypermetroPair>> pairMap = this.getHypermetroPair(allDeletedPairStack);
        boolean pairInConsistentGroup = !pairMap.isEmpty();
        String hypermetroCfg = (String)this.protectGroup.getProps().get("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        this.removePairFromCg(storageDevSn, pairMap, pairInConsistentGroup, config);
        ArrayList<DeleteHypermetroPairTask> taskList = new ArrayList<DeleteHypermetroPairTask>();
        for (HypermetroPair pair : allDeletedPairStack) {
            DeleteHypermetroPairTask task = new DeleteHypermetroPairTask(pair, config, storageDevSn);
            taskList.add(task);
        }
        List result = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)200, (int)30);
        List actualResult = result.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (actualResult.size() != result.size()) {
            for (Callable callable : taskList) {
                DeleteHypermetroPairTask res = (DeleteHypermetroPairTask)callable;
                if (res.getException() == null) continue;
                throw res.getException();
            }
        }
        this.startCg(pairMap, pairInConsistentGroup, config);
    }

    private void startCg(Map<String, List<HypermetroPair>> pairMap, boolean pairInConsistentGroup, HypermetroPairConfiguration config) {
        if (pairInConsistentGroup) {
            StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
            for (Map.Entry<String, List<HypermetroPair>> entry : pairMap.entrySet()) {
                if (entry == null) continue;
                String cgId = entry.getKey();
                String srcDevSN = config.findStoragePair().getSrcDevSN();
                String controlClusterId = config.findStoragePair().getSrcControlClusterId();
                hyperProxy.getMgrByDevId(srcDevSN).startHypermetroCGroup(srcDevSN, controlClusterId, cgId);
            }
        }
    }

    private void removePairFromCg(String storageDevSn, Map<String, List<HypermetroPair>> pairMap, boolean pairInConsistentGroup, HypermetroPairConfiguration config) {
        if (pairInConsistentGroup) {
            StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
            for (Map.Entry<String, List<HypermetroPair>> entry : pairMap.entrySet()) {
                if (entry == null) continue;
                String cgId = entry.getKey();
                List<HypermetroPair> pairList = entry.getValue();
                HypermetroPair tmpPair = pairList.iterator().next();
                String srcDevSN = tmpPair.getSrcDevSN();
                String controlClusterId = config.findStoragePair().getSrcControlClusterId();
                hyperProxy.getMgrByDevId(srcDevSN).pausedHypermetroCGroup(srcDevSN, controlClusterId, cgId, Boolean.valueOf(!storageDevSn.equals(srcDevSN)));
                HypermetroGroup group = new HypermetroGroup();
                group.setSrcDevSN(srcDevSN);
                group.setId(cgId);
                group.setControlClusterId(controlClusterId);
                hyperProxy.getMgrByDevId(srcDevSN).removeHypermetroPairs(group, pairList);
            }
        }
    }

    private List<HypermetroGroup> getHypermetroGroup(List<ProtectObjectStorageInfo> storageInfoCollection) {
        List<HypermetroPair> allPairStack = this.getAllHypermetroPair(new HashSet<ProtectObjectStorageInfo>(storageInfoCollection));
        Map<String, List<HypermetroPair>> pairMap = this.getHypermetroPair(allPairStack);
        ArrayList<HypermetroGroup> hypermetroGroups = new ArrayList<HypermetroGroup>();
        if (pairMap.isEmpty()) {
            LOGGER.error((Object)"Pair is not belong cg.");
            return hypermetroGroups;
        }
        StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
        for (Map.Entry<String, List<HypermetroPair>> entry : pairMap.entrySet()) {
            if (entry == null) continue;
            String cgId = entry.getKey();
            List<HypermetroPair> pairList = entry.getValue();
            HypermetroPair tmpPair = pairList.iterator().next();
            String srcDevSN = tmpPair.getSrcDevSN();
            String controlClusterId = pairList.stream().findFirst().orElse(new HypermetroPair()).getControlClusterId();
            HypermetroGroup hypermetroGroup = hyperProxy.getMgrByDevId(srcDevSN).queryHypermetroCGroup(srcDevSN, controlClusterId, cgId);
            hypermetroGroup.setHypermetroPairs(pairList);
            hypermetroGroups.add(hypermetroGroup);
        }
        return hypermetroGroups;
    }
}

