/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroGroupRollbackItem;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairRollbackItem;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroRelationRollbackItem;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroRelation;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StorageHypermetroRollbackExecutor
implements IRollBackExecutor {
    private static final Log logger = LogFactory.getInstance(StorageHypermetroRollbackExecutor.class);
    private Map<String, Class<? extends HypermetroRelation>> classTypeMap = new HashMap<String, Class<? extends HypermetroRelation>>();

    public StorageHypermetroRollbackExecutor() {
        this.classTypeMap.put(HypermetroGroup.class.getSimpleName(), HypermetroGroup.class);
        this.classTypeMap.put(HypermetroPair.class.getSimpleName(), HypermetroPair.class);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean execute(String param) {
        if (StringUtils.isEmpty((CharSequence)param)) {
            return true;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)param);
        int resultSize = jsonArray.size();
        for (int i = 0; i < resultSize; ++i) {
            JSONObject jsonObject = JSONObject.fromObject((Object)jsonArray.getString(i));
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String className = iterator.next().toString();
                resultSize = this.executeRollbackTask(jsonObject, className) ? resultSize : --resultSize;
            }
        }
        logger.info((Object)"execute end resultSize=%s", (long)resultSize);
        return resultSize == jsonArray.size();
    }

    private boolean executeRollbackTask(JSONObject jsonObject, String className) {
        boolean resultFlag;
        try {
            if (HypermetroGroupRollbackItem.class.getSimpleName().equals(className)) {
                JSONObject resultJson = jsonObject.getJSONObject(className);
                String storageDevSn = resultJson.getString("storageDevSn");
                String groupJsonStr = resultJson.getString("group");
                JSONObject groupJson = JSONObject.fromObject((Object)groupJsonStr);
                HypermetroGroup hypermetroGroup = (HypermetroGroup)JSONObject.toBean((JSONObject)groupJson, HypermetroGroup.class);
                HypermetroGroupRollbackItem rollbackItem = new HypermetroGroupRollbackItem(hypermetroGroup, storageDevSn);
                resultFlag = rollbackItem.execute();
            } else if (HypermetroPairRollbackItem.class.getSimpleName().equals(className)) {
                JSONObject paramJson = JSONObject.fromObject((Object)jsonObject.get(className));
                JSONArray array = JSONArray.fromObject((Object)paramJson.get("pairList"));
                ArrayList<HypermetroPair> hypermetroPairs = new ArrayList<HypermetroPair>();
                for (int index = 0; index < array.size(); ++index) {
                    HypermetroPair hypermetroPair = (HypermetroPair)JSONObject.toBean((JSONObject)array.getJSONObject(index), HypermetroPair.class);
                    hypermetroPairs.add(hypermetroPair);
                }
                String storageDevSn = paramJson.getString("storageDevSn");
                String hyperMetroCfg = paramJson.getString("hyperMetroCfg");
                HypermetroPairRollbackItem pairRollbackItem = new HypermetroPairRollbackItem(hypermetroPairs, hyperMetroCfg, storageDevSn);
                resultFlag = pairRollbackItem.execute();
            } else {
                JSONObject paramJson = JSONObject.fromObject((Object)jsonObject.get(className));
                ProtectGroup protectGroup = (ProtectGroup)JSONObject.toBean((JSONObject)paramJson.getJSONObject("protectGroup"), ProtectGroup.class);
                JSONArray array = JSONArray.fromObject((Object)paramJson.get("releaseDiskInfo"));
                String storageDevSn = paramJson.getString("storageDevSn");
                HashSet<DiskInfo> diskInfoSet = new HashSet<DiskInfo>();
                for (int index = 0; index < array.size(); ++index) {
                    DiskInfo diskInfo = (DiskInfo)JSONObject.toBean((JSONObject)array.getJSONObject(index), DiskInfo.class);
                    diskInfoSet.add(diskInfo);
                }
                HypermetroRelationRollbackItem hypermetroRelationRollbackItem = new HypermetroRelationRollbackItem(protectGroup, diskInfoSet, storageDevSn);
                resultFlag = hypermetroRelationRollbackItem.execute();
            }
        }
        catch (Exception e) {
            resultFlag = false;
            logger.error((Object)"executeRollbackTask error...{}", (Throwable)e);
        }
        return resultFlag;
    }
}

