/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder.util;

import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HypermetroUtil {
    private static Log logger = LogFactory.getInstance(HypermetroUtil.class);
    private static final String VM_MGR_INFO = "vmMgrInfo";

    private HypermetroUtil() {
    }

    public static Map<String, String> getPoolMap() {
        HashMap<String, String> poolMap = new HashMap<String, String>();
        List storagePools = CommonDAOLocator.getMoDao().getAllMo(StoragePool.class);
        if (!VerifyUtil.isEmpty((Collection)storagePools)) {
            for (StoragePool pool : storagePools) {
                poolMap.put(pool.getPoolId(), pool.getName());
                poolMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        return poolMap;
    }

    public static JSONObject getPoVmMgrInfo(Map<String, String> props) {
        if (VerifyUtil.isEmpty(props) || !props.containsKey(VM_MGR_INFO)) {
            logger.info((Object)"Can not find vmMgrInfo in po's props.");
            return new JSONObject();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(props.get(VM_MGR_INFO));
        int idx = 0;
        while (props.containsKey(VM_MGR_INFO + idx)) {
            builder.append(props.get(VM_MGR_INFO + idx));
            ++idx;
        }
        return JSONObject.fromObject((Object)builder.toString());
    }
}

