/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCgCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotController;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateSnapshotCopyProcessor
extends BaseRecoveryProcessor
implements ICreateSnapshotController {
    private static final long serialVersionUID = 1244693909545666537L;

    public void endRecoveryProcessor() {
        this.saveSnapshot(this.getContextRef(), this.getChildProc());
        super.endRecoveryProcessor();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isLocalAllowedExecuteType;
        boolean isCgGroupCopy = false;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        boolean bl = isLocalAllowedExecuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType()) && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType();
        if (isLocalAllowedExecuteType || DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue() == this.getProcType()) {
            Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
            int protectType = ((RecoveryTask)recoveryTasks.stream().findAny().get()).getProtectType();
            if (protectType == ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue() || protectType == ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue()) {
                isCgGroupCopy = true;
                this.updateCgGroupSubProcessors(recoveryTasks, protectType);
            } else {
                isCgGroupCopy = false;
                this.updateSubProcessors(recoveryTasks);
            }
        }
        Set createSnapshotCopySubProcessor = this.getChildProc();
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(createSnapshotCopySubProcessor));
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        if (isCgGroupCopy) {
            this.addSnapshotSubProcessors(context, (Collection)context.getAttribute("recoveryTasks"));
        }
        this.getSnapshotIdAndWWN(context);
        return executeResult;
    }

    private void getSnapshotIdAndWWN(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            return;
        }
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (null == protectGroup) {
            return;
        }
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        if (null == policyTemplate) {
            return;
        }
        int poType = protectGroup.getPoType();
        int ptType = policyTemplate.getType();
        if (11 != poType || 2 != ptType) {
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null != contextParams && contextParams.size() != 0) {
            String[] srcLunIdArray;
            String snapshotCopyInfos = (String)contextParams.get("SnapshotCopyInfos");
            String[] snapshotCopyInfoArray = snapshotCopyInfos.split(",");
            ArrayList<String> lunIdList = new ArrayList<String>();
            ArrayList<String[]> snapshotList = new ArrayList<String[]>();
            for (String snapshot : snapshotCopyInfoArray) {
                lunIdList.add(snapshot.split("-")[0]);
                snapshotList.add(snapshot.split("-"));
            }
            RecoveryProcessBaseUtil.removeContextParamByKey((RecoveryProcessorContext)context, (String)"SnapshotCopyIds");
            RecoveryProcessBaseUtil.removeContextParamByKey((RecoveryProcessorContext)context, (String)"SnapshotCopyWWNs");
            String srcLunIds = (String)contextParams.get("SrcLunIds");
            for (String srcLunId : srcLunIdArray = srcLunIds.split(",")) {
                int index = lunIdList.indexOf(srcLunId);
                RecoveryProcessBaseUtil.addContextParam((RecoveryProcessorContext)context, (String)"SnapshotCopyIds", (String)((String[])snapshotList.get(index))[1]);
                RecoveryProcessBaseUtil.addContextParam((RecoveryProcessorContext)context, (String)"SnapshotCopyWWNs", (String)((String[])snapshotList.get(index))[2]);
            }
            RecoveryProcessBaseUtil.removeContextParamByKey((RecoveryProcessorContext)context, (String)"SnapshotCopyInfos");
        }
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks) {
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return true;
        }
        HashSet<CreateSnapshotCopySubProcessor> createSnapshotSubProcessors = new HashSet<CreateSnapshotCopySubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map lunAndHostMap = recoveryTask.getLunAndHostMap();
            if (null == lunAndHostMap || lunAndHostMap.isEmpty()) continue;
            Set entrySet = lunAndHostMap.entrySet();
            for (Map.Entry entry : entrySet) {
                CreateSnapshotCopySubProcessor processor = new CreateSnapshotCopySubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setDeviceId(recoveryTask.getSrcDeviceId());
                processor.setHostOrGroupIds(RecoveryProcessBaseUtil.getHostOrGroupIds((List)((List)entry.getValue())));
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setSrcSnapshotId(recoveryTask.getProtectId());
                if (null == recoveryTask.getSrcStorageIds()) {
                    throw new LegoCheckedException(1073947393L);
                }
                Iterator iterator = recoveryTask.getSrcStorageIds().iterator();
                if (!iterator.hasNext()) {
                    throw new LegoCheckedException(1073947393L);
                }
                String lunId = (String)iterator.next();
                processor.setLunId(lunId);
                processor.setSnapshotName(DrmStorageUtil.generateRecoverySnapshotName((String)lunId));
                createSnapshotSubProcessors.add(processor);
            }
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(createSnapshotSubProcessors);
        } else {
            this.updateSubProcessors(createSnapshotSubProcessors);
        }
        boolean result = ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private void updateCgGroupSubProcessors(Collection<RecoveryTask> recoveryTasks, int protectType) {
        HashSet<CreateSnapshotCgCopySubProcessor> subProcessors = new HashSet<CreateSnapshotCgCopySubProcessor>();
        HashSet<String> dupSet = new HashSet<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            String srcDeviceId = recoveryTask.getSrcDeviceId();
            String consistentGroupId = recoveryTask.getConsistentGroupId();
            String dupKey = srcDeviceId + "-" + consistentGroupId;
            if (dupSet.contains(dupKey)) continue;
            CreateSnapshotCgCopySubProcessor subProcessor = new CreateSnapshotCgCopySubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setDeviceId(srcDeviceId);
            subProcessor.setSrcCgGroupID(consistentGroupId);
            subProcessor.setProtectType(protectType);
            subProcessors.add(subProcessor);
            dupSet.add(dupKey);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void addSnapshotSubProcessors(RecoveryProcessorContext context, Collection<RecoveryTask> recoveryTasks) {
        Set childProc = this.getChildProc();
        HashSet newProc = new HashSet();
        for (RecoveryProcessor subProcessor : childProc) {
            if (!(subProcessor instanceof CreateSnapshotCgCopySubProcessor)) continue;
            CreateSnapshotCgCopySubProcessor cgSubProcessor = (CreateSnapshotCgCopySubProcessor)subProcessor;
            String srcDeviceId = cgSubProcessor.getDeviceId();
            String cgGroupID = cgSubProcessor.getCgGroupID();
            IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(srcDeviceId);
            if (VerifyUtil.isEmpty((String)cgGroupID)) continue;
            List snapshotList = proxy.querySnapshots(srcDeviceId, XveMOType.SNAPSHOT_CONSISTENCY_GROUP, cgGroupID);
            ExecutionService.map((Collection)snapshotList, snapshot -> {
                Integer lunId = snapshot.getSrcResourceId();
                String newName = "DRdata_" + lunId + "_" + System.currentTimeMillis();
                proxy.renameSnapshot(snapshot.getDevSn(), snapshot, newName);
                return null;
            });
            snapshotList.stream().forEach(snapshot -> {
                CreateSnapshotCopySubProcessor processor = new CreateSnapshotCopySubProcessor();
                processor.setProcName("com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor2");
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                processor.setDeviceId(snapshot.getDevSn());
                processor.setLunId(String.valueOf(snapshot.getSrcResourceId()));
                processor.setSnapshotId(snapshot.getSnapshotId());
                processor.setSnapshotName(snapshot.getSnapshotName());
                processor.setSnapshotWWN(snapshot.getWwn());
                context.setAttribute(RecoveryProcessResult.getCopySnapshotProcResultkey((String)processor.getDeviceId(), (String)processor.getLunId()), (Object)processor.getSnapshotWWN());
                processor.setContextRef(context);
                processor.beforeExecRecoveryProcessor();
                processor.updateProcessNameParams(new String[]{processor.getSnapshotName()});
                RecoveryProcessBaseUtil.addContextParam((RecoveryProcessorContext)context, (String)"SnapshotCopyInfos", (String)(snapshot.getSrcResourceId() + "-" + snapshot.getSnapshotId() + "-" + snapshot.getWwn()));
                processor.endRecoveryProcessor();
                for (RecoveryTask recoveryTask : recoveryTasks) {
                    if (!recoveryTask.getSrcStorageIds().contains(String.valueOf(snapshot.getSrcResourceId()))) continue;
                    Map lunAndHostMap = recoveryTask.getLunAndHostMap();
                    Set entrySet = lunAndHostMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        processor.setHostOrGroupIds(RecoveryProcessBaseUtil.getHostOrGroupIds((List)((List)entry.getValue())));
                    }
                }
                newProc.add(processor);
            });
        }
        childProc.addAll(newProc);
        ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopyProcessor.des");
    }

    public String getStepPosition() {
        return "CreateSnapshotCopy";
    }
}

