/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.protection.replica.StorageDiskHelper;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.impl.DrmStorageBaseServiceImpl;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;

public class CreateReplicationPairTask
implements Callable<ReplicationPair> {
    private static final Log LOGGER = LogFactory.getInstance(CreateReplicationPairTask.class);
    private ReplicationPair pair;
    private ReplicationPairConfiguration config;
    private LegoCheckedException exception;
    private StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();

    public CreateReplicationPairTask(ReplicationPair pair, ReplicationPairConfiguration config) {
        this.pair = pair;
        this.config = config;
    }

    public ReplicationPair getPair() {
        return this.pair;
    }

    public void setPair(ReplicationPair pair) {
        this.pair = pair;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setLegoCheckedException(LegoCheckedException ex) {
        this.exception = ex;
    }

    @Override
    public ReplicationPair call() {
        try {
            return this.doWork();
        }
        catch (LegoCheckedException ex) {
            this.setLegoCheckedException(ex);
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("create replication pair failed. source LUN id:" + this.pair.getSrcLunId()), (long)1073947727L, (String[])new String[]{this.pair.getSrcDevSN(), this.pair.getTgtDevSN()}, (Log)LOGGER);
            this.setLegoCheckedException(legoCheckedException);
        }
        return null;
    }

    private ReplicationPair doWork() {
        String srcDevSN = this.pair.getSrcDevSN();
        String srcLunId = this.pair.getSrcLunId();
        String tgtDevSn = this.pair.getTgtDevSN();
        List pairList = this.sraProxy.queryReplications(srcDevSN, srcLunId);
        if (pairList != null && !pairList.isEmpty()) {
            for (ReplicationPair onePair : pairList) {
                if (!srcLunId.equals(onePair.getSrcLunId()) || !tgtDevSn.equals(onePair.getTgtDevSN()) || !this.pair.getReplicationMode().equals(onePair.getReplicationMode())) continue;
                return onePair;
            }
        }
        Lun srcLun = StorageDiskHelper.getInstance().getLunById(srcDevSN, srcLunId);
        Lun tgtLun = new Lun();
        tgtLun.setDevSn(tgtDevSn);
        tgtLun.setName(srcLun.getName());
        tgtLun.setCapacity(srcLun.getCapacity());
        StoragePair storagePair = this.config.findStoragePair(srcDevSN, tgtDevSn);
        if (storagePair == null) {
            LOGGER.error((Object)"Not found storage pair, srcDevSN:%s,tgtDevSN:%s.", new Object[]{srcDevSN, tgtDevSn});
            throw new LegoCheckedException(1073947725L, new String[]{srcDevSN, tgtDevSn});
        }
        String srcPoolId = srcLun.getStoragePoolId();
        tgtLun.setStoragePoolId(storagePair.getTgtStoragePool(srcPoolId));
        tgtLun.setEncrypted(srcLun.getEncrypted());
        tgtLun.setCryptAlg(srcLun.getCryptAlg());
        DrmStorageBaseServiceImpl drmStorageService = (DrmStorageBaseServiceImpl)ServiceLocator.getInstance().getService(DrmStorageBaseServiceImpl.class);
        Lun lun = drmStorageService.queryLunByName(tgtLun.getDevSn(), tgtLun.getName());
        if (!VerifyUtil.isEmpty((Object)lun) && !VerifyUtil.isEmpty((String)lun.getName())) {
            this.pair.setSrcLunName(lun.getName());
            LOGGER.error((Object)"Target lun already exit,tgDevSN:%s,tgtLunName:%s.", new Object[]{tgtLun.getDevSn(), tgtLun.getName()});
            throw new LegoCheckedException(1073947467L, new String[]{lun.getName()});
        }
        Lun createdLun = drmStorageService.createLun(tgtLun.getDevSn(), tgtLun);
        this.pair.setLocalResType(Integer.valueOf(11));
        if (createdLun == null) {
            LOGGER.error((Object)"Create target lun failed,tgDevSN:%s,tgtLunName:%s.", new Object[]{tgtLun.getDevSn(), tgtLun.getName()});
            throw new LegoCheckedException(1073947726L, new String[]{storagePair.getTgtDevSN()});
        }
        createdLun.setTopMoUuid(this.getDevMoUuid(tgtDevSn));
        CommonDAOLocator.getMoDao().save((Object)createdLun);
        ((ReplicationTargetLun)this.pair.getRepTgtLuns().iterator().next()).setTgtLunId(createdLun.getLunId());
        return this.sraProxy.createReplicationPair(this.pair);
    }

    private String getDevMoUuid(String devSn) {
        NetworkEntity dev = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)devSn);
        return Optional.ofNullable(dev).map(ManagedObject::getUuid).orElseThrow(() -> {
            LOGGER.error((Object)"The dev entity is not existed, devSn: %s", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            return new LegoCheckedException(1073947394L);
        });
    }
}

