/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.Callable;

public class DeleteReplicationPairTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getInstance(DeleteReplicationPairTask.class);
    private static final long PAIR_NOT_EXIST_ERROR_CODE = 37120003L;
    private ReplicationPair pair;
    private int pgStatus;
    private LegoCheckedException exception;

    public DeleteReplicationPairTask(ReplicationPair pair, int pgStatus) {
        this.pair = pair;
        this.pgStatus = pgStatus;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public Boolean call() {
        String pairId = this.pair.getReplicationId();
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        ReplicationPair pairInDevice = null;
        try {
            if (!VerifyUtil.isEmpty((String)pairId)) {
                pairInDevice = sraProxy.getReplicationPair(this.pair.getSrcDevSN(), pairId);
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 37120003L) {
                pairInDevice = null;
            }
            LOGGER.error((Object)"getReplicationPair error:", (Throwable)e);
            this.setException(e);
            throw e;
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)("delete replication pair failed. source LUN id:" + this.pair.getSrcLunId()), (long)1073947728L, (String[])new String[]{this.pair.getSrcDevSN(), this.pair.getSrcLunId(), this.pair.getTgtDevSN(), this.pair.getTgtLunId(), pairId}, (Log)LOGGER);
            LOGGER.error((Object)legoCheckedException.getMessage(), (Throwable)legoCheckedException);
            this.setException(legoCheckedException);
            throw ex;
        }
        this.deleteReplicationPair(sraProxy, pairInDevice);
        return true;
    }

    private void deleteReplicationPair(StorageReplicationManagerProxy sraProxy, ReplicationPair pairInDevice) {
        String srcDevSn = this.pair.getSrcDevSN();
        String tgtDevSn = this.pair.getTgtDevSN();
        String pairId = this.pair.getReplicationId();
        String tgtLunId = this.pair.getTgtLunId();
        try {
            if (pairInDevice != null) {
                String cgId = pairInDevice.getConsistentGroupId();
                if (cgId != null) {
                    sraProxy.splitReplication(srcDevSn, tgtDevSn, cgId, true);
                    ReplicationGroup group = new ReplicationGroup();
                    group.setSrcDevSN(srcDevSn);
                    group.setTgtDevSN(tgtDevSn);
                    group.setReplicationId(cgId);
                    sraProxy.removeReplicationPair(group, Collections.singletonList(pairInDevice));
                    sraProxy.syncOnce(srcDevSn, tgtDevSn, cgId, true);
                } else {
                    sraProxy.splitReplication(srcDevSn, tgtDevSn, pairId, false);
                }
                LOGGER.warn((Object)"Delete ReplicationPair,id:%s.", new Object[]{this.pair.getReplicationId()});
                sraProxy.deleteReplicationPair(this.pair);
            }
            if (!VerifyUtil.isEmpty((String)tgtLunId)) {
                LOGGER.warn((Object)"Delete Lun:%s.", new Object[]{tgtLunId});
                StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(tgtDevSn).deleteLun(tgtDevSn, tgtLunId, (String)this.pair.getTgtLunName().orElse(null));
            }
        }
        catch (LegoCheckedException e) {
            if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == this.pgStatus) {
                LOGGER.error((Object)"something wrong during getReplicationPair");
            }
            LOGGER.error((Object)"getReplicationPair error:", (Throwable)e);
            this.setException(e);
            throw e;
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)String.format(Locale.ROOT, "Delete replication pair failed. source LUN id:%s.", this.pair.getSrcLunId()), (long)1073947728L, (String[])new String[]{this.pair.getSrcDevSN(), this.pair.getSrcLunId(), this.pair.getTgtDevSN(), this.pair.getTgtLunId(), pairId}, (Log)LOGGER);
            LOGGER.error((Object)legoCheckedException.getMessage(), (Throwable)legoCheckedException);
            this.setException(legoCheckedException);
            throw ex;
        }
    }
}

