/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.storage.replication.builder.StorageReplicationRollbackExecutor;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ReplicationRollbackTask {
    public static final int STORAGE_SN_TYPE = 0;
    public static final int STORAGE_RESOURCE_TYPE = 1;
    public static final int REPLICATION_PAIR_TYPE = 2;
    public static final int REPLICATION_GROUP_TYPE = 3;
    private static Log logger = LogFactory.getInstance(ReplicationRollbackTask.class);
    private static final String COLON = ":";
    private Stack<IRollbackItem> rollbackItems = new Stack();

    public boolean execute(ProtectGroup protectGroup) {
        if (this.rollbackItems.isEmpty()) {
            logger.info((Object)"Rollback Items is null.");
            return true;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> devSnSet = new HashSet<String>();
        HashSet<String> lunIdSet = new HashSet<String>();
        HashSet<String> pairIdSet = new HashSet<String>();
        HashSet<String> groupIdSet = new HashSet<String>();
        HashSet<String> vmUuid = new HashSet<String>();
        while (!this.rollbackItems.isEmpty()) {
            IRollbackItem item = this.rollbackItems.pop();
            sb.append(protectGroup.getStatus());
            sb.append("+");
            sb.append(item.toString());
            sb.append("->");
            Map resourceIds = item.getResourceId();
            this.setResourceIdsToSet(devSnSet, resourceIds, 0);
            this.setResourceIdsToSet(lunIdSet, resourceIds, 1);
            this.setResourceIdsToSet(pairIdSet, resourceIds, 2);
            this.setResourceIdsToSet(groupIdSet, resourceIds, 3);
        }
        StringBuilder alarmParameters = new StringBuilder();
        alarmParameters.append(devSnSet);
        alarmParameters.append(COLON);
        alarmParameters.append(lunIdSet);
        alarmParameters.append(COLON);
        alarmParameters.append(pairIdSet);
        alarmParameters.append(COLON);
        alarmParameters.append(groupIdSet);
        for (ProtectObject po : protectGroup.getPolist()) {
            vmUuid.add(po.getMoUuid());
        }
        HashMap<String, String> moUuidMap = new HashMap<String, String>();
        JSONArray moUuidArray = JSONArray.fromObject(vmUuid);
        moUuidMap.put("moUuid", moUuidArray.toString());
        JSONObject json = JSONObject.fromObject(moUuidMap);
        RollBackTaskInfo taskInfo = this.buildRollBackTaskInfo(protectGroup, sb, alarmParameters, json);
        logger.info((Object)"Submit rollback task for delete replication to back task.");
        RollBackTaskManager.getInstance().addTask(taskInfo, true);
        return true;
    }

    private RollBackTaskInfo buildRollBackTaskInfo(ProtectGroup protectGroup, StringBuilder sb, StringBuilder alarmParameters, JSONObject json) {
        RollBackTaskInfo taskInfo = new RollBackTaskInfo();
        taskInfo.setExecutor(StorageReplicationRollbackExecutor.class.getName());
        taskInfo.setExecuteParam(sb.toString());
        String taskId = UUIDGenerator.getUUID();
        taskInfo.setTaskId(taskId);
        taskInfo.setSourceUuid(taskId);
        taskInfo.setSourceDetail(json.toString());
        taskInfo.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        taskInfo.setAlarmId(Long.valueOf(52625490L));
        taskInfo.setAlarmParam(alarmParameters.toString());
        taskInfo.setTargetName(protectGroup.getName());
        return taskInfo;
    }

    private void setResourceIdsToSet(Set<String> sets, Map<Integer, List<String>> resourceIds, int key) {
        List<String> infoList = resourceIds.get(key);
        if (!VerifyUtil.isEmpty(infoList)) {
            sets.addAll(infoList);
        }
    }

    public void addItem(IRollbackItem item) {
        this.rollbackItems.push(item);
    }
}

