/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IReplicationGroupBuilder;
import com.huawei.ism.drm.storage.replication.builder.CreateReplicationPairTask;
import com.huawei.ism.drm.storage.replication.builder.DeleteReplicationPairTask;
import com.huawei.ism.drm.storage.replication.builder.ReplicationGroupBuilderManager;
import com.huawei.ism.drm.storage.replication.builder.ReplicationGroupRollbackItem;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairRollbackItem;
import com.huawei.ism.drm.storage.replication.builder.ReplicationRollbackTask;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class StorageReplicationGroupFactory {
    private static Log logger = LogFactory.getInstance(StorageReplicationGroupFactory.class);
    private boolean failed = false;
    private ReplicationRollbackTask rollback = new ReplicationRollbackTask();
    private ProtectGroup protectGroupInDb;
    private List<DiskInfo> diskInfoList;

    private StorageReplicationGroupFactory() {
    }

    public static StorageReplicationGroupFactory newFactory() {
        return new StorageReplicationGroupFactory();
    }

    public boolean deleteReplicationGroup(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            String errorMsg = "Protect Group is null.";
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        ArrayList<ProtectObjectStorageInfo> protectObjectStorageInfoSet = new ArrayList<ProtectObjectStorageInfo>();
        IProtectGroupBaseService groupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        this.diskInfoList = groupService.queryDiskInfo(protectGroup);
        ProtectGroupUtil.logDiskInfo((String)protectGroup.getName(), this.diskInfoList);
        for (DiskInfo diskInfo : this.diskInfoList) {
            if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskInfo.getStatus())) continue;
            ProtectObjectStorageInfo protectObjectStorageInfo = new ProtectObjectStorageInfo();
            protectObjectStorageInfo.setResourceProviderSN(diskInfo.getDevSn());
            protectObjectStorageInfo.setResourceId(diskInfo.getResourceId());
            protectObjectStorageInfoSet.add(protectObjectStorageInfo);
        }
        Stack<List<ReplicationPair>> pairStack = this.retrieveAllReplicationPair(protectObjectStorageInfoSet);
        LinkedList<Object> rollbackItemQueue = new LinkedList<Object>();
        while (!pairStack.isEmpty()) {
            List<ReplicationPair> oneList = pairStack.pop();
            Map<String, List<ReplicationPair>> pairMap = this.groupReplicationPair(oneList);
            if (pairMap.isEmpty()) {
                rollbackItemQueue.add(new ReplicationPairRollbackItem(oneList));
                continue;
            }
            for (Map.Entry<String, List<ReplicationPair>> entry : pairMap.entrySet()) {
                if (entry == null) continue;
                String cgId = entry.getKey();
                List<ReplicationPair> pairList = entry.getValue();
                ReplicationPair tmpPair = pairList.iterator().next();
                String srcDevSn = tmpPair.getSrcDevSN();
                String tgtDevSn = tmpPair.getTgtDevSN();
                ReplicationGroup group = this.getReplicationGroup(srcDevSn, tgtDevSn, cgId);
                rollbackItemQueue.add(new ReplicationPairRollbackItem(pairList));
                rollbackItemQueue.add(new ReplicationGroupRollbackItem(group));
            }
        }
        ReplicationRollbackTask rollbackTask = new ReplicationRollbackTask();
        while (!rollbackItemQueue.isEmpty()) {
            rollbackTask.addItem((IRollbackItem)rollbackItemQueue.poll());
        }
        return rollbackTask.execute(protectGroup);
    }

    public List<ReplicationGroup> buildReplicationGroup(ProtectGroup protectGroup) {
        block4: {
            if (protectGroup == null) {
                String errorMsg = "Protect Group is null.";
                logger.error((Object)errorMsg);
                throw new LegoCheckedException(1073947393L, errorMsg);
            }
            String protectGroupId = protectGroup.getUuid();
            try {
                IProtectGroupBaseService groupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
                this.protectGroupInDb = groupService.getProtectGroupByID(protectGroupId, false);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1073947394L) break block4;
                this.handleException(protectGroup);
                logger.info((Object)"Protect Group doesn't exists in db, begin to create replication for protect group.");
                return this.createReplicationGroup(protectGroup);
            }
        }
        if (this.protectGroupInDb == null) {
            logger.error((Object)"Protect group does not exists in db.");
            throw new LegoCheckedException(1073947394L);
        }
        return this.updateReplicationGroup(protectGroup);
    }

    private void handleException(ProtectGroup protectGroup) {
        Map<String, List<String>> deviceStorageMap = this.getReplicaMap();
        List allStorageInfoList = protectGroup.distinctStorageInfo();
        for (Map.Entry<String, List<String>> entry : deviceStorageMap.entrySet()) {
            for (ProtectObjectStorageInfo addedStorageInfo : allStorageInfoList) {
                String[] entryKey = entry.getKey().split("@");
                if (!entryKey[1].equals(addedStorageInfo.getResourceProviderSN()) || !entry.getValue().contains(addedStorageInfo.getResourceId())) continue;
                logger.error((Object)"Delete replication pairs failed, pair info is: %s.", new Object[]{addedStorageInfo.getDeviceName()});
                throw new LegoCheckedException(1073947693L, new String[]{entryKey[0]});
            }
        }
    }

    private List<ReplicationGroup> createReplicationGroup(ProtectGroup protectGroup) {
        List<ReplicationGroup> results;
        IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        ReplicationGroupBuilderManager manager = ReplicationGroupBuilderManager.getInstance();
        IReplicationGroupBuilder builder = manager.getBuilder(protectGroup.getPoType());
        List groups = builder.buildReplicationGroup(protectGroup);
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        ReplicationPairConfiguration config = new ReplicationPairConfiguration(replicationCfg);
        try {
            results = this.createReplicationGroup(protectGroup, groups, config);
        }
        catch (Exception ex) {
            logger.error((Object)"An exception occurred while creating consistency group, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            if (!this.isReProtectProcess(protectGroup)) {
                this.rollback.execute(protectGroup);
            }
            throw ex;
        }
        return results;
    }

    private List<ReplicationGroup> createReplicationGroup(ProtectGroup protectGroup, List<ReplicationGroup> groupList, ReplicationPairConfiguration config) {
        ArrayList<ReplicationGroup> cmdGroupList = new ArrayList<ReplicationGroup>();
        for (ReplicationGroup tempGroup : groupList) {
            List tempPairList = tempGroup.getReplicationPairs();
            if (tempPairList == null || tempPairList.isEmpty()) continue;
            for (StoragePair storagePair : config.findStoragePair(tempGroup.getSrcDevSN())) {
                ArrayList<ReplicationPair> pairList = new ArrayList<ReplicationPair>();
                for (ReplicationPair tempPair : tempPairList) {
                    if (!tempPair.getSrcDevSN().equals(storagePair.getSrcDevSN())) continue;
                    ReplicationPair pair = (ReplicationPair)tempPair.clone();
                    if (ProtectGroupUtil.isSyncReplicaOfSmallLun((ProtectGroup)protectGroup)) {
                        pair.setReplicationMode(Integer.valueOf(1));
                    } else {
                        pair.setReplicationMode(Integer.valueOf(2));
                    }
                    ArrayList<ReplicationTargetLun> targetLunList = new ArrayList<ReplicationTargetLun>();
                    ReplicationTargetLun targetLun = new ReplicationTargetLun();
                    targetLunList.add(targetLun);
                    targetLun.setTgtDevSN(storagePair.getTgtDevSN());
                    pair.setRepTgtLuns(targetLunList);
                    pairList.add(pair);
                }
                ReplicationGroup group = new ReplicationGroup();
                group.setSyncMode(Integer.valueOf(protectGroup.getTemplate().getType() == 39 ? 1 : 2));
                group.setReplicationPairs(pairList);
                cmdGroupList.add(group);
            }
        }
        return this.batchCreateReplicationGroup(protectGroup, cmdGroupList, config);
    }

    private Set<ProtectObjectReplica> getReplicas(String poReplicaMateData) {
        HashSet<ProtectObjectReplica> replicas = new HashSet<ProtectObjectReplica>();
        if (!VerifyUtil.isEmpty((String)poReplicaMateData)) {
            JSONArray poReplicaJsonArray = JSONArray.fromObject((Object)poReplicaMateData);
            for (Object object : poReplicaJsonArray) {
                JSONObject json = JSONObject.fromObject(object);
                ProtectObjectReplica poReplica = ProtectObjectReplica.toBean((JSONObject)json);
                replicas.add(poReplica);
            }
        }
        return replicas;
    }

    public Map<String, List<ReplicationPair>> groupReplicationPair(List<ReplicationPair> pairList) {
        HashMap<String, List<ReplicationPair>> result = new HashMap<String, List<ReplicationPair>>();
        for (ReplicationPair onePair : pairList) {
            String consistentGroupId = onePair.getConsistentGroupId();
            if (consistentGroupId == null) continue;
            if (!result.containsKey(consistentGroupId)) {
                ArrayList groupedPairList = new ArrayList();
                result.put(consistentGroupId, groupedPairList);
            }
            ((List)result.get(consistentGroupId)).add(onePair);
        }
        return result;
    }

    public Map<String, List<String>> getReplicaMap() {
        List poReplicaMateData = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select name , poReplicaMateData from ProtectGroupReplica where REPLICATYPE = 2", new Object[0]);
        HashMap<String, Set<ProtectObjectReplica>> poReplicaMap = new HashMap<String, Set<ProtectObjectReplica>>();
        for (Object[] str : poReplicaMateData) {
            String replicaName = str[0].toString();
            int start = replicaName.indexOf("-");
            int end = replicaName.lastIndexOf("-");
            if (start < 0 || end < 0 || start == end) {
                logger.error((Object)"ReplicaName is invalid.");
                throw new LegoCheckedException(-1L);
            }
            poReplicaMap.put(replicaName.substring(start + 1, end), this.getReplicas(str[1].toString()));
        }
        HashMap<String, List<String>> deviceStorageMap = new HashMap<String, List<String>>();
        for (Map.Entry params : poReplicaMap.entrySet()) {
            for (ProtectObjectReplica poReplica : (Set)params.getValue()) {
                for (RelicaStorageInfo replica : poReplica.getStorageInfos()) {
                    String srcStorageIdAndName = CommUtil.combineStringBySign((String[])new String[]{(String)params.getKey(), replica.getSrcStorageProviderSN()});
                    CommUtil.addToMap(deviceStorageMap, (String)srcStorageIdAndName, (Object)replica.getSrcStorageId());
                }
            }
        }
        return deviceStorageMap;
    }

    private List<ReplicationGroup> updateReplicationGroup(ProtectGroup protectGroup) {
        String recoveryPlanStatus;
        IProtectGroupBaseService groupServcie = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        ProtectGroupUtil.logDiskInfo((String)protectGroup.getName(), this.diskInfoList);
        Collection<Object> addedStorageInfoSet = new ArrayList();
        ArrayList<ProtectObjectStorageInfo> deletedStorageInfoSet = new ArrayList();
        Map<String, List<String>> deviceStorageMap = this.getReplicaMap();
        for (DiskInfo diskInfo : this.diskInfoList) {
            String diskStatus = diskInfo.getStatus();
            ProtectObjectStorageInfo protectObjectStorageInfo = new ProtectObjectStorageInfo();
            protectObjectStorageInfo.setResourceProviderSN(diskInfo.getDevSn());
            protectObjectStorageInfo.setResourceId(diskInfo.getResourceId());
            if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskStatus)) {
                addedStorageInfoSet.add(protectObjectStorageInfo);
                continue;
            }
            if (!DiskProtectStatusEnum.REMOVED.getStatus().equals(diskStatus)) continue;
            deletedStorageInfoSet.add(protectObjectStorageInfo);
        }
        if (this.isReProtectProcess(protectGroup)) {
            logger.info((Object)"This is a reprotect processor. PG=%s.", new Object[]{protectGroup.getName()});
            addedStorageInfoSet = Collections.emptySet();
            deletedStorageInfoSet = Collections.emptySet();
        }
        if (!addedStorageInfoSet.isEmpty()) {
            for (Map.Entry entry : deviceStorageMap.entrySet()) {
                for (ProtectObjectStorageInfo protectObjectStorageInfo : addedStorageInfoSet) {
                    String[] entryKey = ((String)entry.getKey()).split("@");
                    if (!entryKey[1].equals(protectObjectStorageInfo.getResourceProviderSN()) || !((List)entry.getValue()).contains(protectObjectStorageInfo.getResourceId())) continue;
                    logger.error((Object)"Delete replication pairs failed, pair info is: %s.", new Object[]{protectObjectStorageInfo.getDeviceName()});
                    throw new LegoCheckedException(1073947693L, new String[]{entryKey[0]});
                }
            }
            this.createReplicationGroup(protectGroup);
        }
        if (VerifyUtil.isEmpty((String)(recoveryPlanStatus = (String)protectGroup.getProps().get("last_recovery_plan_execute_type")))) {
            recoveryPlanStatus = String.valueOf(DrmEnumDefine.RecoveryPlanStatusE.READY.getValue());
        }
        if (!deletedStorageInfoSet.isEmpty()) {
            this.deleteReplicationPair(deletedStorageInfoSet, NumberUtil.convertToInteger((Object)recoveryPlanStatus));
        }
        List list = protectGroup.distinctStorageInfo();
        return this.getReplicationGroup(list);
    }

    private List<ReplicationGroup> getReplicationGroup(Collection<ProtectObjectStorageInfo> storageInfoCollection) {
        Stack<List<ReplicationPair>> allFinalPairStack = this.retrieveAllReplicationPair(storageInfoCollection);
        HashMap<String, List<ReplicationPair>> pairMap = new HashMap<String, List<ReplicationPair>>();
        while (!allFinalPairStack.isEmpty()) {
            List<ReplicationPair> oneList = allFinalPairStack.pop();
            Map<String, List<ReplicationPair>> consPairMap = this.groupReplicationPair(oneList);
            for (Map.Entry<String, List<ReplicationPair>> entry : consPairMap.entrySet()) {
                String consistentGroupId = entry.getKey();
                List<ReplicationPair> pairList = entry.getValue();
                if (pairMap.containsKey(consistentGroupId)) {
                    ((List)pairMap.get(consistentGroupId)).addAll(pairList);
                    continue;
                }
                pairMap.put(consistentGroupId, pairList);
            }
        }
        ArrayList<ReplicationGroup> results = new ArrayList<ReplicationGroup>();
        for (Map.Entry entry : pairMap.entrySet()) {
            String tgtDevSn;
            if (entry == null) continue;
            String consistentGroupId = (String)entry.getKey();
            List pairList = (List)entry.getValue();
            ReplicationPair anyPair = (ReplicationPair)pairList.iterator().next();
            String srcDevSn = anyPair.getSrcDevSN();
            ReplicationGroup group = this.getReplicationGroup(srcDevSn, tgtDevSn = anyPair.getTgtDevSN(), consistentGroupId);
            if (group == null) {
                logger.error((Object)"Create replication group failed.");
                throw new LegoCheckedException(-1L);
            }
            group.setReplicationPairs(pairList);
            results.add(group);
        }
        return results;
    }

    private ReplicationGroup getReplicationGroup(String srcDevSn, String tgtDevSn, String groupId) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        ReplicationGroup group = sraProxy.getReplicationGroup(srcDevSn, groupId);
        return group;
    }

    private void deleteReplicationPair(Collection<ProtectObjectStorageInfo> deletedStorageInfoSet, Integer recoveryPlanStatus) {
        Stack<List<ReplicationPair>> allDeletedPairStack = this.retrieveAllReplicationPair(deletedStorageInfoSet);
        while (!allDeletedPairStack.isEmpty()) {
            ReplicationPairRollbackItem rb;
            boolean isPairInConsistentGroup;
            List<ReplicationPair> pairList = allDeletedPairStack.pop();
            Map<String, List<ReplicationPair>> pairMap = this.groupReplicationPair(pairList);
            boolean bl = isPairInConsistentGroup = !pairMap.isEmpty();
            if (isPairInConsistentGroup) {
                StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
                pairMap.forEach((cgId, onePairList) -> {
                    ReplicationPair tmpPair = (ReplicationPair)onePairList.iterator().next();
                    String srcDevSn = tmpPair.getSrcDevSN();
                    String tgtDevSn = tmpPair.getTgtDevSN();
                    sraProxy.splitReplication(srcDevSn, tgtDevSn, cgId, true);
                    ReplicationGroup group = new ReplicationGroup();
                    group.setSrcDevSN(srcDevSn);
                    group.setTgtDevSN(tgtDevSn);
                    group.setReplicationId(cgId);
                    sraProxy.removeReplicationPair(group, onePairList);
                });
            }
            if (!(rb = new ReplicationPairRollbackItem(pairList, recoveryPlanStatus)).execute()) {
                List pairInfo = pairList.stream().map(onePair -> onePair.getReplicationId() + "@" + onePair.getDevSn()).collect(Collectors.toList());
                logger.error((Object)"Delete replication pairs failed, pair info is:%s.", new Object[]{pairInfo});
                List<Callable<Boolean>> resultTasks = rb.getTaskList();
                for (Callable<Boolean> resultTask : resultTasks) {
                    DeleteReplicationPairTask res = (DeleteReplicationPairTask)resultTask;
                    if (res.getException() == null) continue;
                    throw res.getException();
                }
                throw new LegoCheckedException(-1L);
            }
            if (!isPairInConsistentGroup) continue;
            StorageReplicationGroupFactory.restartConsistencyGroupAndSync(pairMap);
        }
    }

    private static void restartConsistencyGroupAndSync(Map<String, List<ReplicationPair>> pairMap) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        for (Map.Entry<String, List<ReplicationPair>> entry : pairMap.entrySet()) {
            if (entry == null) continue;
            String cgId = entry.getKey();
            List<ReplicationPair> onePairList = entry.getValue();
            ReplicationPair tmpPair = onePairList.iterator().next();
            String srcDevSn = tmpPair.getSrcDevSN();
            String tgtDevSn = tmpPair.getTgtDevSN();
            sraProxy.syncOnce(srcDevSn, tgtDevSn, cgId, true);
        }
    }

    public void retrieveAllReplicationPair(Stack<List<ReplicationPair>> allPairStack, String srcDevSn, List<String> srcLunIdList) {
        List<List<ReplicationPair>> allPairList = this.getReplicationPair(srcDevSn, srcLunIdList);
        if (VerifyUtil.isEmpty(allPairList)) {
            return;
        }
        for (List<ReplicationPair> onePairList : allPairList) {
            allPairStack.push(onePairList);
            ArrayList<String> tgtLunIdList = new ArrayList<String>();
            String tgtDevSn = onePairList.iterator().next().getTgtDevSN();
            if (VerifyUtil.isEmpty((String)tgtDevSn)) {
                logger.error((Object)"The tgtDevSN is null.");
                throw new LegoCheckedException(33561618L);
            }
            for (ReplicationPair onePair : onePairList) {
                tgtLunIdList.add(onePair.getTgtLunId());
            }
            this.retrieveAllReplicationPair(allPairStack, tgtDevSn, tgtLunIdList);
        }
    }

    private Stack<List<ReplicationPair>> retrieveAllReplicationPair(Collection<ProtectObjectStorageInfo> storageInfoSet) {
        if (VerifyUtil.isEmpty(storageInfoSet)) {
            return new Stack<List<ReplicationPair>>();
        }
        String srcDevSN = storageInfoSet.iterator().next().getResourceProviderSN();
        ArrayList<Callable<Lun>> taskList = new ArrayList<Callable<Lun>>();
        ArrayList<String> idList = new ArrayList<String>();
        for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
            String srcLunId = storageInfo.getResourceId();
            idList.add(srcLunId);
            taskList.add(this.createQueryLunTask(srcDevSN, srcLunId));
        }
        List results = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)180, (int)30);
        if (results != null && results.size() != storageInfoSet.size()) {
            List resultLunIdList = results.stream().map(Lun::getLunId).collect(Collectors.toList());
            logger.error((Object)"Retrieve LUN by id %s from storage device failed, result Lun id %s.", new Object[]{idList, resultLunIdList});
        }
        if (results == null) {
            logger.error((Object)"Results is null.");
            throw new LegoCheckedException(0x300001L);
        }
        List<String> lunIdList = results.stream().map(Lun::getLunId).collect(Collectors.toList());
        Stack<List<ReplicationPair>> allPairStack = new Stack<List<ReplicationPair>>();
        this.retrieveAllReplicationPair(allPairStack, srcDevSN, lunIdList);
        return allPairStack;
    }

    private List<List<ReplicationPair>> getReplicationPair(String srcDevSn, List<String> srcLunIdList) {
        ArrayList<List<ReplicationPair>> results = new ArrayList<List<ReplicationPair>>();
        for (String lunId : srcLunIdList) {
            StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
            List pairList = sraProxy.queryReplications(srcDevSn, lunId);
            if (VerifyUtil.isEmpty(pairList = pairList.stream().filter(ReplicationRelation::getIsPrimary).collect(Collectors.toList()))) continue;
            results.add(pairList);
        }
        return results;
    }

    private Callable<Lun> createQueryLunTask(String devSn, String lunId) {
        Callable<Lun> queryLunTask = () -> {
            StorageLunManagerProxy lunManagerProxy = StorageLunManagerProxy.getInstance();
            Lun lun = lunManagerProxy.getLunById(devSn, lunId);
            if (lun == null) {
                logger.error((Object)"Param lun is null.");
                throw new LegoCheckedException(1073947394L);
            }
            return lun;
        };
        return queryLunTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReplicationGroup> batchCreateReplicationGroup(ProtectGroup protectGroup, List<ReplicationGroup> groupList, ReplicationPairConfiguration config) {
        ArrayList<ReplicationGroup> results = new ArrayList<ReplicationGroup>();
        try {
            this.batchCreateReplicationGroupImp(groupList, config, results);
        }
        catch (Throwable throwable) {
            try {
                HashSet allStorageResourceSet = new HashSet();
                protectGroup.getPolist().forEach(po -> po.getUsedStorageResourceSet().forEach(storageResource -> allStorageResourceSet.add(storageResource)));
                if (allStorageResourceSet.size() > 0) {
                    String devSn = ((ProtectObjectStorageInfo)allStorageResourceSet.stream().findFirst().get()).getResourceProviderSN();
                    List lunIds = allStorageResourceSet.stream().map(storageResource -> storageResource.getResourceId()).collect(Collectors.toList());
                    ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).queryReplicationPairsByMasterLunId(devSn, lunIds, true);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Something wrong during queryReplicationPairsByMasterLunId, error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            if (!this.failed) {
                List<ReplicationGroup> cascadeGroupList = this.createCascadeReplicationGroup(protectGroup, results, config);
                if (!VerifyUtil.isEmpty(cascadeGroupList)) {
                    results.addAll(cascadeGroupList);
                }
            } else if (!this.isReProtectProcess(protectGroup)) {
                this.rollback(protectGroup);
            }
            throw throwable;
        }
        try {
            HashSet allStorageResourceSet = new HashSet();
            protectGroup.getPolist().forEach(po -> po.getUsedStorageResourceSet().forEach(storageResource -> allStorageResourceSet.add(storageResource)));
            if (allStorageResourceSet.size() > 0) {
                String devSn = ((ProtectObjectStorageInfo)allStorageResourceSet.stream().findFirst().get()).getResourceProviderSN();
                List lunIds = allStorageResourceSet.stream().map(storageResource -> storageResource.getResourceId()).collect(Collectors.toList());
                ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).queryReplicationPairsByMasterLunId(devSn, lunIds, true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Something wrong during queryReplicationPairsByMasterLunId, error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (!this.failed) {
            List<ReplicationGroup> cascadeGroupList = this.createCascadeReplicationGroup(protectGroup, results, config);
            if (!VerifyUtil.isEmpty(cascadeGroupList)) {
                results.addAll(cascadeGroupList);
            }
        } else if (!this.isReProtectProcess(protectGroup)) {
            this.rollback(protectGroup);
        }
        return results;
    }

    private void batchCreateReplicationGroupImp(List<ReplicationGroup> groupList, ReplicationPairConfiguration config, List<ReplicationGroup> results) {
        HashMap diskStatusMap = new HashMap();
        if (!VerifyUtil.isEmpty(this.diskInfoList)) {
            this.diskInfoList.forEach(disk -> diskStatusMap.put(CommUtil.combineString((String[])new String[]{disk.getDevSn(), disk.getResourceId()}), disk.getStatus()));
        }
        long timeout = LegoBaseConfig.getInstance().getNumber("fsb_create_pair_timeout", 200L);
        long count = LegoBaseConfig.getInstance().getNumber("fsb_create_pair_count", 30L);
        logger.info((Object)"The fsb create pair timeout: %s, count: %s.", new Object[]{timeout, count});
        for (ReplicationGroup group : groupList) {
            ArrayList<Callable<ReplicationPair>> taskList = new ArrayList<Callable<ReplicationPair>>();
            for (ReplicationPair pair2 : group.getReplicationPairs()) {
                CreateReplicationPairTask task = new CreateReplicationPairTask(pair2, config);
                taskList.add(task);
            }
            List result = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)((int)timeout), (int)((int)count));
            List result1 = result.stream().filter(Objects::nonNull).collect(Collectors.toList());
            List<ReplicationPair> rollbackPairList = group.getReplicationPairs().stream().filter(pair -> {
                String diskStatus = (String)diskStatusMap.get(CommUtil.combineString((String[])new String[]{pair.getSrcDevSN(), pair.getSrcLunId()}));
                return DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskStatus);
            }).collect(Collectors.toList());
            if (result1.size() == taskList.size()) {
                this.rollback.addItem(new ReplicationPairRollbackItem(rollbackPairList));
                ReplicationGroup createdGroup = this.createConsistentGroup(result);
                if (this.protectGroupInDb == null) {
                    this.rollback.addItem(new ReplicationGroupRollbackItem(createdGroup));
                }
                try {
                    this.addReplicationPairToCG(createdGroup, result);
                }
                catch (Exception ex) {
                    logger.error((Object)"Error occurs in createConsistentGroup, error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    this.failed = true;
                    throw ex;
                }
                results.add(createdGroup);
                continue;
            }
            this.dealFailForCreateReplicationPair(taskList, rollbackPairList);
        }
    }

    private void dealFailForCreateReplicationPair(List<Callable<ReplicationPair>> taskList, List<ReplicationPair> rollbackPairList) {
        this.failed = true;
        logger.error((Object)"Create Replication pair failed.");
        this.rollback.addItem(new ReplicationPairRollbackItem(rollbackPairList));
        for (Callable<ReplicationPair> task : taskList) {
            CreateReplicationPairTask createReplicationPairTask = (CreateReplicationPairTask)task;
            if (createReplicationPairTask.getException() == null) continue;
            logger.error((Object)"Create Replication pair failed. LUN ID is : %s.", new Object[]{createReplicationPairTask.getPair().getSrcLunId()});
            throw createReplicationPairTask.getException();
        }
        throw new LegoCheckedException(-1L);
    }

    private ReplicationGroup createConsistentGroup(List<ReplicationPair> pairList) {
        ReplicationGroup group;
        Set cgIdSet = pairList.stream().map(pair -> pair.getConsistentGroupId()).filter(consistentGroupId -> consistentGroupId != null).collect(Collectors.toSet());
        if (cgIdSet.size() > 1) {
            logger.error((Object)"The cgId size not one, cgIdSet:%s.", new Object[]{cgIdSet});
            throw new LegoCheckedException(-1L);
        }
        ReplicationPair pairWithGroup = pairList.stream().filter(pair1 -> pair1.getConsistentGroupId() != null).findAny().orElse(null);
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        if (pairWithGroup != null) {
            String srcDevSn = pairWithGroup.getSrcDevSN();
            String tgtDevSn = pairWithGroup.getTgtDevSN();
            String consistentGroupId2 = pairWithGroup.getConsistentGroupId();
            sraProxy.splitReplication(srcDevSn, tgtDevSn, consistentGroupId2, true);
            group = sraProxy.getReplicationGroup(srcDevSn, consistentGroupId2);
        } else {
            group = new ReplicationGroup();
            group.setReplicationName("RD_CG_" + System.currentTimeMillis());
            group.setName(group.getReplicationName());
            ReplicationPair pair2 = (ReplicationPair)pairList.stream().findFirst().get();
            group.setSrcDevSN(pair2.getSrcDevSN());
            group.setReplicationMode(pair2.getReplicationMode());
            group.setTgtDevSN(pair2.getTgtDevSN());
            group.setIsPrimary(Boolean.valueOf(true));
            group = sraProxy.createReplicationGroup(group);
        }
        if (group == null) {
            logger.error((Object)"Create replication group failed.");
            throw new LegoCheckedException(-1L);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplicationPairToCG(ReplicationGroup group, List<ReplicationPair> pairList) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        try {
            sraProxy.addReplicationPair(group, pairList);
        }
        finally {
            sraProxy.getStorageReplicationAdapter(group.getSrcDevSN()).syncOnce(group.getSrcDevSN(), group.getTgtDevSN(), group.getReplicationId(), true);
        }
    }

    private void rollback(ProtectGroup protectGroup) {
        logger.info((Object)"Create Replication failed, begin to rollback!");
        this.rollback.execute(protectGroup);
    }

    private List<ReplicationGroup> createCascadeReplicationGroup(ProtectGroup protectGroup, List<ReplicationGroup> groupList, ReplicationPairConfiguration config) {
        ArrayList<ReplicationGroup> cmdGroupList = new ArrayList<ReplicationGroup>();
        for (ReplicationGroup group : groupList) {
            List<StoragePair> storagePairs = config.findStoragePair(group.getTgtDevSN());
            if (VerifyUtil.isEmpty(storagePairs)) continue;
            StoragePair storagePair = storagePairs.get(0);
            ArrayList<ReplicationPair> cmdPairList = new ArrayList<ReplicationPair>();
            for (ReplicationPair pair : group.getReplicationPairs()) {
                ReplicationPair newPair = new ReplicationPair();
                newPair.setSrcDevSN(group.getTgtDevSN());
                newPair.setSrcLunId(pair.getTgtLunId());
                ArrayList<ReplicationTargetLun> targetLunList = new ArrayList<ReplicationTargetLun>();
                ReplicationTargetLun targetLun = new ReplicationTargetLun();
                targetLunList.add(targetLun);
                targetLun.setTgtDevSN(storagePair.getTgtDevSN());
                newPair.setRepTgtLuns(targetLunList);
                cmdPairList.add(newPair);
            }
            ReplicationGroup cmdGroup = new ReplicationGroup();
            cmdGroup.setSrcDevSN(group.getTgtDevSN());
            cmdGroup.setTgtDevSN(storagePair.getTgtDevSN());
            group.setReplicationPairs(cmdPairList);
            cmdGroupList.add(group);
        }
        if (!cmdGroupList.isEmpty()) {
            return this.batchCreateReplicationGroup(protectGroup, cmdGroupList, config);
        }
        return Collections.emptyList();
    }

    private boolean isReProtectProcess(ProtectGroup protectGroup) {
        String recoveryPlanExecuteType = (String)protectGroup.getProps().get("FS_last_recovery_plan_execute_type");
        if (!VerifyUtil.isEmpty((String)recoveryPlanExecuteType)) {
            return String.valueOf(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()).equals(recoveryPlanExecuteType);
        }
        return false;
    }
}

