/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.Fan;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.array.sdk.model.PowerSupply;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.port.sdk.model.Port;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.discover.array.CustomRetriever;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.common.entity.components.Array;
import com.huawei.ism.common.entity.components.ControllerChassis;
import com.huawei.ism.common.entity.components.Drive;
import com.huawei.ism.common.entity.components.ExpandedLun;
import com.huawei.ism.common.entity.components.HarddriveChassis;
import com.huawei.ism.common.entity.components.Initiator;
import com.huawei.ism.common.entity.components.RaidGroup;
import com.huawei.ism.common.entity.hosts.Host;
import com.huawei.ism.common.entity.hosts.HostGroup;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.connection.smis.ConnectionBase;
import com.huawei.ism.connection.smis.ConnectionManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.proxy.ProxyFactory;
import com.huawei.ism.proxy.arrayproxy.ArrayProxy;
import com.huawei.ism.proxy.convert.ConvertFactory;
import com.huawei.ism.retriever.IRetrieverTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wbem.cim.CIMInstance;

public final class ArrayDiscoverUtil {
    private static Log logger = LogFactory.getInstance(ArrayDiscoverUtil.class);

    public static Array getArray(String deviceId) {
        logger.debug((Object)("deviceId=" + deviceId));
        return ArrayDiscoverUtil.getArray(deviceId, CustomRetriever.ARRAY_TASKS);
    }

    private static Array getArray(String deviceId, List<IRetrieverTask> tasks) {
        Array array;
        if (tasks == null) {
            logger.error((Object)"No Tasks given !!! ", 90160758784257L);
            return null;
        }
        try {
            Connection connection = ConnectionManager.getInstance().getConnectionByArrayId(deviceId);
            CIMInstance arrayInstance = WbemUtil.getComputerSystem((ConnectionBase)connection);
            CustomRetriever retriever = new CustomRetriever();
            retriever.setRetrieverTask(tasks);
            retriever.setConnection(connection);
            String deviceType = connection.getDeviceType();
            retriever.setConvertFactory(ConvertFactory.getInstance((String)deviceType));
            array = retriever.retrieveArray(arrayInstance, new HashMap<String, Object>());
            if ("S2600".equals(array.getDeviceType()) && "--".equals(array.getProductVersion())) {
                ArrayDiscoverUtil.getS2600V1R2LunInfo(array, retriever);
                ArrayDiscoverUtil.getS2600V1R2HostPortInfo(array, retriever);
            }
            array.setConnectionIP(connection.getCurrentIP());
        }
        catch (IsmException e) {
            logger.error((Object)"Get Array from V1 failed!", (Throwable)e, 90160777658643L);
            return null;
        }
        ArrayProxy proxy = (ArrayProxy)ProxyFactory.getProxy((String)array.getDeviceType(), (String)"ArrayInterface");
        try {
            String arraywwn = proxy.getIscsiDeviceName(array.getDeviceID());
            if (null == arraywwn) {
                logger.error((Object)"getIscsiDeviceName got null arraywwn");
                throw new LegoCheckedException(2117645L);
            }
            String[] str = arraywwn.split(":");
            if (str.length >= 3) {
                arraywwn = str[2];
            } else {
                arraywwn = "";
                logger.error((Object)("Error array wwn of " + deviceId), 90160777658643L);
            }
            array.setWWN(arraywwn);
        }
        catch (Exception ex) {
            logger.error((Object)("Get Array Wwn Error,S2600V1R2 can not get array wwn." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658643L);
        }
        return array;
    }

    public static List<PhysicalDisk> getPhysicalDisks(Array array, ArrayUnit sarray) {
        ArrayList<PhysicalDisk> disks = new ArrayList<PhysicalDisk>();
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(Drive.class);
        if (transition == null) {
            logger.error((Object)"No available PhysicalDisk transition !");
            return disks;
        }
        try {
            Collection drives = array.getDrives();
            for (Drive drive : drives) {
                PhysicalDisk disk = (PhysicalDisk)transition.convertToV2(drive);
                disk.setParentMo((ManagedObject)sarray);
                disk.setTopMoUuid(sarray.getTopMoUuid());
                disks.add(disk);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception1 : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return disks;
    }

    public static List<com.huawei.ism.array.sdk.model.RaidGroup> getRaidGroups(Array array, ArrayUnit sarray) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(RaidGroup.class);
        if (null == transition) {
            logger.error((Object)"No available Raid group transition !", 90160777658643L);
            return null;
        }
        ArrayList<com.huawei.ism.array.sdk.model.RaidGroup> v2Rgs = new ArrayList<com.huawei.ism.array.sdk.model.RaidGroup>();
        ArrayDiscoverUtil.processRaidGroups(array, sarray, transition, v2Rgs);
        return v2Rgs;
    }

    private static void processRaidGroups(Array array, ArrayUnit sarray, ITransition transition, List<com.huawei.ism.array.sdk.model.RaidGroup> v2Rgs) {
        try {
            Collection groups = array.getRaidGroups();
            for (RaidGroup rg : groups) {
                com.huawei.ism.array.sdk.model.RaidGroup v2Rg = (com.huawei.ism.array.sdk.model.RaidGroup)transition.convertToV2(rg);
                v2Rg.setTopMoUuid(sarray.getTopMoUuid());
                ArrayDiscoverUtil.processLun(rg, v2Rg);
                v2Rg.setParentMo((ManagedObject)sarray);
                v2Rgs.add(v2Rg);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception2 : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658643L);
        }
    }

    private static void getS2600V1R2HostPortInfo(Array array, CustomRetriever retriever) {
        Collection hosts = array.getHosts();
        if (VerifyUtil.isEmpty((Collection)hosts)) {
            logger.debug((Object)"hosts is null.");
            return;
        }
        ArrayList v1HostPorts = new ArrayList();
        v1HostPorts.addAll(array.getFcHostPorts());
        v1HostPorts.addAll(array.getIscsiHostPorts());
        v1HostPorts.addAll(array.getSasHostPorts());
        HashMap<String, com.huawei.ism.common.entity.components.Port> v1HostPortsMap = new HashMap<String, com.huawei.ism.common.entity.components.Port>();
        for (com.huawei.ism.common.entity.components.Port v1Port : v1HostPorts) {
            v1HostPortsMap.put(v1Port.getUUID(), v1Port);
        }
        for (Host host : hosts) {
            Collection<Object> hostPorts = retriever.getHostPortInfo(host);
            if (VerifyUtil.isEmpty(hostPorts)) continue;
            for (Object object : hostPorts) {
                com.huawei.ism.common.entity.components.Port port = (com.huawei.ism.common.entity.components.Port)object;
                com.huawei.ism.common.entity.components.Port v1HostPort = (com.huawei.ism.common.entity.components.Port)v1HostPortsMap.get(port.getUUID());
                if (null == v1HostPort) continue;
                v1HostPort.setHostId(host.getHostId());
            }
        }
    }

    private static void getS2600V1R2LunInfo(Array array, CustomRetriever retriever) {
        Collection raidGroups = array.getRaidGroups();
        List<Object> luns = retriever.getLunsInfo();
        if (VerifyUtil.isEmpty(luns)) {
            logger.info((Object)"lun list is empty.");
            return;
        }
        ArrayDiscoverUtil.processLuns(raidGroups, luns);
        ArrayDiscoverUtil.processExpandedLun(array, luns);
    }

    private static void processLuns(Collection<RaidGroup> raidGroups, List<Object> luns) {
        logger.debug((Object)("processLuns. raidGroups:" + raidGroups));
        for (RaidGroup rg : raidGroups) {
            for (Object lun : luns) {
                if (!(lun instanceof com.huawei.ism.common.entity.components.Lun) || !((com.huawei.ism.common.entity.components.Lun)lun).getParentUUID().equals(rg.getUUID())) continue;
                rg.addLun((com.huawei.ism.common.entity.components.Lun)lun);
            }
        }
    }

    private static void processExpandedLun(Array array, List<Object> luns) {
        logger.debug((Object)"enter processExpandedLun.");
        array.getExpandedLunList().clear();
        for (Object lun : luns) {
            if (!(lun instanceof ExpandedLun)) continue;
            array.addExpandedLun((ExpandedLun)lun);
        }
    }

    public static Array getShallowArray(String deviceId) {
        return ArrayDiscoverUtil.getArray(deviceId, CustomRetriever.SHALLOW_ARRAY_TASKS);
    }

    public static ArrayUnit getStorageArray(Array array) {
        if (array == null) {
            return null;
        }
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(array.getClass());
        if (transition == null) {
            logger.error((Object)"No available Array transition !", 90160758784257L);
            return null;
        }
        return (ArrayUnit)transition.convertToV2(array);
    }

    public static void processChassises(Array array, ArrayUnit arrayUnit) {
        Collection hardChassises;
        Chassis chassis;
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.Chassis.class);
        if (transition == null) {
            logger.error((Object)"No available Chassis transition!");
            return;
        }
        ControllerChassis controllerChassis = array.getControllerChassis();
        if (null != controllerChassis && null != (chassis = (Chassis)transition.convertToV2(controllerChassis))) {
            arrayUnit.addChildMo((ManagedObject)chassis);
            chassis.setParentMo((ManagedObject)arrayUnit);
            ArrayDiscoverUtil.processPower((com.huawei.ism.common.entity.components.Chassis)controllerChassis, chassis);
            ArrayDiscoverUtil.processFan((com.huawei.ism.common.entity.components.Chassis)controllerChassis, chassis);
        }
        if (!VerifyUtil.isEmpty((Collection)(hardChassises = array.getHardDriveChassises()))) {
            for (HarddriveChassis harddriveChassis : hardChassises) {
                Chassis chassis2 = (Chassis)transition.convertToV2(harddriveChassis);
                if (null == chassis2) continue;
                arrayUnit.addChildMo((ManagedObject)chassis2);
                chassis2.setParentMo((ManagedObject)arrayUnit);
                ArrayDiscoverUtil.processPower((com.huawei.ism.common.entity.components.Chassis)harddriveChassis, chassis2);
                ArrayDiscoverUtil.processFan((com.huawei.ism.common.entity.components.Chassis)harddriveChassis, chassis2);
            }
        }
    }

    public static List<Controller> processControllers(Array array, ArrayUnit arrayUnit) {
        ControllerChassis controllerChassis = array.getControllerChassis();
        if (null == controllerChassis) {
            return null;
        }
        Collection ctls = controllerChassis.getControllers();
        if (ctls == null) {
            logger.debug((Object)"Get Controller NULL !", 90160777658372L);
            return null;
        }
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.Controller.class);
        if (transition == null) {
            logger.error((Object)"Can not find available transition of Controller.", 90160777658373L);
            return null;
        }
        ArrayList<Controller> ismControllers = new ArrayList<Controller>();
        try {
            for (com.huawei.ism.common.entity.components.Controller ctl : ctls) {
                HSObject controller = transition.convertToV2(ctl);
                Controller ctr = (Controller)controller;
                ArrayDiscoverUtil.processPort(ctl, ctr);
                ctr.setParentMo((ManagedObject)arrayUnit);
                arrayUnit.addChildMo((ManagedObject)ctr);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception3 : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
        return ismControllers;
    }

    public static void processDiskHibernateStatus(List<PhysicalDisk> disks, com.huawei.ism.array.sdk.model.RaidGroup raid) {
        if (VerifyUtil.isEmpty(disks)) {
            logger.error((Object)"disks is empty.");
            return;
        }
        if (null == raid || null == raid.getStatus() || 7 != raid.getStatus()) {
            logger.error((Object)("raid=" + raid));
            return;
        }
        for (PhysicalDisk disk : disks) {
            if (!disk.getPoolId().equals(raid.getPoolId()) || !raid.getRaidType().equals(disk.getRaidType())) continue;
            disk.setStatus(Integer.valueOf(7));
        }
    }

    public static void processFan(com.huawei.ism.common.entity.components.Chassis v1Chassis, Chassis v2Chassis) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.Fan.class);
        if (transition == null) {
            logger.error((Object)"No available Fan transition!");
            return;
        }
        Collection v1Fans = v1Chassis.getFans();
        if (VerifyUtil.isEmpty((Collection)v1Fans)) {
            return;
        }
        for (com.huawei.ism.common.entity.components.Fan v1Fan : v1Fans) {
            Fan v2Fan = (Fan)transition.convertToV2(v1Fan);
            if (null == v2Fan) continue;
            v2Fan.setParentMo((ManagedObject)v2Chassis);
            v2Chassis.addChildMo((ManagedObject)v2Fan);
        }
    }

    private static void processLun(RaidGroup v1Rg, com.huawei.ism.array.sdk.model.RaidGroup v2Rg) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.Lun.class);
        if (transition == null) {
            logger.error((Object)"No available PhysicalDisk transition !", 90160777658643L);
            return;
        }
        try {
            Collection luns = v1Rg.getLuns();
            for (com.huawei.ism.common.entity.components.Lun lun : luns) {
                Lun v2Lun = (Lun)transition.convertToV2(lun);
                v2Lun.setParentMo((ManagedObject)v2Rg);
                v2Lun.setTopMoUuid(v2Rg.getTopMoUuid());
                v2Rg.addChildMo((ManagedObject)v2Lun);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception4 : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658643L);
        }
    }

    private static void processPort(com.huawei.ism.common.entity.components.Controller v1Ctl, Controller v2Ctl) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.Port.class);
        if (transition == null) {
            logger.error((Object)"Can not find available transition of Controller.", 90160777658627L);
            return;
        }
        ArrayDiscoverUtil.processHostPort(v1Ctl, v2Ctl, transition);
        ArrayDiscoverUtil.processMgmtPort(v1Ctl, v2Ctl, transition);
    }

    private static void processHostPort(com.huawei.ism.common.entity.components.Controller v1Ctl, Controller v2Ctl, ITransition transition) {
        try {
            Collection ports = v1Ctl.getAllTargetPort();
            for (com.huawei.ism.common.entity.components.Port p : ports) {
                Port v2Port = (Port)transition.convertToV2(p);
                v2Port.setParentMo((ManagedObject)v2Ctl);
                v2Port.setTopMoUuid(v2Ctl.getTopMoUuid());
                v2Ctl.addChildMo((ManagedObject)v2Port);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658643L);
        }
    }

    private static void processMgmtPort(com.huawei.ism.common.entity.components.Controller v1Ctl, Controller v2Ctl, ITransition transition) {
        try {
            Collection managementPorts = v1Ctl.getManagementPorts();
            for (com.huawei.ism.common.entity.components.Port managementPort : managementPorts) {
                Port v2Port = (Port)transition.convertToV2(managementPort);
                v2Port.setTopMoUuid(v2Ctl.getTopMoUuid());
                v2Port.setParentMo((ManagedObject)v2Ctl);
                v2Ctl.addChildMo((ManagedObject)v2Port);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658643L);
        }
    }

    public static void processPower(com.huawei.ism.common.entity.components.Chassis v1Chassis, Chassis v2Chassis) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.PowerSupply.class);
        if (transition == null) {
            logger.error((Object)"No available Power transition!");
            return;
        }
        Collection v1PowerSupplys = v1Chassis.getPowers();
        if (VerifyUtil.isEmpty((Collection)v1PowerSupplys)) {
            return;
        }
        for (com.huawei.ism.common.entity.components.PowerSupply v1PowerSupply : v1PowerSupplys) {
            PowerSupply v2PowerSupply = (PowerSupply)transition.convertToV2(v1PowerSupply);
            if (null == v2PowerSupply) continue;
            v2PowerSupply.setParentMo((ManagedObject)v2Chassis);
            v2Chassis.addChildMo((ManagedObject)v2PowerSupply);
        }
    }

    public static List<com.huawei.ism.base.sdk.model.Initiator> getInitiators(Array array, StorageUnit unit) {
        logger.trace((Object)"getInitiators");
        HashMap<Integer, Host> hostMap = new HashMap<Integer, Host>();
        for (Host host : array.getHosts()) {
            hostMap.put(host.getHostId(), host);
        }
        ArrayList<com.huawei.ism.base.sdk.model.Initiator> v2Initiators = new ArrayList<com.huawei.ism.base.sdk.model.Initiator>();
        ArrayList v1Initiators = new ArrayList();
        v1Initiators.addAll(array.getFcHostPorts());
        v1Initiators.addAll(array.getIscsiHostPorts());
        v1Initiators.addAll(array.getSasHostPorts());
        for (Initiator v1Initiator : v1Initiators) {
            com.huawei.ism.base.sdk.model.Initiator initiator = ArrayDiscoverUtil.transitionInitiator(v1Initiator);
            if (v1Initiator instanceof com.huawei.ism.common.entity.components.Port) {
                com.huawei.ism.common.entity.components.Port port = (com.huawei.ism.common.entity.components.Port)v1Initiator;
                Host host = (Host)hostMap.get(port.getHostId());
                if (host != null) {
                    initiator.setHostUUID(host.getUUID());
                }
                initiator.setUuid(port.getUUID());
            }
            initiator.setParentMo((ManagedObject)unit);
            unit.addChildMo((ManagedObject)initiator);
            v2Initiators.add(initiator);
        }
        return v2Initiators;
    }

    public static com.huawei.ism.base.sdk.model.Initiator transitionInitiator(Initiator v1Initiator) {
        com.huawei.ism.base.sdk.model.Initiator initiator = new com.huawei.ism.base.sdk.model.Initiator();
        initiator.setAlias(v1Initiator.getAlias());
        initiator.setName(v1Initiator.getIdentity());
        initiator.setIdentity(v1Initiator.getIdentity());
        initiator.setHbaType(v1Initiator.getProtocolType().name());
        initiator.setStatus(Integer.valueOf(0));
        initiator.setHealthStatus(Integer.valueOf(0));
        if (v1Initiator.getLinkState() != null) {
            logger.debug((Object)"linkState is not null!");
            initiator.setRunningStatus(V1RunningStateMapper.V1_INITIATOR_STATE.get(v1Initiator.getLinkState()));
        }
        return initiator;
    }

    public static List<ArrayHostGroup> getArrayHostGroups(Array array, StorageUnit unit) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(HostGroup.class);
        if (null == transition) {
            logger.error((Object)"No available host group transition !", 90160777658643L);
            return null;
        }
        ArrayList<ArrayHostGroup> v2HostGroups = new ArrayList<ArrayHostGroup>();
        try {
            Collection groups = array.getHostGroups();
            for (HostGroup hostGroup : groups) {
                ArrayHostGroup v2Rg = (ArrayHostGroup)transition.convertToV2(hostGroup);
                v2Rg.setTopMoUuid(unit.getTopMoUuid());
                ArrayDiscoverUtil.processArrayHost(hostGroup, v2Rg);
                v2Rg.setParentMo((ManagedObject)unit);
                v2HostGroups.add(v2Rg);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658643L);
        }
        return v2HostGroups;
    }

    private static void processArrayHost(HostGroup v1Rg, ArrayHostGroup v2Rg) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(Host.class);
        if (transition == null) {
            logger.error((Object)"No available Host transition!");
            return;
        }
        try {
            Collection hosts = v1Rg.getHosts();
            for (Host host : hosts) {
                ArrayHost v2Host = (ArrayHost)transition.convertToV2(host);
                v2Host.setParentMo((ManagedObject)v2Rg);
                v2Host.setTopMoUuid(v2Rg.getTopMoUuid());
                v2Rg.addChildMo((ManagedObject)v2Host);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658643L);
        }
    }

    public static void setControllerIp(Map<String, List<ManagementPort>> managePortsMap, Map<String, Controller> controllersIDMap, boolean isIpv4) {
        Set<Map.Entry<String, List<ManagementPort>>> entrys = managePortsMap.entrySet();
        for (Map.Entry<String, List<ManagementPort>> entry : entrys) {
            Controller controller = controllersIDMap.get(entry.getKey());
            List<ManagementPort> ports = entry.getValue();
            if (VerifyUtil.isEmpty(ports) || null == controller) {
                logger.debug((Object)("ports:" + ports));
                continue;
            }
            StringBuilder ipsBuffer = new StringBuilder();
            for (ManagementPort port : ports) {
                String ip = isIpv4 ? port.getIpAddress() : port.getIpv6Address();
                if (ip == null || ip.length() < 1) continue;
                ipsBuffer.append(ip).append(",");
            }
            String ips = "";
            if (ipsBuffer.length() > 0) {
                ips = ipsBuffer.substring(0, ipsBuffer.length() - 1);
            }
            if (isIpv4) {
                controller.setManageIpAddrs(ips);
                continue;
            }
            controller.setIpv6Address(ips);
        }
    }

    public static double getMappedLunCap(List<XveLun> xveLuns) {
        double mappedCap = 0.0;
        if (VerifyUtil.isEmpty(xveLuns)) {
            logger.debug((Object)"xveLuns is null");
            return mappedCap;
        }
        for (XveLun lun : xveLuns) {
            if (!lun.getMapped().booleanValue()) continue;
            mappedCap += lun.getTotalCapacity().doubleValue();
        }
        return mappedCap;
    }

    public static double getTotalLunCap(List<XveLun> xveLuns) {
        double totalCap = 0.0;
        if (VerifyUtil.isEmpty(xveLuns)) {
            logger.debug((Object)"xveLuns is null.");
            return totalCap;
        }
        for (XveLun lun : xveLuns) {
            totalCap += lun.getTotalCapacity().doubleValue();
        }
        return totalCap;
    }
}

