/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.util.List;

public final class ComputeArrayColumn {
    public static ArrayCap computeArrayCap(String devSn) {
        List disks = CommonDAOLocator.getMoDao().getMoList(PhysicalDisk.class, "devSn", (Object)devSn);
        double total = 0.0;
        double free = 0.0;
        for (PhysicalDisk disk : disks) {
            int logicType = disk.getLogicalType();
            if (disk.getStatus() == -1 && TypeEnum.DiskLogicalType.Free.getValue() == logicType) continue;
            Double oneDiskSize = disk.getTotalCapacity();
            if (oneDiskSize < 0.0) {
                oneDiskSize = 0.0;
            }
            if (TypeEnum.DiskLogicalType.Free.getValue() == logicType) {
                free += oneDiskSize.doubleValue();
            }
            total += oneDiskSize.doubleValue();
        }
        return new ArrayCap(total, free);
    }

    public static LunCap computeLunCap(String devSn) {
        List luns = CommonDAOLocator.getMoDao().getMoList(Lun.class, "devSn", (Object)devSn);
        double totalCap = 0.0;
        double mappedCap = 0.0;
        for (Lun lun : luns) {
            if (lun.getMapped().booleanValue()) {
                mappedCap += lun.getTotalCapacity().doubleValue();
            }
            if (Integer.valueOf(3).equals(lun.getResourceType())) continue;
            totalCap += lun.getTotalCapacity().doubleValue();
        }
        return new LunCap(totalCap, mappedCap);
    }

    public static void updateTopMoCapactiy(IMoDao moDao, ArrayUnit arrayUnit) {
        if (null == arrayUnit.getParentMo()) {
            return;
        }
        if (arrayUnit.getParentMo() instanceof StorageArray) {
            StorageArray storageArray = (StorageArray)arrayUnit.getParentMo();
            storageArray.setTotalCapacity(arrayUnit.getTotalCapacity());
            storageArray.setUsedCapacity(arrayUnit.getUsedCapacity());
            moDao.onlyUpdate((ManagedObject)storageArray);
        }
    }

    public static final class ArrayCap {
        private double totalCap;
        private double freeCap;

        public ArrayCap(double totalCap, double freeCap) {
            this.totalCap = totalCap;
            this.freeCap = freeCap;
        }

        public double getTotalCap() {
            return this.totalCap;
        }

        public void setTotalCap(double totalCap) {
            this.totalCap = totalCap;
        }

        public double getFreeCap() {
            return this.freeCap;
        }

        public void setFreeCap(double freeCap) {
            this.freeCap = freeCap;
        }
    }

    public static final class LunCap {
        private double totalLunCap;
        private double mappedLunCap;

        public LunCap(double totalLun, double mapLun) {
            this.totalLunCap = totalLun;
            this.mappedLunCap = mapLun;
        }

        public double getTotalLunCap() {
            return this.totalLunCap;
        }

        public void setTotalLunCap(double totalLunCap) {
            this.totalLunCap = totalLunCap;
        }

        public double getMappedLunCap() {
            return this.mappedLunCap;
        }

        public void setMappedLunCap(double mappedLunCap) {
            this.mappedLunCap = mappedLunCap;
        }
    }
}

