/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array;

import com.huawei.ism.common.bean.Device;
import com.huawei.ism.common.entity.components.Array;
import com.huawei.ism.common.entity.hosts.Host;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.proxy.ConvertContainer;
import com.huawei.ism.proxy.convert.Convert;
import com.huawei.ism.retriever.AbstractRetriever;
import com.huawei.ism.retriever.ChassisesRetrieverTask;
import com.huawei.ism.retriever.HostGroupRetrieverTask;
import com.huawei.ism.retriever.HostPortRetrieverTask;
import com.huawei.ism.retriever.IRetriever;
import com.huawei.ism.retriever.IRetrieverTask;
import com.huawei.ism.retriever.RaidRetrieverTask;
import com.huawei.ism.util.errortracer.ErrorTracer;
import com.huawei.ism.util.errortracer.LogErrorTracer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wbem.cim.CIMInstance;

class CustomRetriever
implements IRetriever {
    protected static final List<IRetrieverTask> ARRAY_TASKS = new ArrayList<IRetrieverTask>();
    protected static final List<IRetrieverTask> SHALLOW_ARRAY_TASKS = new ArrayList<IRetrieverTask>();
    private static Log logger = LogFactory.getInstance(CustomRetriever.class);
    private final List<IRetrieverTask> tasks = new ArrayList<IRetrieverTask>();
    private Connection con;
    private final ErrorTracer tracer = new LogErrorTracer();
    private ConvertContainer convertFactory;

    CustomRetriever() {
    }

    public ConvertContainer getConvertFactory() {
        return this.convertFactory;
    }

    public Collection<Object> getHostPortInfo(Host host) {
        Collection allHostPort = null;
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("ElementName", host.getName());
            properties.put("Name", host.getHostId() + "");
            properties.put("DeviceID", host.getUUID());
            properties.put("CreationClassName", "ISM_ProtocolController");
            properties.put("SystemName", (String)WbemUtil.getBasicAttribute((Connection)this.con).get("SystemName"));
            properties.put("SystemCreationClassName", (String)WbemUtil.getBasicAttribute((Connection)this.con).get("SystemCreationClassName"));
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("DeviceID");
            keys.add("SystemName");
            keys.add("SystemCreationClassName");
            keys.add("CreationClassName");
            CIMInstance cimHost = WbemUtil.assembleInstance(properties, (String)"ISM_ProtocolController", keys);
            allHostPort = WbemUtil.retrieveComponents((CIMInstance)cimHost, (String)"ISM_StorageHardwareID", (String)"ISM_RelationHostPort", (ConvertContainer)this.getConvertFactory(), (Connection)this.con, (ErrorTracer)this.tracer);
        }
        catch (Exception ex) {
            logger.error((Object)("Get S2600V1R2 Host Port Info Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
        return allHostPort;
    }

    public List<Object> getLunsInfo() {
        List allLuns;
        try {
            ArrayList associatedComponents = new ArrayList();
            allLuns = WbemUtil.enumerateComponents(associatedComponents, (Connection)this.con, (String)"ISM_StorageVolume", (ConvertContainer)this.getConvertFactory(), (ErrorTracer)this.tracer);
        }
        catch (Exception ex) {
            logger.error((Object)("Get S2600V1R2 Lun Info Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            allLuns = null;
        }
        return allLuns;
    }

    public List<IRetrieverTask> getRetrieverTask() {
        return new ArrayList<IRetrieverTask>(this.tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array retrieveArray(CIMInstance arrayInstance, Map<String, Object> args) {
        Convert arrayConvert = (Convert)this.getConvertFactory().getConvert("ISM_ComputerSystem");
        arrayConvert.setConnection(this.con);
        Array array = (Array)arrayConvert.convertInstance(arrayInstance);
        array.setComponentReady(1L);
        try {
            List<IRetrieverTask> taskList = this.getRetrieverTask();
            int taskSize = taskList.size();
            for (int i = 0; i < taskSize; ++i) {
                IRetrieverTask task = taskList.get(i);
                int status = task.doTask(array, this.con, this.getConvertFactory(), this.tracer);
                if (status != -1) continue;
                logger.error((Object)("Task status: END_OF_RETRIEVE." + task));
                throw new LegoCheckedException(4294967339L);
            }
        }
        finally {
            this.tracer.endTrace();
            this.tracer.clearTracedItems();
        }
        WbemUtil.setDeviceState((Device)array);
        array.setComponentReady(-1L);
        return array;
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    public void setConvertFactory(ConvertContainer factory) {
        this.convertFactory = factory;
    }

    public void setRetrieverTask(List<IRetrieverTask> tasksList) {
        this.tasks.clear();
        this.tasks.addAll(tasksList);
    }

    static {
        ARRAY_TASKS.add((IRetrieverTask)new AbstractRetriever.StatusCheckTask());
        ARRAY_TASKS.add((IRetrieverTask)new ChassisesRetrieverTask());
        ARRAY_TASKS.add((IRetrieverTask)new RaidRetrieverTask());
        ARRAY_TASKS.add((IRetrieverTask)new HostGroupRetrieverTask());
        ARRAY_TASKS.add((IRetrieverTask)new HostPortRetrieverTask());
        SHALLOW_ARRAY_TASKS.add((IRetrieverTask)new AbstractRetriever.StatusCheckTask());
        SHALLOW_ARRAY_TASKS.add((IRetrieverTask)new ChassisesRetrieverTask());
    }
}

