/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Iterator;

public class ArrayHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        Collection<?> v1Objs = msg.getV1Object();
        ArrayUnit arrayUnit = null;
        Iterator<?> iterator = v1Objs.iterator();
        if (iterator.hasNext()) {
            Object v1 = iterator.next();
            ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
            if (transition == null) {
                this.logger.error((Object)("No available transition, " + v1.getClass()));
                throw new LegoCheckedException(0x200909L);
            }
            arrayUnit = (ArrayUnit)transition.convertToV2(v1);
        }
        if (null == arrayUnit) {
            return;
        }
        try {
            String oldArrayName;
            IMoDao moDao = CommonDAOLocator.getMoDao();
            ArrayUnit oldArray = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)arrayUnit.getDevSn());
            String newArrayName = oldArrayName = oldArray.getName();
            arrayUnit.setName(oldArrayName);
            ManagedObject parentMo = oldArray.getParentMo();
            if (null != parentMo && parentMo instanceof StorageArray) {
                oldArray.setName(newArrayName);
                oldArray.setModel(arrayUnit.getModel());
                if ("S2600V1R2".equals(oldArray.getProductModel())) {
                    arrayUnit.setProductVersion("V100R002");
                }
                oldArray.setProductVersion(arrayUnit.getProductVersion());
                oldArray.setStatus(arrayUnit.getStatus());
                moDao.onlyUpdate((ManagedObject)oldArray);
                StorageArray storageArray = (StorageArray)parentMo;
                storageArray.setArrayUnit(oldArray);
                moDao.onlyUpdate((ManagedObject)storageArray);
            }
            this.logger.info((Object)("---> Save array : " + oldArray.getName()), 90160777658372L);
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return "ISM_ComputerSystem";
    }
}

