/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import javax.wbem.cim.CIMObjectPath;

public class ChassisHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        String deviceId = msg.getConnection().getArrayId();
        this.logger.info((Object)("-----> ChassisHandler handle ... " + deviceId), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        ArrayUnit arrayUnit = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)deviceId);
        if (null == arrayUnit) {
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            ManagedObject entity = moDao.getMoByUuid(uuid, Boolean.valueOf(true));
            if (null != entity) {
                moDao.deleteMoWithoutMsg(entity.getMoId());
            }
        } else {
            Chassis chassis = null;
            Collection<?> v1Objs = msg.getV1Object();
            for (Object v1 : v1Objs) {
                if (!(v1 instanceof com.huawei.ism.common.entity.components.Chassis)) continue;
                ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
                if (transition == null) {
                    this.logger.error((Object)("No available transition! " + v1.getClass()));
                    throw new LegoCheckedException(0x200909L);
                }
                chassis = (Chassis)transition.convertToV2(v1);
                this.logger.info((Object)("---> chassis : " + chassis));
                break;
            }
            if (null != chassis) {
                chassis.setParentMo((ManagedObject)arrayUnit);
                chassis.setTopMoUuid(arrayUnit.getTopMoUuid());
                moDao.saveOrUpdateMo(chassis);
            }
        }
    }

    @Override
    public String handleType() {
        return "CIM_Chassis";
    }
}

