/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.base.port.sdk.model.Port;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.util.DiscoverExUtil;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.common.entity.components.TargetFcPort;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.connection.smis.ConnectionManager;
import com.huawei.ism.connection.tlv.TLVCommandExecutor;
import com.huawei.ism.connection.tlv.TLVRecvData;
import com.huawei.ism.connection.tlv.TLVSendData;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.util.log.LogManager;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class ControllerHandler
implements IHandler {
    private static final long OM_FC_PORT_MODE = 3146113L;
    private static final int TIME_OUT = 310;
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        this.logger.debug((Object)"ControllerHandler handing ... ", 90160777658372L);
        String deviceId = msg.getConnection().getArrayId();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit arrayUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)deviceId);
        if (null == arrayUnit) {
            this.logger.error((Object)"Can NOT find the top array of given LUN  !!! ", 90160777658373L);
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            this.deleteController(uuid);
        } else {
            Collection<?> v1Objs = msg.getV1Object();
            Controller ctl = null;
            List<ManagedObject> hostPorts = null;
            Iterator<?> iterator = v1Objs.iterator();
            if (iterator.hasNext()) {
                Object v1 = iterator.next();
                ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
                if (transition == null) {
                    this.logger.error((Object)("No available transition, " + v1.getClass()));
                    throw new LegoCheckedException(0x200909L);
                }
                ctl = (Controller)transition.convertToV2(v1);
                ctl.setTopMoUuid(arrayUnit.getTopMoUuid());
                ctl.setParentMo((ManagedObject)arrayUnit);
                hostPorts = this.processPort((com.huawei.ism.common.entity.components.Controller)v1, ctl);
            }
            if (null != ctl) {
                moDao.saveOrUpdateMo(ctl);
                List oldPorts = moDao.getAllSubMo(ctl.getMoId().longValue(), Port.class);
                MOUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, hostPorts, (List)oldPorts);
            }
        }
    }

    @Override
    public String handleType() {
        return "ISM_Controller";
    }

    private void deleteController(String uuid) {
        this.logger.info((Object)("---> delete controller : " + uuid), 90160777658372L);
        IMoDao modao = CommonDAOLocator.getMoDao();
        ManagedObject entity = modao.getMoByUuid(uuid, Boolean.valueOf(true));
        if (null != entity) {
            modao.deleteMoWithoutMsg(entity.getMoId());
        }
    }

    private List<ManagedObject> processPort(com.huawei.ism.common.entity.components.Controller v1Ctl, Controller v2Ctl) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(com.huawei.ism.common.entity.components.Port.class);
        if (null == transition) {
            this.logger.error((Object)"Can not find available transition of Controller.", 90160777658373L);
            return null;
        }
        List<TLVRecvData> portModeList = this.retrieveAllFcPortMode(v1Ctl.getDeviceID());
        try {
            Collection ports = v1Ctl.getAllTargetPort();
            ArrayList<ManagedObject> v2PortList = new ArrayList<ManagedObject>();
            for (com.huawei.ism.common.entity.components.Port p : ports) {
                if (p instanceof TargetFcPort) {
                    DiscoverExUtil.parseFcMode(v1Ctl, (TargetFcPort)p, portModeList);
                }
                Port v2Port = (Port)transition.convertToV2(p);
                this.setPortSpeed(v2Port);
                v2Port.setParentMo((ManagedObject)v2Ctl);
                v2Port.setTopMoUuid(v2Ctl.getTopMoUuid());
                v2Ctl.addChildMo((ManagedObject)v2Port);
                v2PortList.add((ManagedObject)v2Port);
            }
            Collection managementPorts = v1Ctl.getManagementPorts();
            for (com.huawei.ism.common.entity.components.Port managementPort : managementPorts) {
                Port v2Port = (Port)transition.convertToV2(managementPort);
                v2Port.setParentMo((ManagedObject)v2Ctl);
                v2Port.setTopMoUuid(v2Ctl.getTopMoUuid());
                v2Ctl.addChildMo((ManagedObject)v2Port);
                v2PortList.add((ManagedObject)v2Port);
            }
            return v2PortList;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
            return null;
        }
    }

    protected void setPortSpeed(Port port) {
    }

    private List<TLVRecvData> retrieveAllFcPortMode(String devSn) {
        ArrayList recvDatas;
        Connection connection = ConnectionManager.getInstance().getConnectionByArrayId(devSn);
        TLVCommandExecutor executor = new TLVCommandExecutor(connection);
        TLVSendData sendData = new TLVSendData(TLVSendData.CmdReceiver.UTOP);
        sendData.setCmdCode(3146113L);
        try {
            recvDatas = executor.getBatch(sendData, 310);
        }
        catch (IsmException e) {
            LogManager.error((Object)"Retrieve All Fc Port Mode error", (Throwable)e);
            recvDatas = new ArrayList();
        }
        return recvDatas;
    }
}

