/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.RaidGroup;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ComputeArrayColumn;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class LunHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        this.logger.info((Object)"-----> LunHandler handle ...", 90160777658372L);
        String deviceId = msg.getConnection().getArrayId();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        ArrayUnit arrayUnit = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)deviceId);
        if (null == arrayUnit) {
            this.logger.error((Object)"Can NOT find the top array of given LUN  !!! ", 90160777658373L);
            return;
        }
        if (msg.getActionType().equals("CIM_InstDeletion")) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            this.deleteLun(uuid);
        } else {
            Lun lun = this.extractLun(msg.getV1Object());
            if (null != lun) {
                if (Integer.valueOf(3).equals(lun.getResourceType())) {
                    lun.setParentMo((ManagedObject)arrayUnit);
                    this.updatePrivateLunName(deviceId, moDao, lun);
                } else {
                    RaidGroup raid = (RaidGroup)moDao.getMo(RaidGroup.class, "uuid", (Object)lun.getRaidUuid());
                    if (null == raid) {
                        this.logger.error((Object)("No raid found for non-expand lun : " + lun), 90160777658373L);
                        return;
                    }
                    lun.setParentMo((ManagedObject)raid);
                }
                lun.setTopMoUuid(arrayUnit.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)lun);
            }
        }
        ComputeArrayColumn.LunCap lunCap = ComputeArrayColumn.computeLunCap(deviceId);
        arrayUnit.setTotalLunCap(Double.valueOf(lunCap.getTotalLunCap()));
        arrayUnit.setMappedLunCap(Double.valueOf(lunCap.getMappedLunCap()));
        moDao.onlyUpdate((ManagedObject)arrayUnit);
        ManagedObject parentMo = (ManagedObject)moDao.get((Serializable)arrayUnit.getParentId());
        if (null != parentMo && parentMo instanceof StorageArray) {
            StorageArray storageArray = (StorageArray)parentMo;
            storageArray.setTotalLunCap(Double.valueOf(lunCap.getTotalLunCap()));
            storageArray.setMappedLunCap(Double.valueOf(lunCap.getMappedLunCap()));
            moDao.onlyUpdate((ManagedObject)storageArray);
        }
    }

    private void updatePrivateLunName(String deviceId, IMoDao moDao, Lun lun) {
        Lun oldLun = (Lun)moDao.getMo(Lun.class, "uuid", (Object)lun.getUuid());
        if (null == oldLun || null == oldLun.getName() || oldLun.getName().equals(lun.getName())) {
            return;
        }
        List privateLuns = moDao.find("from Lun where devSn=? and resourceType=? and name=?", new Object[]{deviceId, 2, oldLun.getName()});
        if (VerifyUtil.isEmpty((Collection)privateLuns)) {
            return;
        }
        for (Lun privateLun : privateLuns) {
            privateLun.setName(lun.getName());
            moDao.onlyUpdate((ManagedObject)privateLun);
        }
    }

    @Override
    public String handleType() {
        return "ISM_StorageVolume";
    }

    private Lun extractLun(Collection<?> v1Objs) {
        Lun lun;
        block1: {
            lun = null;
            Iterator<?> iterator = v1Objs.iterator();
            if (!iterator.hasNext()) break block1;
            Object v1 = iterator.next();
            ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
            if (transition == null) {
                this.logger.error((Object)("No available transition, " + v1.getClass()));
                throw new LegoCheckedException(0x200909L);
            }
            lun = (Lun)transition.convertToV2(v1);
        }
        return lun;
    }

    private void deleteLun(String uuid) {
        this.logger.debug((Object)("---> delete lun : " + uuid), 90160777658372L);
        IMoDao modao = CommonDAOLocator.getMoDao();
        ManagedObject entity = modao.getMoByUuid(uuid, Boolean.valueOf(true));
        if (entity != null) {
            modao.deleteMoWithoutMsg(entity.getMoId());
        }
    }
}

