/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ComputeArrayColumn;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LunMappingHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        this.logger.info((Object)"LunMapping handle ...", 90160777658372L);
        String deviceId = msg.getConnection().getArrayId();
        try {
            Collection<?> v1s = msg.getV1Object();
            List<Lun> luns = this.extractLun(v1s);
            IMoDao moDao = CommonDAOLocator.getMoDao();
            for (Lun lun : luns) {
                Lun oldLun = (Lun)moDao.getMo(Lun.class, "uuid", (Object)lun.getUuid());
                if (null == oldLun) continue;
                lun.setParentMo(oldLun.getParentMo());
                lun.setTopMoUuid(oldLun.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)lun);
            }
            ComputeArrayColumn.LunCap lunCap = ComputeArrayColumn.computeLunCap(deviceId);
            ArrayUnit arrayUnit = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)deviceId);
            arrayUnit.setTotalLunCap(Double.valueOf(lunCap.getTotalLunCap()));
            arrayUnit.setMappedLunCap(Double.valueOf(lunCap.getMappedLunCap()));
            moDao.onlyUpdate((ManagedObject)arrayUnit);
            ManagedObject parentMo = (ManagedObject)moDao.get((Serializable)arrayUnit.getParentId());
            if (null != parentMo && parentMo instanceof StorageArray) {
                StorageArray storageArray = (StorageArray)parentMo;
                storageArray.setTotalLunCap(Double.valueOf(lunCap.getTotalLunCap()));
                storageArray.setMappedLunCap(Double.valueOf(lunCap.getMappedLunCap()));
                moDao.onlyUpdate((ManagedObject)storageArray);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658372L);
        }
    }

    private List<Lun> extractLun(Collection<?> objs) {
        ArrayList<Lun> luns = new ArrayList<Lun>();
        for (Object o : objs) {
            if (!(o instanceof com.huawei.ism.common.entity.components.Lun)) continue;
            ITransition trans = DefaultConvertor.getInstance().getTransitionByV1(o.getClass());
            if (trans == null) {
                this.logger.error((Object)("No available transition, " + o.getClass()));
                throw new LegoCheckedException(0x200909L);
            }
            Lun lun = (Lun)trans.convertToV2(o);
            luns.add(lun);
        }
        return luns;
    }

    @Override
    public String handleType() {
        return "ISM_ProtocolControllerForUnit";
    }
}

