/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.array.sdk.model.RaidGroup;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ComputeArrayColumn;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class PhysicalDiskHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        String deviceId = msg.getConnection().getArrayId();
        this.logger.info((Object)("-----> PhysicalDiskHandler handle ... " + deviceId), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        ArrayUnit arrayUnit = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)deviceId);
        if (null == arrayUnit) {
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            this.deleteDisk(uuid);
        } else {
            PhysicalDisk disk = this.extractDisk(msg.getV1Object());
            if (null != disk) {
                this.processDisk(disk, arrayUnit);
            }
        }
        ComputeArrayColumn.ArrayCap arrayCap = ComputeArrayColumn.computeArrayCap(deviceId);
        this.logger.info((Object)("Caculate array total cap : " + deviceId + " - " + arrayCap.getTotalCap()), 90160777658372L);
        arrayUnit.setTotalCapacity(Double.valueOf(arrayCap.getTotalCap()));
        arrayUnit.setUsedCapacity(Double.valueOf(arrayCap.getTotalCap() - arrayCap.getFreeCap()));
        moDao.onlyUpdate((ManagedObject)arrayUnit);
        ComputeArrayColumn.updateTopMoCapactiy(moDao, arrayUnit);
    }

    private void processDisk(PhysicalDisk disk, ArrayUnit array) {
        disk.setParentMo((ManagedObject)array);
        disk.setTopMoUuid(array.getTopMoUuid());
        List raids = CommonDAOLocator.getMoDao().getMoList(RaidGroup.class, "neSN", (Object)array.getDevSn());
        for (RaidGroup rg : raids) {
            if (!rg.getPoolId().equals(disk.getPoolId())) continue;
            if (null == rg.getHibernate() || !rg.getHibernate().booleanValue()) break;
            disk.setStatus(Integer.valueOf(7));
            break;
        }
        CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)disk);
    }

    @Override
    public String handleType() {
        return "ISM_PhysicalDisk";
    }

    private PhysicalDisk extractDisk(Collection<?> v1Objs) {
        PhysicalDisk disk;
        block1: {
            disk = null;
            Iterator<?> iterator = v1Objs.iterator();
            if (!iterator.hasNext()) break block1;
            Object v1 = iterator.next();
            ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
            if (transition == null) {
                this.logger.error((Object)("No available transition, " + v1.getClass()));
                throw new LegoCheckedException(0x200909L);
            }
            disk = (PhysicalDisk)transition.convertToV2(v1);
            this.logger.info((Object)("---> disk : " + disk));
        }
        return disk;
    }

    private void deleteDisk(String uuid) {
        this.logger.info((Object)("---> delete disk : " + uuid), 90160777658372L);
        IMoDao modao = CommonDAOLocator.getMoDao();
        ManagedObject entity = modao.getMoByUuid(uuid, Boolean.valueOf(true));
        if (null != entity) {
            modao.deleteMoWithoutMsg(entity.getMoId());
        }
    }
}

