/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ComputeArrayColumn;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.common.entity.components.Drive;
import com.huawei.ism.common.entity.components.RaidGroup;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Iterator;
import javax.wbem.cim.CIMObjectPath;

public class RaidGroupHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        String deviceId = msg.getConnection().getArrayId();
        this.logger.info((Object)("-----> RaidGroupHandler handle ... " + deviceId), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        ArrayUnit arrayUnit = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)deviceId);
        if (null == arrayUnit) {
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            this.deleteRaid(uuid);
        } else {
            Collection<?> v1Objs = msg.getV1Object();
            RaidGroup v1Raid = null;
            Iterator<?> iterator = v1Objs.iterator();
            if (iterator.hasNext()) {
                Object v1 = iterator.next();
                v1Raid = (RaidGroup)v1;
            }
            if (null == v1Raid) {
                return;
            }
            ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1Raid.getClass());
            if (transition == null) {
                this.logger.error((Object)("No available transition, " + v1Raid.getClass()));
                throw new LegoCheckedException(0x200909L);
            }
            com.huawei.ism.array.sdk.model.RaidGroup raid = (com.huawei.ism.array.sdk.model.RaidGroup)transition.convertToV2(v1Raid);
            this.logger.info((Object)("---> raid : " + raid), 90160777658372L);
            if (null == raid) {
                return;
            }
            raid.setParentMo((ManagedObject)arrayUnit);
            raid.setTopMoUuid(arrayUnit.getTopMoUuid());
            moDao.saveOrUpdateMo((ManagedObject)raid);
            this.processDiskInfo(moDao, arrayUnit, v1Raid, raid);
            ComputeArrayColumn.ArrayCap arrayCap = ComputeArrayColumn.computeArrayCap(deviceId);
            this.logger.info((Object)("Caculate array total cap : " + deviceId + " - " + arrayCap.getTotalCap()), 90160777658372L);
            arrayUnit.setTotalCapacity(Double.valueOf(arrayCap.getTotalCap()));
            arrayUnit.setUsedCapacity(Double.valueOf(arrayCap.getTotalCap() - arrayCap.getFreeCap()));
            moDao.onlyUpdate((ManagedObject)arrayUnit);
            ComputeArrayColumn.updateTopMoCapactiy(moDao, arrayUnit);
        }
    }

    private void processDiskInfo(IMoDao moDao, ArrayUnit arrayUnit, RaidGroup v1Raid, com.huawei.ism.array.sdk.model.RaidGroup raid) {
        ITransition diskTransition = DefaultConvertor.getInstance().getTransitionByV1(Drive.class);
        if (diskTransition == null) {
            this.logger.error((Object)("No available transition, " + Drive.class));
            throw new LegoCheckedException(0x200909L);
        }
        Collection drives = v1Raid.getDisks();
        if (drives != null) {
            for (Drive drive : drives) {
                PhysicalDisk disk = (PhysicalDisk)diskTransition.convertToV2(drive);
                if (raid.getHibernate().booleanValue()) {
                    disk.setStatus(Integer.valueOf(7));
                }
                disk.setParentMo((ManagedObject)arrayUnit);
                disk.setTopMoUuid(arrayUnit.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)disk);
            }
        }
    }

    @Override
    public String handleType() {
        return "ISM_StoragePool";
    }

    private void deleteRaid(String uuid) {
        this.logger.info((Object)("---> Delete RaidGroup : " + uuid), 90160777658372L);
        IMoDao modao = CommonDAOLocator.getMoDao();
        ManagedObject entity = modao.getMoByUuid(uuid, Boolean.valueOf(true));
        if (entity != null) {
            modao.deleteMoWithoutMsg(entity.getMoId());
        }
    }
}

