/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ComputeArrayColumn;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.entity.NotifyComponentType;
import com.huawei.ism.common.entity.components.Drive;
import com.huawei.ism.common.entity.components.RaidGroup;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.notification.ChangeTaker;
import com.huawei.ism.proxy.ConvertContainer;
import com.huawei.ism.proxy.convert.Convert;
import com.huawei.ism.proxy.convert.ConvertFactory;
import com.huawei.ism.proxy.convert.TLVConvert;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import javax.wbem.cim.CIMInstance;

public class TLVReportHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public void handle(Notification msg) {
        HashMap properties = WbemUtil.assembleProperties((CIMInstance)msg.getTmpInstance());
        this.logger.info((Object)"TLVReportHandler handle ... ", 90160777658372L);
        Object[] reportParamValue = (String[])WbemUtil.getArrayProperty((HashMap)properties, (String)"reportParamValue", String.class, (Object[])new String[1]);
        if (VerifyUtil.isEmpty((Object[])reportParamValue)) {
            this.logger.info((Object)"reportParamValue is empty.", 90160777658372L);
            return;
        }
        long notifyID = NumberUtil.convertToLong((Object)reportParamValue[0]);
        long comTypeVal = notifyID >> 16;
        NotifyComponentType notifyComponentType = NotifyComponentType.getNotifyComponentType((int)((int)comTypeVal));
        long notifyTypeVal = comTypeVal << 16 ^ notifyID;
        ChangeTaker.NotifyType notifyType = ChangeTaker.NotifyType.getNotifyType((int)((int)notifyTypeVal));
        if (notifyType == ChangeTaker.NotifyType.Delete) {
            this.saveComponent(msg.getConnection(), msg.getTmpInstance(), notifyComponentType, notifyType);
        } else if (notifyType == ChangeTaker.NotifyType.RefreshDevice) {
            this.logger.info((Object)"Device refresh notify.", 90160777658372L);
        } else {
            this.logger.info((Object)"Device others notify.", 90160777658372L);
            this.saveComponent(msg.getConnection(), msg.getTmpInstance(), notifyComponentType, notifyType);
        }
    }

    @Override
    public String handleType() {
        return "ISM_ReportIndication";
    }

    private void saveComponent(Connection conn, CIMInstance instance, NotifyComponentType notifyComponentType, ChangeTaker.NotifyType notifyType) {
        ConvertContainer factory = ConvertFactory.getInstance((String)conn.getDeviceType());
        Convert convert = (Convert)factory.getConvert(notifyComponentType.getConvertKey());
        convert.setConnection(conn);
        if (!(convert instanceof TLVConvert)) {
            return;
        }
        TLVConvert tlvConvert = (TLVConvert)convert;
        try {
            if (notifyType == ChangeTaker.NotifyType.Delete) {
                String uuid = tlvConvert.buildUUID(instance);
                IMoDao moDao = CommonDAOLocator.getMoDao();
                ManagedObject entity = moDao.getMoByUuid(uuid, Boolean.valueOf(true));
                if (entity != null) {
                    moDao.deleteMoWithoutMsg(entity.getMoId());
                }
            } else {
                Object v1Obj = tlvConvert.convertTLVInst2Component(instance);
                if (v1Obj != null && v1Obj instanceof RaidGroup) {
                    this.processRaidGroup(conn.getArrayId(), (RaidGroup)v1Obj);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)(e.getMessage() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
    }

    private void processRaidGroup(String deviceId, RaidGroup v1RaidGroup) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1RaidGroup.getClass());
        if (null == transition) {
            this.logger.error((Object)("transition is null, " + v1RaidGroup.getClass()));
            return;
        }
        com.huawei.ism.array.sdk.model.RaidGroup raid = (com.huawei.ism.array.sdk.model.RaidGroup)transition.convertToV2(v1RaidGroup);
        if (raid == null) {
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        ArrayUnit parentMo = (ArrayUnit)moDao.getMo(ArrayUnit.class, "devSn", (Object)deviceId);
        if (null == parentMo) {
            return;
        }
        raid.setParentMo((ManagedObject)parentMo);
        raid.setTopMoUuid(parentMo.getTopMoUuid());
        moDao.saveOrUpdateMo((ManagedObject)raid);
        transition = DefaultConvertor.getInstance().getTransitionByV1(Drive.class);
        if (transition == null) {
            this.logger.error((Object)("No available transition, " + Drive.class));
            throw new LegoCheckedException(0x200909L);
        }
        Collection drives = v1RaidGroup.getDisks();
        if (drives != null) {
            for (Drive drive : drives) {
                PhysicalDisk disk = (PhysicalDisk)transition.convertToV2(drive);
                if (raid.getHibernate() != null && raid.getHibernate().booleanValue()) {
                    disk.setStatus(Integer.valueOf(7));
                }
                disk.setRaidType(raid.getRaidType());
                disk.setParentMo((ManagedObject)parentMo);
                disk.setTopMoUuid(parentMo.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)disk);
            }
            ComputeArrayColumn.ArrayCap arrayCap = ComputeArrayColumn.computeArrayCap(deviceId);
            this.logger.info((Object)("Caculate array total cap : " + deviceId + " - " + arrayCap.getTotalCap()), 90160777658372L);
            parentMo.setTotalCapacity(Double.valueOf(arrayCap.getTotalCap()));
            parentMo.setUsedCapacity(Double.valueOf(arrayCap.getTotalCap() - arrayCap.getFreeCap()));
            moDao.onlyUpdateWithoutMsg((ManagedObject)parentMo);
            ComputeArrayColumn.updateTopMoCapactiy(moDao, parentMo);
        }
    }
}

