/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.process;

import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.array.sdk.model.RaidGroup;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.discover.array.ArrayDiscoverUtil;
import com.huawei.ism.cbb.discover.framework.IRetriever;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.common.entity.components.Array;
import com.huawei.ism.common.entity.components.ExpandedLun;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayRetriever
implements IRetriever {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");

    @Override
    public List<Object> retriveDeepDevice(StorageNE device) {
        ArrayList<Object> rtn = new ArrayList<Object>();
        Array array = ArrayDiscoverUtil.getArray(device.getSn());
        if (array == null) {
            this.logger.error((Object)"Get array failed !!!!!", 90160777658643L);
            return rtn;
        }
        ArrayUnit sarray = ArrayDiscoverUtil.getStorageArray(array);
        if (sarray == null) {
            this.logger.error((Object)"Can not get A storage array !", 90160777658624L);
            return rtn;
        }
        ArrayDiscoverUtil.processChassises(array, sarray);
        ArrayDiscoverUtil.processControllers(array, sarray);
        List<PhysicalDisk> disks = ArrayDiscoverUtil.getPhysicalDisks(array, sarray);
        List<RaidGroup> raidGroups = ArrayDiscoverUtil.getRaidGroups(array, sarray);
        if (null != raidGroups) {
            for (RaidGroup raid : raidGroups) {
                ArrayDiscoverUtil.processDiskHibernateStatus(disks, raid);
            }
        }
        List<ArrayHostGroup> arrayHostGroups = ArrayDiscoverUtil.getArrayHostGroups(array, (StorageUnit)sarray);
        ArrayDiscoverUtil.getInitiators(array, (StorageUnit)sarray);
        MOUtil.fillMOChildren((List[])new List[]{disks, raidGroups, arrayHostGroups});
        Collection expandedLuns = array.getExpandedLunList();
        if (expandedLuns != null && !expandedLuns.isEmpty() && !this.processExpandedLun(sarray, expandedLuns)) {
            return rtn;
        }
        rtn.add(sarray);
        rtn.add(array);
        return rtn;
    }

    private boolean processExpandedLun(ArrayUnit arrayNode, Collection<ExpandedLun> expandedLuns) {
        ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(ExpandedLun.class);
        if (null == transition) {
            this.logger.error((Object)("Can not find available transition of " + ExpandedLun.class.getSimpleName()), 90160777658627L);
            return false;
        }
        for (ExpandedLun elun : expandedLuns) {
            HSObject lun = transition.convertToV2(elun);
            arrayNode.addChildMo((ManagedObject)lun);
        }
        return true;
    }
}

