/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.process;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.framework.IRetriever;
import com.huawei.ism.cbb.discover.util.DiscoverExUtil;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class RetrieveStorageArrayProcessor
implements IProcessor {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Array_Discover");
    private final IRetriever retriever;

    public RetrieveStorageArrayProcessor(IRetriever retriever) {
        this.retriever = retriever;
    }

    public void clean(AbstractContext cmd) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(AbstractContext context) {
        List<Object> datas;
        StorageNE device = (StorageNE)context.getAttribute("StorageDevice");
        if (null == device) {
            this.logger.error((Object)"StorageDevice in context is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            WbemUtil.IS_CATCH.set(true);
            datas = this.retriever.retriveDeepDevice(device);
            if (datas == null || datas.size() < 2) {
                this.logger.error((Object)"Get storage array info failed !", 90160777658373L);
                throw new LegoCheckedException(0x200909L);
            }
        }
        finally {
            WbemUtil.IS_CATCH.remove();
        }
        ArrayUnit arrayUnit = (ArrayUnit)datas.get(0);
        arrayUnit.setTopMoUuid("StorageArray" + arrayUnit.getUuid());
        StorageArray storageArray = new StorageArray();
        storageArray.setUuid("StorageArray" + arrayUnit.getUuid());
        storageArray.setIsTopMo(Boolean.valueOf(true));
        storageArray.setManaged(Boolean.valueOf(true));
        storageArray.setArrayUnit(arrayUnit);
        storageArray.setManufacturer("Huawei Technologies Co., Ltd.");
        storageArray.addChildMo((ManagedObject)arrayUnit);
        arrayUnit.setParentMo((ManagedObject)storageArray);
        storageArray.setManagementProtocolMap(device.getManagementProtocolMap());
        storageArray.setManagementProtocol("SMI-S");
        DiscoverExUtil.updateTimeZoneToMo((ManagedObject)storageArray, device.getSn());
        DiscoverExUtil.updateTimeZoneToMo((ManagedObject)arrayUnit, device.getSn());
        context.setAttribute("ArrayUnit", (Object)arrayUnit);
        context.setAttribute("StorageArray", (Object)storageArray);
        context.setAttribute("V1Array", datas.get(1));
        return true;
    }
}

