/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.transition;

import com.huawei.ism.array.sdk.model.PhysicalDisk;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.base.sdk.constant.DiskConstant;
import com.huawei.ism.cbb.discover.array.V1HealthStateMapper;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.common.bean.HealthState;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.Drive;

public class DiskTransition
implements ITransition {
    @Override
    public Object convertToV1(HSObject ismObj) {
        return null;
    }

    @Override
    public HSObject convertToV2(Object v1Obj) {
        PhysicalDisk disk = null;
        if (v1Obj instanceof Drive) {
            Drive drive = (Drive)v1Obj;
            disk = new PhysicalDisk();
            disk.setUuid(drive.getUUID());
            disk.setChassisUUID(drive.getParentUUID());
            disk.setDiskType(DiskConstant.DiskPhysicalType.getPhysicalType((int)drive.getPhysicalType().getValue()).name());
            if (TypeEnum.DiskPhysicalType.DISK_UNKNOW == drive.getPhysicalType()) {
                disk.setDiskType("--");
            }
            disk.setTotalCapacity(Double.valueOf(String.valueOf(drive.getSize())));
            disk.setTotalCapacityUnit(CapabilityUnitType.GB.name());
            disk.setDiskSN(drive.getDeviceID());
            disk.setTemperature(Integer.valueOf(drive.getTemperature()));
            disk.setManufacture(drive.getManufacturer());
            disk.setCurrentSpeed(Long.valueOf(drive.getCurrentSpeed()));
            disk.setDiskPos(drive.getDiskPos().toUIString());
            disk.setBoxId(Integer.valueOf(drive.getDiskPos().getBoxId()));
            disk.setSlotId(Integer.valueOf(drive.getDiskPos().getSlotId()));
            disk.setFirmwareNo(drive.getFirmwareNo());
            disk.setName(drive.getName());
            disk.setDiskRuntime(Integer.valueOf(drive.getDiskRunTime()));
            disk.setSpinSpeed(Long.valueOf(drive.getSpinSpeed()));
            disk.setPhysicalModel(drive.getPhysicalModel());
            disk.setLogicalType(Integer.valueOf(drive.getDiskType().getValue()));
            disk.setRunProgress(Integer.valueOf(drive.getRunProgress()));
            disk.setSerialNo(drive.getSerialNo());
            disk.setWwn(drive.getWWN());
            disk.setPoolId(String.valueOf(drive.getRaidGroupId()));
            this.setDiskRaidType(disk, drive);
            disk.setDevSn(drive.getDeviceID());
            this.setDiskStatus(disk, drive);
        }
        return disk;
    }

    private void setDiskStatus(PhysicalDisk disk, Drive drive) {
        HealthState hs;
        Integer healthStatus;
        if (drive.getHalfLifeState() != null) {
            disk.setHalfLifeState(Integer.valueOf(drive.getHalfLifeState().getValue()));
        }
        if (null == (healthStatus = V1HealthStateMapper.V1_DISK_HEALTH_STATE.get(hs = drive.getHealthState()))) {
            healthStatus = 4;
        }
        disk.setStatus(healthStatus);
        disk.setHealthStatus(healthStatus);
        Integer runningStatus = V1RunningStateMapper.V1_DISK_RUNNING_STATE.get(drive.getRunningState());
        if (null == runningStatus) {
            runningStatus = 4;
        }
        disk.setRunningStatus(runningStatus);
    }

    private void setDiskRaidType(PhysicalDisk disk, Drive drive) {
        disk.setRaidType("RaidGroup");
        if (drive.getRaidGroupId() < 0) {
            disk.setPoolId(String.valueOf(drive.getPoolId()));
            if (drive.getPoolId() >= 0) {
                disk.setRaidType("ThinPool");
            }
        }
    }

    @Override
    public String getSmisType() {
        return "ISM_PhysicalDisk";
    }

    @Override
    public Class<?> getV1Type() {
        return Drive.class;
    }

    @Override
    public Class<?> getV2Type() {
        return PhysicalDisk.class;
    }
}

