/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons;

import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObject;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;

public final class IndicationParser {
    private static Log logger = LogFactory.getInstance(IndicationParser.class);

    public static String parseCim(Notification notification) {
        String type = "CIM_InstDeletion".equalsIgnoreCase(notification.getActionType()) ? IndicationParser.parseForDelete(notification) : notification.getTmpInstance().getClassName();
        return type;
    }

    private static String getClassName(CIMObjectPath objPath) {
        CIMProperty cimProp = objPath.getKey("CreationClassName");
        String creationClassName = null != cimProp ? String.valueOf(cimProp.getValue().getValue()) : objPath.getObjectName();
        return creationClassName;
    }

    private static String parseForDelete(Notification msg) {
        IndicationParser.pretreatCIMInstance(msg.getTmpInstance());
        CIMObjectPath objPath = msg.getTmpInstance().getObjectPath();
        String deviceId = msg.getConnection().getArrayId();
        if (objPath == null) {
            logger.error((Object)("deleteEntity error,because objpath is null.deviceId:" + deviceId + ";"), 90160777658392L);
            return null;
        }
        return IndicationParser.getClassName(objPath);
    }

    private static void pretreatCIMInstance(CIMInstance tmpInstance) {
        String className = tmpInstance.getClassName();
        if (!VerifyUtil.isNone((String)className)) {
            return;
        }
        try {
            final Field field = CIMObject.class.getDeclaredField("cop");
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    field.setAccessible(true);
                    return true;
                }
            });
            CIMObjectPath objPath = (CIMObjectPath)field.get(tmpInstance);
            if (null != objPath) {
                tmpInstance.setClassName(objPath.getObjectName());
            }
        }
        catch (Exception e) {
            logger.error((Object)("pretreatCIMInstance error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658393L);
        }
    }
}

