/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.process.AbstractPingProcessor;
import com.huawei.ism.cbb.proxy.service.impl.ConnectionManagerSmisImpl;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.connection.smis.ConnectionBase;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;

public class SmisPingProcessor
extends AbstractPingProcessor {
    private static final String SSL_ENABLE_FLAG = "1";
    private static final Log logger = LogFactory.getInstance(SmisPingProcessor.class);

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getCurrentIp(String sn) {
        Connection connection;
        ConnectionManagerSmisImpl cm = new ConnectionManagerSmisImpl();
        if (cm.isConnected(sn) && null != (connection = cm.getConnection(sn))) {
            return connection.getCurrentIP();
        }
        return null;
    }

    protected void connect(String sn, String ip, NeMgrProtocolExtend info) {
        DeviceContext.ProtocalType protocalType = DeviceContext.ProtocalType.HTTP;
        Map extendParams = info.getExtendParams();
        if (null != extendParams && SSL_ENABLE_FLAG.equals(extendParams.get("sslFlag"))) {
            protocalType = DeviceContext.ProtocalType.HTTPS;
        }
        User user = new User(info.getNetworkUserName(), info.getNetworkPassword());
        user.setSessionKey("0");
        if (!this.enableConnectionToIp(ip, user, protocalType)) {
            logger.error((Object)("Ping to smis server failed, sn=" + sn + ", ip=" + ip));
            throw new LegoCheckedException(104401L);
        }
        logger.info((Object)("Ping to smis server succeed, sn=" + sn + ", ip=" + ip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enableConnectionToIp(String ip, User user, DeviceContext.ProtocalType protocalType) {
        Connection connection = null;
        try {
            connection = new Connection(ip, user, protocalType);
            long errorId = WbemUtil.examineMyClient((ConnectionBase)connection);
            boolean bl = !WbemUtil.isConnectionFail((long)errorId);
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("Ping to smis server failed, ip=" + ip + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
        return false;
    }
}

