/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.event.clear;

import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.event.clear.ClearAlarmServiceListener;
import com.huawei.ism.cbb.discover.event.clear.EventClearServiceSmisImpl;
import com.huawei.ism.cbb.discover.event.clear.EventClearServiceSnmpImpl;
import com.huawei.ism.cbb.discover.event.clear.EventClearServiceTlvImpl;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmClearService;
import java.io.Serializable;
import java.util.List;

public class BaseEventClearService
implements IAlarmClearService {
    private ManagedObject node = null;
    private ClearAlarmServiceListener cleanAlarmServicelistener = null;
    private final EventClearServiceTlvImpl tlvClear = new EventClearServiceTlvImpl();
    private final EventClearServiceSmisImpl smisClear = new EventClearServiceSmisImpl();
    private final EventClearServiceSnmpImpl smmpClear = new EventClearServiceSnmpImpl();

    public boolean clearAlarm(LegoAlarm legoAlarm, String userName) {
        List<String> clearIds = this.cleanAlarmServicelistener.getAlarmIds();
        if (!VerifyUtil.isEmpty(clearIds) && clearIds.contains(legoAlarm.getAlarmId())) {
            return true;
        }
        if (this.node instanceof Host) {
            return true;
        }
        String subType = null;
        NetworkEntity entity = (NetworkEntity)CommonDAOLocator.getMoDao().get((Serializable)Long.valueOf(legoAlarm.getMoId()));
        if (null != entity) {
            subType = entity.getSubType();
        }
        StorageUnit unit = (StorageUnit)CommonDAOLocator.getMoDao().getMo(StorageUnit.class, "devSn", (Object)legoAlarm.getPortUuid());
        if (null == subType) {
            if (null == unit) {
                return false;
            }
            subType = unit.getSubType();
        }
        if (this.isNotSupportClearOnDevice(subType)) {
            return true;
        }
        return this.sendCmd(legoAlarm, userName, unit);
    }

    private boolean isNotSupportClearOnDevice(String subType) {
        boolean flag1 = "Rack Mounted CX3_20".equals(subType) || "Rack Mounted CX4_240".equals(subType) || "INF-01-00".equals(subType) || "V3160".equals(subType) || "N9000".equals(subType);
        boolean flag2 = "ism.storage.manufacture.inspur.as400".equals(subType) || "DS600-DF20".equals(subType) || "HSV300".equals(subType) || "HSV450".equals(subType);
        return flag1 || flag2;
    }

    private boolean sendCmd(LegoAlarm legoAlarm, String userName, StorageUnit unit) {
        if (this.node instanceof XveStorage) {
            return this.tlvClear.clearAlarm(legoAlarm, userName, (NetworkEntity)this.node, unit);
        }
        if ("S5600(V100R001)".equals(unit.getSubType())) {
            return this.smmpClear.clearAlarm(legoAlarm, userName, (NetworkEntity)this.node, unit);
        }
        return this.smisClear.clearAlarm(legoAlarm, userName, (NetworkEntity)this.node, unit);
    }

    public boolean isMyMo(long moid) {
        this.node = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)Long.valueOf(moid));
        if (null == this.node) {
            return false;
        }
        if (this.node instanceof Host || this.node instanceof StorageNE) {
            NetworkEntity networkEntity = (NetworkEntity)this.node;
            if ("ism.deviceType.uds.subType".equals(networkEntity.getSubType())) {
                return false;
            }
            this.node = this.changeObject(networkEntity);
            return true;
        }
        return false;
    }

    private ManagedObject changeObject(NetworkEntity mo) {
        if (mo instanceof StorageArray && !mo.getIsTopMo().booleanValue() && mo.getParentMo() instanceof NetworkEntity) {
            NetworkEntity ntEntity = (NetworkEntity)mo.getParentMo();
            mo.setManagementProtocolMap(ntEntity.getManagementProtocolMap());
        }
        return mo;
    }

    public ClearAlarmServiceListener getCleanAlarmServicelistener() {
        return this.cleanAlarmServicelistener;
    }

    public void setCleanAlarmServicelistener(ClearAlarmServiceListener cleanAlarmServicelistener) {
        this.cleanAlarmServicelistener = cleanAlarmServicelistener;
    }
}

