/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.event.clear;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.discover.util.IpExUtil;
import com.huawei.ism.cbb.mediation.service.impl.NeMgrProtocolExtendServiceImpl;
import com.huawei.ism.cbb.proxy.service.IConnectionManager;
import com.huawei.ism.cbb.proxy.service.ProxyServiceLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class EventClearServiceSmisImpl {
    private static final Log LOGGER = LogFactory.getInstance(EventClearServiceSmisImpl.class);

    public boolean clearAlarm(LegoAlarm legoAlarm, String userName, NetworkEntity netWork, StorageUnit unit) {
        IConnectionManager connManager = ProxyServiceLocator.getInstance().getConnectionManager();
        if (!connManager.isConnected(legoAlarm.getPortUuid())) {
            StorageNE ne;
            List<String> manageIps = IpExUtil.getMgrIps(unit);
            NeMgrProtocolExtendServiceImpl extendService = new NeMgrProtocolExtendServiceImpl();
            NeMgrProtocolExtend neMgrExtend = extendService.findByMoId(netWork.getMoId());
            try {
                ne = connManager.connect(manageIps, neMgrExtend);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Clear alarm fail. Conection is disabled." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160767696908L);
                return false;
            }
            if (null != ne) {
                return this.sendClearAlarmCommandBySmis(legoAlarm, userName, connManager);
            }
        } else {
            return this.sendClearAlarmCommandBySmis(legoAlarm, userName, connManager);
        }
        return false;
    }

    private boolean sendClearAlarmCommandBySmis(LegoAlarm legoAlarm, String userName, IConnectionManager connManager) {
        try {
            Connection connection = connManager.getConnection(legoAlarm.getPortUuid());
            if (null == connection) {
                LOGGER.error((Object)"connection is null");
                throw new LegoCheckedException(2117645L);
            }
            CIMObjectPath servicePath = new CIMObjectPath("ISM_AlarmService");
            CIMArgument[] inArgs = new CIMArgument[2];
            ArrayList<String> partAlarmSNs = new ArrayList<String>();
            partAlarmSNs.add(String.valueOf(legoAlarm.getAlarmSequence()));
            inArgs[0] = new CIMArgument("alarmSN", new CIMValue(partAlarmSNs));
            inArgs[1] = new CIMArgument("UserName", new CIMValue((Object)userName));
            CIMArgument[] outArgs = new CIMArgument[2];
            connection.invokeMethodAndSwitch(servicePath, "Clear", inArgs, outArgs);
            boolean reuslt = true;
            for (CIMArgument arg : outArgs) {
                if (null == arg) continue;
                if ("failedAlarmSN".equalsIgnoreCase(arg.getName())) {
                    Vector obj = (Vector)arg.getValue().getValue();
                    if (VerifyUtil.isEmpty((Collection)obj)) continue;
                    reuslt = false;
                    continue;
                }
                if (!"failReason".equalsIgnoreCase(arg.getName())) continue;
                LOGGER.error((Object)("failReason:" + arg.getValue().getValue()), 90160767696908L);
            }
            return reuslt;
        }
        catch (CIMException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e, 90160767696908L);
            return false;
        }
    }
}

