/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.event.clear;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.discover.util.IpExUtil;
import com.huawei.ism.cbb.discover.xve.ConnectionManagerTlvImpl;
import com.huawei.ism.cbb.mediation.service.impl.NeMgrProtocolExtendServiceImpl;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.proxy.service.IConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveTLVPParent;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.util.ArrayList;
import java.util.List;

public class EventClearServiceTlvImpl {
    private static final Log LOGGER = LogFactory.getInstance(EventClearServiceTlvImpl.class);

    public boolean clearAlarm(LegoAlarm legoAlarm, String userName, NetworkEntity netWork, StorageUnit unit) {
        LOGGER.info((Object)"begin to delete alarm from device", 90160758784531L);
        ConnectionManagerTlvImpl connManager = new ConnectionManagerTlvImpl();
        if (!connManager.isConnected(legoAlarm.getPortUuid())) {
            NeMgrProtocolExtendServiceImpl extendService;
            NeMgrProtocolExtend neMgrExtend;
            List<String> manageIps = IpExUtil.getMgrIps(unit);
            if (this.connect(manageIps, neMgrExtend = (extendService = new NeMgrProtocolExtendServiceImpl()).findByMoId(netWork.getMoId()), connManager) != null) {
                return this.sendCmdToClearAlarm(legoAlarm, userName, netWork);
            }
        } else {
            return this.sendCmdToClearAlarm(legoAlarm, userName, netWork);
        }
        return false;
    }

    private NetworkEntity connect(List<String> manageIps, NeMgrProtocolExtend neMgrProtocolExtend, IConnectionManager connManager) {
        return connManager.connect(manageIps, neMgrProtocolExtend);
    }

    private boolean sendCmdToClearAlarm(LegoAlarm legoAlarm, String userName, NetworkEntity netWork) {
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().getConnection(netWork.getSn());
        if (null == connection) {
            LOGGER.error((Object)("Connection not exsit, sn=" + netWork.getSn()));
            return false;
        }
        Param userParam = new Param(XveTLVPParent.CmoAlarmInfoE.CMO_ALARM_CLEAR_USER_NAME.getParamIndex(), ParamType.STRING, userName);
        ArrayList<Param> params = new ArrayList<Param>();
        Param snParam = new Param(XveTLVPParent.CmoAlarmInfoE.CMO_ALARM_SEQUENCE.getParamIndex(), ParamType.UNSIGN_INT, (IsmInteger)new UnsignedInt32(legoAlarm.getAlarmSequence()));
        params.add(snParam);
        params.add(userParam);
        try {
            connection.invoke(55847747650L, params);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)(e.getMessage() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160767696908L);
            return false;
        }
    }
}

