/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.jms;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.jms.IMessageReceiver;
import com.huawei.ism.cbb.discover.util.DiscoverExUtil;
import com.huawei.ism.cbb.discover.util.TrapUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.util.NetUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class DeviceSubMoDelMsgReceiver
implements IMessageReceiver {
    private static Log logger = LogFactory.getInstance(DeviceSubMoDelMsgReceiver.class);

    public List<MessageRegister> getMessageRegister() {
        MessageRegister deleteMoReg = new MessageRegister();
        deleteMoReg.setMessageTopic(MessageTopic.DATA);
        deleteMoReg.addMessageCode(106L);
        ArrayList<MessageRegister> list = new ArrayList<MessageRegister>();
        list.add(deleteMoReg);
        return list;
    }

    public void process(MessageUnit messageUnit) {
        Object obj = messageUnit.getObj();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"in process, obj:%s", new Object[]{obj});
        }
        if (null == obj) {
            return;
        }
        Map objs = (Map)obj;
        Collection mos = objs.values();
        for (ManagedObject mo : mos) {
            this.dealDeletedSubMo(mo);
        }
    }

    private void dealDeletedSubMo(ManagedObject mo) {
        if (mo instanceof HvsUnit) {
            return;
        }
        if (mo instanceof StorageUnit) {
            logger.info((Object)("dealDeletedSubMo, StorageUnit " + mo), 90160777658624L);
            StorageUnit deleteSubMo = (StorageUnit)mo;
            try {
                String ip = DeviceSubMoDelMsgReceiver.getLocalIp(deleteSubMo);
                logger.info((Object)("dealDeletedSubMo, ip " + ip), 90160777658624L);
                IAlarmService alarmService = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
                int port = alarmService.getTrapPort();
                if (DiscoverExUtil.isS5600V1R1Unit(deleteSubMo)) {
                    TrapUtil.deleteTrapIpBySnmp(deleteSubMo, ip, port);
                } else if (this.isTlvUnit(deleteSubMo)) {
                    TrapUtil.deleteTrapIpByTlv(deleteSubMo.getDevSn(), ip);
                } else {
                    TrapUtil.deleteTrapIPBySmis(deleteSubMo.getDevSn(), ip);
                }
            }
            catch (Exception e) {
                logger.error((Object)("dealDeletedSubMo, e:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658624L);
            }
        }
    }

    public static String getLocalIp(StorageUnit unit) {
        String remoteIp;
        String[] ips;
        String localIp = "";
        int connectPort = NumberUtil.convertToInteger((Object)"5988");
        String[] stringArray = ips = unit.getLinkIp().split(",");
        int n = stringArray.length;
        for (int i = 0; i < n && !NetUtil.isValidIPV4((String)(localIp = com.huawei.ism.cbb.proxy.protocol.tlv.constant.NetUtil.queryLocalIP((String)(remoteIp = stringArray[i]).trim(), (int)connectPort))); ++i) {
            logger.warn((Object)("Got an invalid local ip " + localIp + " vs remoteIP:" + remoteIp + " remotePort:" + connectPort), 90160777658624L);
        }
        logger.info((Object)("Got local ip " + localIp + " vs linkIP:" + unit.getLinkIp() + " remotePort:" + connectPort), 90160777658624L);
        return localIp;
    }

    private boolean isTlvUnit(StorageUnit unit) {
        return unit instanceof XveUnit;
    }
}

