/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.IDiscoverService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

@Service(name="com.huawei.ism.cbb.discover.sdk.service.IDiscoverService", desc="", interfaceClass=IDiscoverService.class)
public class DiscoverServiceImpl
extends IsmBaseService
implements IDiscoverService {
    private static final Log logger = LogFactory.getInstance(DiscoverServiceImpl.class);

    public void refreshStorage(StorageNE array, String userName) {
        if (null == array || VerifyUtil.isEmpty((String)userName)) {
            logger.error((Object)"Invalid parameters", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)("Start refresh storage, moid=" + array.getMoId() + " ; array.getLinkIp()=" + array.getLinkIp() + "; array=" + array), 90160777658372L);
        BackTask bt = BackTaskUtil.buildBackTask((String)array.getName(), (String)"ism.srm.array.refresh.operationName", (String)userName, (String)"", null);
        CommonTemplate template = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType(array.getManagementProtocol());
        if (null == template) {
            logger.error((Object)("Can not find template, templateKey=" + array.getManagementProtocol()), 90160777658372L);
            throw new LegoCheckedException(127402L);
        }
        this.startRefreshBackTask((NetworkEntity)array, bt, template);
        logger.info((Object)"Finish refresh storage.", 90160777658372L);
    }

    private void startRefreshBackTask(final NetworkEntity ne, BackTask bt, final CommonTemplate template) {
        int timeout = ManagedObjectManagerProxy.getInstance().getMgr((ManagedObject)ne).getTimeout();
        AbstractBackTask task = new AbstractBackTask(ne.getUuid(), bt, timeout, true){

            protected void doWork() {
                RefreshContext context = new RefreshContext((ManagedObject)ne);
                context.setAttribute("refreshTask", (Object)this);
                template.process((AbstractContext)context);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }
}

